#include <stdio.h>
#include <sys/types.h>
#define __MBD
#include <pwd.h>
#include <string.h>
#include "uqwk.h"



/*
 *  Determine runtime options
 */
 
int MAX_E_ARTICLE=10,MAX_S_ARTICLE=100;
int do_init=0;
int do_hidden=0;
int do_only_mail=0;
int do_international=0;
int USER_ID=1; 
int USER_NAM=83;
int slnp_mode =0;
int INIT2=0;
int DAEMON=0;
int MAX_MESSAGES_SIZE; /* max. Groesse des Puffers fuer messages.dat */
char HOME[STRING],BIN[STRING],NG[STRING];
int GROUP_ON=1;
int NNTP_ON=0,nntpport;
unsigned char nntpserver[STRING];
int QWK_VOLL=0;
int MAX_ART_SIZE=8012; 
unsigned char PACKER[DSTRING],MAIL_ADR[STRING/2],USR_PATH[STRING/2];
char ORG_NAME[STRING/2];
			
struct  TL_TYP task;

#undef NNTP_HOST
#undef NNTP_PORT
#undef SYSTEM
#ifndef STRING
#define STRING 88
#endif
char NNTP_HOST[STRING];
char NNTP_PORT[STRING];
char SYSTEM[STRING/2],TXT_MODE[STRING],DOMAIN[STRING];
int NG_ART=0;






DefaultOptions()
/*
 *  Set up default options
 */
{
	struct passwd *pw;

         
	/* Do user-specific stuff*/
	if (NULL == (pw = getpwuid(getuid())))
	{
		fprintf (stderr, "%s: warning: you don't exist\n", progname);
		strcpy (user_name, DEF_USER_NAME);
		strcpy (home_dir, DEF_HOME_DIR);
	}
	else
	{
		strcpy (user_name, pw->pw_name);
		strcpy (home_dir, pw->pw_dir);
	}

	/* Dinky misc options */
	do_mail = DEF_DO_MAIL;
	do_news = 0 /*DEF_DO_NEWS*/;
	inc_hdrs = DEF_INC_HDRS;
	prt_opts = DEF_PRT_OPTS;
	read_only = DEF_READ_ONLY;
	max_blks = DEF_MAX_BLKS;
	strcpy(PACKER,PACKER1);
	grp_len = DEF_GRP_LEN;
	waf_mode = DEF_WAF_MODE;
	strcpy(MAIL_ADR,"root");
	DAEMON=0;
	NG[0]=0;

	strcpy (mail_dir, DEF_MAIL_DIR);
	strcpy (mail_file, DEF_MAIL_FILE);
	strcpy (act_file,"dummy"/* DEF_ACT_FILE*/);
	strcpy (nrc_file, DEF_NRC_FILE);
	strcpy (news_dir, "dummy" /*DEF_NEWS_DIR*/);
        gethostname((char *) bbs_name,8); bbs_name[7]=0;
/*	strcpy (bbs_name, DEF_BBS_NAME); */
	strcpy (bbs_city, DEF_BBS_CITY);
	strcpy (bbs_phone, DEF_BBS_PHONE);
	strcpy (bbs_sysop, DEF_BBS_SYSOP);
	strcpy (bbs_id, DEF_BBS_ID);
	strcpy (rep_file, "" /*DEF_REP_FILE*/);
	strcpy (trn_file, DEF_TRN_FILE);
}

EnvOptions()
/*
 *  Override options from environment variables
 */
{
	char *c;
	

	if (NULL != (c = getenv ("UQ_DO_MAIL"))) do_mail = atoi (c);
	if (NULL != (c = getenv ("UQ_DO_NEWS"))) do_news = atoi (c);
	if (NULL != (c = getenv ("UQ_INC_HDRS"))) inc_hdrs = atoi (c);
	if (NULL != (c = getenv ("UQ_PRT_OPTS"))) prt_opts = atoi (c);
	if (NULL != (c = getenv ("UQ_READ_ONLY"))) read_only = atoi (c);
	if (NULL != (c = getenv ("UQ_MAX_BLKS"))) max_blks = atoi (c);
	if (NULL != (c = getenv ("UQ_GRP_LEN"))) grp_len = atoi (c);
	if (NULL != (c = getenv ("UQ_WAF_MODE"))) waf_mode = atoi (c);

	if (NULL != (c = getenv ("UQ_HOME_DIR"))) strcpy (home_dir, c);
	if (NULL != (c = getenv ("UQ_MAIL_FILE"))) strcpy (mail_file, c);
	if (NULL != (c = getenv ("UQ_MAIL_DIR"))) strcpy (mail_dir, c);
	if (NULL != (c = getenv ("UQ_USER_NAME"))) strcpy (user_name, c);
	if (NULL != (c = getenv ("UQ_NEWS_DIR"))) strcpy (news_dir, c);

/*	if (NULL != (c = getenv ("UQ_BBS_NAME"))) strcpy (bbs_name, c);*/
	if (NULL != (c = getenv ("UQ_BBS_CITY"))) strcpy (bbs_city, c);
	if (NULL != (c = getenv ("UQ_BBS_PHONE"))) strcpy (bbs_phone, c);
	if (NULL != (c = getenv ("UQ_BBS_SYSOP"))) strcpy (bbs_sysop, c);
	if (NULL != (c = getenv ("UQ_BBS_ID"))) strcpy (bbs_id, c);

	if (NULL != (c = getenv ("UQ_ACT_FILE"))) strcpy (act_file, c);
	if (NULL != (c = getenv ("UQ_NRC_FILE"))) strcpy (nrc_file, c);

	if (NULL != (c = getenv ("UQ_REP_FILE"))) strcpy (rep_file, c);
	if (NULL != (c = getenv ("UQ_TRN_FILE"))) strcpy (trn_file, c);
}





BadFlag (c)
char *c;
{
	fprintf (stderr, "%s: bad flag: %s\n", progname, c);
	exit (0);
}

PrintOptions (i)
int i;
{
#ifndef  DEBUG
	printf ("Version: %s\n", UQWK_VERSION);
#endif
	printf ("Do mail: %d\n", do_mail);
	printf ("Do internat. mail: %d\n", do_international);
	printf ("Do news: %d\n", do_news);
	printf ("Include headers: %d\n", inc_hdrs);
	printf ("Read only: %d\n", read_only);
	printf ("Maximum blocks: %d\n", max_blks);
/*	printf ("Group name limit: %d\n", grp_len);*/
/*	printf ("Waffle mode: %d\n", waf_mode);*/
/*	printf ("Mail directory: %s\n", mail_dir);*/
	printf ("News directory: %s\n", news_dir);
/*	printf ("Mail file: %s\n", mail_file);*/
	printf ("User name: %s\n", user_name);
	printf ("Home directory: %s\n", home_dir);
	printf ("BBS name: %s\n", bbs_name);
	printf ("NNTP: %d\n", NNTP_ON);
	printf ("BBS city: %s\n", bbs_city);
	printf ("BBS phone: %s\n", bbs_phone);
	printf ("BBS sysop: %s\n", bbs_sysop);
	printf ("ix-BBS-USER-CHAR: %c\n",USER_NAM);
	printf ("ix-BBS-USER-ID  : %d\n",USER_ID);
	printf ("BBS id: %s\n", bbs_id);
	printf ("Active file: %s\n", act_file);
	printf (".newsrc file: %s\n", nrc_file);
	printf ("Reply file: %s\n", rep_file);
/*	printf ("Newsgroup name translation table: %s\n", trn_file);*/
	printf ("do_init: %d\n", do_init);
	printf ("max.acticle/group: %d\n", MAX_E_ARTICLE+1);
	printf ("max.acticle/all: %d\n", MAX_S_ARTICLE+1);
	printf ("MAX_ART_SIZE:%d\n",MAX_ART_SIZE);
        printf ("NNTP_HOST:(%s)\n",NNTP_HOST);
        printf ("NNTP_PORT:(%s)\n",NNTP_PORT);
        printf ("SYSTEM:(%s)\n",SYSTEM);
#ifdef DEBUG	
       fflush(stdout);
       sleep(20);
	if (!i) exit(-1); else sleep(10);
#else 

       exit(0);
#endif	
}







int CommandOptions (argc, argv)
int argc;
char *argv[];
/*
 *  Override options from command line
 */
{
	int i;
	unsigned char s[DSTRING];

task.time_ok=time(0);
/*SetNNTP();*/
	for (i=1; i<argc; i++)
	{
               
                
		switch (argv[i][0])
		{
		
		case '+':
			switch (argv[i][1])
			{
			case 'm':	do_mail = 1;
					break;
					
			case 'i':	/*do_init = 1;*/
					break;
					
			case 'j':	do_international = 1;
					break;					

			case 'n':	do_news = 1;
					break;

			case 'h':	inc_hdrs = 1;
					break;
			case 'v':       do_only_mail=1;
					break;
					
			case 'H':       do_hidden=1;
					break;

			case 'r':	read_only = 1;
					break;

			case 'w':	strcpy(s,&argv[i][2]);
					sscanf(s,"%ld",&task.time);
					task.time_ok=time(0);
					break;
			
			case 'D':	strcpy (s, &argv[i][2]);
					DAEMON=atoi(s);
					break;
			
						
			case 'M':	strcpy (s, &argv[i][2]);
					if (!strpos("_",s)) strcpy(MAIL_ADR,s);
					 else {
					 strcpy(s,(char *) underl2leer(s));
					 sprintf(MAIL_ADR,"%s (%s)",cut_bef(s),punkt2leer(cut_arg(s)));
					 }
					break;
					
			case 'N':  /* NNTP akivieren*/ 
				        NNTP_ON=1;
				   	break;
			case 'P':	strcpy (s, &argv[i][2]);
					strcpy(USR_PATH,s);
					break;
					
			case 'L':	strcpy (s, &argv[i][2]);
					USER_language=atoi(s);
					break;
			
			case 'V':	
					QWK_VOLL=1;
					break;
			case 'G':	
					GROUP_ON=0;
					break;
				

			default:	BadFlag (argv[i]);
					break;
			}
			break;

		case '-':
			switch (argv[i][1])
			{
			case 'm':	do_mail = 0;
					break;

			case 'n':	do_news = 0;
					break;

			case 'h':	inc_hdrs = 0;
					break;

			case 'r':	read_only = 0;
					break;

			case 'w':	waf_mode = 0;
					break;

			case 'p':	prt_opts = 1;
					break;

			case 'M':	strcpy (mail_dir, &argv[i][2]);
					break;

			case 'f':	strcpy (mail_file, &argv[i][2]);
					break;

			case 'u':	strcpy (user_name, &argv[i][2]);
					break;
					
					
			case 'x':	
					if (atoi(&argv[i][2])>8012)
			                 MAX_ART_SIZE=atoi(&argv[i][2]);
					break;					
					
			
			case 'X':	
			                if (atoi(&argv[i][2])>8012)
			                 MAX_ART_SIZE=atoi(&argv[i][2]);
					break;
					
			case 'U':	strcpy (s, &argv[i][2]);
			                USER_NAM=atoi(s);
					break;
					
			case 'V':	strcpy (s, &argv[i][2]);
			                USER_ID=atoi(s);
					break;
					
		   	case 'I':	
			                INIT2=1;
					break;
					
			
			case 'E':	strcpy (s, &argv[i][2]);
					MAX_E_ARTICLE=atoi(s)-1;
					break;
					
					


			case 'H':	strcpy (home_dir, &argv[i][2]);
					break;

/*
			case 'b':	strcpy (bbs_name, &argv[i][2]);
					break;
*/
			case 'c':	strcpy (bbs_city, &argv[i][2]);
					break;

			case 'P':	strcpy (s, &argv[i][2]);
					if (atoi(s)!=2) strcpy(PACKER,PACKER1);
					  else strcpy(PACKER,PACKER2);
					break;

			case 's':	strcpy (bbs_sysop, &argv[i][2]);
					break;

			case 'i':	strcpy (bbs_id, &argv[i][2]);
					break;

			case 'a':	strcpy (act_file, &argv[i][2]);
					break;

			case 'N':	strcpy (nrc_file, &argv[i][2]);
					break;

			case 'S':	strcpy (news_dir, &argv[i][2]);
					break;

			case 'B':	max_blks = atoi (&argv[i][2]);
					break;

			case 'R':	strcpy (rep_file, &argv[i][2]);
					break;

			case 'l':	grp_len = atoi (&argv[i][2]);
					break;

			case 't':	strcpy (trn_file, &argv[i][2]);
					break;

			default:	BadFlag (argv[i]);
					break;
			}
			break;

		default:
			BadFlag (argv[i]);
			break;
		}
	}




	/* If mail file has not been overridden, set it */
	if (!strcmp (mail_file, DEF_MAIL_FILE))
	{
		strcpy (mail_file, mail_dir);
		strcat (mail_file, "/");
		strcat (mail_file, user_name);
	}

	/* If .newsrc file has not been overridden, set it */
	if (!strcmp (nrc_file, DEF_NRC_FILE))
	{
		strcpy (nrc_file, home_dir);
		strcat (nrc_file, "/.newsrc");
	}

#ifdef DEBUG	
printf("\nopt..ok\n");
prt_opts=1;
#endif

if (MAX_ART_SIZE<8024) MAX_ART_SIZE= 8024;
 
strcpy((char *) ORG_NAME,(char *) GetOrgName());

MAX_MESSAGES_SIZE=GetQwkSize();
return(1);
}







char *GRead(entry)
char *entry;
{
FILE *fd;
static char s[2*STRING];

#ifdef BBS_HOME
 sprintf(s,"%s/etc/config/%s",BBS_HOME,entry);
#else
 sprintf(s,"/etc/tbbs.setup/%s",entry);
#endif
if ((fd=fopen(s,"r"))!=NULL)
 {
   if (fgets(s,STRING,fd)==NULL)
/*nerror("derror.c", 363, "GRead()", "Bad entry in config-base (check the adjustments in \"tbbs.setup\")", entry);*/
      
   fclose(fd);      
   return((char *) s);   
      
 }/* else nerror("derror.c", 367, "GRead()", "Can't read (check the adjustments in \"tbbs.setup\"); please start the \"tbbs.setup\"-SH-Script", s);*/
 return(NULL);  
}

/* ++++++++++++++++++++++  Globale CFG lesen ++++++++++++++++++ */
void SetMain()
{
FILE *fd;
unsigned char t[STRING];
 char s[STRING],*env;
int i,j;

#ifndef BBS_HOME
  strcpy(HOME,(char *)strings(GRead("HOME"))); 
#else
  strcpy(HOME,BBS_HOME);
#endif
i=0;
while(HOME[i]!=0)
{
 if (HOME[i]==32) HOME[i]=0;
 i++;
}

sprintf(BIN,"%s/bin",HOME);

   for (i=0; i<STRING; i++) 
   {
    if (HOME[i]==SPACE) HOME[i]=0;
    if (BIN[i]==SPACE) BIN[i]=0;
   }
strcpy(NNTP_HOST,(char *)strings(GRead("nntp.server")));   
i=0;
while(NNTP_HOST[i]!=0)
{
 if (NNTP_HOST[i]==32) NNTP_HOST[i]=0;
 i++;
}

strcpy(NNTP_PORT,(char *)strings(GRead("nntp.port")));   
i=0;
while(NNTP_PORT[i]!=0)
{
 if (NNTP_PORT[i]==32) NNTP_PORT[i]=0;
 i++;
}

gethostname(SYSTEM,30); SYSTEM[7]=0; /* namens-verstuemmlung wegen DOSen */

strcpy(DOMAIN,(char *)strings(GRead("domain1")));   
i=0;
while(DOMAIN[i]!=0)
{
 if (DOMAIN[i]==32) DOMAIN[i]=0;
 i++;
}


}



void UHelp()
{
printf("\nuqwk Can't usage with \"direct-mode\" - sorry!\n"); 
exit(0);
}


char *GetOrgName()
{
static char s[STRING];
int i;

strcpy(s,user_name);
s[strpos("@",s)-1]=0; /* Namen aus Adresse ausloesen */
for (i=0; i<STRING; i++) 
{
 if (s[i]=='.') s[i]=32;
}

return((char *) &s);
}




int TestSoupActive()
{
static int i=0;  /* default maessig immer QWK aktiv */
FILE *fd;
char s[STRING];

sprintf(s,"%s/usr/%c/%d/qwk/.soup",HOME,USER_NAM,USER_ID);
/*printf("\ntest:(%s)",s);*/
if ((fd=fopen(s,"r"))!=NULL)
{
  fgets(s,STRING/2,fd);
  i=atoi(s);
  fclose(fd);
}
 return((int ) i);
}




void ClearJob()
{
FILE *fd;
char s[STRING];

sprintf(s,"%s/usr/%c/%d/qwk/.lastjob",HOME,USER_NAM,USER_ID);
unlink(s);
}
