#include <stdio.h>
#include <string.h>
#define __MBD
#include "uqwk.h"
#include "../version.h"
 


/*
 *  Process offline commands
 */

OffLine (bytes)
int bytes;
/*
 *  Process offline commands.  Message is open on rep_fd.  We
 *  must be careful to leave the file pointer ready for the
 *  next message.
 */
{
	FILE *pfd;
	int err=0;
	char c, cmd[PATH_LEN];
	time_t timer;
	

	/* Open mail pipe to send results back to user */
	sprintf (buf, "%s -s 'Results of your request' %s",
			MAILER_PATH, user_name);


	sprintf(buf,"%s -F%s -f%s %s", SYSTEM_MAIL,
        	user_name,user_name,user_name);
        
	if ((pfd = popen(buf, "w")) == NULL)
	{
	   printf("\nqwk: Can't open pipe to Mailer (%s)!\n",SYSTEM_MAIL);
	   while (bytes--) fread (&c, 1, 1, rep_fd);
	   return(0);
	}
    	
    	time(&timer);
    	fprintf(pfd, "From: QWK@%s\n",DOMAIN);
  	fprintf(pfd, "Sender: QWK-Server <%s>\n", DOMAIN);
 	fprintf(pfd, "To: %s\n", user_name);
  	fprintf(pfd, "Subject: results of your request for qwk-offline-service\n");
 	fprintf(pfd, "X-Mailer: %s%s#qwk.o \n", VERSION, PATCHLEVEL);
  	fprintf(pfd, "Message-Id: <%x.%d@%s>\n\n", timer, USER_ID,DOMAIN);


	fprintf (pfd, "\nHere are the results of your mail to QWK-Server:\n");

	/* Get lines, process them */
	while (GetLine(&bytes))
	{
		/* Echo command */
		fprintf (pfd, "\nCommand: %s\n", buf);

		/* Extract command */
		if (1 != sscanf (buf, "%s", cmd))
		{
			fprintf (pfd, "Malformed command.\n");
			err=1;
		}
		else
		{
			/* Look up command */
			if ( strpos("help",(char *) touppers(cmd))==1)
			{
				Help(0,pfd);
			}
			else 
			if ( strpos("subscribe",(char *) touppers(cmd))==1)
			{
				/*Subscribe(pfd);*/
				fprintf (pfd, "\n-> SUBSCRIBE: SORRY, command not implement!\n");
			}
			else 
			if ( strpos("unsubscribe",(char *) touppers(cmd))==1)
			{
				/*Unsubscribe(pfd);*/
				fprintf (pfd, "\n-> UNSUBSCRIBE: SORRY, command not implement!\n");
			}
			else 
			if ( strpos("groups",(char *) touppers(cmd))==1)
			{
				Groups(pfd);
			}
			else 
			if ( strpos("allgroups",(char *) touppers(cmd))==1)
			{
				Allgroups(pfd);
			}
			else
			{
			        err=1;
				fprintf (pfd, "No such command.  ");
				fprintf (pfd, "Send HELP for help.\n");
			}
		}
	}

        if (err)
        {
           fprintf (pfd, "\n----------------------------------------------------------------------\n");
           Help(1,pfd);
        }
	fprintf (pfd, "\nEnd of commands.\n");
	pclose (pfd);
	return (1);
}

int GetLine (bytes)
int *bytes;
/*
 *  Get a line from rep_fd, put it in buf, check for end of message
 */
{
	int i;
	i = 0;

	/* Read bytes until EOL or end of message */
	while (*bytes)
	{
		fread (&buf[i], 1, 1, rep_fd);
		(*bytes)--;

		if ( (buf[i] == QWK_EOL) || (i == BUF_LEN-1) )
		{
			buf[i] = 0;
			return (1);
		}
		i++;
	}

	/* If we got here, we ran out of bytes */
	return (0);
}

Help (mode,pfd)
int mode;
FILE *pfd;
{
	
    if (mode)
    {	
	fprintf (pfd,"\nHello,\nYou sent a message to the username 'qwk', presumably to\n");
	fprintf (pfd,"perform some sort of offline configuration. This QWK processor,\n");
	fprintf (pfd,"called QWK, cannot process this message.\n");
	fprintf (pfd,"Commands are to be included in the body of the message.\n");
	fprintf (pfd,"For a list of commands, send a message to QWK with the word\n");
	fprintf (pfd,"HELP in the body of the message (not the subject). \n                                                       Thanks!\n\n");

    }


	fprintf (pfd, "\nAvailable commands (in development!):\n\n");
	
	fprintf (pfd, "HELP                   - This message ;-) \n\n");
	
	fprintf (pfd, "SET_ADR address , nick - Set private Addressbook-Entry for nick...\n");
	fprintf (pfd, "CLR_ADR nick           - Clear private Addressbook-Entry\n");
	fprintf (pfd, "LST_ADR                - List all Entrys of priv.Addressbook\n\n");
	
	fprintf (pfd, "SUBSCRIBE newsgroup    - Subscribe to named newsgroup.\n");
	fprintf (pfd, "UNSUBSCRIBE newsgroup  - Unsubscribe from newsgroup.\n");
	fprintf (pfd, "UNSUBSCRIBE ALL        - Unsubscribe from all newsgroups.\n\n");
	
	fprintf (pfd, "SET conf               - subscribe conf. (newsgroup) \n");
	fprintf (pfd, "DROP conf              - unsubscribe conf. (newsgroup)\n");
	fprintf (pfd, "RESET conf id          - reset conf-pointer to id... \n");
	fprintf (pfd, "MAXSIZE size           - max.size in kbytes for messages.dat\n");
	fprintf (pfd, "MAXNUMBER number       - max.number of messages per group\n\n");
	
	fprintf (pfd, "ACTIVE                 - List all active-file on nntp-server\n");
	fprintf (pfd, "GROUPS                 - List all subscribed newsgroups.\n");
	fprintf (pfd, "ALLGROUPS              - List all available newsgroups.\n\n");
	
    if (mode) 	fprintf (pfd,"-----------------------------------------------------------------\n");	
}

Subscribe (pfd)
FILE *pfd;
{
	struct act_ent *ap;
	struct nrc_ent *np;
	char group[PATH_LEN];

	/* Extract group name */
	if (1 != sscanf (buf, "%*s %s", group))
	{
		fprintf (pfd, "Usage: SUBSCRIBE newsgroup\n");
		return (0);
	}


	/* Already subscribed? */
	np = nrc_list;
	while (np != NULL)
	{
		if (!strcmp (group, np->name))
		{
			if (np->subscribed)
			{
				fprintf (pfd, "Already subscribed to %s.\n",
					group);
				return (0);
			}
			else
			{
				np->subscribed = 1;
				fprintf (pfd, "Okay, re-subscribed to %s.\n",
					group);
				WriteNewsrc();
				return (0);
			}
		}
		np = np->next;
	}

	/* Find group in active file */
	if (1 /*NULL == (ap = FindActive (group))*/)
	{
		fprintf (pfd, "No such newsgroup: %s\n", group);
		return (0);
	}

	/* Okay already, add to .newsrc */
	np = (struct nrc_ent *) malloc (sizeof (struct nrc_ent));
	if (np == NULL) OutOfMemory();
	np->name = (char *) malloc (1+strlen(group));
	if (np->name == NULL) OutOfMemory();
	strcpy (np->name, group);
	np->subscribed = 1;
	np->hi = ap->hi;
	np->next = nrc_list;
	nrc_list = np;

	WriteNewsrc();
	fprintf (pfd, "Okay, you are now subscribed to %s.\n", group);

	return (1);
}

Unsubscribe (pfd)
FILE *pfd;
{
	struct nrc_ent *np;
	char group[PATH_LEN];

	/* Parse group name */
	if (1 != sscanf (buf, "%*s %s", group))
	{
		fprintf (pfd, "Usage: UNSUBSCRIBE newsgroup\n");
		return (0);
	}

	/* Check for ALL */
	if ( (!strcmp (group, "ALL")) || (!strcmp (group, "all")) )
	{
		nrc_list = NULL;
		WriteNewsrc();
		fprintf (pfd,
		  "Okay, you are now unsubscribed from all newsgroups.\n");
		return (0);
	}

	/* We need the .newsrc file */
	/* Look for group in newsrc */
	np = nrc_list;
	while (np != NULL)
	{
		if (!strcmp (group, np->name)) break;
		np = np->next;
	}

	if (np == NULL)
	{
		fprintf (pfd, "You are not currently subscribed to %s.\n",
		         group);
		return (0);
	}

	np->subscribed = 0;

	WriteNewsrc();
	fprintf (pfd, "Okay, you are unsubscribed from %s.\n", group);

	return (1);
}

Groups (pfd)
FILE *pfd;
{
	struct nrc_ent *np;


	fprintf (pfd, "Newsgroups to which you are subscribed:\n\n");


	np = nrc_list;
	while (np != NULL)
	{
		if (np->subscribed)
		{
		 fprintf (pfd, "    %s\n", np->name);
		}
		np = np->next;
	}
	return (1);
}

Allgroups (pfd)
FILE *pfd;
{
  struct nrc_ent *np;
  

	fprintf (pfd, "List of available newsgroups:\n\n");

	np = nrc_list;
	while (np != NULL)
	{
		fprintf (pfd, "    %s\n", np->name);
		np = np->next;
	}

	return (1);
}
