/* ix/MBox (smalltalk.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #MS msleep()          sleeping a few milliseconds  (R) Richard Tobin
   #SC scribble()        scrambled scribbling
   #ST smalltalk()       smalltalking BBS

   Contact <volkers@unnet.wupper.de> for help! */










#include <stdio.h>

#include "../mbox.h"


#define LISA_LOG	"/tmp/lisa.log"
#define LISA_DIC	"/tmp/lisa.dic"

#define MY_NAME_IS	"Lisa"		/* Change in "smalltext.c", too !! */

#define MAX_HISTORY	50

UNSIGNED char KNOW_HOW[STRING];
UNSIGNED char answer[51][STRING];
int noa;

int already;

UNSIGNED char small_history[(MAX_HISTORY+1)][STRING];

int empty, letog;

int fastmode;
int debugmode;

int hacker_alert;
int rationed;

int lisa_quiet;





#ifdef _SMALLTALK

/* #ST - React on users strange inputs [cmdline]. */

int smalltalk_english( cmdline )
UNSIGNED char cmdline[];
{
  UNSIGNED char s[STRING];  
  UNSIGNED char v1[STRING];
  UNSIGNED char v2[31][STRING];
  UNSIGNED char v3[STRING];

  UNSIGNED char question[31][STRING];
  int noq = 0;
  int ok = 0;

  int i = 0, a = 0;  
  int r;

  int val;
  int found;
  int quiet;

  int smv_you, smv_me, smv_not, smv_question, smv_yes, smv_no;
  int smv_object, smv_person, smv_action, smv_smalltalk;

  FILE *fp;



  sprintf(KNOW_HOW, "./etc/languages/know.%s", LANGUAGE);

  i = UMLAUT_MODUS;
  UMLAUT_MODUS = 3;
  strcpy(cmdline, (UNSIGNED char *) iso_line( cmdline ));
  UMLAUT_MODUS = i;

  quiet = 0;
  
  smv_you = 0; smv_me = 0; smv_not = 0; smv_question = 0; smv_yes = 0;
  smv_no = 0; smv_object = 0; smv_person = 0; smv_action = 0; smv_smalltalk = 0;

  if(already != 123){
	strcpy(s, (UNSIGNED char *) mytime( 0 ));
	srand( (int) atoi( (UNSIGNED char *) strcopy(s, 6, 7 ) ));
	already =    123;
	empty =        0;
	fastmode =     0;
	debugmode =    0;
	letog =        9;
	hacker_alert = 0;
	rationed =     0;
	lisa_quiet =   0;

	for(i = 1; i <= MAX_HISTORY; i++){
		strcpy(small_history[i], (UNSIGNED char *) "Lisa Aziz");
	}

#ifdef _MINIX
	if(tty() >= FIRST_EX_TTY){
#endif
		fp = fopen(LISA_LOG, "a" );
		if(fp == NULL){
			nerror("smalltalk.c", 190, "smalltalk", "Can't append to", LISA_LOG);
		}
		strcpy(s, (UNSIGNED char *) USER.name);
		s[10] = '\0'; 
		fprintf(fp, "%10s: + + +  Starting chat on TTY%d  + + +\n\n", s, tty());
		fclose(fp);
#ifdef _MINIX
	  }
#endif

  }  

  if(cmdline[0] == '\0'){
	if(hacker_alert){
		if(empty == 0){
			empty++;
			sm_sulk();
			goto DAS_WARS;
		}
		else return;
	}
	if(empty == 0) sm_emptyline();
	if(empty == 1) sm_empty1();
	if(empty == 2) sm_empty2();
	if(empty == 3) letog = (rand() % 30) + 1;
	empty++;
	if((empty > 3) && (empty <= letog)) return;
	if(empty > letog){
		empty  = 0;
		letog = 9;
		return;
	}
	goto DAS_WARS;
  }

  empty = 0;

  if(hacker_alert > 0) return;


  if(strcomp("FASTMODE", cmdline) == 0){
	if(fastmode)
		fastmode = 0;
	else
		fastmode = 1;
  }
  
  if(strcomp("DEBUGMODE", cmdline) == 0){
	if(debugmode){
		debugmode = 0;
		fastmode  = 0;
	}
	else{
		debugmode = 1;
		fastmode  = 1;
	}
  }
/*
#ifdef _UNNET
  ff = fopen( LISA_DIC, "a" );
  if(ff == NULL){
	nerror("smalltalk.c", 253, "smalltalk", "Can't append to", LISA_DIC);
  }
#endif
*/
  strcat(cmdline, (UNSIGNED char *) " ");

  i = 0; a = 0;

  while(cmdline[i] != '\0'){
	if(cmdline[i] < 'A'){
		noq++;
		strcpy(question[noq], (UNSIGNED char *) strcopy(cmdline, a, (i - 1)));
/*
#ifdef _UNNET
		fprintf(ff, "%s\n", (UNSIGNED char *) upcased( question[noq] ));
#endif
*/
		a = i + 1;
	}
	i++;
  }
/*
#ifdef _UNNET
  fclose(ff);
#endif
*/
  val = 0; 

  fp = fopen( KNOW_HOW, "r" );
  if(fp == NULL){
	nerror("smalltalk.c", 265, "smalltalk", "Can't read", KNOW_HOW);
  }


  for(i = 1; i <= noq; i++){	/* SM ;-) MAIN-LOOP */

	if(strlen(question[i]) < 2) continue;

	rewind(fp); found = 0;

	while((fgets(s, STRING, fp) != NULL) && (s[0] == '#'));
	while((fgets(s, STRING, fp) != NULL) && (found == 0)){

		if(strlen(s) < 2) continue;

		sscanf(s, "%s %s %s", v1, v2[i], v3);

		if(strlen(v1) < 4){
			if((strcomp(v1, question[i]) == 0) &&
			   (strcomp(question[i], v1) == 0)) found++;
		}
		else{
			if(strcomp(v1, question[i]) == 0) found++;
		}
	}

	if(found != 0){

		if(v3[ 0] != '0') smv_you		= i;
		if(v3[ 1] != '0') smv_me		= i;
		if(v3[ 2] != '0') smv_not		= i;
		if(v3[ 3] != '0') smv_question		= i;
		if(v3[ 4] != '0') smv_yes		= i;
		if(v3[ 5] != '0') smv_no		= i;

		if(v3[ 6] != '0') smv_object		= i;
		if(v3[ 7] != '0') smv_person		= i;
		if(v3[ 8] != '0') smv_action		= i;
		if(v3[ 9] != '0') smv_smalltalk		= i;
	}
	else{
		strcpy(v2[i], (UNSIGNED char *) "Ach wie gut das keiner weiss, ...");
	}

  } 				/* SM ;-) PASS#1 LOOP */

  fclose(fp);


  /* SM PASS#2 LOOP */


  if(smv_question != 0){		/* Question Mode */
	
	if(strcomp("WHO", 		v2[smv_question]) == 0){

		if(smv_smalltalk != 0){
			if(strcomp("YOU", 	v2[smv_smalltalk]) == 0)
				smv_you = smv_smalltalk;
		}

		if(smv_not == 0){
			if(smv_you != 0){
				sm_who_lisa(); ok++;
			}
			if(smv_me != 0){
				sm_who_you(); ok++;
			}
			if((smv_you == 0) && (smv_me == 0)){
				sm_who(); ok++;
			}
		}
		else{
			sm_who_not(); ok++;
		}
	}

	if(strcomp("WHAT", 		v2[smv_question]) == 0){
		sm_what(); ok++;
 	}

	if(strcomp("WHICH",		v2[smv_question]) == 0){
		sm_which(); ok++;
 	}

	if(strcomp("WHY",		v2[smv_question]) == 0){
		sm_why(); ok++;
	}

	if(strcomp("WHERE",		v2[smv_question]) == 0){
		sm_where(); ok++;
	}

	if(strcomp("WHEN", 		v2[smv_question]) == 0){
		sm_when(); ok++;
	}

	if(strcomp("HOW",		v2[smv_question]) == 0){
		sm_how(); ok++;
	}
		
	if(strcomp("TIME",		v2[smv_smalltalk]) == 0){
		sm_time(); ok++;
	}

	if(strcomp("DATE",		v2[smv_smalltalk]) == 0){
		sm_date(); ok++;
	}

	if(strcomp("SEARCH",		v2[smv_smalltalk]) == 0){
		sm_search(); ok++;
	}
		
  /*
	smv_you, smv_me, smv_not, smv_question, smv_yes, smv_no
	smv_object, smv_person, smv_action, smv_smalltalk
  */
	

  }
  else{				/* Normal/No Question Mode */

	if(strcomp("DOWNLOAD",		v2[smv_smalltalk]) == 0){
		sm_pd(); ok++;
	}

	if(strcomp("DISCUSS",		v2[smv_smalltalk]) == 0){
		sm_dis(); ok++;
	}

	if(strcomp("READ",		v2[smv_object]) == 0){
		sm_read(); ok++;
 	}

	if(strcomp("ME",		v2[smv_me]) == 0){
		sm_me(); ok++;
	}

	if(strcomp("NOT",		v2[smv_not]) == 0){
		sm_not(); ok++;
	}

	if(strcomp("ALL",		v2[smv_smalltalk]) == 0){
		sm_all(); ok++;
	}

	if(strcomp("PROGRAM",		v2[smv_object]) == 0){
		sm_program(); ok++;
	}

	if(strcomp("SYSOP",		v2[smv_person]) == 0){
		sm_syssie(); ok++;
	}

	if(strcomp("PLEASE",		v2[smv_smalltalk]) == 0){
		sm_please(); ok++;
	}

	if(strcomp("HELLO",		v2[smv_smalltalk]) == 0){
		sm_hello(); ok++; lisa_quiet = 0;
	}

	if(strcomp("SO",		v2[smv_smalltalk]) == 0){
		sm_so(); ok++;
	}

	if(strcomp("END",		v2[smv_smalltalk]) == 0){
		sm_end(); ok++;
	}

	if(strcomp("CITY",		v2[smv_object]) == 0){
		sm_city(); ok++;
	}

	if(strcomp("GOOD",		v2[smv_smalltalk]) == 0){
		sm_good(); ok++;
	}

	if(strcomp("STUPID",		v2[smv_smalltalk]) == 0){
		sm_stupid(); ok++;
	}

	if(strcomp("CORRECT",		v2[smv_smalltalk]) == 0){
		sm_correct(); ok++;
	}

	if(strcomp("SHIT",		v2[smv_smalltalk]) == 0){
		sm_shit(); ok++;
	}

	if(strcomp("YOU",		v2[smv_you]) == 0){
		sm_you(); ok++;
	}

	if(strcomp("YES",		v2[smv_yes]) == 0){
		sm_yes(); ok++;
	}

	if(strcomp("NO",		v2[smv_no]) == 0){
		sm_no(); ok++;
	}

	if(strcomp("LISA",		v2[smv_you]) == 0){
		sm_lisa(); ok++; lisa_quiet = 0;
	}

	if(strcomp("PROBLEM",		v2[smv_smalltalk]) == 0){
		sm_problem(); ok++;
	}

	if(strcomp("GIRL",		v2[smv_person]) == 0){
		sm_girl(); ok++;
	}

	if(strcomp("HAHAHA",		v2[smv_smalltalk]) == 0){
		sm_hahaha(); ok++;
	}

	if(strcomp("COMPUTER",		v2[smv_object]) == 0){
		sm_computer(); ok++;
	}

	if(strcomp("QUIET",		v2[smv_smalltalk]) == 0){
		sm_quiet(); ok++; lisa_quiet = 1;
		return 0;
	}

	if(strcomp("QUESTION",		v2[smv_smalltalk]) == 0){
		sm_question(); ok++;
	}

	if(strcomp("MONEY",		v2[smv_object]) == 0){
		sm_money(); ok++;
	}

	if(strcomp("PERKY",		v2[smv_smalltalk]) == 0){
		sm_perky(); ok++;
	}

	if(strcomp("LOVE",		v2[smv_smalltalk]) == 0){
		sm_love(); ok++;
	}

	if(strcomp("KNOW",		v2[smv_smalltalk]) == 0){
		sm_know(); ok++;
	}

	if(strcomp("LONG",		v2[smv_smalltalk]) == 0){
		sm_long(); ok++;
	}

	if(strcomp("WHISKEY",		v2[smv_smalltalk]) == 0){
		sm_whiskey(); ok++;
	}

	if(strcomp("FIGHT",		v2[smv_action]) == 0){
		sm_fight(); ok++;
	}

	if(strcomp("command",		v2[smv_smalltalk]) == 0){
		sm_command(); ok++;
	}

	if(strcomp("ANSWER",		v2[smv_smalltalk]) == 0){
		sm_answer(); ok++;
	}

	if(strcomp("HERE",		v2[smv_smalltalk]) == 0){
		sm_here(); ok++;
	}

	if(strcomp("SEARCH",		v2[smv_smalltalk]) == 0){
		sm_search(); ok++;
	}

	if(strcomp("BUGFREE",	v2[smv_smalltalk]) == 0){
		if(fastmode == 0){
			sm_bugfree(); ok++;
			fastmode = 1;
		}
		else{
			sm_2bugfree(); ok++;
		}
	}
  }

  /* SM PASS#2 LOOP */


  if(ok == 0){
	sm_bug();
  }

  DAS_WARS: if(lisa_quiet) return -1;

  printf("\n\n");

  if(USER.terminal != ISO6429)
	ansi2( "md", 0, 0 );
  else
	ansi2( "X7", 0, 0 );

  printf("[t-bbs] %s >", MY_NAME_IS);
  ansi2( "me", 0, 0 );
  printf(" ");

  if(noq < 3) rationed++;

  if((rationed > 5) && (val < 2)){
	sm_rationed();
	rationed = 0;
  }

  a = 0;

  do{
	r = (rand() % noa) + 1;

	ok = 1;

	for(i = 1; i <= (MAX_HISTORY); i++){
		if(strcomp(answer[r], small_history[i]) == 0) ok = 0;
	}

	a++;
	if(a > 100) ok = 1;	/* Notbremse! */

  }while(ok == 0);

  for(i = 1; i <= (MAX_HISTORY - 1); i++){
	strcpy(small_history[i], (UNSIGNED char *) small_history[i+1]);
  }

  if(a > 100){
	sm_hacker();
	r = (rand() % noa) + 1;  
	hacker_alert++;
  }

  strcpy(small_history[MAX_HISTORY], (UNSIGNED char *) answer[r]);

  if(!fastmode){
	scribble( answer[r] );
  }
  else{
	printf("%s", answer[r]);
  }

  printf("\n");
  answer[r][60] = '\0';
  sprintf(s, "[LISA:] %s", answer[r]);
  control( s, 3);

  if(debugmode){
	  printf("\n[DEBUG] > You: %d  Me: %d  Not: %d  Question: %d  Yes: %d  No: %d",
		smv_you, smv_me, smv_not, smv_question, smv_yes, smv_no);  
          /*		
	  printf("\n\nObject: {%s}  Person: {%s}  Action: {%s}  Smalltalk: {%s}\n",
		question[smv_object], question[smv_person], question[smv_action],
		question[smv_smalltalk]);
	  printf("Object: {%s}  Person: {%s}  Action: {%s}  Smalltalk: {%s}\n",
		v2[smv_object], v2[smv_person], v2[smv_action],
		v2[smv_smalltalk]);
	 */
  }
  /*
  fp = fopen(LISA_LOG, "a" );
  if(fp == NULL){
	nerror("smalltalk.c", 620, "smalltalk", "Can't append to", LISA_LOG);
  }
  strcpy(s, (UNSIGNED char *) USER.name);
  s[10] = '\0';
  fprintf(fp, "%10s: %s\n%10s: %s\n\n", s, cmdline, MY_NAME_IS, answer[r]);
  fclose(fp);
  */
  if (quiet) lisa_quiet = 1;

  return 0;
}

#endif /* SMALLTALK */



