
#include <dirent.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>


#include <strings.h>

#include "mbox.h"


#ifndef VU
#include "s_global.h"
#else
#include "../s_global.h"
#endif






/* #SW - Display a file [fname].

   It's not allowed to show more than [maxlines].

   [mode]   ->  > 999  =  room for a headline 
		 > 99  =  ANSI graphics as first headline
                   99  =  reset global variables (of "show()")
                    0  =  don't stop, don't use "more()"

   This functions returns -1 if the file doesn't exist or can't be
   read and -9 if "show()" is ordered to skip the file. */

#define LLL 80

int show(fname, maxlines, mode)
UNSIGNED char fname[];
int maxlines;
int mode;
{
  FILE *fp;

  UNSIGNED char s[LONGSTRING];
  UNSIGNED char o[LONGSTRING];
  UNSIGNED char t[STRING];
  UNSIGNED char CONTENT[STRING];
  UNSIGNED char address[STRING];
  int ml;
  int ret_status = 0;
  int maxi = ZOPT.OPT->MAX_SCR_LINES;
  int swing = 0;
  int sl, ok;
  int i;
  char *kk;
 
  int HEADER_done = 0;
  int HEADER_path = 0;
  int HEADER_double = 0;

  int FACE = 0;
  int tog_mode = 0;

  ZOPT.OPT->html = 0;
  ZOPT.OPT->html_ref = 1;

  ZOPT.OPT->posit = 0; 

ZOPT.OPT->seite=1;

  if (mode > 9999) {
	mode -= 10000;
	tog_mode++;
	ZOPT.OPT->tog = 1;
  }
  if (mode > 999) {		/* ANSI Headline */
	mode -= 1000;
	maxi -= 8;
	swing = 2;
	ZOPT.OPT->morechen = 1;
  }  
  if (mode > 99) {		/* HEADLINE */
	mode -= 100;
	maxi -= 2;
	swing = 2;
	ZOPT.OPT->morechen = 1;

	if(ZOPT.OPT->USER.terminal == ISO6429) maxi++;
  }
  if (mode == 99) {		/* RESET */
	ZOPT.OPT->show_more = 0;
	return 0;
  }

  fp = fopen(fname, "r");
  if (fp == NULL) {
	return -1;
  }
  ml = 0;
  ZOPT.OPT->morechen = 0;

  CONTENT[0]  = 0;
  ZOPT.OPT->ENCODING[0] = 0;
  address[0]  = 0;
 
  ZOPT.OPT->RTFcomment    = 0;
  ZOPT.OPT->RTFcenter     = 0;
  ZOPT.OPT->RTFrightflush = 0; 
  ZOPT.OPT->RTFheading    = 0;

  ZOPT.OPT->QPkeys 	= 0;



  sprintf(ZOPT.OPT->show_tmp, "%s/show%d", TMP, getpid());
  ZOPT.OPT->page = fopen(ZOPT.OPT->show_tmp, "w");

  if (mode != 2)
	ZOPT.OPT->show_more = 0;
  else
	ZOPT.OPT->morechen = ZOPT.OPT->show_more;

  if (ZOPT.OPT->show_more > maxi) ZOPT.OPT->show_more = 0;


  if(ZOPT.OPT->DISKUSSION){
	while((fgets(t, STRING, fp) != NULL) && (strcomp("Subject: ", t) != 0));

	if(strcomp("Subject: ", t) != 0) return -9;

	if(sgrep( t, ZOPT.OPT->DIS_subject ) != 0){

		sprintf(t, " %s: %s ", GetText("SHO01_MSG"), (UNSIGNED char *) stripped(ZOPT.OPT->DIS_subject) );
		headline( t );
		rewind(fp);
	}		
	else{
		fclose(fp);
		fclose(ZOPT.OPT->page);
		return -9;
	}
  }


  while ((ml < maxlines) && (( kk=fgets(s, LONGSTRING, fp)) != NULL)) 
  {

	ZOPT.OPT->posit++;

	if(ZOPT.OPT->SHORT_HEADER){

		if(strcomp("Content-Type:", s) == 0){
			strcpy(CONTENT, (UNSIGNED char *) strcopy(s, 14, 80));
			if(strcomp("text/richtext", CONTENT) != 0) /* RTF etc. */
				 CONTENT[0] = 0;
		}
		if(strcomp("Content-Transfer-Encoding:", s) == 0){
			strcpy(ZOPT.OPT->ENCODING, (UNSIGNED char *) strcopy(s, 27, 80));
		}

		if((strcomp("Path: ", s) == 0) || (strcomp("Newsgroups: ", s) == 0)){
			HEADER_path++;
			continue;
		}

		if((HEADER_path != 0) && (HEADER_done == 0)){

			if(strcomp("From: ", s) == 0){
				printf("%s %s", GetText("GBL01_MSG"), strcopy(s, 6, strlen(s)));
				fprintf(fp, "%s %s", GetText("GBL01_MSG"), strcopy(s, 6, strlen(s)));
				ZOPT.OPT->morechen++;
			}
			if(strcomp("Subject: ", s) == 0){
				printf("%s %s", GetText("GBL03_MSG"), strcopy(s, 9, strlen(s)));
				fprintf(fp, "%s %s", GetText("GBL03_MSG"), strcopy(s, 9, strlen(s)));
				ZOPT.OPT->morechen++;
			}		
			if(strcomp("Date: ", s) == 0){
				printf("%s %s\n", GetText("GBL02_MSG"), strcopy(s, 6, strlen(s)));
				fprintf(fp, "%s %s\n", GetText("GBL02_MSG"), strcopy(s, 6, strlen(s)));
				ZOPT.OPT->morechen++;
			}
			if(strlen(s) < 3){
				HEADER_done++;
				ZOPT.OPT->morechen++;
			}
			continue;
 		}	
	}
	else{
		if(HEADER_done == 0){
			sprintf(t, "%s %s", GetText("GBL01_MSG"), X_MAIL_DEMON);
			if(strcomp(t, s) == 0){
				do{
					fgets(s, LONGSTRING, fp);
				}while(strcomp("From", s) != 0);
				HEADER_double++;
				ansi2("md", 0, 0);
			}
			if((strcomp("Path:", s)        == 0) || 
			   (strcomp("From", s)	       == 0) ||
			   (strcomp("Newsgroups:", s)  == 0) || 
                           (strcomp(GetText("GBL01_MSG"), s)      == 0) ||
			   (strcomp("Date:", s)        == 0) ||
			   (strcomp("Return-Path:", s) == 0)){
				ansi2("md", 0, 0);
				HEADER_double++;
			}	
			if(strlen(s) < 3){
				HEADER_done++;
				HEADER_double = 0;
				ansi2("me", 0, 0);
			}			
		}
	}

	if(strcomp("From:", s) == 0){
		strcpy(address, (UNSIGNED char *) strcopy(s, 6, 80));
	}
	if(strcomp("Reply-To:", s) == 0){
		strcpy(address, (UNSIGNED char *) strcopy(s, 10, 80));
	}
	if(strcomp("Content-Type:", s) == 0){
		strcpy(CONTENT, (UNSIGNED char *) strcopy(s, 14, 80));
		if(strcomp("text/richtext", CONTENT) != 0) /* RTF etc. */
			 CONTENT[0] = 0;
	}
	if(strcomp("Content-Transfer-Encoding:", s) == 0){
		strcpy(ZOPT.OPT->ENCODING, (UNSIGNED char *) strcopy(s, 27, 80));
				
	}
	if(strcomp("Content-", s) == 0){
		if((HEADER_done != 0) || (ml < 2)){
			HEADER_done++;
			continue; 
		}
	}
	if(strcomp("Xref:", s) == 0){
		continue;
	}
        if(strcomp("X-Face:", s) == 0){
		if(FACE == 0){
			FACE++;
		}
	}
	if((strcomp("<html>", s) == 0) || (strcomp("<!doctype", s) == 0) ||
	   (strcomp("<Head>", s) == 0) || (strcomp("<Title>", s) == 0)){
		ZOPT.OPT->html = 1;
		ZOPT.OPT->morechen = 0;
		ansi2( "cl", 0, 0 );
	}

	if(ZOPT.OPT->html != 0){
		if(strcomp("-------------------------------------------------------------", s) == 0) return 0;
		strcpy(s, (UNSIGNED char *) handle_html(s));
	}	

#ifdef _MULTIMEDIA
	if(strcomp("Quoted-Printable", ZOPT.OPT->ENCODING) == 0){
		strcpy(s, (UNSIGNED char *) quoted_printable(s));
	}
	if(CONTENT[0] != 0){
		strcpy(s, (UNSIGNED char *) richtext(s));
	}
#endif	

	if(ZOPT.OPT->UMLAUT_MODUS != 4) 
		strcpy(s, (UNSIGNED char *) iso_line(s));

	if(ZOPT.OPT->ROT13_MODUS && HEADER_done) 
		strcpy(s, (UNSIGNED char *) unrot13( s ));


	sl = strlen(s);
	while(sl > LLL){
		strcpy(o, (UNSIGNED char *) s);
		sl = LLL; ok = 0;
		i = 0;
		while((s[i] != 0) && (i <= sl)){
			if(s[i] == ESC){
				i++;
				while((s[i] < 65) || (s[i] == '[')){
					i++;
					sl++;
				}
				sl += 2;
			}			
			i++;
		}

		while((sl > 0) && (ok == 0)){
			if(s[sl] < 48){
				ok = sl;
			}
			sl--;
		}
		s[ok] = 0;

		if(sl < (strlen(o)-1)){
			ZOPT.OPT->morechen++;	
		
			if(tog_mode) show_toggle();
			printf("%s", s);
			if(tog_mode) ansi2( "me", 0, 0 );
			printf("\n");
			fprintf(ZOPT.OPT->page, "%s\n", s);
		
			strcpy(s, (UNSIGNED char *)bigcopy(o, ok, strlen(o)));
			sl = strlen(s);
		}
		else{
			sl = 0;
		}	

		if(ok == 0){
			sl = LLL;
		}
		if(s[0] == '\n') s[0] = 0;
	}
	i = strlen(s) -1;
	if(s[i] == '\n') s[i] = 0; 
	
	if(tog_mode) show_toggle();
	printf("%s", s);
	if(tog_mode) ansi2( "me", 0, 0 );
	printf("\n");
	fprintf(ZOPT.OPT->page, "%s\n", s);

	ml++;
	ZOPT.OPT->morechen++;
	if ((ZOPT.OPT->morechen >= maxi) && (mode > 0)) {
		ZOPT.OPT->morechen = 0;
		maxi += swing;
		swing = 0;
		fclose(ZOPT.OPT->page);
		if(ZOPT.OPT->html == 0)
		{
		 if ((ret_status = more())==1) ml = maxlines;
		}
		else
			(void) getint();

		maxi = ZOPT.OPT->MAX_SCR_LINES;	
		if ((ret_status != 0) && (ret_status != 2)) {
			ml = maxlines + 9999;
		}
		else {
			if(ret_status == 2){
				rewind(fp);
				ZOPT.OPT->posit -= (maxi * 2);
				if(ZOPT.OPT->posit < 0) ZOPT.OPT->posit = 0;
				for(i = 0; i < ZOPT.OPT->posit; i++)
  					fgets(s, LONGSTRING, fp); 
			}
			else{
				ZOPT.OPT->page = fopen(ZOPT.OPT->show_tmp, "w");
				if(HEADER_double != 0){
					ansi2( "md", 0, 0 );
				}
			}
		}
		if((ZOPT.OPT->USER.terminal == ISO6429) && (ZOPT.OPT->seite == 2)) maxi--;
	}
  }
  /*
  if (kk==NULL) 
  {
   ansi("X7");
   printf("\n-------- %s --------",(char *) GetText("SHO20_MSG"));
   ansi("me");
   printf("\n");
  }
  */
  fclose(fp);

  ZOPT.OPT->show_more = ZOPT.OPT->morechen;

  if (ZOPT.OPT->page != NULL) fclose(ZOPT.OPT->page);
  unlink(ZOPT.OPT->show_tmp);


  if(FACE != 0){
	faces( fname );
  }


  if((strcomp("PM", ZOPT.OPT->BRETT) == 0) && (address[0] != 0)){
  	filofax( address, 0 );
  }


  return (int) ret_status;
}




/* #MR - Ask user whether he/she likes to see more.

   This functions returns 0 for continue and -1 for stop. 
   And 1 to completly break the action or 2, to go to a
   previous page */

int more()
{
  UNSIGNED char s[LONGSTRING];
  UNSIGNED char c;
  int ok = 0;

FIRST_TRY:

  ansi2("mr", 0, 0);
  printf("                                                                               ");
  if (ZOPT.OPT->ROT13_MODUS)
	printf("%c[ROT13!] [%s] (?) > ", CR, GetText("SHO04_MSG"));
  else
	printf("%c[%s] (?) > ", CR, GetText("SHO04_MSG"));
  ansi2("me", 0, 0);

SECOND_TRY:

  c = getint();

  if (c == '?') {
	ansi2("mr", 0, 0);
	clearline();
	printf("%c%s > ", CR, GetText("SHO05_MSG"));
	ansi2("me", 0, 0);
	goto SECOND_TRY;
  }
  if (c > 96) c -= 32;

  if ((c == DEL) ||
      (c == CTRL_D) ||
      (c == CTRL_X) ||
      (c == GetEChar("SHO06_MSG")) ||
      (c == GetEChar("SHO07_MSG")))
	ok = -1;

  if ((c == GetEChar("SHO08_MSG")) || (c == GetEChar("SHO09_MSG"))) ok = 1;

  if ((c == GetEChar("SHO10aMSG")) || (c == GetEChar("SHO10bMSG"))) ok = 2;

  if (c == GetEChar("SHO10_MSG")) {
	ansi2("cl", 0, 0);
	ansi2("mr", 0, 0);
	printf("                                                                               ");
	printf("%c%s\n", CR, GetText("SHO11_MSG"));
	ansi2("me", 0, 0);	
	ZOPT.OPT->page = fopen(ZOPT.OPT->show_tmp, "r");
	if (ZOPT.OPT->page != NULL) {
		while (fgets(s, LONGSTRING, ZOPT.OPT->page) != NULL) {
			printf("%s", s);
		}
		fclose(ZOPT.OPT->page);
	}
	goto FIRST_TRY;
  }
 
  if(ok != 1){	
  	  if(ok == 2){
		ansi2("cl", 0, 0);
		ZOPT.OPT->seite--;
		if(ZOPT.OPT->seite < 1) ZOPT.OPT->seite = 1;
		sprintf(s, "%s^-  [%s %d]", ZOPT.OPT->headinfo,GetText("SHO12_MSG"), ZOPT.OPT->seite);
		headline(s);
	  }
          else{
	  	ZOPT.OPT->seite++;
	  }
	
	  if ((ZOPT.OPT->USER.more == 3) && (ZOPT.OPT->demo_mode==0)){
		clearline();
	  }
	  else {
		if((ZOPT.OPT->USER.more != 0)&&(ZOPT.OPT->demo_mode==0)){
			ansi2("cl", 0, 0);
			sprintf(s, "%s^-  [%s %d]", ZOPT.OPT->headinfo, GetText("SHO12_MSG"), ZOPT.OPT->seite);
			headline(s);
		}
		else printf("\n\n");
	  }
  }
  else{	
	clearline();
  }

  return (int) ok;
}



/* #RT - Converting a RTF (MIME Richtext) line [s] to a line containing
   ANSI (or any other terminal) codes.

   This function returns the converted line. */

UNSIGNED char *richtext( s )
UNSIGNED char s[];
{
  UNSIGNED char rt[LONGSTRING];
static  UNSIGNED char line[LONGSTRING];
  UNSIGNED char space[LONGSTRING];
  int i = 0, j;
  int l = 0;
  int not;
  int keys = 0;

  while(s[i] != 0){
	if(s[i] != '<'){
		if(ZOPT.OPT->RTFcomment == 0){
			/* RTF-Konform:
			if(s[i] == '\n')
				line[l] = ' ';
			else
				line[l] = s[i];
			NICHT RTF-Konform: */

			line[l] = s[i];
			l++;
			keys++;
		}
	}
	else{
		line[l] = 0;
		not = 0;
		i++;
		j = i;
		while((s[j] != '>') && (s[j] != 0)){
			if(s[j] == '/'){
				i++;
				not++;
			}
			j++;
		}
		strcpy(rt, (UNSIGNED char *) bigcopy(s, i, (j-1)));

		if(not == 0){
			if(strcomp("Bold",       rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "md" ));
			if(strcomp("Italic",     rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "mr" ));
			if(strcomp("Bigger",     rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "mb" ));
			if(strcomp("Flash",      rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "mb" ));
			if(strcomp("Underline",  rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "us" ));
			if(strcomp("Paragraph",  rt) == 0){
				strcat( line, "\n\n");
				ZOPT.OPT->morechen += 2;
			}
			if(strcomp("Comment",    rt) == 0)
				ZOPT.OPT->RTFcomment++;
			if(strcomp("Center",     rt) == 0)
				ZOPT.OPT->RTFcenter++;
			if(strcomp("FlushRight", rt) == 0)
				ZOPT.OPT->RTFrightflush++;
			if(strcomp("Heading",   rt) == 0){
				ZOPT.OPT->RTFheading++;
				strcat( line, (UNSIGNED char *) termansi( "md" ));
			}
		}
		else{
			if(strcomp("Bold",       rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "me" ));
			if(strcomp("Italic",     rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "me" ));
			if(strcomp("Bigger",     rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "me" ));
			if(strcomp("Flash",      rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "me" ));
			if(strcomp("Underline",  rt) == 0) 
				strcat( line, (UNSIGNED char *) termansi( "me" ));
			if(strcomp("Paragraph",  rt) == 0){
				strcat( line, "\n\n");
				ZOPT.OPT->morechen += 2;
			}
			if(strcomp("Comment",    rt) == 0)
				ZOPT.OPT->RTFcomment = 0;
			if(strcomp("Center",     rt) == 0)
				ZOPT.OPT->RTFcenter = 9999;
			if(strcomp("FlushRight", rt) == 0)
				ZOPT.OPT->RTFrightflush = 9999;
			if(strcomp("Heading",   rt) == 0){
				ZOPT.OPT->RTFheading = 9999;
				strcat( line, (UNSIGNED char *) termansi( "me" ));
			}
		}

		if(strcomp("LT", rt) == 0) 
			strcat( line, (UNSIGNED char *) "<" );

		/* NICHT RTF-Konform:
		if(strcomp("NL", rt) == 0){ 
			strcat( line, (UNSIGNED char *)  "\n" );
			ZOPT.OPT->morechen++;
		}
		*/

		if(strcomp("NP", rt) == 0) 
			strcat( line, (UNSIGNED char *) "\f" );
		if(ZOPT.OPT->RTFcomment == 0){
			l = strlen(line);
		}
		i = j;
	}
	i++;
  }
  line[l] = 0;
  strcpy(space, (UNSIGNED char *) "                                                                              ");	

  if((ZOPT.OPT->RTFcenter != 0) || (ZOPT.OPT->RTFheading != 0)){
	i = (79 - keys) / 2; 
	if(i <  0) i = 0;
	if(i > 79) i = 0;
	space[i] = 0;
	strcat(space, (UNSIGNED char *) line);
	strcpy(line, (UNSIGNED char *) space);
  }
  if(ZOPT.OPT->RTFrightflush != 0){
	i = 79 - keys;
	space[i] = 0;
	strcat(space, (UNSIGNED char *) line);
	strcpy(line, (UNSIGNED char *) space);
  }

  if(ZOPT.OPT->RTFcenter     == 9999) ZOPT.OPT->RTFcenter = 0;
  if(ZOPT.OPT->RTFrightflush == 9999) ZOPT.OPT->RTFrightflush = 0;
  if(ZOPT.OPT->RTFheading    == 9999) ZOPT.OPT->RTFheading = 0;

  return (UNSIGNED char *) line;
}





/* #QP - Converting a line [s] regarding QP rules #1 to #5.

   This function returns the converted line. */

UNSIGNED char *quoted_printable( s )
UNSIGNED char s[];
{
static  UNSIGNED char line[LONGSTRING];
  int i = 0, l = 0, p = 0;

  while(s[i] != 0){
	if(s[i] == '='){
		if(s[(i+1)] == '\n'){
			i++;
		}
		else{
			if(s[(i+1)] < 65)
				p = 16 * (s[(i+1)] - 48);
			else
				p = 16 * (s[(i+1)] - 55);
			if(s[(i+2)] < 65)
				p = p  + (s[(i+2)] - 48); 
			else
				p = p  + (s[(i+2)] - 55); 
			line[l] = p;
			l++;
			i += 2;
		}
	}
	else{
		line[l] = s[i];
		l++;
		ZOPT.OPT->QPkeys++;
		if(s[i] == '\n') ZOPT.OPT->QPkeys = 0;
	}

	if(ZOPT.OPT->QPkeys >= 75){
		p = l;
		while((line[p] != ' ') && (p > 0)){
			p--;
		}
		line[p] = '\n';
		ZOPT.OPT->QPkeys = 0;
	}
	i++;
  }
  line[l] = 0;

  return (UNSIGNED char *) line;
}




/* #IC - Converting a character [c] from ISO 8859-1 to another standard.

   This function returns the converted (group of) char(s). */

 
unsigned char *iso_convert( c )		/* !!! unsigned, NOT UNSIGNED !!! */
int c;
{
  int ok = 0;

static   unsigned char t[STRING];

  t[0] = 0; 
  t[1] = 0;

  if(c > 127){

	if(ZOPT.OPT->UMLAUT_MODUS == 1){
		switch(c){
			case 142 :
			case 196 : t[0] = 196; 
				   break;
			case 153 :
			case 214 : t[0] = 214; 
				   break;
			case 154 :
			case 220 : t[0] = 220; 
				   break;
			case 225 : 
			case 223 : t[0] = 223; 
				   break;
			case 132 :
			case 228 : t[0] = 228; 
				   break;
			case 148 :
			case 246 : t[0] = 246;
				   break;
			case 129 :
			case 252 : t[0] = 252; 
				   break;
		}
	}
	if(ZOPT.OPT->UMLAUT_MODUS == INTEL_INSIDE){
		switch(c){
			case 142 :
			case 196 : t[0] = 142; 
				   break;
			case 153 :
			case 214 : t[0] = 153; 
				   break;
			case 154 :
			case 220 : t[0] = 154; 
				   break;
			case 225 : 
			case 223 : t[0] = 225; 
				   break;
			case 132 :
			case 228 : t[0] = 132; 
				   break;
			case 148 :
			case 246 : t[0] = 148;
				   break;
			case 129 :
			case 252 : t[0] = 129; 
				   break;
		}
	}
	if(ZOPT.OPT->UMLAUT_MODUS == 3){
		switch(c){
			case 142 :
			case 196 : t[0] = 'A'; ok++;
				   break;
			case 153 :
			case 214 : t[0] = 'O'; ok++;
				   break;
			case 154 :
			case 220 : t[0] = 'U'; ok++;
				   break;
			case 225 : 
			case 223 : t[0] = 's'; 
				   t[1] = 's';
				   break;
			case 132 :
			case 228 : t[0] = 'a'; ok++;
				   break;
			case 148 :
			case 246 : t[0] = 'o'; ok++;
				   break;
			case 129 :
			case 252 : t[0] = 'u'; ok++;
				   break;
		}
		if(ok != 0){
			t[1] = 'e';
		}
		t[2] = 0;
	}
	if(t[0] == 0) t[0] = c;
  }
  else{
	t[0] = c;
  }

  return (UNSIGNED char *) t;
}



/* #IL - Converting a line [s] from ISO 8859-1 to another standard.

   This function returns the converted line. */

unsigned char *iso_line( s )
unsigned char s[];		/* !!! unsigned, NOT UNSIGNED !!! */
{
  unsigned char t[LONGSTRING];
static  unsigned char z[LONGSTRING];

  int i = 0;

  t[0] = 0;

  while(s[i] != 0){
	strcat(t, (unsigned char *) iso_convert( s[i] ));
	i++;
  }

  strcpy(z, (UNSIGNED char *) t);
 
  return (unsigned char *) z;
}



/* THANX (!) to Iain Lea (TIN) for the following ... */


/* #RO - Encrypting a line [s] using ROT13 algorythm.

   This function returns the converted line. */

UNSIGNED char *rot13( s )
UNSIGNED char s[];
{
static  UNSIGNED char t[LONGSTRING];

  int i = 0;

  t[0] = 0;

  while(s[i] != 0){
	if((s[i] >= 'A') && (s[i] <= 'Z')){
		t[i] = 'A' + (s[i] + 'A' + 13) % 26;
	}
	else{
		if((s[i] >= 'a') && (s[i] <= 'z')){
		s[i] -= 32;
		t[i] = 'A' + (s[i] + 'A' + 13) % 26;
		t[i] += 32;
	}
		else{
			t[i] = s[i];
		}
	}
	i++;
  }

  t[i] = 0;

  return (UNSIGNED char *) t;
}



/* THANX (!) to Iain Lea (TIN) for the following ... */


/* #UR - Decrypting a line [s] using ROT13 algorythm.

   This function returns the converted line. */

UNSIGNED char *unrot13( s )
UNSIGNED char s[];
{
static   UNSIGNED char t[LONGSTRING];
  int i = 0;

  t[0] = 0;

 
  while(s[i] != 0){
	if((s[i] >= 'A') && (s[i] <= 'Z')){
		t[i] = 'A' + (s[i] - 'A' + 13) % 26;
	}
	else{
		if((s[i] >= 'a') && (s[i] <= 'z')){
		t[i] = 'a' + (s[i] - 'a' + 13) % 26;
	}
		else{
			t[i] = s[i];
		}
	}
	i++;
  }

  t[i] = 0;

  return (UNSIGNED char *) t;
}



/* #SR - Display a file without converting (esp. for ANSI files) */

void show_raw( path, ypos )
UNSIGNED char path[];
int ypos;
{
  UNSIGNED char s[LONGSTRING];

  FILE *fp;

  if(ypos != 0) ansi( "cl");
 
  if ((ZOPT.OPT->USER.terminal==5)||(ZOPT.OPT->USER.schluessel[3] == 128))
    printf("\033(K"); /*this is for the special characters*/
    
  fp = fopen( path, "r" );
  if(fp == NULL){
	/*
	nerror( "show.c", 873, "show_raw()", "Can't open", path );	
	*/
	return;
  }
  while(fgets(s, LONGSTRING, fp) != 0){
	printf("%s", s);
  }
  fclose(fp);

  if(ypos != 0) ansi2( "cm", 1, ypos );
}


int show_toggle()
{
  if(ZOPT.OPT->tog == 1){
	ZOPT.OPT->tog = 0;
 	
	if(ZOPT.OPT->USER.terminal != ISO6429)
		ansi2( "md", 0, 0 );
	else
		ansi2( "X7", 0, 0 );
  }
  else{
	ZOPT.OPT->tog = 1;
	
	if(ZOPT.OPT->USER.terminal != ISO6429)
		ansi2( "me", 0, 0 );
	else
		ansi2( "X8", 0, 0 );
  }
  return(0);
}



/* #HT - WWW/html format handler ... don't expect too much ;-) */

UNSIGNED char *handle_html( s )
UNSIGNED char s[];
{
static  UNSIGNED char line[LONGSTRING];
  UNSIGNED char t[STRING];
  UNSIGNED char u[STRING];

  int i = 0, a = -1, b = -1, l = 0;
  int not = 0;

  int headline = 0;

  FILE *fp;
 
  /*
  fp = fopen( "log", "a" );
  fprintf(fp, "1 %s", s);
  */

  line[0] = 0;
  
  while(s[i] != 0){
	if(s[i] == '<'){
		a = i + 1;
		while((s[i] != 0) && (s[i] != '>')) i++;
		b = i -1;
		not = 0;
		if(s[a] == '/'){
			not++;
			a++;
		}
		strcpy(t, (UNSIGNED char *) strcopy(s, a, b));	

		if(not == 0){
			if(strcomp("!DOC",      t) == 0)
				strcat( line, (UNSIGNED char *) termansi( "X2" ));
			if(strcomp("Body",      t) == 0)
				strcat( line, (UNSIGNED char *) termansi( "X2" ));
			if(strcomp("Head",      t) == 0)
				strcat( line, (UNSIGNED char *) termansi( "X2" ));
			if(strcomp("Title",     t) == 0){
				strcat( line, (UNSIGNED char *) termansi( "X4" ));
				headline = 1;
			}
			if(strcomp("Address",   t) == 0)
				strcat( line, (UNSIGNED char *) termansi( "X6" ));
			if(strcomp("Pre",       t) == 0)
				strcat( line, (UNSIGNED char *) termansi( "X0" ));
			if(strcomp("I",         t) == 0)
				strcat( line, (UNSIGNED char *) termansi( "X1" ));
			/*
			if(strcomp("P",         t) == 0)
				strcat( line, (UNSIGNED char *) termansi( "md" ));
			*/
			if(strcomp("Tt",        t) == 0)
				strcat( line, (UNSIGNED char *) termansi( "us" ));
			if(strcomp("H1",        t) == 0){
				strcat( line, (UNSIGNED char *) termansi( "X9" ));
				headline = 2;
			}
		}
		else{
			/*
			if(strcomp("A",         t) == 0){
				sprintf(u, "[%d] ", html_ref); html_ref++;
				strcat(line, (UNSIGNED char *) u);				
			}
			else{
				strcat(line, (UNSIGNED char *) termansi( "me" ));
				strcat(line, (UNSIGNED char *) termansi( "X2" ));
			}	
			*/
			strcat(line, (UNSIGNED char *) termansi( "me" ));
			strcat(line, (UNSIGNED char *) termansi( "X2" ));
		}
		l = strlen( line );
	}
	else{
		line[l] = s[i];
		l++; line[l] = 0;
	}
	i++;
  }

  if(headline != 0){
	strcpy(t, (UNSIGNED char *) line );
	strcpy(line, (UNSIGNED char *) "                                                                            ");
	a = 0; i = 0;
	while(t[i] != 0){
		if((t[i] > 64) && (t[i] != '[') && (t[i] != ';')) a++;
		i++;
	}
	a = 40 - (a/2);
	line[a] = 0;
	strcat(line, (UNSIGNED char *) t ); 

	if(headline == 1){
		ansi2( "X4", 0, 0 );
		clearline(); 
	}
  }

  /*
  fprintf(fp, "2 %s", line);
  fclose(fp);
  */ 
  
  return (UNSIGNED char *) line; 
}





void ViewWait()
{
   printf("\n");
   ansi("mb");
   printf("wait....");
   ansi("me");
}