/* 
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+  File-Upload-Func 							+
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/

#undef DEBUG3

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <utmp.h>
#include <time.h>
#include <dirent.h>

#ifndef VU
#include "mbox.h"
#include "sfile.h"
#include "s_global.h"
#else
#include "../mbox.h"
#include "../sfile.h"
#include "../s_global.h"
#endif


/*#include <stdlib.h>*/
#include <strings.h>



int fbytes=0,ffile=0;
unsigned char namen_dir [STRING];




void s_profile(s,cps,bps,eff,err,protokoll,rem)
unsigned char s[];
int cps,bps,eff,err;
unsigned char protokoll;
unsigned char rem[];
{ 
 FILE *fd;
 unsigned char t[STRING],t2[STRING];
 extern int SCRATCH_PD;

if (!SCRATCH_PD)
{ 
 sprintf(t,"%s/%s",ZOPT.OPT->HOME,S_PROFILE);
 if ((fd=fopen(t,"a"))!=NULL)
 {      
        sprintf(t, "%s  %c  %-40.40s", mydate( 1 ), 
               protokoll, leer2slash(dir2nam(s))); 
        if (!err)
        {
	    sprintf(t2, "  %6d  %6d  %2d%% OK", cps, bps, eff);
	} else 
	{
	    sprintf(t2, "  %6d  %6d  %2d%% BRK", cps, bps, eff);
	}
	strcat(t,(char *) t2); strcat(t,(char *) "  ");  strcpy(t,(char *) str_fill(t,79)); strcat(t,(char *) "\n");
	fprintf(fd, "%s",t);
	fclose(fd);
  }

 sprintf(t,"%s/%s",ZOPT.OPT->HOME,S_UPLOAD_PROF);  
 if ((fd=fopen(t,"a"))!=NULL)
 {
        fprintf(fd, 
        	"%s :	%s	Level:%d,\nuid:	%d	bytes: %d\n%s\n%s\n----\n",
        	mydate( 1 ), ZOPT.OPT->USER.name,	ZOPT.OPT->USER.level,ZOPT.OPT->USER.id,fbytes,s,rem); 
	fclose(fd);
  }  
} else  /* SCRATCH_PD_LOG */
{
 sprintf(t,"%s/%s",ZOPT.OPT->HOME,SSCRATCH_LOG);
 if ((fd=fopen(t,"a"))!=NULL)
 {
        fprintf(fd, "%s  %-20.20s %c  %-40.40s", mydate( 1 ),ZOPT.OPT->USER.name, 
               protokoll, leer2slash(dir2nam(s))); 
        if (!err)
        {
	    fprintf(fd, "  %6d  %6d  %2d%% OK\n", cps, bps, eff);
	} else 
	{
	    fprintf(fd, "  %6d  %6d  %2d%% BRK\n", cps, bps, eff);
	}
	fclose(fd);
  }

}
}


/* schreibt die REM-Datei fuer ASCII */
void inf(nam,rem)
unsigned char nam[],rem[];
{
FILE *fd;
unsigned char t[STRING];
extern int SCRATCH_PD;

strcpy(t,nam);
strcat(t,INF);
/*
printf("SCRATCH_PD: %d, USER-name: %s, SCRATCH-USER: %s\n",SCRATCH_PD,ZOPT.OPT->USER.name,ZOPT.OPT->SCRATCH_USER);
sleep(4);
*/
if ((fd=fopen(t,"w"))!=NULL)
{
 if (!SCRATCH_PD) fprintf(fd, "%s\n%s (%d), %s\n",rem,ZOPT.OPT->USER.name,ZOPT.OPT->USER.id,mydate( 1 )); 
  else fprintf(fd, "%s\n%s\n%s\n",rem,ZOPT.OPT->USER.name,ZOPT.OPT->SCRATCH_USER); 
 fclose(fd);
}
}



/*  REM-Files fuer jeden Upload in tmp-dir*/ 
void inf2(path,rem)
unsigned char path[],rem[];
{
FILE *fd;
unsigned char t[STRING];
struct dirent *actdir;
DIR *dp;
struct stat fst;
extern int SCRATCH_PD;


chdir(path); fbytes=0;
namen_dir[0]=0;
dp = opendir(path);
readdir(dp);
readdir(dp);
while(((actdir = readdir(dp)) != NULL)   )
{
  if (!strpos(INF,actdir->d_name))
  { 
    sprintf(t,"%s/%s",path,actdir->d_name);
    strcpy(namen_dir,actdir->d_name);
    
    stat(t, &fst);			
    fbytes += fst.st_size;
    ffile ++;
    strcat(t,INF);
    if ((fd=fopen(t,"w"))!=NULL)
    {
        if (!SCRATCH_PD) fprintf(fd, "%s\n%s (%d) %s\n",rem,ZOPT.OPT->USER.name,ZOPT.OPT->USER.id,mydate( 1 )); 
          else fprintf(fd, "%s\n%s\n%s\n",rem,ZOPT.OPT->USER.name,ZOPT.OPT->SCRATCH_USER); 
        fclose(fd);
    }
   }
}
}





/* erzeugt noetigen alle Pfade  */
void mkpath(s,akt)
unsigned char s[STRING];
int akt;
{ 
 unsigned char t[STRING],l[STRING];
 
 strcpy(t,(char *) slash2leer(s));
 strcpy(t,(char *) cut_leer(slash2leer(s)));
 strcpy(l,(char *) cut_bef(t));
 chdir("/");
 do 
 { 
   mkdir(l,0777); chdir(l); 
   strcpy(t,(char *) cut_leer(cut_arg(t)));
   strcpy(l,(char *) cut_bef(t));
 } while (strlen((char *) cut_arg(t))!=NULL);
  if (akt)
  { 
       mkdir(l,0777); chdir(l);
   }
 chdir(ZOPT.OPT->HOME);
}






/* Protokoll abfragen */
unsigned char protoK()
 {
 unsigned char protokoll=0;
 
      printf("\n");	
      printf("%c%s, ? > ", CR, GetText("MIS13_MSG"));
      ansi2("me", 0, 0);

      do {
	     protokoll = getint();
	     if (protokoll >= 97) protokoll -= 32;
		if (protokoll == '?') {
		     clearline();
		     ansi2("mr", 0, 0);
		     printf("%c%s > ", CR, GetText("MIS14_MSG"));
		     ansi2("me", 0, 0); 
		}
		if ((protokoll != GetEChar("MIS15_MSG")) && (protokoll != GetEChar("MIS15_MSG")) &&
		    (protokoll != GetEChar("MIS18_MSG")) && (protokoll != GetEChar("MIS17_MSG") ))
		     protokoll = 0;
	} while (protokoll == 0);

	printf("%c", protokoll);
    return(protokoll);
 }


/* Upload in die local.pd-Gruppen der MBOx */
void MBox_Upload(path)
unsigned char path[];
{
  if (ZOPT.OPT->USER.level < ZOPT.OPT->WRITE_IN_LEV) {
		FMsgBox(GetText("LOP16_MSG"));
	}
 else
 {
   brett(cut_leer(strich2punkt(path)));
   schreiben("");
 }
}





/* #SN - Upload von einem Bin-File */


void upload(arg,rem,protokoll)
UNSIGNED char arg[STRING],rem[STRING];
UNSIGNED char protokoll;
{
  FILE *fp;
  UNSIGNED char s[STRING];
  UNSIGNED char tmp0[STRING],pubdir[STRING];
  UNSIGNED char tmp[STRING];
  UNSIGNED char /* protokoll=0, */  lf=0;
  extern int SCRATCH_PD;
  int c,a1,a2,a3,a4;
  int cps,bps,eff=0,err=0;
  struct stat fst;
  
  long tn, ts;
  
if (ZOPT.OPT->USER.level < ZOPT.OPT->WRITE_IN_LEV) {
		FMsgBox(GetText("LOP16_MSG"));
		}
else 
{		
if (ZOPT.OPT->USER.level<DIRECT_UPLOAD_LEVEL)
{
 sprintf(tmp0,"%s/%s",ZOPT.OPT->HOME,UHOME);
 strcpy(tmp,tmp0); 
 strcat(tmp,"/");
 strcat(tmp,arg);
} else
{
 sprintf(tmp0,"%s/%s",ZOPT.OPT->HOME,DHOME);
 strcpy(tmp,tmp0); 
 strcat(tmp,"/");
 strcat(tmp,arg);
}
if (SCRATCH_PD)
{
 sprintf(tmp0,"%s/%s",ZOPT.OPT->HOME,DHOME);
 strcpy(tmp,tmp0); 
 strcat(tmp,"/");
 strcat(tmp,arg);
}
		noctrlx();
		ansi2("mr", 0, 0); 
		printf("\n%s  (%s) [%c,%c]",GetText("SF_D44"),
		   arg,GetEChar("GBL06_MSG"),GetEChar("GBL07_MSG")); /* Starten ! */
		
		 
	   if (yesno2())
	   {	
			
			printf("\n\n");
			FMsgBox(GetText("PD13a_MSG"));  /* BRK -> CTRL+X */

			ansi2("me", 0, 0);
			a1=GetEChar("MIS15_MSG");
			a2=GetEChar("MIS16_MSG");
			a3=GetEChar("MIS17_MSG");
			a4=GetEChar("MIS18_MSG");
 	
 	         if (protokoll==a1)
 	         {
			                mkpath(tmp,NULL);
					fp = fopen(tmp, "w");
					if (fp == NULL) {
						nerror("s_upload.c", 97, "ascii-upload", "Can't write to", tmp);
					}
					c = 0;
					lf = CR;
					fputc(LF, fp);

					/*
					while ((c != CTRL_X) && (c != CTRL_D)) {
					*/
					while ((c != CTRL_E) && (c != CTRL_D)) {
						c = getint();
						if ((c == CR) && (lf == CR))
							fputc(LF, fp);
						if (c == CR) lf = CR;
						if (c == LF) lf = LF;
						/*
						if ((c != CTRL_X) && (c != CTRL_D) && (c != CR)) {
							fputc(c, fp);
						}
						*/
						if ((c != CTRL_E) && (c != CTRL_D) && (c != CR)) {
							fputc(c, fp);
						}
					}
					fclose(fp);
		} else
		{
		   if (protokoll==a2)
		   {
					printf("\n");
					sprintf(s, "exec %s -c TimeTravelAgency 2> /dev/null", RX);
					mkpath(tmp,1);
		   } else
		   {
		         if (protokoll==a3)
		         {
					printf("\n");
					sprintf(s, "exec %s 2> /dev/null", RB);
					mkpath(tmp,1);
		         } else
		         {  
					printf("\n");
					sprintf(s, "exec %s 2> /dev/null", RZ);
					mkpath(tmp,1);
			 }
		   }
		}


			if (protokoll != GetEChar("MIS15_MSG")){ /* !=ASCII */
			        sprintf(pubdir,"%s/%s/sfile.upload.%d",ZOPT.OPT->HOME,TMP,ZOPT.OPT->USER.id);
				ffile=1;
				mkdir( pubdir, 0777 );
				chdir( pubdir );

				time(&ts);
				
				if (!ssystem( s )) err=1;  /* Upload - exec */
				
				time(&tn); tn = tn - ts;
				tn -= 10;  /* 10 = "Toleranz" */
	
				chdir( ZOPT.OPT->HOME );
				inf2(pubdir,rem);
				sprintf(s, "mv %s/* %s", pubdir, leer2slash(dir2path(tmp)));
				
				ssystem( s ); /* mv tmp->dir */
				sprintf(s, "rm -r %s", pubdir);
				ssystem( s ); /* rm */
		} 
			ctrlx();
			
			if (protokoll==GetEChar("MIS15_MSG")) {
			  stat(tmp, &fst);			
			  fbytes=fst.st_size;
			}
			
			
			
			if (fbytes ==NULL) {
				FMsgBox(GetText("SF_D46"));
				err=1;
				strcat(tmp,INF);
				unlink(tmp); 
				return;
			} else 
			{
			  if (protokoll==GetEChar("MIS15_MSG")) inf(tmp,rem); /* bei ASCII */
			}
			
			printf("\n");
			ansi2( "md", 0, 0 );
			printf("%d %s %d)\n",fbytes, GetText("SF_D47"),ffile );
			
			if(tn < 1) tn = 1L;
			
			cps=fbytes/tn; 
			bps=(fbytes / tn)*11;
			ZOPT.OPT->BAUDRATE = bbs_baudrate( bps );
			eff = ((100000 / ZOPT.OPT->BAUDRATE) * bps) / 1000;  
			
			printf("%s %d cps (ca. %d bps).", GetText("MIS26_MSG"),
				(fbytes / tn), ((fbytes / tn) * 11));				
			ansi2( "me", 0, 0 );
			
			
			
			if (err) FMsgBox(GetText("PD14_MSG"));
			  else 
			 {
#ifdef DLUP_RATIO			 
			    ZOPT.OPT->USER.upratio += ((long) fbytes / 1000);
			    printf("\n%s %d %s %d kB)\n",GetText("SD05_MSG"),fbytes / 1000,GetText("SD05a_MSG"),
			        ZOPT.OPT->USER.upratio);
#endif
			    if (ZOPT.OPT->USER.level<DIRECT_UPLOAD_LEVEL)
			    {
			      printf("\n%s\n%s\n",GetText("SD01_MSG"),GetText("SD01a_MSG"));
			    }
			    else
			    {
			      printf("\n%s\n%s\n",GetText("SD02_MSG"),GetText("SD02a_MSG"));
			      ZOPT.OPT->AENDERUNG=1;
			    }
			    			    
			 }
			
			/*
			if (protokoll==GetEChar("MIS15_MSG")) s_profile(tmp,cps,bps,eff,err,protokoll,rem);
			  else {
			           strcat(tmp,namen_dir);
			           s_profile(tmp,cps,bps,eff,err,protokoll,rem);
			       }
			 */
			
	  } else FMsgBox(GetText("SF_D45"));
	  chdir(ZOPT.OPT->HOME);
}	  
printf("\n");
}

