#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <dirent.h>
#include <signal.h>

#include <errno.h>

#include <stdio.h>
/*#include <stdlib.h>*/
#include <unistd.h>
#include <strings.h>




#define MAX_CDDRIVES	10


#ifndef VU
#include "mbox.h"
#include "s_global.h"
#else
#include "../mbox.h"
#include "../s_global.h"
#endif







void GlobalPdLog(err,protokoll,bps,cps,eff,name)
int protokoll, cps, eff,err;
unsigned char *name;
{
 FILE *fp;
 char tmp[STRING],t2[STRING];
  
  sprintf(tmp,"%s/%s",ZOPT.OPT->HOME,PDLOG);
  fp = fopen( tmp, "a" );
  
  
  if(fp != NULL){
		     sprintf(tmp, "%s  %c  %-41.41s", 
		       mydate( 1 ), protokoll, name); 
		     if(  (bps > 0) && (!err))
		     {
		     sprintf(t2,   " %05d  %06.5d  %04d%% OK", cps, bps, eff);
	             }
	             else
	             {
		       sprintf(t2, " %05d  %06.5d  %04d%% BRK", cps, bps, eff);
	             }
	             strcat(tmp,t2);   
	             fprintf(fp, "%-78.78s\n",tmp);
     fclose(fp);
  }
}


/* Mail-Size-Logging to File */
/*  modes :
 * 		0	-> aliases-adr
 *		1 	-> rmail-adr
 */
void LogMailStat(mode,name,to,alias)
int mode;
unsigned char *name,*to,*alias;
{
FILE *fd;
unsigned char s[STRING],_to[STRING];
struct stat fst;

chdir(ZOPT.OPT->HOME);
strcpy(_to,to);

if (checkdomain(_to)||(ZOPT.OPT->maillogsize<10)) 
{ 
 return;  /* lokale Mails  nicht loggen */
}
stat(name,&fst);
if (mode==1) sprintf(s,"%s/etc/log/rmail/%s",ZOPT.OPT->HOME,leer2punkt(ZOPT.OPT->USER.name));
if (mode==0) sprintf(s,"%s/etc/log/rmail/%s",ZOPT.OPT->HOME,leer2punkt(GetRealName(alias)));


if ((fd=fopen(s,"a"))!=NULL)
{
  if ((fst.st_size>ZOPT.OPT->maillogsize)&&(mode==1)) /* normal-rmail */
  {
   fprintf(fd,"%s,%s [%d]-> %s \n",mydate(0),mytime(0),fst.st_size,_to) ;
   }
  if ((fst.st_size>ZOPT.OPT->maillogsize)&&(!mode)) /* alias-rmail */
  {
   fprintf(fd,"%s,%s [%d]<- %s (alias-mail bbs->)\n",mydate(0),mytime(0),fst.st_size,ZOPT.OPT->USER.name) ;
  }
  fclose(fd);
}

}