
#include <stdio.h>
#include <sys/types.h>
#include <setjmp.h>
#include <sys/stat.h>

#include <unistd.h>
#include <dirent.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <strings.h>



#include "mbox.h"

#undef DEBUG

#ifndef _MINIX
#define UNSIGNED unsigned
#else
#define UNSIGNED
#endif

#define LONGSTRING 256
#undef STRING
#define STRING 80

struct OPT_T {
 int hidden,      		/* im Hintergrund weitermachen, alle Signale ignorieren :-) */
     print,	  		/* Anzeige der Schalter */
     nice,			/* nice-flag */
     new_f,			/* neues MBRSH Uebergabe-Format */
     uid,gid;	  		/* UID / GID */
 char system[LONGSTRING];	/* Befehlszeile */
} OPT;



int CommandOptions (argc, argv)
int argc;
char *argv[];
{

int i;
unsigned char s[STRING];


 if (!((getgid()==GUEST_GID)&&(getuid()==GUEST_GID)))
  {
      printf("\n\7exec failure: permission denied.\n");
      sleep(1);
      exit(-3);
  }
           	
SetClean();

	for (i=1; i<argc; i++)
	{
		switch (argv[i][0])
		{
		
		case '~':
			switch (argv[i][1])
			{
						
			case 'N':	
					OPT.new_f=1;
					break;
					

			case 'H':	OPT.hidden=1;
					break;
			
			case 'p':	OPT.print=1;
					break;
					
			
			case 'n':	
					strcpy(s,&argv[i][2]);
					OPT.nice= atoi(s);
					break;
					
									
			default:	/*BadFlag (argv[i]);*/
					strcat(OPT.system," '");
				        strcat(OPT.system,argv[i]);
				        strcat(OPT.system,"'");
					break;
					
			}
			break;




		default:
		  if(!(i<(argc-2)))
		  {
		   if (atoi(argv[i]))
		   {
		   if (!OPT.gid) OPT.gid=atoi(argv[i]) ;
		    else  OPT.uid=atoi(argv[i]) ;
		   }
		  } else
		  {
		  strcat(OPT.system," ");
		  strcat(OPT.system,argv[i]);
		  }
		  break;
		}
	}
return(0);
}



void SetClean()
{
 OPT.hidden=OPT.print=OPT.nice=OPT.new_f=0;
 OPT.uid=OPT.gid=0;	  		
 strcpy(OPT.system,"");
}


void PrintOpt()
{
 printf("\nOPT.hidden=%d",OPT.hidden);
 printf("\nOPT.print=%d",OPT.print);
 printf("\nOPT.nice=%d",OPT.nice);
 printf("\nOPT.new_f=%d\n",OPT.new_f);
 printf("\nOPT.gid=%d",OPT.gid);
 printf("\nOPT.uid=%d",OPT.uid);
 printf("\nOPT.system=%s\n",OPT.system);
 exit(0);
}



void Hidden()
{
int temp;


  while ((temp = fork()) < 0) sleep(1);

  if (temp) exit(0);	/* not mbrsh_exit() !!! */
  
#ifndef BSD
   setpgrp();
#else
   setpgrp(0,getpid());
#endif  

}





int BadFlag (c)
char *c;
{
	fprintf (stderr, "%s: bad flag: %s\n", "bbs_mail", c);
	exit (0);
}





void sigcatch(sig)
int sig;
{
printf("\nSignal: %d\n",sig); 
 

  switch (sig) {

	case SIGQUIT:
	case SIGABRT:
	case SIGINT:
	case SIGTERM:          	
        case SIGTSTP:    
        case SIGCONT:    	      
	case SIGHUP:     
		        setgid( 0 ); 
                        setuid( 0 ); 
                        kill(getppid(),SIGHUP);
                        exit(-1);
			break;
  }
}






void InstallSig()
{
	signal(SIGINT,  sigcatch);
	signal(SIGQUIT, sigcatch);
	signal(SIGHUP,  sigcatch);
	signal(SIGABRT, sigcatch);
#ifdef JOBCONTROL
    signal(SIGTSTP, sigcatch);               /* stop signal              */
    signal(SIGCONT, sigcatch);               /*Y/N stop signal              */
#endif	
	signal(SIGTERM, sigcatch);
}






int main(argc, argv)
int argc;
UNSIGNED char *argv[];
{
  int pid,ret;

if (argc<3) return(-1);


CommandOptions(argc,argv);

InstallSig();
if (OPT.print) PrintOpt();
  if (OPT.gid!=0) setgid( OPT.gid );
  if (OPT.uid!=0) setuid( OPT.uid );
  if (OPT.nice!=0) nice( OPT.nice );
  if (OPT.hidden) Hidden();
#ifdef DEBUG
 printf("\nmbrsh: %s\n",OPT.system);
#endif
  if (OPT.hidden)
  {
  strcat (OPT.system," ");  strcat (OPT.system,">>/dev/null"); 
  }
  if (((ret=system( OPT.system ))!=127))
  {
   pid=getppid();
   setuid( ROOT_UID );
   setgid( ROOT_GID ); 
#ifdef DEBUG   
   printf("\ncleanup(), ret=%d,  ppid: %d, UID: %d, GID: %d",ret,pid,getuid(),getgid());
   kill(pid,SIGHUP);
#endif   
  }
  return 0;
}


