
#ifndef _ESTDIO
#include <stdio.h>
#else
#include <estdio.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <dirent.h>

#include <errno.h>

#include "mbox.h"


/* #SE - This is used by MB-DAEMON to build up some Stock files. 

   The parameter [path] contains the path to a news article which
   has to be analysed. The "Subject:" line of this article is
   delivered in [subj]. */

stock_exchange( path, subj )
UNSIGNED char path[];
UNSIGNED char subj[];
{
  FILE *fp;
  FILE *ff;  
  FILE *wp;

  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char idx[STRING];

  int i, wpkn = 1;

  fp = fopen( path, "r" );
  if(fp == NULL){
	/*
	nerror("dstock.c", 53, "stock_exchange", "Can't read", path );		
	*/
	return;
  }

  while((fgets(s, STRING, fp) != 0) && (strlen(s) > 1));
  
  if(strcomp(STOCK_DJ,		 subj) == 0){

	if(strcomp(WPKN_DJ,	 subj) == 0)
		sprintf(s, "%s/dj.wpkn", STOCK_PATH);
	else{
		while((fgets(s, STRING, fp) != 0) && (strcomp("DATUM", s) != 0));
		strcpy(t, (UNSIGNED char *) strcopy(s, 7, 14));
		if(t[0] > '9') return;
		sprintf(s, (UNSIGNED char *) "%s/%s.dj", STOCK_PATH, t);
		wpkn = 0;
		sprintf(idx, "%s/dj.wpkn", STOCK_PATH);
	}
  } 


  if(strcomp(STOCK_DAX,		 subj) == 0){

	if(strcomp(WPKN_DAX,	 subj) == 0)
		sprintf(s, "%s/dax.wpkn", STOCK_PATH);
	else{
		while((fgets(s, STRING, fp) != 0) && (strcomp("DATUM", s) != 0));
		strcpy(t, (UNSIGNED char *) strcopy(s, 7, 14));
		if(t[0] > '9') return;
		sprintf(s, (UNSIGNED char *) "%s/%s.dax", STOCK_PATH, t);
		wpkn = 0;
		sprintf(idx, "%s/dax.wpkn", STOCK_PATH);
	}
  }

  i = 0;
  
  while(s[i] != 0){
	if(s[i] == ' ') s[i] = '-';
	i++;
  }  

  ff = fopen( s, "w" );
  if(ff == NULL){
	mkdir( STOCK_PATH, 0777 );
	if(fp != NULL) fclose(fp);
	return;
  }

  if(wpkn == 1){

	while(fgets(s, STRING, fp) != 0){
		fputs(s, ff);
	}

  }
  else{

	wp = fopen( idx, "r" );
	if(wp == NULL){
		if(ff != NULL) fclose(ff);
		if(fp != NULL) fclose(fp);
		return;
	}

	fgets(t, STRING, wp);

	while(fgets(s, STRING, fp) != 0){
		fgets(t, STRING, wp);
		fprintf(ff, "%s%s", t, s);
	}

	fclose(wp);
  }

  fclose(ff);
  fclose(fp);
}
