{ OCT 97 - Release Notes                                         }
{ Used for multi user system                                     }

Unit LockUser;

interface

Uses Dos, Crt, Lib, Data, Dates, CDrop, Fossil, Stats, Errorlog, WaitTix;

Procedure LockUserFile(UserNumber : String);
Procedure CheckLockFile;

implementation

type
  Node = Record
       NodeNumber : Byte;
end;

Procedure LockUserFile(UserNumber : String);
Var
  LocFile    : File of Node;
  FileMask   : string;
  NodeNum    : Node;
begin
  If BBSCfg.NodeDir[Length(BBSCfg.NodeDir)] = '\' then
    begin
      FileMask := BBSCfg.NodeDir + UserNumber + '.LOC';
    end
  Else
    begin
      FileMask := BBSCfg.NodeDir + '\' + UserNumber + '.LOC';
    end;
  NodeNum.NodeNumber := BBSCfg.Node;
  Assign(LocFile, FileMask);
  {$I-} Reset(LocFile); {$I+}
  If IOResult = 0 then
    begin  { Checks To See Wether User Is Already On Other Nodes }
      LineFeed;
      LineFeed;
      Print('User Already Logged On Another Node..!');
      LogError('Duplicate User Tried To Log On To System');
      Wait(30);
      Error := 3;
      Close(LocFile);
    end
  Else
    begin
      Rewrite(LocFile);
      Write(LocFile, NodeNum); { Write Node Number To Loc File }
      Close(LocFile);
      Error := 0;
    end;
end;

{ When Sauron Resets Checks For Undeleted Node Files }
procedure CheckLockFile;
Var
  LocFile     : File of Node;
  FileMask,
  DeleteEntry,
  UserNumber  : string;
  DirInfo     : SearchRec;
  NodeNum     : Node;
begin
  If BBSCfg.NodeDir[Length(BBSCfg.NodeDir)] = '\' then
    begin
      FileMask := BBSCfg.NodeDir + '*.LOC';
    end
  Else
    begin
      FileMask := BBSCfg.NodeDir + '\*.LOC';
    end;
  FindFirst(FileMask, AnyFile, DirInfo);
  While DosError = 0 do
   begin
     If BBSCfg.TempDir[Length(BBSCfg.NodeDir)] = '\' then
       begin
           DeleteEntry := BBSCfg.NodeDir + DirInfo.Name;
        end
     Else
        begin
            DeleteEntry := BBSCfg.NodeDir + '\' + Dirinfo.Name;
        end;
     {$I-} Assign(LocFile, DeleteEntry);
     Reset(LocFile); {I$+}
     FileError := IOResult;
     If FileError <> 0 then
       begin
         LogError('Unable Lock File ' + DeleteEntry + ' - ' + ErrorString(FileError));
       end
     Else
       begin
         Seek(LocFile, 0);
         Read(LocFile, NodeNum);
         Close(LocFile);
         if (NodeNum.NodeNumber = BBSCfg.Node) then { If Lock File Belongs To This Node Then Delete }
           begin
             Erase(LocFile);
             LogError('UserFile ' + DeleteEntry + ' Succesfully Deleted');
           end;
       end;
      FindNext(DirInfo);
   end;
end;

end.