{ 17/08/95  Added UpdateDownloadFile }
{           & UpdateDownLoadedTags   }

(* Colours Need to Be Changed *)

{ OCT 97 - Release Notes                                         }

Unit GetDl;

interface

Uses Dos, Crt, Lib, Data, Colours, ErrorLog, WaitTix;

procedure GetDLFile;
procedure UpLoadFile;
procedure UpDateDownLoadedFile;
procedure UpDateDownloadedTags;
procedure CopyCommentFiles;

implementation

Var
  Step,
  DLTime   : Integer;
  Fsize    : LongInt;
  Name,
  Strgs,
  FileDesc : String;
  CPS,NOS  : Real;
  DirInfo  : SearchRec;
  OK       : Word;
  Last,
  Done     : Boolean;

procedure GetDlFile;
begin
  if Areas.DnLoads = 0 then
    begin
      Colour(FCyan);
      LineFeed;
      Print('Sorry, Downloads Are Not Permitted From This File Area');
      Colour(FWhite);
      Wait(30);
      Error := 1;
    end
  Else
    begin
      Assign(Files, Areas.FileLst);
      {$I-} Reset(Files); {$I+}
      If IOResult <> 0 then
      begin
        LogError(' Error Opening : ' + Areas.FileLst + ' During DownLoad ');
        Print('*Sorry Unable To Locate File List');
        LineFeed;
        Wait(30);
      end
    Else
      begin
        FSize := FileSize(Files);
        Print('*Current File Area ');
        Print(Areas.DirDes);
        LineFeed;
        LineFeed;
        Print('*Enter Name Of The File To Download : ');
        Response := ReadKB(15);
        SelFile := Response;
        LineFeed;
        LineFeed;
        Step := 0;
        Done := False;
        If Areas.Dir[Length(Areas.Dir)] = '\' then
          begin
            Name := Areas.Dir + Response;
          end
        Else
          begin
            Name := Areas.Dir + '\' + Response;
          end;
        FindFirst(Name, Archive, DirInfo);
        If DosError = 0 then
         begin
          while (done = False) and (Step < Filesize(Files) - 1) do
             begin
               Seek(Files, Step);
               Read(Files, FInfo);
               If Pos(Response, FInfo.FileName) <> 0 then
                 begin
                   FileNumber := Step; { Store Downloaded File }
                   Colour(FGreen);
                   Print('Filename      : ');
                   Colour(FYellow);
                   Print(FInfo.FileName);
                   Colour(FGreen);
                   SetX('35');
                   Print('UpLoad Date : ');
                   Colour(FYellow);
                   Print(FInfo.FDate);
                   LineFeed;
                   Colour(FGreen);
                   Print('FileSize      : ');
                   Colour(FYellow);
                   Str(FInfo.Size, strgs);
                   Print(Strgs);
                   LineFeed;
                   Colour(FGreen);
                   Print('Description   : ');
                   Colour(FYellow);
                   Print(FInfo.Des1);
                   Colour(FGreen);
                   LineFeed;
                   If not local then
                     begin
                       CPS    := LineBaud / 11;
                       NOS    := FInfo.Size / CPS;
                       DLTime := trunc(NOS / 60) + 1;
                     end
                   Else
                     begin
                       DLTime := 0;
                     end;
                   Str(DLTime, Strgs);
                   Print('Download Time : ');
                   Colour(FYellow);
                   Print(Strgs);
                   Colour(FGreen);
                   Print(' Minutes Approx');
                   LineFeed;
                   Print('Uploaded By   : ');
                   Colour(FYellow);
                   Print(FInfo.ULUser);
                   LineFeed;
                   Colour(FGreen);
                   Print('Downloaded    : ');
                   Colour(FYellow);
                   Str(FInfo.DLTimes, Strgs);
                   Print(Strgs);
                   Colour(FGreen);
                   Print(' Times');
                   LineFeed;
                   LineFeed;
                   If (Times <= DLTime) then
                     begin
                       Error := 1;
                       Done  := True;
                       Colour(FYellow);
                       Print('Sorry, You Do Not Have Enough Time To Download This File');
                       LineFeed;
                       LineFeed;
                       Colour(FRed);
                       Print('Press Any Key To Continue');
                       Response := ReadKB(1);
                     end
                   Else
                     begin
                       Colour(FWhite);
                       Print('Continue With DownLoad (Y/n) : ');
                       Response := ReadKB(2);
                       If (Response = 'y') or (Response = 'Y') then
                         begin
                          Tagged := False;
                           LineFeed;
                           DlFile := '';
                           DlFile := Name;
                           Error := 0;
                           Last  := True;
                           Done  := True;
                         end
                       Else
                         begin
                           Error := 1;
                           Done  := True;
                         end;
                      end;
                   end;
               inc(Step);
             end;
          end
         Else
           Begin
             LineFeed;
             LineFeed;
             Print('*Unable To Locate File..');
             Error := 1;
           end;
        Close(Files);
      end;
   end;
end;

procedure UpLoadFile;
begin
  if Areas.UpLoads = 0 then
    begin
      Colour(FCyan);
      Print('Sorry, Uploads Are Not Permitted To This File Area');
      Colour(FWhite);
      Wait(30);
      Error := 1;
      Exit;
    end;
    LineFeed;
    Print('Enter Name Of File To Upload : ');
    Response := ReadKB(15);
    LineFeed;
    Repeat
      LineFeed;
      Print('                        |-------------------------------|');
      LineFeed;
      Print('Enter File Description : ');
      FileDesc := ReadKb(31);
      LineFeed;
      Name := Areas.Dir + '\' + Response;
    Until Length(FileDesc) > 5;
    LineFeed;
    DlFile := Name;
end;

procedure UpDateDownLoadedFile;
begin
  Assign(Files, Areas.FileLst);
  {$I-} Reset(Files); {$I+}
  If IOResult <> 0 then
    begin
      LogError(' Error Opening : ' + Areas.FileLst + ' For DownLoad Update');
    end
  else
    begin
      { Update File Download Times }
      Seek(Files, FileNumber);
      Read(Files, FInfo);
      inc(FInfo.DLTimes);
      Seek(Files, FileNumber);
      Write(Files, FInfo);
      FileNumber := 0;
     { Update User Information }
     inc(UserInfo.Downloads);
     UserInfo.BytesDL  := UserInfo.BytesDL + FInfo.Size;
     UserInfo.FileArea := Areas.DirNo - 1;
     Val(UserInfo.UserACC, Step, Loop);
     Seek(DataFile, Step);
     Write(DataFile, UserInfo);
     { Close File List }
     Close(Files);
    end;
end;

procedure UpDateDownLoadedTags;
Var
  UserTag : String;
  Step,
  Code    : integer;
begin
  If BBSCfg.TempDir[Length(BBSCfg.TempDir)] = '\' then
    begin
      UserTag := BBSCfg.TempDir + UserInfo.UserAcc + '.TAG';
    end
  Else
    begin
      UserTag := BBSCfg.TempDir + '\' + UserInfo.UserAcc + '.TAG';
    end;
  Assign(TagInfo, UserTag);
  {$I-} Reset(TagInfo); {$I+}
  If IOResult <> 0 then
    begin
      LogError('Unable To Open ' + UserTag + ' For File Update');
    end
  Else
    begin
      TagSize := FileSize(TagInfo);
      for Step := 0 to Tagsize - 1 do
        begin
          Seek(TagInfo, Step);
          Read(TagInfo, Tags);
          If Tags.Tagged = 1 then
            begin
              Assign(Files, Tags.DirLst);
              {$I-} Reset(Files); {$I+}
              If IOResult <> 0 then
              begin
                LogError(' Error Opening : ' + Areas.FileLst + ' For DownLoad Update');
              end
            else
              begin
              { Update File Download Times }
              Seek(Files, Tags.RecNumber);
              Read(Files, FInfo);
              inc(FInfo.DLTimes);
              Seek(Files, Tags.RecNumber);
              Write(Files, FInfo);
              { Update User Information }
              inc(UserInfo.Downloads);
              UserInfo.BytesDL  := UserInfo.BytesDL + FInfo.Size;
              Val(UserInfo.UserACC, Code, Loop);
              Seek(DataFile, Step);
              Write(DataFile, UserInfo);
              { Close File List }
              Close(Files);
            end;
        end;
     end;
    Close(TagInfo);
   end;
end;

procedure CopyCommentFiles;
var
  Comp,
  UserTag,
  Files   : string;
  Arc     : Boolean;
begin
  TextColor(7);
  Arc := False;
  If not Tagged then
    begin
      if Pos('.ARJ', DLFile) > 0 then
        begin
          Comp := 'COMMENT ' + 'ARJ ' +  DLFile + ' ' + 'C:\SAURON\STORFILE' + ' ' + 'C:\SAURON\STORFILE\' + SelFile;
          Arc  := True;
        end
      Else
        begin
          If Pos('.ZIP', DLFile) > 0 then
            begin
              Comp := 'COMMENT ' + 'ZIP ' +  DLFile + ' ' + 'C:\SAURON\STORFILE' + ' ' + 'C:\SAURON\STORFILE\' + SelFile;
              Arc  := True;
            end
          else
            begin
            end;
        end;
      { Cont }
      if Arc then
        begin
          Command := '/C ' + Comp;
          SwapVectors;
          Exec(GetEnv('COMSPEC'), Command);
          SwapVectors;
          if DosError <> 0 then
            begin
              LogError('Could not execute COMMAND.COM While Coping & Commenting');
            end
          else
            begin
              DlFile := 'C:\SAURON\STORFILE\' + SelFile;
            end;
        end;
    end
  Else
    begin
     If BBSCfg.TempDir[Length(BBSCfg.TempDir)] = '\' then
       begin
         UserTag := BBSCfg.TempDir + UserInfo.UserAcc + '.TAG';
       end
     Else
       begin
         UserTag := BBSCfg.TempDir + '\' + UserInfo.UserAcc + '.TAG';
       end;
     Assign(TagInfo, UserTag);
     {$I-} Reset(TagInfo); {$I+}
     If IOResult <> 0 then
       begin
         LogError('Unable To Open ' + UserTag + ' For File Update');
       end
     Else
      begin
        TagSize := FileSize(TagInfo);
        If Tagsize <> 0 then
          begin
            for Step := 0 to Tagsize - 1 do
              begin
                Seek(TagInfo, Step);
                Read(TagInfo, Tags);
                If Tags.Tagged = 1 then
                   begin
                     if Pos('.ARJ', Tags.FileName) > 0 then
                       begin
                         if Tags.Dir[Length(Tags.Dir)] = '\' then
                           begin
                             DLFile := Tags.Dir + Tags.FileName;
                           end
                         Else
                           begin
                             DLFile := Tags.Dir + '\' + Tags.FileName;
                           end;
                         Files := 'C:\SAURON\STORFILE\' + Tags.FileName;
                         Comp := 'COMMENT ' + 'ARJ ' +  DLFile + ' ' + 'C:\SAURON\FILESTOR' + ' ' + Files;
                         Arc  := True;
                       end
                    Else
                      begin
                        If Pos('.ZIP', Tags.FileName) > 0 then
                         begin
                           if Tags.Dir[Length(Tags.Dir)] = '\' then
                              begin
                                DLFile := Tags.Dir + Tags.FileName;
                              end
                           Else
                              begin
                                DLFile := Tags.Dir + '\' + Tags.FileName;
                              end;
                           Files := 'C:\SAURON\STORFILE\' + Tags.FileName;
                           Comp := 'COMMENT ' + 'ZIP ' +  DLFile + ' ' + 'C:\SAURON\FILESTOR' + ' ' + Files;
                           Arc  := True;
                         end
                      else
                        begin
                        end;
                    end;
                  { Cont }
                  if Arc then
                  begin
                    Command := '/C ' + Comp;
                    SwapVectors;
                    Exec(GetEnv('COMSPEC'), Command);
                    SwapVectors;
                    if DosError <> 0 then
                      begin
                        LogError('Could not execute COMMAND.COM While Coping & Commenting');
                     end
                   else
                     begin
                       Tags.Dir := 'C:\SAURON\STORFILE\';
                       Seek(TagInfo, Step);
                       Write(TagInfo, Tags);
                     end;
                 end;
              end;
          end;
       end;
    end;
  end;
end;

end.