{ ANSI Interperter }

{ OCT 97 - Release Notes                                         }
{ This converts ansi codes from menu files to be displayed local }
{ There may well be a bug here                                   }

Unit ANS;

interface

Uses Crt, Dos, Data, Fossil;

procedure Ansi(Chars : Char);

implementation

Var
  Code : integer;

procedure DealWithAnsi(InChar : Char);
Var
  X , Y : integer;
begin
        case InChar of
          'A' : begin
                  AnsiCode := 0;
                  Temps := WhereY;
                  if Temps > 1 then
                    begin
                      Val(AnsiCommand,I,Code);
                      if Temps - I >= 2 then
                        begin
                          GotoXY(WhereX,Temps - I);
                        end;
                    end;
                  AnsiCommand := '';
                end;
          'B' : begin
                  AnsiCode := 0;
                  Temps := WhereY;
                  if Temps < CurrentLine then
                    begin
                      Val(AnsiCommand,I,Code);
                      if I+Temps <= CurrentLine then
                        begin
                          GotoXY(WhereX,Temps + I);
                        end;
                    end;
                  AnsiCommand := '';
                end;
          'C' : begin
                  AnsiCode := 0;
                  Temps := WhereX;
                  if Temps <> 80 then
                    begin
                      Val(AnsiCommand,I,Code);
                      if Code <> 0 then
                        begin
                          I := 1;
                        end;
                      if I+Temps <= 80 then
                        begin
                          GotoXY(Temps+I,WhereY);
                        end;
                    end;
                  AnsiCommand := '';
                end;
          'D' : begin
                  AnsiCode := 0;
                  Temps := WhereX;
                  if Temps <> 0 then
                    begin
                      Val(AnsiCommand,I,Code);
                      if I <= Temps then
                        begin
                          GotoXY(Temps - I,WhereY);
                        end;
                    end;
                  AnsiCommand := '';
                end;
          'h' : begin
                  AnsiCommand := '';
                end;
          'H','f' : begin
                      AnsiCode := 0;
                      if Length(AnsiCommand) = 0 then
                        begin
                          GotoXY(1,1);
                        end
                      else
                        begin
                          Pntr := Pos(';',AnsiCommand);
                          Fst := copy(AnsiCommand,0,Pntr - 1);
                          Val(Fst,Fval,Code);
                          Snd := copy(AnsiCommand,Pntr+1,Length(AnsiCommand)-Pntr);
                          Val(Snd,Sval,Code);

                          { move cursor if within limits }

                          if ((Fval > 0) and (Fval <= 80)) then
                            begin
                              if ((Sval > 1) and (Sval <= CurrentLine)) then
                                begin
                                   GotoXY(SVal,FVal);
                                end;
                            end
                         Else
                            begin
                              GotoXY(1,1);
                            end;
                        end;
                      AnsiCommand := '';
                    end;
          'J' : begin
                  AnsiCode := 0;
                  ClrScr;
                  AnsiCommand := '';
                end;
          'K' : begin
                  AnsiCode := 0;
                  ClrEol;
                  AnsiCommand := '';
                end;
          'l' : begin
                  AnsiCommand := '';
                end;
          'm' : begin
                  AnsiCode := 0;
                  repeat
                    begin
                      Command := '';
                      Pntr := Pos(';',AnsiCommand);
                      Command := Copy(AnsiCommand,0,Pntr - 1);
                      AnsiCommand := Copy(AnsiCommand,Pntr + 1,Length(AnsiCommand));
                      if Pntr = 0 then
                        begin
                          Command := AnsiCommand;
                        end;

                      { deal with type of command }

                      Val(Command,Cval,Code);
                      case Cval of
                        0 : begin
                              Fore := White;
                              Back := 0;
                              High := 0;
                              Flash := 0;
                            end;
                        1 : begin
                              High := 8;
                            end;
                        4 : begin
                              { only used in monochrome }
                            end;
                        5 : begin
                              Flash := 128;
                            end;
                        7 : begin
                              { Not Used in Colour }
                            end;
                        8 : begin
                              { Not Used In Colour }
                            end;
                       30 : begin
                              if High > 0 then Fore := DarkGray else Fore := Black;
                            end;
                       31 : begin
                              if High > 0 then Fore := LightRed else Fore := Red;
                            end;
                       32 : begin
                              if High > 0 then Fore := LightGreen else Fore := Green;
                            end;
                       33 : begin
                              if High > 0 then Fore := Yellow else Fore := Brown;
                            end;
                       34 : begin
                              if High > 0 then Fore := LightBlue else Fore := Blue;
                            end;
                       35 : begin
                              if High > 0 then Fore := LightMagenta else Fore := Magenta;
                            end;
                       36 : begin
                              if High > 0 then Fore := LightCyan else Fore := Cyan;
                            end;
                       37 : begin
                              if High > 0 then Fore := White else Fore := LightGray;
                            end;
                       40 : begin
                              Back := 0;
                            end;
                       41 : begin
                              Back := 64;
                            end;
                       42 : begin
                              Back := 32;
                            end;
                       43 : begin
                              Back := 96;
                            end;
                       44 : begin
                              Back := 16;
                            end;
                       45 : begin
                              Back := 80;
                            end;
                       46 : begin
                              Back := 48;
                            end;
                       47 : begin
                              Back := 112;
                            end;
                      end;  { end of case }
                    end;  { end of repeat }
                    TextAttr := Flash + Back + Fore;
                  until Pntr = 0;
                  AnsiCommand := '';
                end;  { end of 'm' }
          'p' : begin
                  AnsiCommand := '';
                end;
          's' : begin
                  AnsiCode := 0;
                  SaveCurX := WhereX;
                  SaveCurY := WhereY;
                  CurSaved := True;
                  AnsiCommand := '';
                end;
          'u' : begin
                  AnsiCode := 0;
                  if CurSaved = True then
                    begin
                      GotoXY(SaveCurX,SaveCurY);
                    end;
                  AnsiCommand := '';
                end;
          'n' : begin   { ANSI Auto Detect }
                  AnsiCode := 0;
                  If AnsiCommand = '6' then
                    begin  { Return X & Y of cursor }
                      X := WhereX;
                      Y := WhereY;
                      SendFChar(27);
                      SendFChar(ord('['));
                      SendFChar(X);
                      SendFChar(Ord(';'));
                      SendFChar(Y);
                      SendFChar(Ord('R'));
                    end;
                  AnsiCommand := '';
                end;
        else
          if InChar <> ' ' then
            begin
              AnsiCommand := AnsiCommand + InChar;
            end;
        end; { end of case }
end;


procedure Ansi(Chars : Char);
Begin
  Code := Ord(Chars);
  case AnsiCode of
     0 : Case Code of
            27 : begin { some ansi sequence }
                   AnsiCode := 1;
                 end;
             else
                 begin
                   write(Chars);
                 end;
          end;   { Case End }
     1 : begin   { Check For [ after #27 }
           if Code = 91 then
             begin
               AnsiCode := 2;
             end
           Else
             begin
               Write(Chr(27));
               Write(Chr(Code));
               AnsiCode := 0;
             end;
        end;
    2 : begin
          DealWithAnsi(Chars);
        end;
   end; { Case End }
end;

end.
