// Filename: 	doorsys.h
// Contents:	the routines to read/write the doorsys.txt file used by 
//		external applications to read/write user information.
// Author:	Gregory Shaw
// Created:	6/14/95

#ifndef _DOORSYS_H_
#define _DOORSYS_H_

#include "bbshdr.h"

// Structure:	DoorSys
// Purpose:	store the door switch file format as per the DOORSYS.TXT
//		standard
// Author:	Gregory Shaw
// Created:	6/14/95
// Notes:	Those pieces of this file that don't apply will have a
//		value that makes sense in the context of that variable.
//		Those that are not used actively (e.g. have a dummy value)
//		have (dv) in the comment
//		There are a number of items unique to this BBS that don't 
//		make sense in a msdos environment.  Their mapping is:
//			Value			Stored within
//			-----			-------------
//			terminal type		work phone
//			language		password
//			card color		comment (field 1)
//			editor			comment (field 2)
//		The attempt has been made to make sure that any externals
//		used by PC-BBS systems can work with this file.

typedef struct 
{
	char	comport[10];	// communications port (COM0: = local) (dv)
	int	baud;		// baud rate (dv)
	int	parity;		// parity (dv)
	int	node;		// node number
	int	DTErate;	// DTE rate (Actual BPS rate) (dv)
	char	screen;		// screen display (Y = on, N = off) (dv)
	char	printer;	// printer display (Y = on, N = off) (dv)
	char	pagebell;	// use bell for page (Y = on, N = off) (dv)
	char	calleralarm;	// caller alarm (Y = on, N = off) (dv)
	char	fullname[50];	// user's full name
	char	callfrom[50];	// calling from location
	char	homephone[20];	// home phone number (dv)
	char	workphone[20];	// work/data phone number (terminal type)
	char	password[20];	// password (language)
	int	seclevel;	// security level
	int	timeson;	// total times on
	char	lastcall[10];	// date last call (mm/dd/yy)
	long	secsremaining;	// seconds remaining this call
	int	minsremaining;	// minutes remaining this call
	char	graphicmode[4];	// Graphics mode (GR=graph, NG=nongraph, 7E=7,E caller)
	int	pagelength;	// page length
	char	usermode;	// user mode (Y = expert, N = novice) (dv)
	char	confs[100];	// conferences registered in (7 max, comma
				// separated list of numbers 1-7) (dv)
	int	confexit;	// conference exited to door from (single number)	 (dv)
	char	expdate[10];	// user expiration date (mm/dd/yy)
	int	recnum;		// record number in userlog file (dv)
	char	defprotocol;	// default protocol (X,C,Y,G,I,N,Z, etc.) (dv)
	int	uploads;	// total number of uploads 
	int	downloads;	// total number of downloads
	int	daily_k;	// daily download 'K' total 
	int	daily_k_max;	// daily download 'K' max
	char	birth[10];	// caller's birthdate (mm/dd/yy) (dv)
	char 	mainpath[100];	// path to MAIN directory (where userlog resides)
	char	genpath[100];	// path to GEN (?) directory (dv)
	char	sysopname[MAX_LOGIN_LENGTH];	// sysop's login name
	char	aliasname[MAX_ALIAS_LENGTH];	// alias name
	char	eventtime[10];	// event time (netmail processing) (hh:mm) (dv)
	char	ecc;		// error correcting connection? (Y/N) (dv)
	char	ansi;		// ANSI supported & caller using NG mode? (Y/N)
	char	recordlock;	// use record locking? (Y/N) (dv)
	char	defaultcolor;	// BBS default color (1-15) 
	int	credit;		// time credits in minutes
	char	newfiles[10];	// last new files scan date (mm/dd/yy)
	char	calltime[10];	// time of this call (hh:mm)
	char	lastcalltime[10];	// time of last call (hh:mm)
	int	maxfilesday;	// maximum # daily files available for download (dv)
	int	filestoday;	// # of files downloaded today
	int	upload_k;	// total 'K' bytes uploaded (dv)
	int 	download_k;	// total 'K' bytes downloaded (dv)
	char	comment[100];	// user comment (color 
	int	doorsopened;	// total doors opened (dv)
	int	messagesleft;	// total messages left (dv)
} DoorSys;

// Class:	door
// Purpose:	encapsulate the door execution functions
// Attributes:	info - door information
// Methods:	nodenum - generate a node number from the tty
// 		door_exec - execute a door
//		write_doorsys - write the doorsys file
//		read_doorsys - read doorsys file
// Author:	Gregory Shaw
// Created:	6/14/95

class Door:public language
{
	int skipline(FILE *);	// skip a line of text in door file (read)
	char *scanline(FILE *);	// scan an entire line in
public:
	DoorSys info;		// doorsys user information
	int bbs_read_doorsys(void);	// read the door information
					// and interpret for BBS
	int delete_doorsys(void);	// delete the doorsys file
	int init_door();	// init info
	int nodenum(void);	// generate node number from tty
	int read_doorsys(void);	// read the door information
	int write_doorsys(int init);	// write the door information
};


#endif // _DOORSYS_H_
