// Filename:   bbsinfo.h
// Contents:   the bbs information object
// Author:     Greg Shaw
// Created:        7/11/93

/*

This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _BBSINFO_H_
#define _BBSINFO_H_

// Structure:  card_color
// Contents:   the information that defines a card 'level'
// Author:     Greg Shaw
// Created:        7/27/93

typedef struct
{
	char   colr[11];	// card color
	unsigned int acl;	// minimum acl for that level
	unsigned int tl;	// minimum tl for level
	int	flags;		// additional flags for level (or'd into user flags)
	int 	kbytes;		// kbytes per day user may download
	unsigned int	max_kbytes;	// max kbytes per validation user may download
	unsigned int	max_files;	// max number of downloads per period (total)
	int	days_valid;	// days timelimit is valid
	int	max_time;	// max total time available for period
	int	months_valid;	// timeperiod (months) that account valid
	int	start_time;	// time of day after which a user can log on
	int	end_time;	// time of day before which a user can log on
	// account is valid
} CardRec;


// Object:     bbsinfo
// Purpose:        return some information that is setup-specific (and could
//             change, so hard-coding isn't an option)
// Attributes: none
// Methods:
//             loghost - return the name of the loghost
//             watchost - return the name of the sysop watcher daemon
//                 ratio - return the required upload/download ratio
//             def_acl - return the default BBS access level
//             def_termtype - return the default terminal type
// Author:     Greg Shaw
// Created:        7/11/93

class bbsinfo:public bbsutil
{
	// information cache 
	int	cmail;		// checkmail
	int	cchat;		// credit chat
	int	cuploads;	// credit uploads
	int	dcard;		// default card color
	int	dfore;		// default foreground
	int	dback;		// default background
	int 	dattr;		// default attribute
	int	itime;		// inactivity timeout
	int	lmaccess;	// log menu accesses?
	int	lmext;		// log externals?
	int	mcheck;		// mail check time
	int	mfiles;		// max files per batch
	int	slast;		// show last 5 users to log on?
	int	stime;		// show timeleft in prompt?
	int	scoms;		// show commands in prompt?
	int	sfor;		// show fortune on logon?
	int	sonce[3];	// show system message once?
	int	tlfud;		// timelimit fudge?
	int	waitt;		// wait time
	int	logmaili;	// log mail import
	int	mfor;		// forward mail to BBS?
	char	*sys;		// logon name of sysop
	char	*spager;	// system pager name
	char	*talkp;		// talk program name
	char	*dterm;		// default terminal type
	char	*mspool;	// mail spool directory
	char	*vprog;		// validation program
	char	*lhost;		// log host
	char	*mhost;		// mail host
	char	*chost;		// chat host
	char	*whost;		// watch host
	char	*dhost;		// database host
	char	*rsent;		// registration sentence
	char	*rkey;		// registration key
	char	*bname;		// bbs name
	unsigned int	mk;	// maxk downloaded per session
	unsigned int	mkd;	// maxk downloaded per day
	float	rato;		// download/upload ratio

	// find line with keyword
	int    findline(char **line, char *word);
	public:
		bbsinfo();		// constructor
		~bbsinfo();		// constructor
		uid_t 	bbs_uid(void);    // return bbs uid
		gid_t 	bbs_gid(void);    // return bbs uid
		char	*bbs_name(void);	// name of BBS

		CardRec	*cardinfo(int   type); // return card info for card type passed in
		int	chat_avail(int tim); // is sysop available for chat?
		int	checkmail(void);    // check for mail?
		int	creditchat(void);   // is chat time credited?
		int	credituploads(void);// is upload time credited?
		char	*chathost(void);   // chat daemon

		char	*dbhost(void);		// database host
		int	def_card(void);  // default card color
		int	def_foreground(void); // default foreground
		int	def_background(void); // default background
		int	def_attribute(void);// default color attribute
		char	*def_termtype(void); // default terminal type
		
		int	inactivity_timeout(void); // time before user booted

		char	*loghost(void);    // error logging daemon
		int	log_mail_import(void); // log mail import?
		int	log_menu_accesses(void); // log menu accesses?
		int	log_externals(void);// log externals?

		int	mailforward(void);// forward mail into BBS?
		char	*mailhost(void);	// mail host
		int	mailchecktime(void);// minimum # of seconds between new mail checks
		char	*mailspool(void);  // system mail spool file
		unsigned int maxk(void);         // max # of K user can download at one time
		unsigned int maxk_day(void);         // max # of K user can download in one day
		int 	maxfiles(void);         // max # of files user can download in one batch 

		float	ratio(void);     // upload to download ratio
		char	*reg_sentence(void);	// registration sentence
		char	*reg_key(void);	// key

		int	showlast(void);		// show last 5 users logged on?
		int	showtime(void);     // show user timeleft
		int	showcoms(void);     // show user valid command keys
		int	showfortune(void);  // show user fortune upon logon?
		char	*sysop(void);      // return sysop's name
		char	*sys_pager(void);  // default system pager
		
		char	*talkprog(void);   // return the system 'talk' program
		int	timelimit_fudge(void); // fudge timelimit?
		// fudge factor for logging out user when time expired in download

		char    *validation_program(void);	// name of validation program
		
		int	waittime(void);     // time between logons allowed for users
		char	*watchhost(void);  // sysop watcher daemon
};


#endif                          // _BBSINFO_H_







