// Filename:   bbs.C
// Contents:   the main bbs program (main)
// Author: Greg Shaw
// Created:    7/28/93

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _BBS_C_
#define _BBS_C_


#include "bbshdr.h"

bbsmon sysop_mon;	// sysop end bbsmoning 
moncon mon_obj;		// connection to system bbsmoning daemon
#ifdef USE_DATABASE	// try to save some room
	Message message;	// message base object
#endif

// the user object is defined globally so that the menu object can access
// it via extern

User   user;		// the current user
Door   doorobj;		// BBS door interface
Chat   chatobj;             // chat object interface

#define DEBUG	// generate core dumps on signals

// Function:   getout
// Purpose:    get out of the bbs system.  Quick and dirty
// Author: Greg Shaw
// Created:    8/16/93

void getout(int sig)
{
	char   tmpstr[255];         // temporary string
	static int inalready=0;     // if already in, don't do again

	if (sig == SIGINT)                            // don't exit on interrupt
		return;
	if (sig == SIGPIPE)         // closed pipe
		return;                 // don't track
	if (!inalready)
	{
		sprintf(tmpstr,"Got signal %d",sig);
		user.ap_log(tmpstr);
		inalready++;
		user.save(NULL);
		sprintf(tmpstr,"(hangup) Logoff for %s %s",user.fname,user.lname);
		user.ap_log(tmpstr);
//		if (mon_obj.watching())
//		{
//			sprintf(tmpstr,"Logoff for %s %s.\n",user.fname,user.lname);
//			mon_obj.send(tmpstr,1);
//		}
#ifdef DEBUG
		abort();
#endif
		exit(0);                // exit to OS
		inalready = 0;
	}
}


main(int argc, char *argv[])
{
	char   tmpstr[255];         // temporary string
	char   tmpstr2[255];
	char   *bbsdir;             // bbs 'home' directory
	// current menu
	char   curmenu[MENU_NAME_LEN];
	// previous menu (should a menu not be found)
	char   prevmenu[MENU_NAME_LEN];
	char   menustack[MENU_STACK_SIZE][MENU_NAME_LEN];
	int    stacktop;            // current stack top
	int    bootuser;            // kick user out?
	int    x;                 // counter
	int    done;                // done inside bbs?
	int    priv_highest;	// last message number
	int    newuser;             // is it a the first logon for this user?
	int    credit;              // credited minutes for upload
	float  uldlratio;           // download/upload ratio
	files  fileobj;             // files upload/download object
	Menu   menu;                // current menu
	MenuItem *result;           // result of menu run
	time_t now;                 // current time
	time_t then;                 // current time
	struct tm *tnow;            // current time (structure

	time_t timeatlogoff;        // time to log user off (when in external)
	User   tmpuser;             // temporary user object for sysop editing


	// copy name of program into progname global (for error logging)
	menu.set_progname(menu.last_path_item(argv[0]));

	// get user's ansi settings
	user.check_for_ansi();

	// display welcome text file
	if (bbsdir = getenv("BBSDIR"), bbsdir == NULL)
	{
		printf("BBSDIR environment variable not set.\r\n");
		return(0);
	}
	sprintf(tmpstr,"%s/text/welcome",bbsdir); // get 'welcome file path'
	menu.display_file(tmpstr,0,user.terminal(),1);

	// get the user (or get user's information)
	stacktop = 0;               // stack empty
	bootuser = 0;
	if (newuser = user.get(NULL,1), newuser == -1)
	{
		menu.ap_log("Unable to get user.");
		return(0);
	}

	// turn on signal handlers so that hangup and such caught
	for (x=1; x<15; x++)
		signal(x,&getout);


	// send a quick note to the sysop 
//	if (mon_obj.watching())
//	{
//		sprintf(tmpstr,"Logon for %s %s.\n",user.fname,user.lname);
//		mon_obj.send(tmpstr,1);
//	}

	user.update_callers();	// increment # of callers
	if (user.showlast())	// show last few callers and caller number?
	{
		menu.clear_scr();
		user.callingfrom(tmpstr2);	// get city and state
		sprintf(tmpstr,user.gstrl("WELCOMEBACK"),user.fname,user.lname,
				tmpstr2);
		menu.sstrcr_c(tmpstr);
		sprintf(tmpstr,user.gstrl("YOUARECALLER"),user.caller());
		menu.sstrcr_c(tmpstr);
		menu.cr();
		menu.sstrcrl("RECENTBBSCALLERS");
		sprintf(tmpstr,"%s/admin/recent_callers",bbsdir); // get 'welcome file path'
		menu.display_file(tmpstr,0,user.terminal(),0);
	}	
	user.update_recent_callers();	// add my name to the recent_callers file

	user.display_info(1);       // display user info with 'Welcome back' msg.
	if (!newuser)
	{
		strcpy(tmpstr,bbsdir);  // get bbsdir
		// get newuser file path
		strcat(tmpstr,"/text/newuser.msg");
		// display newuser file
		menu.display_file(tmpstr,1,user.terminal(),1);
	}
	// check for mail
	if (user.mailavail())
	{
		user.cr();
		user.sstrcrl("YOUHAVEMAIL");
		user.cr();
		user.waitcr();
		// add something here for reading mail at logon
	}
#ifdef USE_DATABASE
	// scan for public messages addressed to them
	user.sstrl("MSSCANMES");
	if (user.yesno())
	{
		user.cr();
		message.scan(user.last_logon());
		user.waitcr();
		message.mailavail();	// invoke to initialize
	}
#endif
	strcpy(prevmenu,"bulletins");
	strcpy(curmenu,"bulletins");
	if (menu.build("bulletins",1) != 0)
	{
		menu.ap_log("Unable to open bulletins menu.\r\n");
		return(0);
	}
	if (user.showfortune())
	{
		user.sysint("fortune",0,0);
		menu.waitcr();
	}
	done = 0;
//	mon_obj.send_message("browsing");
	while (!done)
	{
		user.check_acl();	// check for access level update
		if (user.mailavail())   // new unix mail?
		{
			user.clear_scr();
			user.sstrcrl("YOUHAVEMAIL");
			user.cr();
			user.waitcr();
		}
#ifdef USE_DATABASE
		if (message.mailavail())   // new BBS mail?
		{
			user.clear_scr();
			user.sstrcrl("YOUHAVEBBSMAIL");
			user.cr();
			user.waitcr();
		}
#endif
		if (user.u_uploads() == 0)
			uldlratio = (float)user.u_downloads()/(float)1;
		else
			uldlratio = (float)user.u_downloads()/(float)user.u_uploads();
		// run menu till something selected
		while (result = menu.run(), result == NULL);
		switch(result->com_type)
		{
			default:
			case -1:            // boot the user due to timeout or out of time
				done++;
				bootuser++;
				sprintf(tmpstr,"Forced logoff for %s %s",user.fname,user.lname);
				user.ap_log(tmpstr);
				break;
			case 0:             // do nothing
				break;
			case 1:             // logout of bbs
				user.cr();
				user.sstrl("LOGOFF");
				if (user.yesno())
					done++;
				break;
			case 2:             // branch to (another) menu
				strcpy(prevmenu,curmenu);
				// get new menu name
				strcpy(curmenu,result->misc);
				// log menu access?
				if (menu.log_menu_accesses())
				{
					sprintf(tmpstr,"menu: %s",result->misc);
					menu.ap_log(tmpstr);
				}
				if (menu.build(curmenu,1) != 0)
				{
					sprintf(tmpstr,"Unable to open menu %s.",result->misc);
					menu.ap_log(tmpstr);
					// get new menu name
					strcpy(curmenu,prevmenu);
					if (menu.build(curmenu,1) != 0)
					{
						sprintf(tmpstr,"PANIC: Unable to open menu %s.",prevmenu);
						menu.er_log(tmpstr);
					}
				}
				else
				{
					// get new menu name
					strcpy(menustack[stacktop++],prevmenu);
				}
				break;
			case 3:             // exit to previous menu
				if (stacktop > 0)
				{
					strcpy(prevmenu,curmenu);
					strcpy(curmenu,menustack[--stacktop]);
					if (menu.build(curmenu,1) != 0)
					{
						sprintf(tmpstr,"Unable to open menu %s.",result->misc);
						menu.ap_log(tmpstr);
						// get last menu
						strcpy(curmenu,prevmenu);
						if (menu.build(curmenu,1) != 0)
						{
							sprintf(tmpstr,"PANIC: Unable to open menu %s.",prevmenu);
							menu.er_log(tmpstr);
						}
					}
				}
				break;
			case 4:             // search userlog for user information
				user.list(1,0);
				break;
			case 5:             // list users in userlog
				user.list(0,0);
				break;
			case 6:             // display user information and access level
				// display user info w/o 'Welcome back' msg.
				user.display_info(0);
				break;
			case 7:             // modify user setup
				user.check_info();
				break;
			case 8:             // chat with sysop (via talk)
				sprintf(tmpstr,"%s requested chat with the sysop",user.logname());
				user.ap_log(tmpstr);
				user.clear_scr();
				time(&then);
				tnow = localtime(&then);
				if (user.chat_avail(x))
				{
					user.sstrcrl("ATTEMPTCHAT");
					user.cr();
					user.sstrcrl("CTRLCTOEXIT");
					user.waitcr();
					sprintf(tmpstr,"%s %s",user.talkprog(),user.sysop());
					user.sysint(tmpstr,0,0);
					if (user.creditchat())
					{
						time(&now);
						// get credited time
						credit += (now - then)/60;
						if (credit > 0)
							user.inc_credit(x);
					}
				}
				else
				{
					user.sstrcrl("SYSOPNOTAVAIL");
					user.sstrcrl("PLEASELEAVEFEEDBACK");
					user.waitcr();
				}

				break;
			case 9:             // transfer to a new root menu (reset menu stack)
				strcpy(prevmenu,curmenu);
				// get new menu name
				strcpy(curmenu,result->misc);
				if (menu.build(curmenu,1) != 0)
				{
					sprintf(tmpstr,"Unable to open menu %s.",result->misc);
					menu.ap_log(tmpstr);
					// get new menu name
					strcpy(curmenu,prevmenu);
					if (menu.build(curmenu,1) != 0)
					{
						sprintf(tmpstr,"PANIC: Unable to open menu %s.",prevmenu);
						menu.er_log(tmpstr);
					}
				}
				else
				{               // successful change -- this is the new
					// 'top' menu -- nuke menu stack
					stacktop = 0;
				}
				break;
			case 10:            // display file, paged
				sprintf(tmpstr,"%s/text/%s",bbsdir,result->misc);
				menu.display_file(tmpstr,1,user.terminal(),1);
				break;
			case 11:            // display file, not paged
				sprintf(tmpstr,"%s/text/%s",bbsdir,result->misc);
				menu.display_file(tmpstr,0,user.terminal(),1);
				break;
			case 12:            // transfer to another menu directly
				strcpy(prevmenu,curmenu);
				// get new menu name
				strcpy(curmenu,result->misc);
				if (menu.build(curmenu,1) != 0)
				{
					sprintf(tmpstr,"Unable to open menu %s.",result->misc);
					menu.ap_log(tmpstr);
					// get new menu name
					strcpy(curmenu,prevmenu);
					if (menu.build(curmenu,1) != 0)
					{
						sprintf(tmpstr,"PANIC: Unable to open menu %s.",prevmenu);
						menu.er_log(tmpstr);
					}
				}
				// nothing goes on stack.
				break;
			case 13:            // chat with sysop (alternative method)
				sprintf(tmpstr,"%s wanted to chat with the sysop",user.logname());
				user.ap_log(tmpstr);
				time(&now);
				tnow = localtime(&now);
				x = tnow->tm_hour * 100;
				x += tnow->tm_min;
				if (user.chat_avail(x))
					chatobj.private_connect(user.sysop(),0);
				else
				{
					user.sstrcrl("SYSOPNOTAVAIL");
					user.sstrcrl("PLEASELEAVEFEEDBACK");
					user.waitcr();
				}
				break;
			case 14: 	// send email (feedback) to SysOp 
				user.inc_priv_messages(message.post(PRIVATE_SECTION,NULL,1,menu.sysop()));
				break;
			// menu commands (implemented in menu.C):
			// 15: include another menu file
			// 16: define a macro
			// 17: undefine a macro
			// 18-20: unused
			case 21:            // call shell to launch external
				menu.clear_scr();
				time(&now);
				timeatlogoff = (user.u_timelimit() * 60) -
				(now - user.user_logon() + (user.prevtimeused()*60))
				+ now;
				// compute time to log user off if in external
				sprintf(tmpstr,"Executing %s\n",result->misc);
//				mon_obj.send(tmpstr,1);
				strcpy(tmpstr,result->misc);
				if (user.sysint(tmpstr,timeatlogoff,0) == NUKEHIM)
				{
					done++;
					bootuser++;
					continue;
				}
				user.waitcr();
				break;
			case 22:            // call shell to launch bbs-style external
				menu.clear_scr();
				time(&now);
				timeatlogoff = (user.u_timelimit() * 60) -
				(now - user.user_logon() + (user.prevtimeused()*60))
				+ now;
				// compute time to log user off if in external
				sprintf(tmpstr,"Executing %s\n",result->misc);
//				mon_obj.send(tmpstr,1);
				strcpy(tmpstr,result->misc);
				doorobj.write_doorsys(0);	// write door information
				if (user.sysint(tmpstr,timeatlogoff,0) == NUKEHIM)
				{	
					done++;
					bootuser++;
					doorobj.delete_doorsys();
					continue;	
				}
				doorobj.bbs_read_doorsys();
				user.waitcr();
				break;
			case 25:            // list new files with option to download
				// print 'please wait' message
				fileobj.waitmsg();
				if (!fileobj.open(result->misc,user.usercard()))
				{
					x =
					fileobj.list(1,user.usercard(),&user.kused,
					user.last_logon(),uldlratio,
					user.u_timelimit(),
					user.user_logon(),
					user.prevtimeused(),
					&user.total_kused,
					user.u_downloads(),
					user.lin());
					if (x > 0)
						user.inc_downloads(x);
				}
				break;
			case 26:            // list new files without option to download
				// print 'please wait' message
				fileobj.waitmsg();
				if (!fileobj.open(result->misc,user.usercard()))
				{
					fileobj.list(0,user.usercard(),&user.kused,
					user.last_logon(),uldlratio,0,0,0,0,0,
					user.lin());
				}
				break;
			case 27:            // list all files with option to download
				// print 'please wait' message
				fileobj.waitmsg();
				if (!fileobj.open(result->misc,user.usercard()))
				{
					x =
					fileobj.list(1,user.usercard(),&user.kused,0L,
					uldlratio,user.u_timelimit(),
					user.user_logon(),
					user.prevtimeused(),
					&user.total_kused,
					user.u_downloads(),
					user.lin());
					if (x > 0)
						user.inc_downloads(x);
				}
				break;
			case 28:            // list all files without option to download
				// print 'please wait' message
				fileobj.waitmsg();
				if (!fileobj.open(result->misc,user.usercard()))
				{
					fileobj.list(0,user.usercard(),&user.kused,0L,uldlratio,0,0,0,0,0,user.lin());
				}
				break;
			case 29:            // search for string in files area with option
				if (!fileobj.open(result->misc,user.usercard()))
				{
					x = fileobj.search(1,user.u_timelimit(),
					user.user_logon(),
					user.prevtimeused());
					if (x > 0)
						user.inc_downloads(x);
				}
				break;
			case 30:            // search for string in files area w/o option
				if (!fileobj.open(result->misc,user.usercard()))
				{
					fileobj.search(0,0,0,0);
				}
				break;
			case 31:            // view detailed information on file
				if (!fileobj.open(result->misc,user.usercard()))
				{
					fileobj.info(NULL,NULL,NULL);
					user.waitcr();
				}
				break;
			case 32:            // download file
				if (!fileobj.open(result->misc,user.usercard()))
				{
					x =
					fileobj.one_download(&user.kused,
						uldlratio,NULL,1,
						user.usercard(),
						user.u_downloads(),
						&user.total_kused);
					if (x > 0)
						user.inc_downloads(x);
				}
				break;
			case 33:            // upload files
				if (!fileobj.open(result->misc,user.usercard()))
				{
					x = fileobj.upload(user.logname(),user.editorname(), &credit);
					if (x > 0)
						user.inc_uploads(x);
					if (credit > 0 && user.credituploads())
						user.inc_credit(x);
				}
				break;
			case 34:            // delete a file (that you uploaded)
				break;
			case 35:            // download a particular file (with ratio checking
				x = fileobj.one_download(&user.kused,
						uldlratio,result->misc,1,
						user.usercard(),
						user.u_downloads(),
						&user.total_kused);
				if (x > 0)
					user.inc_downloads(x);
				break;
			case 36:            // download a particular file (without ratio checking
				fileobj.one_download(&user.kused,
						uldlratio,result->misc,0,
						user.usercard(),
						user.u_downloads(),
						&user.total_kused);
				break;
			case 37:            // upload a file without adding to a files section
				fileobj.one_upload(user.logname(),result->misc);
				break;
			case 38:            // upload a file without adding to a files section
					// upload to /bbs/tmp/$LOGNAME
				fileobj.one_upload(user.logname(),NULL);
				break;
//			case 39:	// search all files sections for a filename
//				fileobj.search_sections();
//				(not available yet)
				// sysop specific commands follow
			case 40:            // search for users for edit/delete
				tmpuser.list(1,1);
				break;
			case 41:            // delete inactive users from the BBS
				tmpuser.inactive_delete();
				break;
			case 42:            // list inactive users
				tmpuser.inactive_list();
				break;
			case 43:            // list users for edit/delete
				tmpuser.list(0,1);
				break;
			case 44:            // invoke BBS bbsmon (sysop only)
				sysop_mon.line_bbsmon();
				break;
#ifdef USE_DATABASE
			case 46:	// post public message
				user.inc_pub_messages(message.post(result->misc,NULL,0,NULL));
				break;
			case 47:	// read public messages
				user.inc_pub_messages(message.read_public(result->misc,0,user.lin()));
				break;
			case 48:	// group read through group number
				if (sscanf(result->misc,"%d",&x) != 1)
				{
					user.ap_log("Unable to determine group number for group read");
				}
				else
					user.inc_pub_messages(message.read_public(NULL,x,user.lin()));
				break;
			case 49:	// group read 
				user.inc_pub_messages(message.read_public(NULL,-1,user.lin()));
				break;
			case 50:	// select sections for group reads
				message.select_sections();
				break;
			case 51:	// scan for new messages in section since last call
				message.scan_section(user.last_logon(),result->misc);
				break;
			case 52:	// search in section
				break;
			case 53:	// search sections
				break;
			case 54:	// search sections, group number
				break;
			case 55:	// post private message
				user.inc_priv_messages(message.post(result->misc,NULL,1,NULL));
				break;
			case 56:	// read private messages
				// loop until normal exit code
				x = 1;
				priv_highest = 0;
				for (x = 1; x != 0;)
				{ 
					x = message.read_private(result->misc,&priv_highest);
					// x < 0 means lookup due to deleted message
					if (x >= 0)
					{
						user.inc_priv_messages(x);
						x = 0;
					}
				}
				break;
			case 57:	// display section information
				message.section_information(result->misc);
				break;
			case 58:	// expire messages
				message.expire();
				message.waitcr();
				break;
			case 59:	// show groups currently selected
				message.show_groups();
				break;
			case 60:	// list sender and subject of messages in mailbox
				message.list_messages(result->misc);
				break;
			case 61:	// send an email message to a particular address
				user.inc_priv_messages(message.post(PRIVATE_SECTION,NULL,1,result->misc));
				break;
			case 62:	// delete all messages in mailbox
				message.delete_mail(result->misc);
				break;
			// 63-69 unused
#endif
			case 70:            // display chat server status
				chatobj.admin_info(0);
				break;
			case 71:            // display private chat server status
				chatobj.admin_info(1);
				break;
			case 72:            // display broadcast server status
				chatobj.admin_info(2);
				break;
			case 73:            // display info on all rooms
				chatobj.ap_log("viewing all rooms information");
				chatobj.room_info();
				break;
			case 74:            // display info on one room
				sprintf(tmpstr,"displaying chat room %s information",result->misc);
				chatobj.ap_log(tmpstr);
				if (sscanf(result->misc,"%d",&x) != 1)
				{
					menu.ap_log("Unable to determine chat room number.");
				}
				else
					chatobj.room_users(x);
				break;
			case 75:            // send a broadcast to all users
				chatobj.ap_log("sending broadcast to all users.");
				chatobj.broadcast(0);
				break;
			case 76:            // send a broadcast to one user
				chatobj.ap_log("sending broadcast to one user.");
				chatobj.broadcast(1);
				break;
			case 77:            // change a club password
				sprintf(tmpstr,"Changing club password for room %s.",result->misc);
				chatobj.ap_log(tmpstr);
				if (sscanf(result->misc,"%d",&x) != 1)
				{
					menu.ap_log("Unable to determine chat room number.");
				}
				else
					chatobj.change_club_password(x);
				break;
			case 78:            // connect to a club
				sprintf(tmpstr,"Connecting to club %s.",result->misc);
				chatobj.ap_log(tmpstr);
				if (sscanf(result->misc,"%d",&x) != 1)
				{
					menu.ap_log("Unable to determine chat room number.");
				}
				else
					chatobj.club_connect(x);
				break;
			case 79:            // connect to a dynamic room
				sprintf(tmpstr,"Connecting to dynamic room %s.",result->misc);
				chatobj.ap_log(tmpstr);
				chatobj.dynamic_connect();
				break;
			case 80:            // connect to a public room
				sprintf(tmpstr,"Connecting to public room %s.",result->misc);
				chatobj.ap_log(tmpstr);
				if (sscanf(result->misc,"%d",&x) != 1)
				{
					menu.ap_log("Unable to determine chat room number.");
				}
				else
					chatobj.room_connect(x);
				break;
			case 81:            // connect to another person privately
				sprintf(tmpstr,"Connecting to private room.");
				chatobj.ap_log(tmpstr);
				chatobj.private_connect(NULL,0);
				break;
			case 82:            // create a dynamic room
				sprintf(tmpstr,"Creating dynamic room.");
				chatobj.ap_log(tmpstr);
				chatobj.room_create();
				break;
			case 83:            // edit your kill file
				chatobj.edit_kill();
				break;
			case 84:            // break into chat with a user (sysop initiated)
				chatobj.private_connect(NULL,1);
				break;
			case 85:	// change fore/back chat output colors
				user.edit_chat_colors();
				break;
		}
	}
#ifdef USE_DATABASE
	if (!bootuser)
	{
		// ask whether to update high message
		menu.sstrl("UPDATEMESPTR");
		if (menu.yesno())
			message.save_groupfile();
	}
	menu.cr();
	menu.cr();
#endif
	menu.clear_scr();
	// display logoff message
	strcpy(tmpstr,bbsdir);      // get bbsdir
	// get logoff menu
	strcat(tmpstr,"/text/logoff");
	if (!bootuser)
		menu.display_file(tmpstr,0,user.terminal(),1);
	menu.cr();
	menu.cr();
	menu.cr();
	menu.cr();
	user.save(NULL);
	sprintf(tmpstr,"\\f6rocat BBS System for Linux version \\f4%s\\n",VERSION);
	menu.sstrcr_c(tmpstr);
	menu.sstrcr_c("\\f6copyright \\f7(C)\\f6 1994-1996 by Gregory Shaw and fmSoft, Inc.  All Rights Reserved.\\n");
	menu.sstrcr_c("\\f6rocat BBS support is available at The Roman Catacombs \\f4(303) 404-3473\\n");
	menu.cr();
	if (!strcmp(crypt(menu.reg_sentence(),"k2"),menu.reg_key()))
	{
		sprintf(tmpstr,"\\f6This instance is registered to \\f2%s\\n",menu.reg_sentence());
		menu.sstrcr_c(tmpstr);
	}
	else
		menu.sstrcr_c("\\f6This copy is \\f2UNREGISTERED\\n");
	sprintf(tmpstr,"Logoff for %s %s",user.fname,user.lname);
	user.ap_log(tmpstr);
//	if (mon_obj.watching())
//	{
//		sprintf(tmpstr,"Logoff for %s %s.\n",user.fname,user.lname);
//		mon_obj.send(tmpstr,1);
//	}
	sleep(1);
	return(0);
};


#endif                          // _BBS_C_






