/* From iioobj.gstr file "rogues.pas" */

#ifndef _ROGUES_C_
#define _ROGUES_C_

#include "bf.h"

void check_for_levelr(Player *player, boolean watch)
{
  long level;
  double num;
  char STR1[256], STR3[256];


  level = 1;
  num = 450.0;
  while (num < player->experience) {
    level++;
    num *= 1.5;
  }
  level--;
  if (level <= player->level)
    return;
  if (watch) {
    sprintf(STR3, "From the fight, %s %s has gained", player->male?"Prince":"Princess",player->alias);
    ioobj.sstrcr(STR3);
    sprintf(STR3, "%ld %s.", level-player->level,level-player->level>1?"levels":"level");
    ioobj.sstrcr(STR3);
  }
  player->level = level;
  if (watch) {
    sprintf(STR1, "He is now level %ld", player->level);
    ioobj.sstrcr(STR1);
  }
}

void check_rogue(Player **uptr, boolean watch)
{
  char STR2[256];

  if (watch) {
    sprintf(STR2, "Moving %s", (*uptr)->alias);
    ioobj.sstrcr(STR2);
  }
  if ((*uptr)->dead) {
    if (watch) {
      sprintf(STR2, "%s is dead.", (*uptr)->alias);
      ioobj.sstrcr(STR2);
      ioobj.sstrcr("Attempting resurrection..");
    }
    (*uptr)->dead = false;
    if ((*uptr)->armysize < 100000L) {
      (*uptr)->armysize = abs(rand() % 30000) + 40000L;
    }
    (*uptr)->gold = 20000;
  }
  if (!find_r_castle((*uptr)->alias)) {
    if (watch) {
      sprintf(STR2, "%s has lost his only castle.",
	      (*uptr)->alias);
      ioobj.sstrcr(STR2);
      ioobj.sstrcr("Giving him another..");
    }
    give_r_castle(uptr, watch);
  }
  if (watch) {
    sprintf(STR2, "Augmenting army of %s", (*uptr)->alias);
    ioobj.sstrcr(STR2);
  }
  if ((*uptr)->armysize > 1000)
    (*uptr)->armysize += (*uptr)->armysize / 10;
  else {
    (*uptr)->armysize = abs(rand() % 30000) + 1200;
  }
  (*uptr)->gold += abs(rand() % 30000) + 5000;
}

boolean find_r_castle(char *name)
{
  Castle *gptr;
  boolean found;

  gptr = castles;
  found = false;
  while (gptr != NULL && !found) {
    if (!strcmp(gptr->alias, name))
      found = true;
    else
      gptr = gptr->next;
  }
  return found;
}

void give_r_castle(Player **uptr, boolean watch)
{
  Castle castle;
  char STR2[54];
  char STR3[256];

  castle.sector = abs(rand() % boardsize) + 1;
  castle_name(&castle);
  strcpy(castle.alias, (*uptr)->alias);
  sprintf(STR2, "%s", castle.name);
  strcpy(castle.name, STR2);
  sprintf(STR2, "%s", castle.alias);
  strcpy(castle.alias, STR2);
  if (watch) {
    sprintf(STR3, "%s receives the castle %s from others in his alliance",
	    (*uptr)->alias, castle.name);
    ioobj.sstrcr(STR3);
  }
  castle.armor = 10;
  castle.weapon = 10;
  castle.oil = 5;
  castle.castype = 0;
  castle.moat = 10;
  castle.wall = 10;
  castle.towers = 1;
  strcpy(castle.oldowner, "Magi");
  castle.defend = abs(rand() % 10000) + 20000;
  castle.alliance = 100;
  strcpy(castle.attackedby, "none");
  addcastle(castle, &castles);
}

void move_rem(boolean watch)
{
  ioobj.sstrcr("Moving Rogues..");
  player = players;
  while (player != NULL) {
    if (player->alliance == 100) {
      check_rogue(&player, watch);
      move_rogue(&player, watch);
    }
    player = player->next;
  }
  ioobj.sstrcr("All of the Magi have been moved.  Thank you for waiting..");
  ioobj.waitcr();
}

void move_rogue(Player **player, boolean watch)
{
  long direction, b, moves;
  Player *enemy;
  boolean dead;
  Castle *cptr;
  Army *army;
  boolean dum;
  long tmp;
  char STR4[256];

  remove_rogue_castles(player, watch);
  b = (long)floor(sqrt((double)boardsize) + 0.5);
  direction = abs(rand() & 7);
  switch (direction) {

  case 0:
    direction = -b;
    break;

  case 1:
    direction = 1 - b;
    break;

  case 2:
    direction = 1;
    break;

  case 3:
    direction = b + 1;
    break;

  case 4:
    direction = b;
    break;

  case 5:
    direction = b - 1;
    break;

  case 6:
    direction = -1;
    break;

  case 7:
    direction = -b - 1;
    break;
  }
  moves = 0;
  dead = false;
  strcpy((*player)->killedby,"-");
  (*player)->sector += direction;
  if ((*player)->sector > boardsize)
    (*player)->sector -= boardsize;
  else if ((*player)->sector < 0)
    (*player)->sector += boardsize;
  while (moves < 201 && !(*player)->dead) {
    (*player)->sector += direction;
    if ((*player)->sector > boardsize)
      (*player)->sector -= boardsize;
    else if ((*player)->sector < 0)
      (*player)->sector += boardsize;
    if (find_player_in_sector((*player)->sector, &enemy) &&
	enemy->alliance != 100 && !enemy->dead)
      dum = roguefight(*player, enemy, watch, false);
    if (find_army_in_sector((*player)->sector, &army)) {
      if (!find_player_by_alias(army->owner, &enemy))
	exit_game(0);
      if (watch) {
	sprintf(STR4, "%s %s has found an army of %s",
		(*player)->male?"Prince":"Princess",(*player)->alias, enemy->alias);
	ioobj.sstrcr(STR4);
      }
      tmp = enemy->armysize;
      if (!roguefight(*player, enemy, watch, true))
	delete_army(army);
      enemy->armysize = tmp;
    }
    if (!(*player)->dead)
      roguecastle(player, &cptr, watch);
    moves++;
  }
  remove_rogue_castles(player, watch);
}

void remove_rogue_castles(Player **player, boolean watch)
{
  Castle *cptr, *cptr2, *dptr;
  long count, num;
  char STR2[256];

  count = 0;
  cptr = castles;
  while (cptr != NULL) {
    if (!strcmp(cptr->alias, (*player)->alias))
      count++;
    cptr = cptr->next;
  }
  num = 5;
  if (count <= 5)
    return;
  cptr = castles;
  cptr2 = castles;
  while (cptr != NULL && num > 0) {
    if (strcmp(cptr->alias, (*player)->alias)) {
      cptr2 = cptr;
      cptr = cptr->next;
      continue;
    }
    if (watch) {
      sprintf(STR2, "%s loses the castle %s to tornadoes.",
	      (*player)->alias, cptr->name);
      ioobj.sstrcr(STR2);
    }
    num--;
    (*player)->armysize += cptr->defend;
    if (cptr == castles) {
      castles = cptr->next;
      cptr2 = castles;
      dptr = cptr;
    } else {
      cptr2->next = cptr->next;
      dptr = cptr;
    }
    cptr = cptr->next;
    free(dptr);
  }
}

void roguecastle(Player **player, Castle **cptr, boolean watch)
{
  long x, oillost, totalarmy;
  boolean init;
  long tmp, castlelost, totcaslost;
  boolean dead, done, playerwon;
  char STR2[256], STR3[256], STR4[256];
  Player *WITH;
  long FORLIM;

  done = false;
  dead = false;
  init = true;
  if (find_castle_in_sector((*player)->sector, cptr) && (*cptr)->alliance != 100) {
    if (watch) {
      sprintf(STR4, "%s %s decides to attack castle %s",
	      (*player)->male?"Prince":"Princess",(*player)->alias, (*cptr)->name);
      ioobj.sstrcr(STR4);
    }
    playerwon = false;
    WITH = *player;   /*with*/
    if ((*cptr)->defend <= 1) {
      if (watch) {
	sprintf(STR3, "%s %s walks into the empty castle %s",
		(*player)->male?"Prince":"Princess",
		(*player)->alias,
		(*cptr)->name);
	ioobj.sstrcr(STR3);
	ioobj.sstrcr("and makes it his.  ");
      }
      playerwon = true;
      (*player)->experience += 20000;
      strcpy((*cptr)->oldowner, (*cptr)->alias);
      strcpy((*cptr)->alias, (*player)->alias);
      (*cptr)->alliance = (*player)->alliance;
      (*cptr)->armor = (*player)->armor;
      (*cptr)->weapon = (*player)->weapon;
      (*cptr)->defend = 1;
      (*player)->armysize--;
      done = true;
    }
    totcaslost = 0;
    while ((*cptr)->defend > 0 && !(*player)->dead && !done) {
      tmp = (long)floor(0.02 * (*cptr)->defend + 0.05 * (*cptr)->defend +
			lrand48() % labs((*cptr)->defend + 1) * 0.02 +
			((*cptr)->defend - (*player)->armysize) * 0.02 +
			(*cptr)->armor * 0.05 * (*cptr)->defend +
			(*cptr)->weapon * 0.05 * (*cptr)->defend + 0.5);
      totalarmy = WITH->armysize;
      castlelost = (long)floor((WITH->str - 12) * 0.02 * totalarmy +
			       (WITH->chrs - 12) * 0.005 * totalarmy +
			       (WITH->int_ - 12) * 0.005 * totalarmy +
			       WITH->level * 0.02 * totalarmy +
			       lrand48() % labs(totalarmy) * 0.1 +
			       (totalarmy - (*cptr)->defend) * 0.03 +
			       (WITH->armor - 2) * 0.005 * totalarmy +
			       (WITH->weapon - 2) * 0.005 * totalarmy + 0.5);
      castlelost /= labs((*cptr)->wall - 9);
      if ((*cptr)->moat > 0)
	castlelost /= labs((*cptr)->moat - 5) + 1;
      if ((*cptr)->towers > 0)
	castlelost /= labs((*cptr)->towers - 2) + 1;
      if (castlelost < 0)
	castlelost = 0;
      if (castlelost > (*cptr)->defend)
	castlelost = (*cptr)->defend;
      if ((*cptr)->moat > 0) {
	tmp += abs(rand() % 200) * labs((*player)->armor - 4) *
	       labs((*cptr)->moat - 4);
      }
      if ((*cptr)->towers > 0) {
	tmp += abs(rand() % 1000) * labs(10 - (*player)->armor) *
	       labs((*cptr)->towers);
      }
      tmp += abs(rand() % 300) * labs((*player)->armor - 5) *
	     labs((*cptr)->wall - 10);
      oillost = 0;
      if ((*cptr)->oil > 0) {
	FORLIM = (*cptr)->oil;
	for (x = 1; x <= FORLIM; x++) {
	  oillost += abs(rand() % 400);
	}
	(*cptr)->oil = 0;
      }
      tmp += oillost;
      if (castlelost < 0)
	castlelost = 0;
      if (castlelost > (*cptr)->defend)
	castlelost = (*cptr)->defend;
      totcaslost += castlelost;
      if (tmp < 0) {
	tmp = abs(rand() % labs((*cptr)->defend + 1));
      }
      if (tmp > (*player)->armysize)
	tmp = (*player)->armysize;
      if (tmp < totalarmy) {
	if (watch) {
	  sprintf(STR3, "%s %s changes his mind.",
		(*player)->male?"Prince":"Princess",
		  (*player)->alias);
	  ioobj.sstrcr(STR3);
	  ioobj.sstrcr("He leaves the castle to it's own devices.");
	  (*player)->sector += lrand48() % 50;
	}
	done = true;
      } else {
	if (tmp >= totalarmy || (*player)->armysize <= 1) {
	  if (watch) {
	    sprintf(STR2, "%s %s has been defeated!",
		(*player)->male?"Prince":"Princess",
		    (*player)->alias);
	    ioobj.sstrcr(STR2);
	  }
	  (*player)->killed = (*player)->armysize;
	  (*player)->armysize = 1;
	  strcpy((*player)->killedby, (*cptr)->name);
	  (*player)->dead = true;
	  dead = true;
	  done = true;
	} else
	  (*player)->armysize -= tmp;
      }
      if (castlelost >= (*cptr)->defend && !done) {
	if (dead)
	  (*cptr)->defend /= 2;
	else {
	  if (watch) {
	    sprintf(STR3, "%s %s has prevailed!",
		(*player)->male?"Prince":"Princess",
		    (*player)->alias);
	    ioobj.sstrcr(STR3);
	  }
	  playerwon = true;
	  strcpy((*cptr)->oldowner, (*cptr)->alias);
	  strcpy((*cptr)->alias, (*player)->alias);
	  (*cptr)->alliance = (*player)->alliance;
	  (*cptr)->armor = (*player)->armor;
	  (*cptr)->weapon = (*player)->weapon;
	  (*cptr)->defend = (*player)->armysize / 4;
	  (*player)->armysize -= (*player)->armysize / 4;
	  done = true;
	}
      }
      if (!playerwon) {
	if (!done)
	  (*cptr)->defend -= castlelost;
	continue;
      }
      WITH->goldfound = (int)fabs(totcaslost / (abs(rand() % 50) + 1));
      (*player)->experience += totcaslost * 20;
      (*player)->gold += WITH->goldfound;
      done = true;
      ioobj.cr();
    }  /*while*/
  }
  check_for_levelr(*player, watch);
  if ((*player)->dead)
    subtract_levelr(*player, watch);
}  /*procedure*/

boolean roguefight(Player *attacker, Player *defender, boolean watch, boolean army)
{
  boolean Result;
  boolean flee;
  long offset1, offset2;
  boolean done;
  long a, b, attackerlosses, defenderlosses, mmen, tmp1, tmp2, defenderdead;
  char STR2[256], STR3[256];
  char STR4[256];

  flee = false;
  done = false;
  defenderdead = 0;
  mmen = 0;
  offset1 = 0;
  offset2 = 0;
  if (defender->armysize <= 1) {
    if (watch) {
      sprintf(STR3, "%s %s has found the bones of another army.  ",
		attacker->male?"Prince":"Princess",
	      attacker->alias);
      ioobj.sstrcr(STR3);
    }
    done = true;
  }
  while (!done) {
    if (!attacker->alignment)
      offset1 = 6;
    if (!defender->alignment)
      offset2 = 6;
    a = attacker->armysize;
    b = defender->armysize;
    attackerlosses = labs((long)floor((defender->str - 12) * 0.02 * b +
	      (defender->chrs - 12) * 0.005 * b +
	      (defender->int_ - 12) * 0.005 * b +
	      lrand48() % labs(b) * 0.1 + (b - a) * 0.03 +
	      (defender->race - offset2 - 2) * 0.01 * b +
	      (defender->armor - 2) * 0.005 * b +
	      (defender->weapon - 2) * 0.005 * b * 1.15 + 0.5));
    attackerlosses += labs((long)floor(defender->level * 0.02 * b + 0.5));
    if (attackerlosses >= attacker->armysize)
      attackerlosses = attacker->armysize;
    tmp1 = attackerlosses;
    ioobj.cr();
    defenderlosses = labs((long)floor((attacker->str - 12) * 0.02 * a +
	      (attacker->chrs - 12) * 0.005 * a +
	      (attacker->int_ - 12) * 0.005 * a +
	      attacker->level * 0.01 * a + lrand48() % labs(a) * 0.1 +
	      (a - b) * 0.03 +
	      (attacker->race - offset1 - 2) * 0.01 * a +
	      (attacker->armor - 2) * 0.005 * a +
	      (attacker->weapon - 2) * 0.005 * a + 0.5));
    defenderdead += defenderlosses;
    attackerlosses = labs((long)floor((defender->str - 12) * 0.02 * b +
	      (defender->chrs - 12) * 0.005 * b +
	      (defender->int_ - 12) * 0.005 * b +
	      defender->level * 0.03 * b + lrand48() % labs(b) * 0.1 +
	      (b - a) * 0.03 +
	      (defender->race - offset2 - 2) * 0.01 * b +
	      (defender->armor - 2) * 0.005 * b +
	      (defender->weapon - 2) * 0.005 * b + 0.5));
    tmp2 = attackerlosses;
    if (tmp2 >= attacker->armysize || attacker->armysize <= 1) {
      if (watch) {
	sprintf(STR2, "%s %s has been destroyed by",
		attacker->male?"Prince":"Princess",
		attacker->alias);
	ioobj.sstrcr(STR2);
	sprintf(STR2, "%s %s", 
		defender->male?"Prince":"Princess",defender->alias);
	ioobj.sstrcr(STR2);
      }
      if (watch) {
	sprintf(STR3, "%s %s stares in disbelief as the magi",
		defender->male?"Prince":"Princess",
		defender->alias);
	ioobj.sstrcr(STR3);
	ioobj.sstrcr("Weapons of his enemy dissolve before his eyes.");
	ioobj.sstrcr("If he only had such weapons..");
      }
      quit = true;
      done = true;
      flee = true;
      if (!army) {
	attacker->dead = true;
	attacker->killed = attacker->armysize;
	defender->gold += attacker->gold;
	defender->goldfound = attacker->gold;
	defender->killed += defenderdead;
	strcpy(defender->killedby, attacker->alias);
	attacker->gold = 0;
	attacker->armysize = 1;
	strcpy(attacker->killedby, defender->alias);
      }
    }
    if (defenderlosses >= defender->armysize || defender->armysize <= 1) {
      if (watch) {
	sprintf(STR2, "%s %s falls before the armies of ",
		defender->male?"Prince":"Princess",
		defender->alias);
	ioobj.sstrcr(STR2);
	sprintf(STR2, "%s %s", 
		attacker->male?"Prince":"Princess",
		attacker->alias);
	ioobj.sstrcr(STR2);
      }
      done = true;
      if (!defender->incastle)
	defender->dead = true;
      else if (watch) {
	sprintf(STR3, "but, %s %s is hiding in his castle",
		defender->male?"Prince":"Princess",
		defender->alias);
	ioobj.sstrcr(STR3);
	ioobj.sstrcr("What a wimp!");
      }
      defender->killed = defender->armysize;
      strcpy(defender->killedby, attacker->alias);
      attacker->experience += defenderdead * 3;
      attacker->gold += labs(defender->gold);
      defender->armysize = 1;
      defenderlosses = 0;
    }
    if (flee || done)
      continue;
    if (watch) {
      sprintf(STR2, "%s %s has lost %ld of %ld warriors.",
		attacker->male?"Prince":"Princess",
	      attacker->alias, tmp2, attacker->armysize);
      ioobj.sstrcr(STR2);
    }
    attacker->armysize -= tmp2;
    if (watch) {
      sprintf(STR4, "While %s has lost %ld of %ld warriors.", defender->alias, defenderlosses, defender->armysize);
      ioobj.sstrcr(STR4);
    }
    defender->armysize -= defenderlosses;
  }  /*while*/
  if (!flee && army)
    Result = false;
  else
    Result = true;
  check_for_levelr(attacker, watch);
  return Result;
}  /*function*/

void rollrogues()
{
  long count;
  FILE *outfile;
  Player rogue;
  Castle castle;
  struct stat buf;
  char STR1[256];
  char STR2[66];
  char STR3[62];

  sprintf(STR1, "%s/Princes", CONFDIR);
  if (stat(STR1,&buf) < 0)
  {  /* doesn't exist */
	ioobj.sstrcr("Creating Players...");
	sprintf(STR1, "%s/Princes", CONFDIR);
	outfile = ioobj.bopen(STR1, "wb");
	if (outfile == NULL)
	{
		perror(STR1);
		exit_game(1);
	}
	for (count = 1; count <= 16; count++) {
		major_castles(count, &castle);
		sprintf(STR2, "%s", castle.alias);
		sprintf(rogue.alias, "%.30s", STR2);
		sprintf(STR3, "%s", castle.name);
		sprintf(STR1, "%.31s", STR3);
		strcpy(castle.name, STR1);
		rogue.armysize = abs(rand() % (50000*theoptions.difficulty));
		rogue.sector = abs(rand() % (boardsize - 1)) + 1;
		rogue.armor = 5;
		rogue.weapon = 5;
		rogue.alliance = 100;
		rogue.alignment = true;
		rogue.incastle = false;
		rogue.teleport = 0;
		rogue.level = 1;
		rogue.experience = 0;
		rogue.map = 0;
		rogue.timesplayed = 0;
		rogue.dmons = 0;
		rogue.descas = 0;
		rogue.mwarriors = 0;
		rogue.mweapon = 0;
		rogue.steal = 0;
		rogue.killer = 0;
		rogue.gold = 5000;
		rogue.dead = false;
		rogue.goldfound = 0;
		rogue.bank = 0;
		strcpy(rogue.alliancename, "Magi");
		rogue.allianceleader = false;
		strcpy(rogue.killedby, "-");
		rogue.str = abs(rand() % 10) + 10;
		rogue.int_ = abs(rand() % 10) + 10;
		rogue.luck = abs(rand() % 10) + 10;
		rogue.chrs = abs(rand() % 10) + 10;
		rogue.agi = abs(rand() % 10) + 10;
		rogue.killed = 0;
		rogue.entrydate = 0;
		if (abs(rand() % 100) > 49)
			rogue.male = true;
		else
			rogue.male = false;
		strcpy(rogue.name, "magi");
		rogue.race = abs(rand() % 5) + 7;
		fwrite(&rogue, sizeof(Player), 1, outfile);
	}
	ioobj.bclose(outfile);
	sprintf(STR1, "%s/Princes", CONFDIR);
	chmod(STR1,0775);
  }
}

void subtract_levelr(Player *player, boolean watch)
{
  long level, num;
  char STR1[256], STR3[256];


  level = 1;
  num = 450;
  if (level <= 1)
    return;
  while (level < player->level - 1) {
    level++;
    num *= 2;
  }
  player->experience = num;
  if (watch) {
    sprintf(STR3, "From the fight, %s %s has lost",
		player->male?"Prince":"Princess",
	    player->alias);
    ioobj.sstrcr(STR3);
    ioobj.sstrcr("one level.");
  }
  player->level = level;
  if (watch) {
    sprintf(STR1, "He is now level %ld", player->level);
    ioobj.sstrcr(STR1);
  }
}
#endif _ROGUES_C_
