#ifndef _ARMIES_C_
#define _ARMIES_C_

#include "bf.h"

void create_armies(void)
{

  char STR1[256];
  struct stat buf;
  FILE *arfile;


  arfile = NULL;
  sprintf(STR1, "%s/Armies", CONFDIR);
  if (stat(STR1,&buf) < 0)
  {  /* doesn't exist */
	  ioobj.sstrcr("Creating armies..");
	  sprintf(STR1, "%s/Armies", CONFDIR);
	  arfile = ioobj.bopen(STR1, "wb");
	  if (arfile == NULL)
	    {
		perror(STR1);
		exit_game(1);
	    }
	  ioobj.bclose(arfile);
          chmod(STR1,0775);
  }
}

void delete_army(Army *arptr)
{
  Army *dptr, *arptr2;

  dptr = armies;
  while (dptr != arptr) {
    arptr2 = dptr;
    dptr = dptr->next;
  }
  if (dptr == armies)
    armies = dptr->next;
  arptr2->next = dptr->next;
  free(dptr);
}

boolean find_army_in_sector(long thesector, Army **arptr)
{
  *arptr = armies;
  while (*arptr != NULL && (*arptr)->sector != thesector)
    *arptr = (*arptr)->next;
  return (*arptr != NULL);
}


void get_armies(Army **armies)
{
  FILE *infile;
  Army arrec, *arptr;
  char STR1[256];

  infile = NULL;
  sprintf(STR1, "%s/Armies", CONFDIR);
  infile = ioobj.bopen(STR1, "rb");
  if (infile == NULL)
  {
	perror(STR1);
	exit_game(1);
  }
  while (!feof(infile)) {
    if (fread(&arrec, sizeof(Army), 1, infile) == 1)
    {
	    arptr = (Army *)malloc(sizeof(Army));
	    arptr->sector = arrec.sector;
	    arptr->region = arrec.region;
	    arptr->region_sub = arrec.region_sub;
	    strcpy(arptr->owner, arrec.owner);
	    arptr->men = arrec.men;
	    arptr->next = *armies;
	    *armies = arptr;
    }
  }
  ioobj.bclose(infile);
  infile = NULL;
}


void station_army(Player **uptr)
{
  long men;
  Army *arptr;
  char STR2[256], STR3[256];
  char s[256], c[256];

  ioobj.clear_scr();
  arptr = armies;
  while (arptr != NULL && arptr->sector != currentsector)
    arptr = arptr->next;
  if (arptr != NULL) {
    sprintf(STR3, "You have %ld men in your army.", (*uptr)->armysize);
    ioobj.sstrcr(STR3);
    sprintf(STR2, "You currently have %ld warriors in this sector.", arptr->men);
    ioobj.sstrcr(STR2);
    ioobj.cr();
    ioobj.sstr("Do you wish to take or leave men? ");
    strcpy(s,"");
    ioobj.gstr(s, 1L);
    if (uncase(s[0]) == 'l') {
      ioobj.sstr("How many warriors would you like to add? ");
    strcpy(s,"");
      ioobj.gstr(s, 6L);
      stringtonum(s, &men);
      if (men >= (*uptr)->armysize || men <= 0)
	ioobj.sstrcr("You do not have that many warriors.");
      else {
	(*uptr)->armysize -= men;
	arptr->men += men;
	ioobj.sstrcr("Your warriors have been stationed.");
      }
    } else {
      ioobj.sstr("How many warriors would you like to take? ");
    strcpy(s,"");
      ioobj.gstr(s, 6L);
      stringtonum(s, &men);
      if (men > arptr->men || men <= 0)
	ioobj.sstrcr("You don't have that many warriors in the sector!");
      else {
	if (men == arptr->men) {
	  (*uptr)->armysize += men;
	  delete_army(arptr);
	} else {
	  arptr->men -= men;
	  (*uptr)->armysize += men;
	}
      }
    }
  } else {
    sprintf(STR3, "You have %ld men in your army.", (*uptr)->armysize);
    ioobj.sstrcr(STR3);
    ioobj.cr();
    ioobj.sstrcr("You may station any part of your army in this sector.");
    ioobj.sstr("How many warriors would you like to station? ");
    strcpy(c,"");
    ioobj.gstr(c, 6L);
    stringtonum(c, &men);
    if (men > (*uptr)->armysize)
      ioobj.sstrcr("You don't have that many men to put on station!");
    else if (men > 0) {
      (*uptr)->armysize -= men;
      arptr = (Army *)malloc(sizeof(Army));
      arptr->next = armies;
      armies = arptr;
      arptr->men = men;
      arptr->region = sector.region;
      arptr->region_sub = sector.region_sub;
      arptr->sector = currentsector;
      strcpy(arptr->owner, (*uptr)->alias);
      ioobj.sstrcr("the warriors have been stationed.");
    }
  }
  ioobj.waitcr();
}


#endif // _ARMIES_C_
