/* This is completely random, maximum maximum should be 2G. Except of course
   that we can only have 256 message queues, so it's fixed at 256 for now. */ 
#define MAX_NODES 256

/* One day... */
#define DEV_MODEM    0
#define DEV_LOCAL    1
#define DEV_TELNET   2

#define SHM_PERM 0660

#define BUSY_INIT     0  
#define BUSY_WAITING  1
#define BUSY_LOGIN    2
#define BUSY_ONLINE   3
#define BUSY_CHATTING 4
#define BUSY_DOOR     5
#define BUSY_PAGING   6
#define BUSY_SHUTDOWN 7
#define BUSY_DOWNLOAD 8
#define BUSY_UPLOAD   9

#define KEYFILE "."

#define SF_INCBUSY    1
#define SF_INCDONE    2
#define SF_INTERRUPT  4

struct status_t {
  int flags;
  int busy;
  pid_t pid;
};

struct pool_t {
  int nodes;
  struct status_t status[MAX_NODES];
};

extern struct pool_t *status_pool;
extern struct status_t *status_p;
extern int node;

int initstatus();
int getstatus(int, struct status_t *);
void killstatus();
int probe_node();
struct status_t *attach_other(int);
int init_pool(int);

#define isanode(x) (status_pool -> status[(x)].pid != 1)
