#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <termios.h>
#include <unistd.h>
#include "modem.h"
#include "output.h"

#define SMTP_PORT 25

static int smtp_socket;
static char *smtp_buffer = NULL;

int smtp_connect(char *hostname) 
{
  int sd;
  struct hostent *host;
  struct sockaddr_in sname;

  if(smtp_buffer == NULL)
    smtp_buffer = (char *)malloc(1024);
   
  host = gethostbyname(hostname);
  if(!host) {
    log("SMTP host (%s) lookup failure", hostname);
    return -1;
  }
   
  sd = socket(PF_INET, SOCK_STREAM, 0);
  sname.sin_family = AF_INET;
  sname.sin_port = htons(SMTP_PORT);
  memcpy(&sname.sin_addr, host -> h_addr_list[0], sizeof(struct in_addr));

  if(connect(sd, (struct sockaddr *)&sname, sizeof(struct sockaddr_in)) == -1) {
    log("could not connect to SMTP host %s", hostname);
    close(sd);
    return -1;
  }
   
  if(!read(sd, smtp_buffer, 1024)) {
    close(sd);
    return -1;
  }
  
  if(strncmp(smtp_buffer, "220", 3)) {
    close(sd);
    return -1;
  }
   
  smtp_socket = sd;
  return sd;
}

int smtp_command(char *cmd)
{
  write(smtp_socket, cmd, strlen(cmd));
  write(smtp_socket, "\n", 1);   
  if(!read(smtp_socket, smtp_buffer, 1024))
    return 0;
   
  smtp_buffer[3] = 0;
  return atoi(smtp_buffer);
}

void smtp_write(char *s)
{
  write(smtp_socket, s, strlen(s));
  write(smtp_socket, "\n", 1);
}
