/* telnet.c - action for menu item type 'T'
 *
 * $Id: telnet.c,v 1.2 2001/11/13 10:23:52 ivarch Exp $
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif	/* HAVE_CONFIG_H */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "hook.h"
#include "terminal.h"
#include "viewmenu.h"


/* Telnet to the place denoted by "e".
 */
void menuview_telnet (menudata_t data, menuentry_t * e) {
  int n;

  if (!e->filename) return;

  bbs_hook (HOOK_SET_ACTION, 0,
            (e->status & MENU_STATUS_HIDETITLE) ? "" : e->title);
  bbs_hook (HOOK_SET_KEYPATH, data->buf, 0);

  n = strspn (e->filename, " 0123456789"	/* allow only these chars */
                           "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                           "abcdefghijklmnopqrstuvwxyz"
                           "_-.");
  if ((n >= 0) && (n < strlen (e->filename))) e->filename[n] = 0;

  sprintf (data->buf, "exec " TELNET_PATH " -E -- %s", e->filename);

  t_echo_on ();
  t_canon_on ();
  menuview_system (data->buf, 0);
  t_init (getenv ("TERM"));
  t_echo_off ();
  t_canon_off ();
}

/* EOF */
