/* editor.h - editor internal header file
 *
 *   ed_load        - load file into editor
 *   ed_save        - save from editor to file
 *   ed_loadopts    - read options from environment
 *   ed_saveopts    - save options to environment
 *   ed_redraw      - redraw entire screen
 *   ed_redraw_line - redraw single line
 *   ed_line_expand - convert a line's ^]'s to \035R]\035r glyphs
 *   ed_exit        - free all memory used
 *
 *   ed__op_left       - move cursor left 1 column
 *   ed__op_right      - move cursor right 1 column
 *   ed__op_up         - move cursor up 1 row
 *   ed__op_down       - move cursor down 1 row
 *   ed__op_home       - move cursor to start of line
 *   ed__op_end        - move cursor to end of line
 *   ed__op_prevword   - move cursor to start of previous word
 *   ed__op_nextword   - move cursor to end of current word
 *   ed__op_prevscreen - move cursor up 1 screen
 *   ed__op_nextscreen - move cursor down 1 screen
 *   ed__op_del_left   - delete 1 character to the left of the cursor
 *   ed__op_del_right  - delete 1 character to the right of the cursor
 *   ed__op_cutline    - kill the current line
 *   ed__op_paste      - yank (paste) killed lines
 *   ed__op_cutforw    - kill from the cursor to the end of the line
 *   ed__op_insert     - toggle insert/overwrite mode
 *   ed__op_indent     - toggle autoindent
 *   ed__op_togwrap    - toggle word wrapping
 *   ed__op_margin     - set right margin
 *   ed__op_top        - move to top of file
 *   ed__op_bottom     - move to bottom of file
 *   ed__op_goto       - ask user for line number and go to it
 *   ed__op_mark       - mark start/end of block
 *   ed__op_block      - use block
 *   ed__op_find       - ask user for text string, find it, and go to it
 *   ed__op_wrap       - word wrap current line
 *   ed__op_key        - insert an arbitrary character
 *   ed__op_datestamp  - insert a datestamp
 *
 * $Id: editor.h,v 1.1.1.1 1999/12/02 20:01:51 ivarch Exp $
 */

#ifndef _IV_EDITOR_H
#define _IV_EDITOR_H

#define ed__redraw rf_redraw

extern int  ed__redraw;			/* "redraw screen now" flag */
extern long ed__topline;		/* line number at top of display */
extern long ed__leftchar;		/* char at left of display */
extern long ed__curline;		/* current line number */
extern long ed__curchar;		/* current character index */
extern long ed__curcol;			/* current readable column */
extern int  ed__showhelp;		/* 1 if currently showing help */
extern int  ed__start_line;		/* start screen line of editor body */
extern long ed__lines;			/* number of lines in array */
extern char ** ed__array;		/* array of lines */

extern char * ed__killbuf;		/* kill/yank buffer */
extern int  ed__newkill;		/* "new kill buffer" flag */

extern int  ed_opt__insert;		/* insert mode */
extern int  ed_opt__indent;		/* autoindent mode */
extern int  ed_opt__wrap;		/* word wrapping */
extern int  ed_opt__margin;		/* right margin for wrapping */

int  ed_load (char *);
void ed_save (char *);
void ed_loadopts (void);
void ed_saveopts (void);
void ed_redraw (char *, char *);
void ed_redraw_line (long);
void ed_line_expand (char *, long);
void ed_exit (void);

void ed__op_left (void);
void ed__op_right (void);
void ed__op_up (void);
void ed__op_down (void);
void ed__op_home (void);
void ed__op_end (void);
void ed__op_prevword (void);
void ed__op_nextword (void);
void ed__op_prevscreen (void);
void ed__op_nextscreen (void);
void ed__op_del_left (void);
void ed__op_del_right (void);
void ed__op_cutline (void);
void ed__op_paste (void);
void ed__op_cutforw (void);
void ed__op_insert (void);
void ed__op_indent (void);
void ed__op_togwrap (void);
void ed__op_margin (void);
void ed__op_top (void);
void ed__op_bottom (void);
void ed__op_goto (void);
void ed__op_mark (void);
void ed__op_block (void);
void ed__op_find (void);
int  ed__op_wrap (int);
int  ed__op_key (int);
void ed__op_datestamp (void);

#endif	/* _IV_EDITOR_H */

/* EOF */
