/* alloc.c - creation and destruction of vt_info's
 *
 * $Id: alloc.c,v 1.1.1.1 1999/12/02 20:00:52 ivarch Exp $
 */

#include <stdlib.h>
#include "Internal.h"


/* Create a new VT100 structure with "rows" rows and "cols" columns in
 * memory and with "respond" as the function to call to make a string
 * response, initialise it, and return a pointer to it in the form of a
 * `vt_info' type.
 *
 * Note that "respond" can be a null pointer, in which case no responses
 * to terminal status enquiry codes and the like will be made.
 *
 * The return value is 0 on error.
 */
vt_info vt100_create (int cols, int rows, vt_outcall respond) {
  vt_info vt;

  if ((rows < 1) || (cols < 1)) return (0);

  vt = calloc (1, sizeof (*vt));		/* allocate structure */
  if (!vt) return (0);

  vt->text = malloc (rows * cols);		/* space for text */
  if (!vt->text) {
    free (vt);
    return (0);
  }

  vt->attrs = malloc (rows * cols * sizeof (unsigned short));
  if (!vt->attrs) {				/* space for attributes */
    free (vt->text);
    free (vt);
    return (0);
  }

  vt->output_function = respond; 

  vt->rows = rows;
  vt->cols = cols;
  vt100_reset (vt);	/* initialise terminal */

  return (vt);
}


/* Free all memory associated with "vt_info".
 */
void vt100_destroy (vt_info vt) {
  if (!vt) return;
  if (vt->attrs) { free (vt->attrs); vt->attrs = 0; }
  if (vt->text)  { free (vt->text);  vt->text = 0; }
  free (vt);
}

/* EOF */
