/* guest.c - determine whether user is external or guest
 *
 * $Id: guest.c,v 1.1.1.1 1999/12/02 20:00:12 ivarch Exp $
 */

#include <string.h>
#include "bbs.h"

extern int bbs__external;


/* Return 1 if the current user is an external user (i.e. does not have a
 * shell account). 
 */
int hook_is_external (void) {
  if (!strcmp (current_user, "guest")) return (1);
  return (bbs__external ? 1 : 0);
}


/* Return 1 if the current user is a guest user.
 */
int hook_is_guest (void) {
  if (!strcmp (current_user, "guest")) return (1);
  return (0);
}

/* EOF */
