/* remove.c - remove an account
 *
 * $Id: remove.c,v 1.2 2001/11/13 10:23:50 ivarch Exp $
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "terminal.h"
#include "examine.h"
#include "hook.h"
#include "bbs.h"

extern void uo_genlist (void);

extern uo_info_t * uo_list;
extern int uo_list_len;


/* Allow the user to remove the "user" account.
 */
void examine_remove (char * user) {
  char buf[1024];
  int c, n, i;
  char * a;

  if (examine_priv_check (user)) return;

  snprintf (buf, sizeof (buf) - 1,
            "Really delete account `\035B%s\035b'?"
            "  [\035BY\035b]/[\035BN\035b]",
            user);

  rf_redraw = 1;
  n = 0;

  do {
    c = t_getchar (n);				/* read a keypress */
    n = 1;

    t_checksize ();				/* check for terminal resize */

    bbs_hook (HOOK_KEY_PRESSED, 0, &c);

    if (rf_redraw) {
      t_goto (0, t_rows - 1);
      t_clrtoeol ();
      t_centre (buf);
      rf_redraw = 0;
    }

    if (c == 12) rf_redraw = 1;
    else if (c == 'y') c = 'Y';
    else if (c == 'n') c = 'N';

  } while ((c != 'Y') && (c != 'N'));

  rf_redraw = 1;

  if (c == 'N') return;

  uo_genlist ();			/* check account is not logged in */

  for (i = 0; i < uo_list_len; i ++) {
    if ((uo_list[i].username) && (!strcmp (uo_list[i].username, user))) {
      t_goto (0, t_rows - 1);
      t_clrtoeol ();
      t_centre ("\035R  *** Account still logged in! ***  \035r");
      sleep (2);
      return;
    }
  }

  strcpy (buf, cf_str ("udb"));
  a = strrchr (buf, '/');
  if (!a) return;
  sprintf (a, "/%s", user);
  remove (buf);					/* delete UDB */

  strcpy (buf, cf_str ("ldb"));
  a = strrchr (buf, '/');
  if (!a) return;
  sprintf (a, "/%s", user);
  remove (buf);					/* delete LDB */

  sprintf (buf, "%s/%s", cf_str ("u2u"), user);
  remove (buf);					/* delete U2U file */

  strcpy (buf, cf_str ("friends"));
  a = strrchr (buf, '/');
  if (!a) return;
  sprintf (a, "/%s", user);
  remove (buf);					/* delete friends list */

  t_goto (0, t_rows - 1);
  t_clrtoeol ();
  t_centre ("\035R  --- Account deleted ---  \035r");

  sleep (1);
}

/* EOF */
