/* display.c - main functions for examining a user
 *
 * $Id: display.c,v 1.1.1.1 1999/12/02 20:00:03 ivarch Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <pwd.h>
#include <sys/types.h>
#include "examine.h"
#include "terminal.h"
#include "mstring.h"
#include "hook.h"
#include "bbs.h"

extern void uo_genlist (void);
extern void hook_special_menu (int);
extern char * uo__timespan (long);

extern uo_info_t * uo_list;
extern int uo_list_len;

int examine__allow_send = 0;
int examine__allow_disconnect = 0;
int examine__allow_password = 0;
int examine__allow_alter = 0;


/* Display the "examine user" screen.
 */
void examine__redraw (char * user) {
  char buf[1024];
  char * a;
  int i, x;

  examine_udb_load (user);

  examine__allow_password = 1;

  if (!strcmp (current_user, "guest")) examine__allow_password = 0;

  uo_genlist ();

  x = -1;
  for (i = 0; i < uo_list_len; i ++) {
    if ((uo_list[i].username) && (!strcmp (uo_list[i].username, user))) x = i;
  }

  t_clear ();
  t_goto (0, 0);

  sprintf (buf, "Examining user `%s'", user);
  t_centre (buf);

  t_goto (0, 1);

  strcpy (buf, "\035CB");
  for (i = 0; (i < t_cols) && (i < (sizeof (buf) - 16)); i ++) buf[i+3] = '~';
  buf[i+3] = 0;
  strcat (buf, "\035CA");
  t_lineout (buf, 0);

  t_lineout ("", 0);

  a = examine_udb_env ("BBS_PRIVS");
  strcpy (buf, "  \035BPrivileges:\035b");
  if (strchr (a, 'D')) strcat (buf, " Disconnect");
  if (strchr (a, 'A')) strcat (buf, " Alter");
  t_lineout (buf, 0);

  a = examine_udb_env ("BBS_BANS");
  strcpy (buf, " \035BActive Bans:\035b");
  if (strchr (a, 'N')) strcat (buf, " Nameline");
  if (strchr (a, 'M')) strcat (buf, " Mail");
  if (strchr (a, '2')) strcat (buf, " Messages");
  if (strchr (a, 'E')) strcat (buf, " Edit/Add");
  if (strchr (a, 'B')) strcat (buf, " Login");
  t_lineout (buf, 0);

  sprintf (buf, "  \035BUser Level:\035b %s", examine_udb_env ("BBS_LEVEL"));
  t_lineout (buf, 0);
  sprintf (buf, "    \035BNameline:\035b \035CG\035B%s\035b\035CA",
           examine_udb_env ("MVIEW_NAMELINE"));
  t_lineout (buf, 0);

  t_lineout ("", 0);

  if (x >= 0) {
    sprintf (buf, "     \035BKeypath:\035b <\035B%s\035b>",
             uo_list[x].keypath);
    t_lineout (buf, 0);
    sprintf (buf, "      \035BAction:\035b %s", uo_list[x].action);
    t_lineout (buf, 0);
    sprintf (buf, "\035BConnect time:\035b %s",
             uo__timespan (time (0) - uo_list[x].login));
    t_lineout (buf, 0);
    sprintf (buf, "        \035BIdle:\035b %s",
             uo__timespan (time (0) - uo_list[x].idle));
    t_lineout (buf, 0);
    sprintf (buf, "    \035BLocation:\035b %s", uo_list[x].location);
    t_lineout (buf, 0);
  } else {
    t_lineout ("     \035BKeypath:\035b", 0);
    t_lineout ("      \035BAction:\035b", 0);
    t_lineout ("\035BConnect time:\035b", 0);
    t_lineout ("        \035BIdle:\035b", 0);
    t_lineout ("    \035BLocation:\035b Not logged in", 0);
  }

  t_lineout ("", 0);

  sprintf (buf, "      \035BLogins:\035b %s", examine_udb_env ("BBS_LOGINS"));
  t_lineout (buf, 0);
  sprintf (buf, " \035BLast Logout:\035b %s", examine_udb_env ("BBS_LOGOUT"));
  t_lineout (buf, 0);

  a = getenv ("BBS_PRIVS");
  if (!a) a = "";

  if ((!strchr (a, 'A')) && (strcmp (user, current_user)))
    examine__allow_password = 0;
  examine__allow_send = (strcmp (user, current_user)) ? 1 : 0;
  examine__allow_disconnect = (strchr (a, 'D') && (x >= 0)) ? 1 : 0;
  examine__allow_alter = (strchr (a, 'A')) ? 1 : 0;

  strcpy (buf, "[\035BQ\035b]:Exit");
  if (examine__allow_password) strcat (buf, "  [\035BP\035b]:Password");
  if (examine__allow_send) strcat (buf, "  [\035BS\035b]:Send");
  if (examine__allow_disconnect) strcat (buf, "  [\035BD\035b]:Disconnect");
  if (examine__allow_alter) strcat (buf, "  [\035BE\035b]:Edit"
                                    "  [\035BR\035b]"
                                    " [\035BC\035b]");

  t_goto ((t_cols - mstrlen (buf)) / 2, t_rows - 1);
  t_write (0);
  t_write (buf);
}


/* Examine "user", prompting for a user to examine if "user" is 0.
 */
void examine_user (char * user) {
  char action[1024];
  char keypath[64];
  char buf[1024];
  char tbuf[16];
  FILE * fptr;
  char * a;
  long n;
  int c;

  if (!user) {
    tbuf[0] = 0;
    do {
      n = t_input ("Examine user: ", tbuf, sizeof (tbuf) - 1);
    } while (n == 1);
    user = tbuf;
  }

  if ((!user) || (user[0] < 32)) return;
  if (strchr (user, '.') || strchr (user, '/')) return;

  strcpy (buf, cf_str ("udb"));
  a = strrchr (buf, '/');
  if (!a) return;
  sprintf (a, "/%s", user);

  rf_redraw = 1;

  fptr = fopen (buf, "r");			/* check user's UDB exists */
  if (!fptr) {
    t_goto (0, t_rows - 1);
    t_clrtoeol ();
    sprintf (buf, "\035R  *** Unknown user `%s' ***  \035r", user);
    t_centre (buf);
    sleep (2);
    return;
  }
  fclose (fptr);

  a = 0;
  action[0] = 0;
  bbs_hook (HOOK_GET_ACTION, &a, 0);
  if (a) strncpy (action, a, sizeof (action) - 1);
  a = 0;
  keypath[0] = 0;
  bbs_hook (HOOK_GET_KEYPATH, &a, 0);
  if (a) strncpy (keypath, a, sizeof (keypath) - 1);

  n = 0;

  do {

    c = t_getchar (n);				/* read a keypress */
    n = 1;

    t_checksize ();				/* check for terminal resize */

    bbs_hook (HOOK_KEY_PRESSED, 0, &c);

    if (rf_redraw) {
      bbs_hook (HOOK_SET_ACTION, "Examining ", user);
      bbs_hook (HOOK_SET_KEYPATH, "", 0);
      examine__redraw (user);
      rf_redraw = 0;
    }

    switch (c) {
      case 12 : rf_redraw = 1; break;
      case 'q':
      case 'Q':
      case 27 :
      case -27: hook_special_menu (c); break;
      case 10 :
      case 13 : n = 2; break;
      case 'p':
      case 'P': if (examine__allow_password) examine_password (user); break;
      case 's':
      case 'S': if (examine__allow_send) examine_send (user); break;
      case 'd':
      case 'D': if (examine__allow_disconnect) examine_disconnect(user); break;
      case 'e':
      case 'E': if (examine__allow_alter) examine_edit (user); break;
      case 'r':
      case 'R': if (examine__allow_alter) examine_remove (user); break;
      case 'c':
      case 'C': if (examine__allow_alter) examine_create (user); break;
      case -1 :
      case 0  : bbs_hook (HOOK_CHECK_MSGS, "yes", 0); break;
      default : break;
    }

    if (menuview_exitup) n = 2;

  } while (n != 2);

  bbs_hook (HOOK_SET_ACTION, 0, action);
  bbs_hook (HOOK_SET_KEYPATH, keypath, 0);

  rf_redraw = 1;
}

/* EOF */
