unit Types;

interface
const
{ ========================================================================== }
{ Size of maximum sized 16-bit arrays of Byte, Word or LongInts              }
{ ========================================================================== }
  CByteMaxHigh     = 65520;
  CWordMaxHigh     = ( CByteMaxHigh div 2 );
  CLongMaxHigh     = ( CWordMaxHigh div 2 );

{ ========================================================================== }
{ Maximum sized 16-bit arrays of Byte, Word or LongInts                      }
{ ========================================================================== }
type
  TByteMax         = array[0..( CByteMaxHigh - 1 )] of Byte;
  TWordMax         = array[0..( CWordMaxHigh - 1 )] of Word;
  TLongMax         = array[0..( CLongMaxHigh - 1 )] of LongInt;

{ ========================================================================== }
{ Maximum sized 16-bit arrays which can be accessed as Byte, Word or
  LongInts                                                                   }
{ ========================================================================== }
type
  TBufMax          = record
    case Byte of
      0: ( Bytes   : TByteMax );
      1: ( Words   : TWordMax );
      2: ( Longs   : TLongMax );
  end; { record TBufMax }

{ ========================================================================== }
{ Message text buffer, buffer used for all kind of messages in FOSS          }
{ ========================================================================== }
type
  PMsgBuffer       = ^TMsgBuffer;
  TMsgBuffer       = array[0..( CByteMaxHigh - 1 )] of Char;

{ ========================================================================== }
{ Types orginally defined in the DOS unit                                    }
{ ========================================================================== }
type
  PathStr          = string[79];
  DirStr           = string[67];

{ ========================================================================== }
{ String types, just to simplify further definitions                         }
{ ========================================================================== }
type
  Str4             = string[4];
  Str6             = string[6];
  Str10            = string[10];
  Str12            = string[12];
  Str16            = string[16];
  Str30            = string[30];
  Str40            = string[40];
  Str46            = string[46];
  Str60            = string[60];
  Str80            = string[80];
  Str200           = string[200];

{ ========================================================================== }
{ Date and time types                                                        }
{ ========================================================================== }
type
  TDate            = record
    case Word of
      0: ( Year    : Word;
           Month,
           Day     : Byte );
      1: ( RAW     : LongInt );
  end; { record TDate (4 Bytes) }

  TTime            = record
    case Byte of
      0: ( Hour,
           Minute  : Byte );
      1: ( RAW     : Word );
  end; { record TTime (2 Bytes) }

  TDateTime        = record
    Date           : TDate;
    Time           : TTime;
  end; { record TDateTime (6 Bytes) }

{ ========================================================================== }
{ Password type, used to store password and Expiry date                      }
{ ========================================================================== }
type
  TPassword        = record
    Pwd            : Str12;            { Password string }
    Date           : TDate;            { Expire date of password }
  end; { record TPassword }

{ ========================================================================== }
{ System text type, used to store the FOSSTEXT.* files in memory             }
{ ========================================================================== }
type
  TTxt             = record
    Pnt            : array[0..799] of record
      Pos          : Word;             { Position of text in Text array }
      Len          : Char;             { Length of text in Text array }
    end; { record Pnt }
    Text           : array[0..49151] of Byte;
  end; { record TTxt }

{ ========================================================================== }
{ System meny types, used to store meny setup from FOSSTEXT.* files in
  memory                                                                     }
{ ========================================================================== }
type
  TMenuKey         = record
    Func           : string[25];       { Command string }
    MinKey         : Byte;             { Minimum number of matched
                                         characters from start of string }
  end; { record TMenuKey }

  PMenus           = ^TMenus;
  TMenus           = array[0..99] of TMenuKey;

{ ========================================================================== }
{ Access type, used to store different sets of Access in areas               }
{ ========================================================================== }
type
  TAccess          = ( acReadMsg,      { Allowed to read messages }
                       acWriteMsg,     { Allowed to write messages }
                       acUploadFile,   { Allowed to upload files }
                       acDownloadFile, { Allowed to download files }
                       acOpenDoor,     { Allowed to open doors }
                       acAreaOp,       { Allowed to use AreaOp functions in
                                         SysOp menu }
                       acSysOp,        { Allowed to use SysOp function in
                                         SysOp menu }
                       acRFU );        { RFU }
  SAccess          = set of TAccess;

{ ========================================================================== }
{ Graph type, used to store what kind of additional control characters to
  send in addition to the standard AscII set                                 }
{ ========================================================================== }
type
  TGraph           = ( grIBM,          { Allow high 128+ AscII characters }
                       grANSI );       { Allow ANSI control codes }
  SGraph           = set of TGraph;

{ ========================================================================== }
{ ClearScr type, used to store when the user wants the screen blanked        }
{ ========================================================================== }
type
  TClearScr        = ( clMenu,         { Clear screen before menus }
                       clMsg,          { Clear screen before messages }
                       clBullet );     { Cleer screen before bulletins }
  SClearScr        = set of TClearScr;

{ ========================================================================== }
{ ANSIUse type, used to store when the user wants ANSI graphics used         }
{ ========================================================================== }
type
  TANSIUse         = ( anMenu,         { Use ANSI graphics in menus }
                       anMsg,          { Use ANSI graphics in messages }
                       anBullet );     { Use ANSI graphics in bulletins }
  SANSIUse         = set of TANSIUse;

{ ========================================================================== }
{ ARC type, used to store preferred archive format                           }
{ ========================================================================== }
type
  TArc             = ( arNone,         { Archiving not preferred }
                       arZIP,          { Use ZIP archiving }
                       arARC,          { Use ARC archiving }
                       arLZH,          { Use LZH/LHA archiving }
                       arARJ );        { Use ARJ archiving }

{ ========================================================================== }
{ AreaMark type, used to store message marking in memory                     }
{ ========================================================================== }
type
  TAreaMark        = array[1..32767] of Word;

{ ========================================================================== }
{ Connect type, used to store connection information                         }
{ ========================================================================== }
type
  TConnect         = record
    ModemSpeed     : LongInt;          { Modem speed in bits per second }
    PCSpeed        : LongInt;          { PC<->modem speed in bits per second }
    ErrorCorrect   : ( eNone,          { No error correction on link }
                       eMNP,           { Link uses MNP error correction }
                       eMNP10,         { Link uses MNP level 10 error
                                         correction }
                       eLAPM,          { Link uses LAPM error correction }
                       eTEL,           { Telnet link }
                       eVMP );         { VModem link }
    Compression    : ( cNone,          { No hardward compression on link }
                       cMNP5,          { Link uses MNP level 5 compression }
                       cV42b );        { Link uses V42bis compression }
  end; { record TConnect (10 Bytes) }

{ ========================================================================== }
{ FrogNetAddr type, used to control network message flow                     }
{ ========================================================================== }
type
  TFrogNetAddr     = record
    case LongInt of
      0: ( Country : Word;
           Region,
           Node    : Byte );
      1: ( Buf     : LongInt );
  end; { record TFrogNetAddr (4 Bytes) }

{ ========================================================================== }
{ SysCfg type, used to store main configuration information
  API: fioReadMainCfg
       fioWriteMainCfg                                                       }
{ ========================================================================== }
type
  TSysCfg          = record
    Version        : string[19];       {   1-  20  Version of FOSS which last
                                                   wrote to this file }
    BoardName      : Str30;            {  21-  51  Name of Bulletin Board }
    MaxLoggedChats : Word;             {  52-  53  Max number of SysOp chat
                                                   log files to keep }
    VersionID      : Word;             {  54-  55  VersionID of FOSS which
                                                   last wrote to this file }
    SystemNodeID   : TFrogNetAddr;     {  56-  59  FrogNet address of this
                                                   Bulletin Board }
    Registered     : Boolean;          {  60-  60  Is this Board registered? }

    NU2            : array[61..71] of Byte;

    SysOpName      : Str30;            {  72- 102  Name of main SysOp, user
                                                   which this name have
                                                   extra access }
    SysOpPassword  : TPassword;        { 103- 119  Main SysOp's password }
    FileDescrName  : Str12;            { 120- 132  Last used DESCRIPT.ION file
                                                   name }
    FrogNetReqUser : Str30;            { 133- 163  Name of FrogNet request
                                                   user of this Board }
    Location       : Str30;            { 164- 194  Current geographic location
                                                   of this Board }
    GiveBackMS     : Byte;             { 195- 195  Number of ms to return to
                                                   OS on each sleep }
    DelayB4Kill    : LongInt;          { 196- 199  Delay in seconds before
                                                   attempting to kill a ext.
                                                   program after DCD is lost }
    NewUserTime    : Word;             { 200- 201  Default time limit given to
                                                   new users }
    NewLevel       : Byte;             { 202- 202  Default access level given
                                                   to new users }
    NewFlags       : set of ( NewOk2Reg );
                                       { 203- 203  NewOk2Reg: Area new users
                                                   allowed to register on this
                                                   Board? }
    ScratchPad     : PathStr;          { 204- 283  Scratch-pad file name }
    UNZIPPath      : PathStr;          { 284- 363  UNZIP path }
    ZIPPath        : PathStr;          { 364- 443  ZIP path }
    MainPhone      : Str16;            { 444- 460  Main phone number of this
                                                   Board }
    PipeServer     : Str30;            { 461- 491  Pipe server path }

    NU3            : array[492..603] of Byte;

    RAMDisk        : DirStr;           { 604- 671  RAM-disk path }
    Inactivity     : Word;             { 672- 673  Max inactivity time in
                                                   seconds before disconnect }

    NU4            : array[674..1013] of Byte;

    PkArcPath      : PathStr;          {1014-1093  PkArc path }
    PkXArcPath     : PathStr;          {1094-1173  PkXArc path }
    LHAPath        : PathStr;          {1174-1253  LHA path }
    ARJPath        : PathStr;          {1254-1333  ARJ path }

    NU6            : array[1334..1413] of Byte;

    CDROM          : array[1..10] of Char;
                                       {1414-1423  CD-ROM driver letters }

    RFU            : array[1424..4092] of Byte;

    RecPos         : LongInt;          {4093-4096  FilePos of this record }
  end; { type TSYSCfg (4 KBytes) }

{ ========================================================================== }
{ NodeCfg type, used to store node specific configuration information
  API: fioReadNodeCfg
       fioWriteNodeCfg
       fioDelNodeCfg
       fioGetNodeCnt                                                         }
{ ========================================================================== }
type
  TNodeFlag        = ( nfShowWhenOffline,
                       nfUseInactivity );
  SNodeFlag        = set of TNodeFlag;

  TNodeCfg         = record
    ComPort        : Integer;          {   1-   2  Active com port for node:
                                                   1-4 = COM1-4
                                                   5   = use specified dev. }

    NU1            : array[3..8] of Byte;

    LockedSpeed    : Boolean;          {   9-   9  Locked modem speed }
    ConnectType    : ( DirectCOM,
                       DirectLOCAL,
                       WaitForRING,
                       WaitForDCD );   {  10-  10  Node type }

    InitStr        : Str60;            {  11-  71  Modem init string }
    AnswerStr      : Str30;            {  72- 102  Modem answer string }
    OnHookStr      : Str30;            { 103- 133  Modem onhook string }
    OffHookStr     : Str30;            { 134- 164  Modem offhook string }

    SysOpAvail     : Boolean;          { 165- 165  SysOp available? }

    NU2            : array[166..166] of Byte;

    RingB4Answer   : Byte;             { 167- 167  Number of rings before
                                                   answering a call }
    IODevice       : Str16;            { 168- 184  IO-Device to use if ComPort
                                                   is 5 }
    Flags1         : SNodeFlag;        { 185- 185  Node flags }
    InitSpeed      : LongInt;          { 186- 189  Modem init speed }
    MinSpeed       : LongInt;          { 190- 193  Min accepted CONNECT
                                                   speed }
    MaxSpeed       : LongInt;          { 194- 197  Max accepted CONNECT
                                                   speed }
    MinLevel       : Word;             { 198- 199  Min accepted access level }
    MaxLevel       : Word;             { 200- 201  Max accepted access level }
    DialStr        : Str30;            { 202- 232  Modem dial string }

    RFU            : array[233..252] of Byte;
    RecPos         : LongInt;          { 253- 256  FilePos of this record }
  end; { type TNodeCfg (256 Bytes) }

{ ========================================================================== }
{ AreaDirCfg type, used to store directory configuration for each area
  API: fioReadDirCfg
       fioFindDirNo
       fioFindDirName
       fioWriteDirCfg                                                        }
{ ========================================================================== }
type
  TAreaDirCfg      = record
    DirNo          : Word;             {   1-   2  Internal number of
                                                   directory }
    DirName        : Str30;            {   3-  33  Name of directory }
    DiskDir        : DirStr;           {  34- 101  Assigned disk directory }
    Flags          : set of ( ShowUploader,
                              UploadDir,
                              NoDownload );
                                       { 102- 102  Directory flags }
    FirstRec       : LongInt;          { 103- 106  Internal pointer to .DIR }
    NextRec        : LongInt;          { 107- 110  Internal pointer to .DIR }

    RFU            : array[111..124] of Byte;

    RecPos         : LongInt;          { 125- 128  FilePos of this record }
  end; { type TAreaDirCfg (128 Bytes) }

{ ========================================================================== }
{ AreaCfg type, used to store area configuration information for each area
  API: fioReadAreaCfg
       fioFindAreaCode
       fioFindAreaName
       fioWriteAreaCfg
       fioReadNetAddr
       fioWriteNetAddr
       fioReadUsrAreaReg
       fioWriteUsrAreaReg
       fioReadMsgHeader
       fioFindMsgNo
       fioFindNextMsg
       fioFindPrevMsg
       fioReadMsgBuf
       fioReadMsgStatus
       fioWriteMsgHeader
       fioUpdateMsgHeader
       fioWriteMsg
       fioReadDirCfg
       fioFindDirNo
       fioFindDirName
       fioFindDirName
       fioReadFileRec
       fioWriteFileRec
       usrHaveAccess
       usrMsgAddress                                                         }
{ ========================================================================== }
type
  TAreaFlag        = ( afNewUserMember,
                       afAllowResign,
                       afPublicMessages,
                       afPrivateMessages,
                       afFrogNetMember,
                       afNetworkMember,
                       afExternalArea,
                       NU7 );
  SAreaFlag        = set of TAreaFlag;

  TAreaCfg         = record
    AreaName       : Str30;            {   1-  31  Name of area }
    AreaCode       : Str4;             {  32-  36  Code used for AREAxxxx
                                                   files }
    FileCode       : Str4;             {  37-  41  AreaCode of file menu }
    DoorCode       : Str4;             {  42-  46  AreaCode of door menu }
    BullCode       : Str4;             {  47-  51  AreaCode of bulletin menu }

    NU1            : array[52..53] of Byte;

    ReadOldMsg     : Word;             {  54-  55  Max number of old messages
                                                   to read }
    AreaFlags      : SAreaFlag;        {  56-  56  Area flags }
    HostNodeID     : TFrogNetAddr;     {  57-  60  Address of FrogNet host for
                                                   this area }

    NU2            : array[61..62] of Byte;

    AccessLevel    : array[0..15] of SAccess;
                                       {  63-  78  Access levels for this
                                                   area }

    RFU            : array[79..124] of Byte;

    RecPos         : LongInt;          { 125- 128  FilePos of this record }
  end; { record TAreaCfg (128 Bytes) }

{ ========================================================================== }
{ AreaLinkStat type, used to store status of a network link in an area       }
{ ========================================================================== }
type
  TAreaLinkFlag     = ( lfActiveLink,
                        lfAcceptRequest,
                        lfAcceptResign );
  SAreaLinkFlag    = set of TAreaLinkFlag;

  TAreaLinkStat    = record
    LinkFlags      : SAreaLinkFlag;    {   1-   1  Link flags }
    LastMsgXfer    : LongInt;          {   2-   5  Last message transfered }
    TempMsgXfer    : LongInt;          {   6-   9  Temp message pointer }

    RFU            : array[10..28] of Byte;

    RecPos         : LongInt;          {  29-  32  FilePos of this record }
  end; { record TAreaLinkStat (32 Bytes)  }

{ ========================================================================== }
{ EventCfg type, used to store all timed event of the system                 }
{ ========================================================================== }
type
  TEventCfg        = record
    EventName      : Str30;            {   1-  31  Name of event }
    EventType      : ( evtCommand,
                       evtPollHUB );   {  32-  32  Type of event }
    EventFreq      : ( evtCustom,
                       evtDaily,
                       evtWeekly,
                       evtMonthly,
                       evtYearly );    {  33-  33  Frequency of event }
    LastRun        : TDateTime;        {  34-  39  Last time event was started }
    NextRun        : TDateTime;        {  40-  45  Next time event should run }
    CustomFreq     : TDateTime;        {  46-  51  Custom frequency of event }

    EventCommand   : Str80;            {  52- 132  Command to execute }
    EventNode      : Word;             { 133- 134  Run event from node }

    RFU            : array[135..1020] of Byte;

    RecPos         : Longint;          {1021-1024  FilePos of this record }
  end; { record TEventCfg (1 KBytes) }

{ ========================================================================== }
{ User type, used to store most of the user information                      }
{ ========================================================================== }
type
  TUser            = record
    UserName       : Str30;            {   1-  31  Local user name }
    UserAddress    : Str30;            {  32-  62  Address }
    UserPostCode   : Str30;            {  63-  93  Post code }
    City           : Str12;            {  94- 106  City }
    Password       : TPassword;        { 107- 123  Password and latest date
                                                   to change it }
    HomePhone      : Str16;            { 124- 140  Home phone number }
    WorkPhone      : Str16;            { 141- 157  Word phone number }

    FirstOn        : TDateTime;        { 158- 163  Time user was created }
    TimesOn        : LongInt;          { 164- 167  Number logons }
    MsgWritten     : Word;             { 168- 169  Messages written }
    MsgRead        : Word;             { 170- 171  Messages read }
    LastOn         : TDateTime;        { 172- 177  Last seen online }

    NU1            : array[178..178] of Byte;

    Flags          : set of ( Available,
                              Xpert,
                              Killed,
                              Background,
                              FreeForUse );
                                       { 179- 179  User flags }

    Downloads      : Word;             { 180- 181  Files downloaded }
    DownloadKB     : Word;             { 182- 183  KBytes downloaded }
    Uploads        : Word;             { 184- 185  Files uploaded }
    UploadKB       : Word;             { 186- 187  KBytes uploaded }
    Protocol       : Char;             { 188- 188  Transfer protocol }

    Graphics       : SGraph;           { 189- 189  Graphics mode }
    AccessLevel    : Byte;             { 190- 190  Expert mode }

    TimeAllowed    : Word;             { 191- 192  Minutes allowed each day }
    TimeLeft       : Word;             { 193- 194  Minutes left today }
    TimeTotal      : LongInt;          { 195- 198  Total minutes online }

    ANSIClear      : SClearScr;        { 199- 199  Clear screen before
                                                   displaying ... }
    ScreenLines    : Byte;             { 200- 200  Screen lines }
    Language       : Char;             { 201- 201  Language key }
    ANSIUse        : SANSIUse;         { 202- 202  Use ANSI codes when
                                                   displaying ... }

    NU2            : array[203..208] of Byte;

    Packing        : TArc;             { 209- 209  Selected archiver }
    Toggles				 : set of ( DisplayStatus,
                              ShowAddress,
                              NoAutoRead );
                                       { 210- 210  User toggles }

    RFU            : array[211..252] of Byte;

    RecPos         : LongInt;          { 253- 256  FilePos of this record }
  end; { record TUser (256 Bytes) }

{ ========================================================================== }
{ AreaUserStat type, used to store each users setup for each area            }
{ ========================================================================== }
type
  TAreaUserFlag    = ( ufMember,
                       ufInvited );
{  Area_Flags }
  SAreaUserFlag    = set of TAreaUserFlag;

{  AREA_Reg }
  TAreaUserStat    = record
    LastRead       : LongInt;          {   1-   4  Last message read in area }
    Access         : SAccess;          {   5-   5  Additional access for this
                                                   area access should primary
                                                   be taken from
                                                   TAreaCfg.AccessLevel }
    LastScan       : TDateTime;				 {   6-  11  Last new files scan in area
                                                   this one is saved only for
                                                   file areas }
    Flags          : SAreaUserFlag;    {  12-  12  Users area flags }
    InvitedBy      : LongInt;          {  13-  16  Invited by user (RecPos) }

    RFU            : array[17..32] of Byte;
  end; { record TAreaUserStat (32 Bytes) }

{ ========================================================================== }
{ MessageHeader type, used to store header information for each message      }
{ ========================================================================== }
type
{  MsgSecT }
  TMessageFlag     = ( mfActive,
                       mfPublic,
                       mfPrivate,
                       mfRead,
                       mfFile,
                       mfReq );
{  MsgSec }
  SMessageFlag     = set of TMessageFlag;

{  NetRegT }
  TNetworkFlag     = ( nfToLocal,
                       nfFromLocal,
                       nfEchoMessage );
{  NetReg }
  SNetworkFlag     = set of TNetworkFlag;

(*
  TMsgUser         = record
    case UserType : ( Local, FrogNet, OtherNet ) of
      Local:
        ( ID       : LongInt );        { Pos in user database }
      FrogNet:
        ( User     : Str30;            { User name }
          Addr     : TFrogNetAddr;         { User address }
          Node     : TFrogNetAddr );       { Received from node }
      OtherNet:
        ( UserAddr : Str80;
          ExtraPos : LongInt );        { 86/  86 - }
  end; { TMsgUser }
*)

{  AREA_Mhd}
  TMessageHeader   = record
    FromUser       : LongInt;          {   1-   4  Pointer to user record }
    ToUser         : LongInt;          {   5-   8  Pointer to user record }
    NetUsers       : SNetworkFlag;     {   9-   9  Network Flags }
    Security       : SMessageFlag;     {  10-  10  Message Flags }

    Subject        : Str60;            {  11-  71  Subject of message }
    MsgPointer     : LongInt;          {  72-  75  Pointer to message text }
    MsgNumber      : LongInt;          {  76-  79  Number of message }
    ReplyTo        : LongInt;          {  80-  83  Message is a reply to
                                                   message number ... }
    FirstReply     : LongInt;          {  84-  87  First reply to this
                                                   message is ... }

    Lines          : Word;             {  88-  89  Approx number of lines in
                                                   message }
    DateEntered    : TDateTime;        {  90-  95  Time/Date of message
                                                   entry }

    ONumber        : LongInt;          {  96-  99  Origins message number }
    RNumber        : LongInt;          { 100- 103  Origins ReplyTo number }
    NextInThread   : LongInt;          { 104- 107  Next message in thread,
                                                   this number is the next
                                                   reply to (ReplyTo) msg }
    ReceivedFrom   : TFrogNetAddr;     { 108- 111  Message is received from }

    NU1            : array[112..118] of Byte;

    MsgBufLen      : LongInt;          { 119- 122  Total number of message
                                                   bytes }

    NetFromPos     : LongInt;          { 123- 126  Pointer to network address }
    NetFromLen     : Word;             { 127- 128  Length of address string,
                                                   this is currently not used}
    NetToPos       : LongInt;          { 129- 132  Pointer to network address }
    NetToLen       : Word;             { 133- 134  Length of address string,
                                                   this is currently not used}

    RFU            : array[135..252] of Byte;

    RecPos         : LongInt;          { 253- 256  FilePos of this record }
  end; { record TMessageHeader (256 Bytes) }

{ ========================================================================== }
{ DirFile type, used to store each file installed and available for download }
{ ========================================================================== }
type
  PDirFile         = ^TDirFile;
  TDirFile         = record
    FileName       : string[16];       {   1-  17  Name of file shown to
                                                   user }
    Description    : string[120];      {  18- 138  File description }

    RFU2           : array[139..139] of Byte;

    FTXPointer     : LongInt;          { 140- 143  Pointer to extended
                                                   description, not used yet }
    Date           : TDateTime;        { 144- 149  Date of install/upload }
    Size           : LongInt;          { 150- 153  Size of file in bytes }
    DirNo          : LongInt;          { 154- 157  DirNo belonging to }
    UploadedBy     : LongInt;          { 158- 161  Uploaded by user ... }
    Downloads      : LongInt;          { 162- 165  Number of downloads }
    CDROM          : Byte;             { 166- 166  CD-ROM# or 0 for normal }
    CDPath         : string[60];       { 167- 227  CD-ROM path }
    FileFlags      : set of ( KilledFile );
                                       { 228- 228  File record flags }

    RBU            : array[229..252] of Byte;

    RecPos         : LongInt;          { 253- 256  FilePos of this record }
  end; { type TDirFile (256 Bytes) }

{ ========================================================================== }
{ NodeStat type, used to store various status information for each node      }
{ ========================================================================== }
type
  TActivityFlag    = ( afWrittenMessage,
                       afReadMessage,
                       afUploadedFile,
                       afDownloadedFile,
                       afOpenedDoor,
                       afFrogNetExchange,
                       afYelledForSysop );
{  ActivityS }
  SActivityFlag    = set of TActivityFlag;

  TNodeStat        = record
    NodeNo         : Byte;             {   1-   1  Node number }
    Activity       : Word;             {   2-   3  Last known node activity
                                                     0 = Down
                                                     1 = Event
                                                     2 = Wait
                                                     3 = Recycling
                                                     4 = Picking up call
                                                     5 = Login
                                                     6 = FrogNet xfer
                                                    10 = Active
                                                    11 = Entering a msg
                                                    12 = Downloading
                                                    13 = Uploading
                                                    14 = In a door
                                                    15 = SysOpChat
                                                    16 = Bidirectional xfer
                                                   500..
                                                   755 = Chatting with node }
    ComPort        : Byte;             {   4-   4  Comport
                                                     0 = Local
                                                     1..
                                                     4 = Comport 1..4
                                                     5 = IODevice }
    ShowAllways    : Boolean;          {   5-   5  Allways show in status }
    IOHandle       : Word;             {   6-   7  Current IO-handle for
                                                   node }
    BaudRate       : LongInt;          {   8-  11  Init bps-rate }
    DoneWhat       : SActivityFlag;    {  12-  12  Registered activity types }

    NU1            : array[13..13] of Byte;

    LockedSpeed    : Boolean;          {  14-  14  Locked modem speed? }

    UserName       : Str30;            {  15-  45  Last/active users name }
    UserAddress    : Str30;            {  46-  76  Address }
    UserPostCode   : Str30;            {  77- 107  PoseCode }
    City           : Str12;            { 108- 120  City }

    Downloads      : Word;             { 121- 122  Files downloaded }
    DownloadKB     : Word;             { 123- 124  KB downloaded }
    Uploads        : Word;             { 125- 126  Files uploaded }
    UploadKB       : Word;             { 127- 128  KB uploaded }
    Protocol       : Char;             { 129- 129  File transfer protocol }

    TimeAllowed    : Word;             { 130- 131  Time allowed each day }
    TimeLeft       : Word;             { 132- 133  Time left today }
    Connected      : LongInt;          { 134- 137  Time of login }
    Graphics       : SGraph;           { 138- 138  Terminal graphics setup }

    ConnectSpeed   : TConnect;         { 139- 148  Connection speed }
    Avail          : Boolean;          { 149- 149  Available for node comms }
    UserPos        : LongInt;          { 150- 153  FilePos of last/current
                                                   user }

    RFU            : array[154..256] of Byte;

  end; { record TNodeStat (256 Bytes) }

{ ========================================================================== }
{ NodeMsg type, used to send message between nodes                           }
{ ========================================================================== }
type
  TNodeMsg         = record
    FromNode       : Byte;             {   1-   1  Sent from node }
    FromUser       : LongInt;          {   4-   5  Sent by user }
    ToNode         : Byte;             {   6-   6  Sent to node }
    ToUser         : LongInt;          {   7-  10  Sent to user }
    Flags          : set of ( nmRead,
                              nmInBuffer );
                                       {  11-  11  Message flags }

    RFU            : array[12..47] of Byte;

    SystemMsg      : Byte;             {  48-  48  System message }
    Message        : string[79];       {  49- 128  Message text }
  end; { record TNodeMsg (128 Bytes) }

{ ========================================================================== }
{ Protocol type, used to store file transfer protocol configuration          }
{ ========================================================================== }
type
  TProtocolType    = ( ptBatch,
                       ptBiDirectional,
                       ptAuto );
  SProtocolType    = set of TProtocolType;

  TProtocol        = record
    Letter         : Char;             {   1-   1  Letter used to select
                                                   protocol }
    Name           : Str30;            {   2-  32  Name of protocol }
    ProgramPath    : Str60;            {  33-  93  Program path }
    UploadCommand  : Str200;           {  94- 294  Receive command }
    DownloadCommand: Str200;           { 295- 495  Send command }

    OkErrorLevel   : ShortInt;         { 496- 496  Error level returned if
                                                   OK }
    ProtType       : SProtocolType;    { 497- 497  Protocol capabilities }
    AutoReceive    : Str16;            { 498- 514  Auto receive string }

    RFU            : array[515..1020] of Byte;

    RecPos         : LongInt;          {1021-1024  FilePos of this record }
  end; { record TProtocol (1 KBytes) }

{----------------------------------------------------------------------------
  Fileformat for the MAIN\B&BLINKS.CFG file - Network link config
 ----------------------------------------------------------------------------}
Type
  Net_Config_Record = Record
    LinkType       : ( FrogNetHost,    { 1/  1 * Remote system is ...        }
                       FrogNetNode,
                       OtherNetLink );
    NodeAddr       : Str30;            {31/ 32 * Remote system ID            }
    LastBullDate   : Word;             { 2/ 34 * Last bulletin exchange date }
    LinkSysOp      : Str30;            {31/ 65 * Remote SysOp name           }
    LinkPassword   : Str12;            {13/ 78 * Password to access link     }
    LinkPhone      : Str16;            {17/ 95 * Link phone number           }
    LinkSystem     : Str30;            {31/126 * Remote system name          }
    NodeID         : TFrogNetAddr;         { 4/130 * }

    RFU            : Array[131..254] Of Byte;

    LinkLocalPos   : Word;             { 2/256 * Temp pointer to this record,
                                                 only internal use           }
  End; { Record Net_Config_Record }

IMPLEMENTATION

End. { Unit Types }