/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose:                                                              *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: language.cpp 118 2009-08-07 04:34:35Z frank $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/language.cpp $
// $LastChangedDate: 2009-08-07 00:34:35 -0400 (Fri, 07 Aug 2009) $
// $LastChangedRevision: 118 $
// $LastChangedBy: frank $

# include <stdio.h>
# include <ctype.h>

# include <cstring> // gcc 4.3
# include <cstdlib> // gcc 4.3

# include <string>
# include <fstream>

# include "language.h"
# include "struct.h"

using namespace std;

void language::lang_remove() {

    std::string path = DATAPATH;
    path += "language.dat";
    remove(path.c_str());
}

int language::lang_write(LangRec *lang, int idx) {

    std::string path = DATAPATH;
    path += "language.dat";
    int x = 0;

	FILE *stream = fopen(path.c_str(),"rb+");
   	if(stream == NULL) {
	   	stream = fopen(path.c_str(), "wb");
    	if(stream == NULL) {
    		perror("Error unable to write language.dat, check permissions!");
        	return x;
    	}
	}
    if(fseek(stream,(int)idx*sizeof(LangRec),SEEK_SET)==0)
	    x = fwrite(lang,sizeof(LangRec),1,stream);
    fclose(stream);
    return x;
}

int language::lang_read(LangRec *lang, int idx) {


    std::string path = DATAPATH;
    path += "language.dat";

    int x = 0;

    FILE *stream = fopen(path.c_str(),"rb+");
    if(stream == NULL) {
    	stream=fopen(path.c_str(), "wb");
    	if(stream == NULL) {
       		perror("Error unable to read language.dat, check permissions!");
      		return x;
    	}
	}
    fclose(stream);

	stream = fopen(path.c_str(), "rb");
    if(fseek(stream,(int)idx*sizeof(LangRec),SEEK_SET)==0)
    	x = fread(lang,sizeof(LangRec),1,stream);
    fclose(stream);
    return x;
}


int language::lang_count() {

	int i = 0;
    LangRec lang;

	while(lang_read(&lang,i)) { ++i; }
    if(i < 1)	i = -1;
    else i--;
    return(i);
}


void language::lang_get(char *lang, int idx) {

	int id1 = 0;
	id1 = lang_count();
    LangRec l1;
    --idx;

    if (idx > id1) {
		return;
	}
    lang_read(&l1,idx);
    strcpy(lang,l1.Lang);
}


void language::lang_check(std::string lang) {

    std::string temp  = lang;
    std::string temp2 = "";
    // Disgards any Config lines starting with the # or ; Character
    if (temp[0] == '#' || temp[0] == ';') return;
    char Num[5]={0};
    int LangNum;
    int cnt = 0;

    // Parse first 3 Digits for Language string Number
    for (int i = 0; i !=4; i++) {
        if (isdigit(temp[cnt])) { Num[cnt] = temp[cnt]; ++cnt; }
    }

    LangNum = atoi(Num);
    --LangNum;
    LangRec l1;
    if (temp.size() > 4)  {
        temp2 = temp.substr( 4, temp.size());
        strcpy(l1.Lang,temp2.c_str());
        lang_write(&l1,LangNum);
    }
}

void language::lang_compile() {

    std::string name = INIPATH;
    name += "language.txt";

    ifstream inStream;
    inStream.open( name.c_str() );
    if (!inStream.is_open()) {
        perror("Error unable to open language.dat, check permissions!");
        return;
    }
    lang_remove();

    std::string cfgdata;
    for (;;) {
        getline(inStream,cfgdata);
        lang_check(cfgdata);
        if(inStream.eof()) break;
    }
    inStream.close();
    return;
}




