/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose:                                                              *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: enthral.cpp 163 2010-10-15 22:10:34Z mercyful $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/enthral.cpp $
// $LastChangedDate: 2010-10-15 18:10:34 -0400 (Fri, 15 Oct 2010) $
// $LastChangedRevision: 163 $
// $LastChangedBy: mercyful $


# ifdef HAVE_CONFIG_H
# include <config.h>
# endif

# include <stdio.h>
# include <unistd.h>
# include <signal.h>
# include <errno.h>

# include <cstring>
# include <cstdlib>
# include <termios.h>

# include "configbbs.h"
# include "language.h"
# include "main_system.h"
//# include "menus.h"
# include "conio.h"
# include "users.h"
# include "node.h"
# include "dtfunc.h"
# include "console.h"


using namespace std;

char BBSPATH[255]    = {0};
char DATAPATH[255]   = {0};
char MENUPATH[255]   = {0};
char ANSIPATH[255]   = {0};
char MESGPATH[255]   = {0};
char FILEPATH[255]   = {0};
char LOCKPATH[255]   = {0};
char INIPATH[255]    = {0};
char DAPATH[255]     = {0};
char NODEPATH[255]   = {0};
char NODEDIR[10]     = {0};
char USRSIG[255]     = {0};
char SCRIPTS[255]    = {0};
char ENTHRALTMP[255] = {0};

char UsersIP[1024]   = {0};
char SYSOP_NAME[80]  = {0};

int  NODE_NUM        = 0;
int  UserLoggedIn    = FALSE;

// Ansi Terminal Detected.
int isANSI = FALSE;

static UserRec user;

struct termios old_termios;

void killazombie (int iSig) {

    // User Hung up or Disconnected, Shutdown properly and End Program..
    // Add System Shutdown here.

    // Node Node is Setup, Add Process to Read User Data From Node Filename
    // Log User, Then Remove File to make sure node is clean.
    node    _node;
    users   _usr;
    SESSION _io;
    
    _node.node_remove_dropfiles(NODE_NUM);
    _node.node_remove(NODE_NUM);

    if (strcmp(user.handle,"") != 0 && UserLoggedIn == TRUE) {
        user.dtlaston = GetCurrentDTSec();
        _usr.users_write(&user,user.idx);
    }

    _io.errlog((char *)"killazombie System Shutdown (User Hung Up on the System!).");

    exit(iSig);
}



void exit_system(void) {

    SESSION _io;
    node    _node;
    users   _usr;

    if (strcmp(user.handle,"") != 0 && UserLoggedIn == TRUE) {
        user.dtlaston = GetCurrentDTSec();
        _usr.users_write(&user,user.idx); // Save Stats
    }

    UserLoggedIn = FALSE;

    // Clear Node Data.
    _node.node_remove_dropfiles(NODE_NUM);
    _node.node_remove(NODE_NUM);

    _io.errlog((char *)"Atexit System Shutdown Cleanly.");

    exit(0);

}


int main(int argc, char *argv[]) {

     // Setup Signal Checking if Telnetd was killed.
    // Then kill this program, Add Save Current Users Settings...
    // NOTE This only killed if program kicked off directly from telnetd,
    // if you run a bash script, that becomes a zombie process becasue it creates a second pty!
    (void) signal (SIGHUP, killazombie);
    (void) signal (SIGTERM, killazombie);
    (void) signal (SIGINT, killazombie);

    SESSION _io;
    
   	

	// Obtain a copy of the termios structure for stdout.
	if( tcgetattr( STDOUT_FILENO, &old_termios ) )
		return( 1 );

    // Setup Global Path in Structs.h
	char sCmd[255]={0};
    char parg[255]={0};

    strcpy(parg,argv[0]);

    int num = 0;
    int i   = 0;

    memset(&BBSPATH,0,sizeof(BBSPATH));
    // Get FULL PATH TO EXE, and Chop off Filename for PATH
    for (int i = 0; ;i++) {
        if (parg[i] == '\0') break;
        if (parg[i] == '/') num = i;
    }
    if (num != 0) {
        for (int i = 0; i < num+1; i++) {
           BBSPATH[i] = parg[i];
        }
    }

    // If no path, get environment varliable.
    if (strlen(BBSPATH) > 1 && strcmp(BBSPATH,"\\") != 0) { }
    else strcpy(BBSPATH,getenv("ENTHRAL"));

    int iRet = chdir(BBSPATH);

    sprintf(DATAPATH,"%sdata/",BBSPATH);  // Data Path
    sprintf(MENUPATH,"%smenu/",BBSPATH);  // Menu Files
    sprintf(ANSIPATH,"%sansi/",BBSPATH);  // Ansi Files
    sprintf(MESGPATH,"%smsgs/",BBSPATH);  // Message Files
    sprintf(INIPATH,"%sini/",BBSPATH);    // INI Files
    sprintf(DAPATH,"%sdareas/",BBSPATH);  // Data Area Data
    sprintf(FILEPATH,"%sfiles/",BBSPATH);  // Files Area Data
    sprintf(USRSIG,"%susersig/",BBSPATH);  // Files Area Data

	// Direcotries that don't always have data, have checks for creating them!
	sprintf(NODEPATH,"%snode/",BBSPATH);   // Nodes
	sprintf(LOCKPATH,"%slock/",BBSPATH);  // r/w Lock Files
    sprintf(SCRIPTS,"%sscripts/",BBSPATH);  // scripts path.  ie python
	sprintf(ENTHRALTMP,"/tmp/enthral");   // Tmp, Sockets, IPC

    // Do Error Checking if CONFIG.CFG File exists, if not creates it
    if(configdataexists() == false)
        createconfig();

    // Open and Read Config file
    parseconfig();


    // Get Users incomming IP Address
    // Unless being kicked off locally.
    if (argc >= 3) {
        sprintf(UsersIP,"%s",argv[2]);
    }
    else {
        sprintf(UsersIP,"Localhost");
    }

    // Figure out Node Number
    node _node;
    for (i = 1; ;i++) {
        if (_node.node_exists(i) == FALSE) {
            NODE_NUM = i;
            break;
        }
    }

    _io.errlog((char *)" *** BBS Loaded! Root Path: %s",BBSPATH);

	// Go through and create basic directory structure if doesn't exist.
    _io.errlog((char *)"User Logged in IP: %s - Node: %i ",UsersIP,NODE_NUM);

	// Create Data Directory
	sprintf(sCmd,"%s",DATAPATH);
	if (mkdir(sCmd, 0770) == -1 && errno != EEXIST) {
		fprintf(stderr, "cannot create data directory %s (%d)\r\n",
			sCmd, errno);
        // Go through and create basic directory structure if doesn't exist.
        _io.errlog((char *)"Err: Unable to create data folder.");
	}

	// Create Node Directory
	sprintf(sCmd,"%s",MESGPATH);
	if (mkdir(sCmd, 0770) == -1 && errno != EEXIST) {
		fprintf(stderr, "cannot create msgs directory %s (%d)\r\n",
			sCmd, errno);
        _io.errlog((char *)"Err: Unable to create msgs folder.");
	}

	// Create Node Directory
	sprintf(sCmd,"%s",FILEPATH);
	if (mkdir(sCmd, 0770) == -1 && errno != EEXIST) {
		fprintf(stderr, "cannot create files directory %s (%d)\r\n",
			sCmd, errno);
        _io.errlog((char *)"Err: Unable to create files folder.");
	}

	// Create Node Directory
	sprintf(sCmd,"%s",NODEPATH);
	if (mkdir(sCmd, 0770) == -1 && errno != EEXIST) {
		fprintf(stderr, "cannot create node directory %s (%d)\r\n",
			sCmd, errno);
        _io.errlog((char *)"Err: Unable to create node folder.");
	}

	// Create Node Subdirectory NodeNum Directory!
    sprintf(NODEDIR,"node%i",NODE_NUM);
	sprintf(sCmd,"%s%s",NODEPATH,NODEDIR);
    if (mkdir(sCmd, 0770) == -1 && errno != EEXIST) {
        fprintf(stderr, "cannot create NODE_NUM directory %s (%d)\r\n",
            sCmd, errno);
        _io.errlog((char *)"Err: Unable to create NODE_NUM folder.");
    }

	// Create Lockfile directory.
	sprintf(sCmd,"%slock",BBSPATH);
	if (mkdir(sCmd, 0770) == -1 && errno != EEXIST) {
		fprintf(stderr, "cannot create lock file directory %s (%d)\r\n",
			sCmd, errno);
        _io.errlog((char *)"Err: Unable to create lock folder.");
	}

    // Create UserSig Directory
    sprintf(sCmd,"%susersig",BBSPATH);
    if (mkdir(sCmd, 0770) == -1 && errno != EEXIST) {
        fprintf(stderr, "cannot create lock file directory %s (%d)\r\n",
            sCmd, errno);
        _io.errlog((char *)"Err: Unable to create usersig folder.");
    }

     // Create UserSig Directory
    sprintf(sCmd,"%sscripts",BBSPATH);
    if (mkdir(sCmd, 0770) == -1 && errno != EEXIST) {
        fprintf(stderr, "cannot create lock file directory %s (%d)\r\n",
            sCmd, errno);
        _io.errlog((char *)"Err: Unable to create scripts folder.");
    }

	// Create TMP Directory!
	if (mkdir(ENTHRALTMP, 0770) == -1 && errno != EEXIST) {
		fprintf(stderr, "cannot create /tmp/enthral directory %s (%d)\r\n",
			sCmd, errno);
        _io.errlog((char *)"Err: Unable to create /tmp/enthral folder.");
	}


    // Compile Language File on Startup {Data dir has to be present first!}
    language *lang = new language;
    if (!lang) {
        _io.errlog((char *)"Err: Unable to Allocate Memory for Language.txt Compile.");
        fprintf(stderr, "Err: Unable to Allocate Memory for Language.txt Compile.\r\n");
    }

    isANSI = TRUE;
    lang->lang_compile();
    delete lang;

    // Set Node File with Blank Data Untill User Has Logged in.
    memset(&user,0,sizeof(UserRec));
    // Setup Default Node User as logging in...
    sprintf(user.handle,"User Logging In");
    _node.node_write(&user,NODE_NUM);


    // Test Setting the Terminal back to Original.
    tcflush( STDOUT_FILENO, TCIFLUSH);
	if ( tcsetattr( STDOUT_FILENO, TCSADRAIN,&old_termios ) )
		return( 2 );

    // New internode/process communication WIP!
    init_nodes();    
		
    // Procedures to run at shutdown.
    atexit(exit_system);  // Removed Node Files, and Saves Use On Proper Shutdown


/*-------------------------------------------------------------------------

    Main System Setup,

 -------------------------------------------------------------------------*/

    main_system ms;
    ms.start(&user); // Main Loop.
    _io.errlog((char *)"System Shutdown Cleanly.");

    exit( 0 );
}
