/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose:                                                              *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: dtfunc.cpp 152 2010-04-10 10:53:59Z mercyful $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/dtfunc.cpp $
// $LastChangedDate: 2010-04-10 06:53:59 -0400 (Sat, 10 Apr 2010) $
// $LastChangedRevision: 152 $
// $LastChangedBy: mercyful $

# define _XOPEN_SOURCE
# include <time.h>
# include <stdio.h>
# include <stdlib.h>
# include <string>

# include <cstring> //gcc 4.3
# include <cstdlib> //gcc 4.3

# include "dtfunc.h"
# include "conio.h"

using namespace std;

// Example to format from Seconds to Date/Time -MF
/*
int main () {

	struct tm *tm_ptr,*tm_ptr2,  ts;
	time_t  the_time, tm2,tm3;
	char buf[256];
	char *result;
	double buf2 = 0;
	double buf3 = 0;

	time (&the_time);
	tm_ptr = localtime(&the_time);

	// Convert Current Time to Seconds
	strftime(buf, 256, "%A %d %B  %Y %I:%M:%S %p", tm_ptr);
	printf("\nFormatted: %s\n",buf);
	printf("\nRAW: %ld",the_time);
	sprintf(buf,"%ld",the_time);
	buf2 = atol(buf);

	// Convert Seconds to Current Time
	tm2 = (time_t)buf2;
	tm_ptr = localtime(&tm2);
	strftime(buf, 256, "%A %d %B %Y %I:%M:%S %p", tm_ptr);
	printf("\nFormatted: %s\n", buf);

	buf2 = 0;
	memset(&buf,0,sizeof(buf));
	memset(&ts,0,sizeof(tm));

	ts.tm_mday = 4;
	ts.tm_mon = 4 - 1;
	ts.tm_year = 1977 - 1900;
	ts.tm_isdst = -1;

	time_t tmp_t;
	tmp_t = mktime(&ts);

	memset(&buf,0,sizeof(buf));
	printf("\n MKTIME DATE RAW: %d",tmp_t);

	long i = Date2Sec("04/04/1977");
	printf("\n TEST DATE RAW: %ld ",i);

	sprintf(buf,"%s",Sec2Date(i));
	printf("\nDATE Formatted: %s\n", buf);
	return 0;

}*/


char *getLastCallDays(unsigned long lastcall) {

    static char buff[120];
    memset (&buff,0,sizeof(buff));

    unsigned long today = GetCurrentDTSec();
    unsigned long sec = today - lastcall;

     char date[25]={0},
         date2[25]={0};

    unsigned long date3 = 0;
    unsigned long date4 = 0;

    strcpy(date,Sec2Date(today));
    strcpy(date2,Sec2Date(lastcall));

    int i = 0, t = 0, mm, dd,  yy;
    char dt[5]={0};
    dt[i++] = date[t++]; dt[i++] = date[t++];
    mm = atoi(dt);
    ++t; i = 0;
    dt[i++] = date[t++]; dt[i++] = date[t++];
    dd = atoi(dt);
    ++t; i = 0;
    dt[i++] = date[t++]; dt[i++] = date[t++];
    dt[i++] = date[t++]; dt[i++] = date[t++];
    yy = atoi(dt);

    i = 0;
    t = 0;
    int mm2, dd2, yy2;
    char dt2[5]={0};
    dt2[i++] = date2[t++]; dt2[i++] = date2[t++];
    mm2 = atoi(dt2);
    ++t; i = 0;
    dt2[i++] = date2[t++]; dt2[i++] = date2[t++];
    dd2 = atoi(dt2);
    ++t; i = 0;
    dt2[i++] = date2[t++]; dt2[i++] = date2[t++];
    dt2[i++] = date2[t++]; dt2[i++] = date2[t++];
    yy2 = atoi(dt2);

    //int tday, tmonth, tyear;

    if (strcmp(date,date2) == 0) {
        sprintf(buff,"earlier today");
        return buff;
    }
    else if (mm == mm2 && yy == yy2 && dd == dd2+1) {
        sprintf(buff,"yesterday");
        return buff;
    }

    date3 = Date2Sec(date);
    date4 = Date2Sec(date2);
    sec = date3 - date4;
    sprintf(buff,"%ld days ago",sec / 86400);

    return buff;
}

/*

int calc_age(UserRec *tu)
{
    int retval=0,mon,day,year;
    int count1,count2;
    time_t t;
    struct tm *tm;

    (void)time(&t);
    tm=localtime(&t);
    tm->tm_year+=1900;

    mon=atoi(tu->birthday_mo);
    day=atoi(tu->birthday_dy);
    year=atoi(tu->birthday_yr);
    if(mon==1 && day==1 && year==1970)
        return retval;
    count1=(year*12)+mon;
    count2=(tm->tm_year*12)+tm->tm_mon;
    retval=(count2-count1)/12;

    return(retval);
}
*/



char *getAge(long sec) {

    time_t  tmp1;
    tm     *t2;

    char date[25]={0},
         date2[25]={0};

    static
    char buff[4]={0};

    // Convert Current Time to Birthdat Format.
    tmp1 = GetCurrentDTSec();
    t2 = localtime(&tmp1);
    strftime(date, 256, "%m/%d/%Y", t2);

    SESSION s;

    // Setup Birthday.
    strcpy(date2,Sec2Date(sec));

    // Current Date/Time
    int i = 0, t = 0, mm, dd,  yy;
    char dt[5]={0};
    dt[i++] = date[t++]; dt[i++] = date[t++];
    mm = atoi(dt);
    ++t; i = 0;
    dt[i++] = date[t++]; dt[i++] = date[t++];
    dd = atoi(dt);
    ++t; i = 0;
    dt[i++] = date[t++]; dt[i++] = date[t++];
    dt[i++] = date[t++]; dt[i++] = date[t++];
    yy = atoi(dt);

    // BirthDate and Time
    i = 0;
    t = 0;
    int mm2, dd2, yy2;
    char dt2[5]={0};
    dt2[i++] = date2[t++]; dt2[i++] = date2[t++];
    mm2 = atoi(dt2);
    ++t; i = 0;
    dt2[i++] = date2[t++]; dt2[i++] = date2[t++];
    dd2 = atoi(dt2);
    ++t; i = 0;
    dt2[i++] = date2[t++]; dt2[i++] = date2[t++];
    dt2[i++] = date2[t++]; dt2[i++] = date2[t++];
    yy2 = atoi(dt2);

/*
    int tyear;
    tyear = yy - yy2;

    if (mm < mm2)
        --tyear;
    else
    if (mm = mm2 && dd < dd2)
        --tyear;
*/

    int count1,count2,retval=0;
    if(mm==1 && dd==1 && yy==1970)
        return (char *)"";
    count1=(yy*12)+mm;
    count2=(yy2*12)+mm2;
    retval=(count1-count2)/12;


    sprintf(buff,"%i",retval);
    return (buff);
}


int isBday(long sec) {

    time_t  tmp1;
    tm     *t2;

    char date[25]={0},
         date2[25]={0};

    //static char buff[4]={0};

    // Convert Current Time to Birthdat Format.
    tmp1 = GetCurrentDTSec();
    t2 = localtime(&tmp1);
    strftime(date, 256, "%m/%d/%Y", t2);

    SESSION s;

    // Setup Birthday.
    strcpy(date2,Sec2Date(sec));

    // Current Date/Time
    int i = 0, t = 0, mm, dd,  yy;
    char dt[5]={0};
    dt[i++] = date[t++]; dt[i++] = date[t++];
    mm = atoi(dt);
    ++t; i = 0;
    dt[i++] = date[t++]; dt[i++] = date[t++];
    dd = atoi(dt);
    ++t; i = 0;
    dt[i++] = date[t++]; dt[i++] = date[t++];
    dt[i++] = date[t++]; dt[i++] = date[t++];
    yy = atoi(dt);

    // BirthDate and Time
    i = 0;
    t = 0;
    int mm2, dd2, yy2;
    char dt2[5]={0};
    dt2[i++] = date2[t++]; dt2[i++] = date2[t++];
    mm2 = atoi(dt2);
    ++t; i = 0;
    dt2[i++] = date2[t++]; dt2[i++] = date2[t++];
    dd2 = atoi(dt2);
    ++t; i = 0;
    dt2[i++] = date2[t++]; dt2[i++] = date2[t++];
    dt2[i++] = date2[t++]; dt2[i++] = date2[t++];
    yy2 = atoi(dt2);

    if (dd == dd2 && mm == mm2)
        return TRUE;

    return FALSE;

}


int VerifyBday(char *date) {

    int i = 0, t = 0, mm, dd,  yy;
    char dt[5]={0};
    dt[i++] = date[t++]; dt[i++] = date[t++];
    mm = atoi(dt);
    ++t; i = 0;
    dt[i++] = date[t++]; dt[i++] = date[t++];
    dd = atoi(dt);
    ++t; i = 0;
    dt[i++] = date[t++]; dt[i++] = date[t++];
    dt[i++] = date[t++]; dt[i++] = date[t++];
    yy = atoi(dt);

    // Get Current Year.
    char curdate[25]={0};
    time_t  tmp1;
    tm     *t2;

    tmp1 = GetCurrentDTSec();
    t2 = localtime(&tmp1);
    strftime(curdate, 256, "%Y", t2);

    // Just some basic verification!
    if (mm < 1 || mm > 12) return FALSE;
    if (dd < 1 || dd > 31) return FALSE;
    // Older then 13 to Access!
  if ((yy < 1) || (yy > atoi(curdate)-13) || (yy < atoi(curdate)-100)) return FALSE;
    return TRUE;
}

char *Sec2DateTM(long time, int format) {

    struct tm *tm_ptr;
    time_t  the_time;

    static char buff[120];
    memset (&buff,0,sizeof(buff));
    // Convert Seconds to Current Time
    the_time = (time_t)time;
    tm_ptr = localtime(&the_time);

    // Setup Formatting For Every DAT & Seperate Time Format (WIP)
    switch (format) {
        case 1:  // Default Message Date / Time Format
            strftime(buff, 256, "%A %B %d, %Y %I:%M:%S %p", tm_ptr);
            break;

        case 2: // Date / Time
            strftime(buff, 256, "%m/%d/%Y %I:%M%p", tm_ptr);
            break;

        case 3: // Date
            strftime(buff, 256, "%m/%d/%Y", tm_ptr);
            break;

        case 4: // Time
            strftime(buff, 256, "%I:%M %p", tm_ptr);
            break;

        case 5: // Date / Time
            strftime(buff, 256, "%A %m/%d/%Y %I:%M %p", tm_ptr);
            break;

        default : break;
    }
    return (buff);

}

time_t StampToDosTime(struct _stamp *st) {

    time_t tt;
    struct tm tms;
    tms.tm_sec   = st->time.ss << 1;
    tms.tm_min   = st->time.mm;
    tms.tm_hour  = st->time.hh;
    tms.tm_mday  = st->date.da;
    tms.tm_mon   = st->date.mo - 1;
    tms.tm_year  = st->date.yr + 80;
    tms.tm_isdst = -1;
    tt = mktime(&tms);
    return tt;
}

struct _stamp *DosTimeToStamp(time_t tt) {

    struct tm *tmsp;
    static struct _stamp st;
    tmsp = localtime(&tt);
    st.time.ss = tmsp->tm_sec >> 1;
    st.time.mm = tmsp->tm_min;
    st.time.hh = tmsp->tm_hour;
    st.date.da = tmsp->tm_mday;
    st.date.mo = tmsp->tm_mon + 1;
    st.date.yr = tmsp->tm_year - 80;
    return (&st);
}

// Get Current Date/Time and return seconds
long GetCurrentDTSec() {

	time_t  the_time;
	time (&the_time);
	return the_time;
}

//Seconds to Date Format Birthday
char *Sec2Date(long sec) {

	tm *ts2;
	time_t tmp2_t;
	static char buf[256];
	memset(&buf,0,sizeof(buf));

	tmp2_t = sec;
	ts2 = localtime(&tmp2_t);
	strftime(buf, 256, "%m/%d/%Y", ts2);
	return (buf);
}

long Date2Sec(char *date) {  // "04/04/1977"

    // Pre-Parsing and Converting from 1/1/2007 to 01/01/2007
    std::string dtCompare;
    dtCompare = date;

    int id1 = 0;
    id1 = dtCompare.find("/",0);
    // Insert Preceeding 0 to update to 01/ from 1/
    if (id1 < 2) {
        dtCompare.insert(0,"0");
    }

    id1 = dtCompare.find("/",3);
    // Insert Preceeding 0 to update to 01/01 from 01/1
    if (id1 < 5) {
        dtCompare.insert(3,"0");
    }

    int i = 0, t = 0, mm, dd,  yy;
    tm ts;

    memset(&ts,0,sizeof(tm));
    char dt[5]={0};
    dt[i++] = dtCompare[t++]; dt[i++] = dtCompare[t++];
    mm = atoi(dt);
    ++t; i = 0;
    dt[i++] = dtCompare[t++]; dt[i++] = dtCompare[t++];
    dd = atoi(dt);
    ++t; i = 0;
    dt[i++] = dtCompare[t++]; dt[i++] = dtCompare[t++];
    dt[i++] = dtCompare[t++]; dt[i++] = dtCompare[t++];
    yy = atoi(dt);

    ts.tm_mday  = dd;
    ts.tm_mon   = mm - 1;
    ts.tm_year  = yy - 1900;
    ts.tm_isdst = -1;

    time_t tmp_t;
    tmp_t = mktime(&ts);
    return (tmp_t);
}
