/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose:                                                              *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: configbbs.cpp 118 2009-08-07 04:34:35Z frank $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/config.cpp $
// $LastChangedDate: 2009-08-07 00:34:35 -0400 (Fri, 07 Aug 2009) $
// $LastChangedRevision: 118 $
// $LastChangedBy: frank $

# include <stdio.h>
# include <string>
# include <fstream>

# include <cstring> // gcc 4.3
# include <cstdlib> // gcc 4.3

# include "struct.h"
# include "config.h"

using namespace std;


bool configdataexists() {

    std::string path = INIPATH;
    path += "config.ini";

    FILE *stream;
    stream = fopen(path.c_str(),"rb+");
    if(stream == NULL) {
        perror(" ini ***cannot open config.ini, check if it exists and permissions!");
        return false;
    }
    fclose(stream);
    return true;
}


void createconfig() {

    std::string name = INIPATH;
    name += "config.ini";

    ofstream outStream2;
    outStream2.open( name.c_str(), ofstream::out | ofstream::trunc );
    if (!outStream2.is_open()) {
        perror(" ini ***cannot create config.ini, check permissions!");
        exit(1);
        return;
    }

    outStream2 << "#" << endl;
    outStream2 << "# .----------------------------------------------------------------." << endl;
    outStream2 << "# | " << BBSVERSION << "        |" << endl;
    outStream2 << "# | Main System Configuration File                                 |" << endl;
    outStream2 << "# `----------------------------------------------------------------'" << endl;
    outStream2 << "#" << endl;
    outStream2 << "#" << endl;
    outStream2 << "Set SYSOP_NAME ""<ENTER>"" " << endl;

    outStream2.close();
    return;
}


void checkcfg(std::string cfgdata) {

    std::string temp = cfgdata;
    std::string::size_type id1 = 0;

    std::string::size_type st1 = -1;
    std::string::size_type st2 = -1;
    std::string::size_type  ct = -1;

    // Disgards any Config lines with the # Character
    if (temp[0] == '#') return;

    // Sets if LOGGING is on / off
    id1 = -1;
    id1 = temp.find("Set SYSOP_NAME", 0);
    if (id1 != -1) {
        std::string temp1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        sprintf(SYSOP_NAME,"%s",(char *)temp1.c_str());
    }

}


void parseconfig() {

    std::string name = INIPATH;
    name += "config.ini";

    ifstream inStream;
    inStream.open( name.c_str() );
    if (!inStream.is_open()) {
        perror(" ini ***cannot parse config.ini, check if it exists and permissions!");
        exit(1);
    }

    std::string cfgdata;
    for (;;) {
        getline(inStream,cfgdata);
        checkcfg(cfgdata);
        if(inStream.eof()) break;
    }
    inStream.close();
    return;
}

