#! /usr/bin/perl -w

# Enthral SVN: $Id: install.pl 169 2010-10-19 15:48:02Z frank $
# Source: $HeadURL: http://svn.enthralbbs.com/trunk/install.pl $
# $LastChangedDate: 2010-10-19 11:48:02 -0400 (Tue, 19 Oct 2010) $
# $LastChangedRevision: 169 $
# $LastChangedBy: frank $

# Enthral BBS Auto Install script

# Standard variables and system requests

my $smapiurl = "http://voxel.dl.sourceforge.net/sourceforge/husky/smapi-2.2.4-src.tar.gz";
my $os = $^O;
my $origsysop = "Mercyful Fate";
my $systemuser = "bbs";
my $commentfield = "Enthral";
my $homedir = "/home/$systemuser";
use File::Copy;
use File::Find;
use Cwd;
my $trunk = getcwd;
$|=1;

# Make sure user is root
my $name = `whoami`;
chomp ( $name );
if ($name ne "root") { die "\nYou must be root in order to install Enthral.\n\n"; }

# Capture User Input
system("clear");
print "Welcome to the Enthral BBS install script.\r\n";
print " - Build 429 Alpha Install process (10/18/2010).\r\n\r\n";

print "This script will ask you for your Sysop Name and BBS Name and\r\n";
print "then download and compile smpai (which is required for JAM Message Areas),\r\n";
print "add the sysop name to the config.ini file, and compile snoop and stats.\r\n";
print "The script will also create a new user called \"enthral\" which will be the\r\n";
print "primary user that Enthral runs off\r\n\r\n";

print "WARNING. We am not responsible for anything that might occur with your\r\n";
print "system.  While we have done our best to ensure that the script functions as\r\n";
print "promised, things may go wrong from time to time.  Please ensure you make\r\n";
print "a complete backup of your system before attempting to use this.\r\n\r\n";

print "Are you ready to continue? (y/n): ";

if (<STDIN> =~ /^[yY]/)
{
print "\r\nSysop Name/Handle (Has to match exactly what you plan on using) \r\n[Sysop Name]: ";
my $sysop = <>;
chomp ( $sysop );

# Replace Sysop Name in config.ini
chdir "ini/";
my $dir = getcwd;
print "\r\n[*] Replacing $origsysop with $sysop in config.ini\r\n\r\n";
sleep 2;
find(\&wanted,$dir);

print "\r\n[*] Finished\r\n";
sleep 2;

sub wanted{
#       (-f $_ && -w $_ && -T $_) or return;
        /\.ini$/ or return;
        my $file=$_;
        my $found = 0; # If the string was found in $file
        print "Searching $file.\n";
        open(INFILE,$file) or (print "Could not open $file for reading: $!\r\n" and return);
        my @text=<INFILE>;
        close(INFILE);
        for(my $x=0;$x<=$#text;$x++){
                $text[$x]=~s/$origsysop/$sysop/g and $found = 1 and
                        print " -Found in $file (line ".($x+1).")\r\n";
        }
        if($found){
                open(OUTFILE,">$file") or (print "Unable to open $file for writing: $!\r\n\t$file must be changed manually\r\n." and return);
                foreach(@text){
                        print OUTFILE $_;
                }
                close(OUTFILE);
        }
}

sleep 2;

# add user enthral
chdir $trunk;

$count = `awk -F":" '{print \$3}' /etc/passwd|sort -n|tail -1`;
chomp($count);
$usernumber = ++$count;

open(A, ">>/etc/passwd");
print A "$systemuser:x:$usernumber:$usernumber:$systemuser,,,:$homedir:/bin/bash\n";
close(A);

open(A, ">>/etc/group");
print A "$systemuser:x:$usernumber:\n";
close(A);

open(A, ">>/etc/shadow");
print A "$systemuser:*LK*:::::::\n";
close(A);

mkdir($homedir, 0755);

print "\r\n[*] Password for user $systemuser\r\n\r\n";
system("/usr/bin/passwd $systemuser");
print "\r\n";

# Download and unpack smapi 2.2
chdir $trunk;
print "\r\n[*] Downloading smapi-2.2.4-src.tar.gz\r\n";
sleep 1;

mkdir("/tmp/enthral", 0777) || print $!;
mkdir("smapi_src", 0777) || print $!;
chdir "smapi_src/";
system "wget $smapiurl";

system "tar xzvf smapi-2.2.4-src.tar.gz";
unlink <*.tar.gz*>;
print "\r\n[*] smapi-2.2.4-src.tar.gz successfully downloaded and unpacked.\r\n";

# Configuring smapi
chdir "smapi/";

sleep 1;

print "\r\n[*] Compiling Husky SMAPI Lib for JAM Message Support.\r\n";

# makefile.lnx compiles for both linux and bsd.
copy("makefile.lnx","Makefile") or die "Copy failed: $!";

# Add special compiler flags to SMAPI for compile on gcc 4.3+ and 64 Bit Systems.
my $foundIt = 0; # If the string was found in $file
print "\r\n[*] Searching Makefile.\n";
open(INFILE,"Makefile") or (print "Could not open Makefile for reading\r\n" and return);

my @text=<INFILE>;
close(INFILE);

for(my $x=0;$x<=$#text;$x++){
    $text[$x]=~s/-DNOSEMAPHORES/-DNOSEMAPHORES -U_FORTIFY_SOURCE -m32 /g and $foundIt = 1 and
    print " -Added -U_FORTIFY_SOURCE -m32 for gcc 4.3+ and 64 bit compability (line ".($x+1).")\n";
}

if($foundIt){
    open(OUTFILE,">Makefile") or (print "must be changed manually\r\n." and return);
    print OUTFILE @text;
    close(OUTFILE);
}

sleep 2;

system "make";

print "\r\n[*] libsmapilnx.a compiled successfully.  Moving to compile Enthral.\r\n";
copy("libsmapilnx.a","../../src/libsmapilnx.a") or die "Copy failed: $!";
chdir "../../";

sleep 1;

print "\r\n[*] Building Base Enthral System...\r\n";

# Cleaning any left over files
print "\r\n[*] Cleaning Root directory\r\n";
sleep 1;
system "rm -f m4/{lt,lib}*.m4";

# run AutoMake
print "\r\n[*] Running AutoMake (Autogen.sh)\r\n";
sleep 1;
system "./autogen.sh";

# run Configure
print "\r\n[*] Running configure\r\n";
sleep 1;
system "make distclean";
system "./configure";

# run make clean
print "\r\n[*] Running make distclean\r\n";
sleep 1;
system "make clean";

# run make
print "\r\n[*] Running make\r\n";
sleep 1;
system "make";

sleep 2;

# compile stats
chdir "src/stats";
print "\r\n[*] Compiling Stats Program. You will need to update main.txt for your paths!\n";
system "g++ -o stats main.cpp process2.cpp userdat.cpp";
sleep 1;

# compile snoop
chdir "../snoop";
print "\r\n[*] Compiling Snoop, basic console program.\r\n";
system "g++ -o snoop snoop.cpp";
sleep 1;

# compile ddtelnetd
chdir "../ddtelnetd";
print "\r\n[*] Compiling ddtelnetd, telnet server.\r\n";
system("g++ -o ddtelnetd ddtelnetd.c -lutil");

# move system to new homedir
print "\r\n[*] Moving everything to $homedir\r\n";
mkdir("$homedir/source");
system("mv $trunk/* $homedir/source/");

mkdir("$homedir/enthral", 0777);
mkdir("$homedir/enthral/stats", 0777);
system("mv $homedir/source/src/ddtelnetd/ddtelnetd $homedir/source/src/ansi $homedir/source/src/dareas $homedir/source/src/data $homedir/source/src/enthral $homedir/source/src/files $homedir/source/src/ini $homedir/source/src/lock $homedir/source/src/menu $homedir/source/src/msgs $homedir/source/src/node $homedir/source/src/scripts $homedir/source/src/usersig $homedir/source/src/snoop/snoop $homedir/enthral/");
copy("$homedir/source/src/stats/stats","$homedir/enthral/stats/");
copy("$homedir/source/src/stats/toppc.ans","$homedir/enthral/stats/");
copy("$homedir/source/src/stats/topud.ans","$homedir/enthral/stats/");

# set permissions and ownership
system "chown -R $systemuser:$systemuser $homedir";
system "chmod -R 0777 $homedir";

# check which services manager is running
print "\r\n[*] Checking if your system uses inetd or xinetd.\r\n\r\n";
if (-e "/etc/inetd.conf") { 
    print "[*] inetd found. Adding ddtelnetd to inetd.conf\r\n";
	open(A, ">>/etc/inetd.conf");
	print A "# enthral telnet server setup\n";
	print A "telnet          stream  tcp     nowait  root     $homedir/enthral/ddtelnetd -u $systemuser -l $homedir/enthral/enthral\n";
	close(A);
}

if (-d "/etc/xinetd.d") { 
    print "[*] xinetd found. Adding ddtelnetd to xinetd.d\r\n";
	
	open INPUTFILE, "<", "$homedir/source/src/ddtelnetd/telnet" or die $!;
	open OUTPUTFILE, ">", "/etc/xinetd.d/telnet" or die $!;
	
	while (<INPUTFILE>) {
		$_ =~ s/\/path\/to\//$homedir\/enthral\//g;
	  	print OUTPUTFILE $_; 
	}	
}


print "\r\n[*] Finished Install.\r\n"; 
print "\r\n[*] Source Files loacated in the $homedir/source/ folder\r\n";
print "\r\n[*] Main system located in the $homedir/enthral/ folder\r\n\r\n";

print "Remember this is still a rough Alpha and a Work in Progress.\r\n";
sleep 2;

print "\r\nCongradulations, Enthral compile complete.\r\n";
print "Please restart your system so that the services can take effect\r\n";

print "For support, drop by irc.bbs-scene.org #enthral and #bbs.\r\n\r\n";

}
