/* PRELIMINARY - Don't forget to do the configuring below!! */
/* Suggestions not wanted.... NEEDED!!!! */

/***[ABOUT]******************************************************************
 *  ShowScreen is a !Simple! REXX utility for AdeptXBBS.                    * 
 *  ShowScreen.Cmd shows a display file which is determined by its args,    *
 *  and then shows it to the user, but asks the user to press [ENTER], thus *
 *  giving him/her a chance to read the file before Adept redraws the menu. *
 ****************************************************************************
 * Author: Matt Davis - 1:3666/107.0@Fidonet  **  Distributed with CML-Data *
 ****************************************************************************/
ARG line DisplayFile SpecialParm
/*-----------CONFIGURATION------------*/

  AdeptDriveLtr = E                  /*Drive LETTER only!                   */
  AdeptBasePath = Adept              /*Base dir NAME only! No Slashes!      */
  AdeptTextPath = Text               /*Text dir NAME only! No Slashes!      */
  DisplayFile   =                    /*Optional!  See below for information */
  SpecialParm   =                    /*Optional!  See below for information */

/*  * [CONFIGURATION] *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
 * Please note that you will have to modify the first three fields for      *
 * ShowScreen to work correctly!                                            *
 *                                                                          *
 * The LAST two settings are OPTIONAL!!  If you can't figure out how to     *
 * get this utility to work via menuitem 10 from a regular menu, then you   *
 * will have to fill in the DisplayFile field manually, and make a copy of  *
 * ShowScreen for EACH file you want to show.  If you can figure out how    *
 * to get Adept to send parameters correctly to REXX programs, then you     *
 * can have Adept specify the DisplayFile on the fly.  If you figure it     *
 * out, PLEASE drop me netmail.  I'm tired, and sick of screwing with it    *
 * trying to figure it out <sigh>                                           *
 *                                                                          *
 * Please see below for information on "SpecialParm"                        * 
 *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  */

/* ARG determines how ShowScreen.Cmd deals with arguments, or command line
   parameters.  Here, the first argument is defined as the variable "line"
   while the second is defined as the variable "DisplayFile".  It should be
   noted that any time AdeptXBBS executes a REXX file, it automatically
   makes the line number the first argument.                                */

/* SpecialParm will eventually be used to tell ShowScreen special actions 
   to take depending on the parameter passed to this Arg.                   */

IF DisplayFile = ""
   Then Call ParmErrorGen
   ELSE

IF line = ""
   Then Call ParmErrorLine
   ELSE

'copy 'AdeptDriveLtr':\'AdeptBasePath'\'AdeptTextPath'\'DisplayFile'.* 'AdeptDriveLtr':\'AdeptBasePath'\'AdeptTextPath'\ShowFileHold.*'

/* Kludge (hopefully temporary) to get this thing to work quickly....       */ 

AdeptShow(line,1,2,ShowFileHold.Asc,sS)
AdeptHitReturn(line) 

END

/****************************************************************************/

ParmErrorGen:

AdeptPrint(line, "\r\n  {F8ShowScreen 1.0 - REXX Display Viewing Add-in for AdeptXBBS 1.0 for OS/2 3.0")
AdeptPrint(line, "\r\n  Copyright Matthew C. Davis (McD), 1995.  (CML/2 - 1:3666/107.0@Fidonet)\r\n")

AdeptPrint(line, "\r\n {FAError Encountered.  Description:\r\n")
AdeptPrint(line, "\r\n {F4LINE{F2: {F3"line"")
AdeptPrint(line, "\r\n {F4DISP{F2: {F3"DisplayFile"")
AdeptPrint(line, "\r\n {F4SPEC{F2: {F3"SpecialParm"")

AdeptPrint(line, "\r\n\n {B1{FDPARAMETER ERROR!!!{F8\r\n")

IF line = ""
   Then Call ParmErrorLine
   ELSE

IF DisplayFile = ""
   Then Call ParmErrorDisp
   ELSE

END

/****************************************************************************/

ParmErrorDisp:

AdeptPrint(line, "{F8Location: {FGDisplay File Specification {F9(Parameter 2){FG\r\n")
AdeptHitReturn(line) 

END

/****************************************************************************/

ParmErrorLine:

AdeptPrint(line, "{F8Location: {FGLine Number Specification {F9(Parameter 1){FG\r\n")
AdeptHitReturn(line) 

IF DisplayFile = ""
   Then Call ParmErrorDisp
   ELSE

END
