/*------------------------------------------------------------------
 * miniftp.cmd :
 *------------------------------------------------------------------
 * 03-16-93 originally by Patrick J. Mueller & Cliff Nadler
 *------------------------------------------------------------------
 
 Editted by someone to convert to adept... who?
 Editted by Paul Meyer:
 History:
   7th  June 1996: Added Colour!
   8th  June 1996: Added FTPERRNO Descriptions
   10th June 1996: Added ability to limit FTP file size
                   Made it easier to port to other systems
   11th June 1996: Can limit put size
                   Jazzed up usage a bit
                   added cat/more to view a file
   12th June 1996: Beautified.. Cleaned-up code
   14th June 1996: Added Progress Indicator - Now to make it look cool
   16th June 1996: Made Progress Indicator look half-cool
                   Fixed bug when get'ing files from Neologic ftpd, different
                   directory format.
                   Fixed up login where it would notify the user if they were
                   logged into the server before allowing them to type cmds.
                   Also fixed up open where if they entered anonymous as their
                   username, it'd log them in anonymously.
                   Fixed/Added a few other things when get'ing files.
                   If anyone can document the AdeptInput flags and types, do
                   so and mail me back.
   7th  July 1996: Fixed bug with open command now will correctly display an
                   error if one is found.
                   Fixed another couple of bugs with open.
                   Fixed Help Up..
                   Added BIN and ASC commands.  Defaults on ASCII mode.
                   Fixed some other shit, but I forget..
   14th July 1996: FTP now checks to see if a file was already ftp'd before
                   going and grabbing it again.
                   Fixed bug where sometimes it would say Connected when in
                   fact it wasn't.
                   Finally got around to putting the AdeptLocation and 
                   AdeptSayGen's in.
                   
 To do:
   * Mget - Multiple Get.
   * Dir and Ls just return current directory and subdirs.
   * Create a log file.. possible format:
       day/time AFTP user file size timetoftp bps
   * Change More prompt in dir and ls to an AdeptTimedInKey()
   * Fix up STATUS.
   * Add open list.  Either popular servers (sysop defined) or create a last
     10 list for each user.
   
 If you make any worthwhile changes, please email them to me or if you
 want anything added, email me as well... pmeyer@ednet.com.au ...or you
 can find me on IRC as _Spyder_
*/

ARG line
Signal on Error
Signal on Halt

/* Change these next few lines to suit your system/preferences */

/* Limits: */

/* Define largest ftp that a user can make (in bytes) */
MAXFTP = 2000000
/* or... users bytes remaining today... */
/*MaxFTP = AdeptGetVar(line,38)-AdeptGetVar(line,36)
MaxFTP = FtpK * 1024*/

/* Define largest file a user can cat (in bytes) */
MAXCAT = 50000

/* Delete file after sending it to the user?  "YES" or "NO" */
DELAFTERXFER = "NO"

/* Temp dir to place files into: Use forward slashes */
TMPDIRFS = "c:/adept/temp/" 

/* Same as above except with a double backslash.  AdeptMenuType,86 does't
   like forward slashes
*/
TMPDIRBS = "c:\\adept\\temp\\"

/* Your internet domain.  Appended to users handle to form email address */
DOMAIN = "spyders.ednet.com.au"

/* End of user definition thingys */

/* Flags for AdeptInput */
STRF_UCASE       = X2D(00000001)  /* Uppercased Input */
STRF_LCASE       = X2D(00000002)  /* Lowercased Input */
STRF_REQUIRED    = X2D(00000004)  /* Input is Required */
STRF_NOECHO      = X2D(00000008)  /* Don't echo typing to screen */
STRF_ENCRYPT     = X2D(00000010)  /* Encrypt? */
STRF_HOT         = X2D(00000020)  /* Hotkey Input Don't wait for CRLF */
STRF_EDIT        = X2D(00000040)  /* Means INS DEL etc work? */
STRF_PRETTY      = X2D(00000080)  /* I think this is First letter Uppercased */
STRF_MUSTHOT     = X2D(00000100)  /* Required+Hot? */
STRF_NEAT        = X2D(00000200)  /* Neat? Same as pretty? */
STRF_NOHELP      = X2D(00000400)  /* Don't look up help file */
STRF_NOQUE       = X2D(00000800)  /* ??? */
STRF_NOQUEONE    = X2D(00001000)  /* ??? */
STRF_CHATCLNT    = X2D(00002000)  /* ??? */
STRF_NOTIMECHECK = X2D(00004000)  /* Don't check time remaining */

/* Types for AdeptInput */
STRT_ALPHA        = 1  /* Letters Only */
STRT_NUMERIC      = 2  /* Numbers Only */
STRT_ALPHANUMERIC = 3  /* Letters and Numbers Only */
STRT_HEX          = 4  /* Read as Hexadecimal */
STRT_FILENAME     = 5  /* Read as Filename */
STRT_FILESPEC     = 6  /* Read as File Spec (ie *.*) */
STRT_ALL          = 7  /* Read All Keys */
STRT_ANY          = 8  /* Read Any ? Same as above? */
STRT_YN           = 9  /* Yes or No (Y/N) */
STRT_MULTFILES    1 = 0
STRT_MULTSPECS    1 = 1
STRT_YNQ          1 = 2
STRT_YNQS         1 = 3
STRT_JUSTFILE     1 = 4
STRT_MULTJUST     1 = 5
STRT_TELEPHONE    1 = 6
STRT_YNNUM        1 = 7


/*------------------------------------------------------------------
 * load functions, if needed
 *------------------------------------------------------------------*/
if RxFuncQuery("FtpLoadFuncs") then
   do
   rc = RxFuncAdd("FtpLoadFuncs","RxFtp","FtpLoadFuncs")
   rc = FtpLoadFuncs()
   end

if RxFuncQuery("SysLoadFuncs") then
   do
   rc = RxFuncAdd("SysLoadFuncs","RexxUtil","SysLoadFuncs")
   rc = SysLoadFuncs()
   end

/*------------------------------------------------------------------
 * set up signal
 *------------------------------------------------------------------*/
rows = AdeptGetVar(line,46)
cols = 80

mode = "ASCII"

host = ""
user = ""
pass = ""

TEST = ""

Call AdeptLocation line,"FTP - Not Connected"
Call AdeptSayGen line,"FTP - Not Connected"

/*------------------------------------------------------------------
 * set things
 *------------------------------------------------------------------*/
Call AdeptPrint line,"[2J\r\n"

do while (cmd <> "QUIT")

   Request = AdeptRequestsLogoff(line)
     if(Request = 1) then exit

   /*---------------------------------------------------------------
    * print prompt
    *---------------------------------------------------------------*/
   Call AdeptPrint line,"\r\n{FGEnter FTP command: (use ? for help)\r\n"

   /*---------------------------------------------------------------
    * get command
    *---------------------------------------------------------------*/
   Call AdeptPrint line,"[0m{FG"||host||"{F9> {F8"   
   test = AdeptInput(line, 1, 75, STRT_ALL, STRF_EDIT+STRF_NOHELP, "", "", "", "")

   Request = AdeptRequestsLogoff(line)
     if(Request = 1) then exit

   parse var test cmd cmdargs

   parse var cmdargs file1 file2 rest

   if (file1 = "") then file1 = "*"
   if (file2 = "") then file2 = file1

   /*------------------------------------------------------------------
    * sanity check
    *------------------------------------------------------------------*/
   cmd = translate(cmd)

   if (host="") then
    if (cmd <> "OPEN") & (cmd <> "?") & (cmd <> "HELP") & (cmd <> "QUIT") then
    do
      Call AdeptPrint line,"\r\n{FFYou have not provided host, userid, and password information."
      Call AdeptPrint line,"\r\n{FFUse the OPEN command to provide this information.\r\n"
      iterate
    end
   
   /* --------------------------------------------------------------------
    * check for put and if so get the file from the user before sending it
    * off to the remote site...
    ---------------------------------------------------------------------*/
   if (cmd = "PUT") then
   do
     Call AdeptMenuType Line,146
     Call AdeptRecv Line,16,TMPDIRFS,"Hold",file1
   end
   
   /*---------------------------------------------------------------
    * run command
    *---------------------------------------------------------------*/
   err = 0
   select
     when (cmd = "QUIT")    then iterate
/*
     when (cmd = "UPUT")    then err = FtpPutUnique(file1,TMPDIRFS||file2,mode)
     when (cmd = "APPEND")  then err = FtpAppend(file1,file2,mode)
*/
     when (cmd = "BIN") | (cmd = "BINARY") then
     do
       mode = "BINARY"
       Call AdeptPrint line,"\r\nType set to Binary/Image\r\n"
     end

     when (cmd = "ASC") | (cmd = "ASCII") then
     do
       mode = "ASCII"
       Call AdeptPrint line,"\r\nType set to ASCII\r\n"
     end

     when (cmd = "STATUS")  then
     do
       junk = FtpPwd('curdir')
       Call AdeptPrint line,"\r\nFtp Status:"
       Call AdeptPrint line,"\r\nConnected to: "||host||" - "||curdir
       Call AdeptPrint line,"\r\nTransferring in "||mode||" mode."
       Call AdeptPrint line,"\r\nYou have {T0 minutes remaining."
       Call AdeptPrint line,"\r\nThere is a limit of "||MAXFTP||"bytes per file."
     end

     when (cmd = "DELETE") | (cmd = "DEL") then
     do
       sure = AdeptInput(line, 1, 1, STRT_YN, STRF_NOHELP, "\r\n{F4Are you sure you want to delete {FF"||file1||"{F8? [{FGy{F8/N{FG{F8] ", "", "", "")
       if (sure="Y") | (sure="y") then
         err = FtpDelete(file1)
     end
     
     when (cmd = "RENAME") | (cmd = "REN") then 
     do
       Call AdeptPrint line,"\r\n{F4Renaming {FF"||file1||"{F4 to {FF"||file2||"\r\n"
       err = FtpRename(file1,file2)
     end
     
     when (cmd = "QUOTE")   then err = FtpQuote(cmdargs)
     when (cmd = "SITE")    then err = FtpSite(cmdargs)
     when (cmd = "CD")      then err = FtpChDir(file1)
     when (cmd = "MD")      then err = FtpMkDir(file1)

     when (cmd = "RD")      then 
     do
       sure = AdeptInput(line, 1, 1, STRT_YN, STRF_NOHELP, "\r\n{FGAre you sure you want to delete "||file1||"{F8? [{FGy{F8/{FGN{F8] ", "", "", "")
       if (sure="Y") | (sure="y") then
         err = FtpRmDir(file1)
     end

     when (cmd = "CAT") | (cmd = "MORE") then
     do
       Call AdeptPrint line,"\r\n{F4Displaying File{F9... {F4Please Wait{F9..."
       err = FtpDir(file1,"gstem.")
        
       if substr(sysret,1,4)='OS/2' then /* Neologic */
         parse var gstem.1 perm size fmonth fday ftime file
       else /* UNIX L8 or Windows_NT */
         parse var gstem.1 perm num owner group size fmonth fday ftime file
        
       if(size>MAXCAT) then
         Call AdeptPrint line,"\r\n{F4This file is too large to view."
       else
         err = FtpGet(TMPDIRFS||file1,file2,"ASCII")
         call AdeptShow line,2,,,TMPDIRFS||file2
     end
     
     when (cmd = "DIR")     then 
     do
       Call AdeptPrint line,"\r\n{F4Retrieving Directory List{F9... {F4Please Wait{F9...{F8"
       err = FtpDir(file1,"stem.")
     end

     when (cmd = "LS")      then 
     do
       Call AdeptPrint line,"\r\n{F4Retrieving Directory List{F9... {F4Please Wait{F9...{F8"
       err = FtpLs(file1,"stem.")
     end

     when (cmd = "PWD")     then
     do
       junk = FtpPwd('curdir')
       Call AdeptPrint line,"\r\n{F4Current Remote Directory{F8: {FG"||curdir||"\r\n"
     end

     when (cmd = "SYS")     then
     do
       junk = FtpSys('sys')
       Call AdeptPrint line,"\r\n{F4Returned from sys{F8: {FG"||sys||"\r\n"
     end

     when (cmd = "OPEN") then
     do
	   if(host\="") then
	   do
         rc = FtpLogoff()
         host = ""
         user = ""
         pass = ""
         sys  = ""
       end
	   
       parse var cmdargs host user pass
         
       call AdeptPrint line,"\r\n"

       if(host="") then
         host = AdeptInput(line, 1, 75, STRT_ALL, STRF_REQUIRED+STRF_EDIT+STRF_NOHELP, "{F4\r\nEnter FTP Host{F8: {FG", "", "", "")
           
       if(user="") then 
       do
         user = AdeptInput(line, 1, 75, STRT_ALL, STRF_EDIT+STRF_NOHELP+STRF_LCASE, "{F4\r\nEnter Username [Enter for Anonymous]{F8: {FG", "", "", "")
         if(user="") | (user="anonymous") then
         do
           user = "anonymous"
           pass = Translate(AdeptGetVar(line,2),'.',' ')"@"DOMAIN
         end
       end
           
       if(pass="") then
         pass = AdeptInput(line, 1, 75, STRT_ALL, STRF_NOECHO+STRF_EDIT+STRF_NOHELP, "{F4\r\nEnter Password{F8: {FG", "", "", "")

       Call AdeptPrint line,"\r\n{F4Attempting to Connect to {FF"||host||"{F9...\r\n"

       Call FtpSetUser host, user, pass
       
       sysret = FtpSys('sys')

       if (sys="") | (sysret<0) then
       do
         Call AdeptPrint line,"{F4Error Connecting to {FF"||host
         host = ""
         user = ""
         pass = ""
       end
       else
       do
         Call AdeptPrint line,"{F4Connected to {FF"||host
         Call AdeptLocation line,"FTP - "||host
         Call AdeptSayGen line,"FTP - "||host
       end
     end
         
     when (cmd = "CLOSE")   then
     do
       rc = FtpLogoff()
       host = ""
       user = ""
       pass = ""
       sys  = ""
       Call AdeptLocation line,"FTP - Not Connected"
       Call AdeptSayGen line,"FTP - Not Connected"
     end

     when (cmd = "GET")     then 
     do
	   /* Not safe to allow a user to ftp a file to another dir... */

       if(lastpos(file2,"\\")\=0) | (lastpos(file2,"/")\=0) then
       do
         Call AdeptPrint line,"\r\n{F4Invalid local filename.  Cancelling Transfer!\r\n"
         cmd = ""
         iterate
       end

       FtpDir(file1,"gstem.")
        
	   /* Does the file they tied to ftp exist? */

       if(gstem.0)=0 then
       do
         Call AdeptPrint line,"\r\n{F4File does not exist.\r\n"
         cmd = ""
         iterate
       end
        
	   /* Convert dir listing from different ftpd's */
	   
       if substr(sysret,1,4)='OS/2' then /* Neologic */
         parse var gstem.1 perm size fmonth fday ftime file
       else /* UNIX L8 or Windows_NT */
         parse var gstem.1 perm num owner group size fmonth fday ftime file
        
	   /* If the file has already been ftp'd.. lets just send the file to them
	      instead of going and ftp'ing it again... */

	   if(stream(TMPDIRFS||file1,"c","query exist")<>"")then
	     if(stream(TMPDIRFS||file1,"c","query size")<>size)then
	     do
           /* Check filesize vs limits */

           if(size>MAXFTP) then
             Call AdeptPrint line,"\r\n{F4I'm sorry, but the sysop won't allow you to FTP a file this size!"
           else
           do
             Call AdeptPrint line, "\r\n{F4Receiving {FF"||file||" {F9({FF"||size||" {F4bytes{F9) {F4in {FF"||mode||" {F4mode{F8... {F4Please Wait{F8..."
             call time "r" /* Start Timer */
             progresstid = AdeptStartREXXThread("ftp_progress.cmd", line, TMPDIRFS||file1, size)

             err = FtpGet(TMPDIRFS||file1,file2,mode)

             Call AdeptSleep line, 1500

             rc=AdeptKillREXXThread(progresstid)
        
             elapsed = strip(format(time("e"),10,2))
           end
         end
         else
           elapsed = 1
         
     end
     
     when (cmd = "PUT")     then
     do
       size=stream(TMPDIRFS||file1,'c','query size')

       if(size>MAXFTP) then
         Call AdeptPrint line,"\r\n{F4I'm sorry, but the sysop won't allow you to send a file this size!"
       else 
       do
         Call AdeptPrint line, "\r\n{F4Transmitting File in {FF"||mode||" {F4mode{F8... {F4Please Wait{F8..."
         call time "r" /* Start Timer */
         err = FtpPut(TMPDIRFS||file1,file2,mode)
       end
     end

     when (cmd = "?") | (cmd = "HELP")       then call Usage

     otherwise
       Call AdeptPrint line,"\r\n{F4Invalid command. Use {F8'{FF?{F8'{F4 for help.\r\n"
   end

   /*---------------------------------------------------------------
    * stop timer for get/put
    *---------------------------------------------------------------*/
   if (cmd = "GET") | (cmd = "PUT") then
   do
     if (cmd = "GET") then
       lfile = TMPDIRFS||file1
     else
       lfile = TMPDIRFS||file1

     if (stream(lfile, 'c', 'query exist') <> '') then
     do
       bytes = stream(lfile,"C","QUERY SIZE")

       bps = strip(format(bytes/elapsed,10,2))
       Call AdeptPrint line,"\r\n\r\n{F4Transmitted {FF"||bytes||"{F4bytes in {FF"||elapsed||"{F4seconds: {FF"||bps||"{F4bytes/second.\r\n"
       AdeptSetGlobalVar('status','IDLE')
     end
     else
     do
       Call AdeptPrint line,"\r\n\r\n{F4File was not Transferred.\r\n"
       AdeptSetGlobalVar('status','IDLE')
     end
       
   end

   /*------------------------------------------------------------------
    * check error
    *------------------------------------------------------------------*/
   if (err <> 0) then do
     select
       when FTPERRNO="FTPSERVICE" then
         ftperr="Unknown Service"
       when FTPERRNO="FTPHOST" then
         ftperr="Unknown Host"
       when FTPERRNO="FTPSOCKET" then
         ftperr="Unable to Obtain Socket"
       when FTPERRNO="FTPCONNECT" then
         ftperr="Unable to Connect to Server"
       when FTPERRNO="FTPLOGIN" then
         ftperr="Login Failed"
       when FTPERRNO="FTPABORT" then
         ftperr="Transfer Aborted"
       when FTPERRNO="FTPLOCALFILE" then
         ftperr="Problem Obtaining Local File"
       when FTPERRNO="FTPDATACONN" then
         ftperr="Problem Initializing Data Connection"
       when FTPERRNO="FTPCOMMAND" then
         ftperr="Command Failed"
       when FTPERRNO="FTPPROXYTHIRD" then
         ftperr="Proxy Server Does Not Support Third Party Transfers"
       when FTPERRNO="FTPNOPRIMARY" then
         ftperr="No Primary Connection for Proxy Transfer"
       otherwise
         ftperr="Unknown Error! FTPERRNO="||FTPERRNO||" err="||err
     end
       
     Call AdeptPrint line,"\r\n{F4Error from FTP: {FF"||ftperr||"\r\n"
   end

   /*------------------------------------------------------------------
     check for get and if it is send the file to the user
    *-------------------------------------------------------------------*/
   if (cmd = "GET") then
   do
     filetodl = TMPDIRFS||file2
     if (stream(filetodl, 'c', 'query exist') <> '') then
     do
       filetodl = TMPDIRBS||file2
       Call AdeptPrint line,"{F4Sending you {FF",file2
       Call AdeptMenuType line,86,filetodl

       if(DELAFTERXFER="YES") then
         ADDRESS CMD "@del "TMPDIRFS||file2">NUL"
     end
   end
     
   if (cmd = "PUT") then
   do
     if(DELAFTERXFER="YES") then
     do
       ADDRESS CMD "@del "TMPDIREFS||file1">NUL"
       
       rc = AfsysOpen('.\files','handle','FALSE')
       rc = AfSysFindExact(handle,file1,'8')
       rc = AfSysZeroFileRecord(handle)
       rc = AfSysSetFileRecord(handle)
       rc = AfSysClose(handle)
     end
   end

   /*------------------------------------------------------------------
    * check for dir or ls
    *------------------------------------------------------------------*/
   x = 0

   if (cmd = "LS") | (cmd = "DIR") then
   do i = 1 to stem.0
     x = x + 1
     Call AdeptPrint line,"\r\n"||stem.i
     if(x = rows-3) then
     do
       Call AdeptSleep line,128
       More = AdeptInput(line,,1,,,"\r\n{F4More {F8[{FGY{F8/{FGn{F8]? {F8",,,)
       x = 0
       if(More = 'N') then
       do
         I = stem.0
         Iterate
       end
       if(More = 'n') then
       do
         I = stem.0
         iterate
       end
     end
   end
end

/*------------------------------------------------------------------
 * quit
 *------------------------------------------------------------------*/
Error:
done:
  rc = FtpSetUser("X","X","X")
  rc = FtpLogoff()
  curdir = directory(TMPDIRFS)
  rc=AdeptKillREXXThread(progresstid)
exit

/*------------------------------------------------------------------
 * break condition
 *------------------------------------------------------------------*/
halt:
   Call AdeptPrint line,"\r\n{FDTerminating ...\r\n"
   signal done

/*------------------------------------------------------------------
 * some simple help
 *------------------------------------------------------------------*/
Usage:
   hr = translate(cmdargs) /* hr - Help Request */
   select
      when (hr = "OPEN")    then signal HelpOpen
      when (hr = "CLOSE")   then signal HelpClose
      when (hr = "SITE")    then signal HelpSite
      when (hr = "DIR")     then signal HelpDir
      when (hr = "LS")      then signal HelpLs
      when (hr = "GET")     then signal HelpGet
      when (hr = "PUT")     then signal HelpPut
      when (hr = "BIN")     then signal HelpBin
      when (hr = "ASC")     then signal HelpAsc
      when (hr = "CAT")     then signal HelpCat
      when (hr = "RENAME")  then signal HelpRename
      when (hr = "DELETE")  then signal HelpDelete
      when (hr = "SYS")     then signal HelpSys
      when (hr = "MD")      then signal HelpMd
      when (hr = "CD")      then signal HelpCd
      when (hr = "RD")      then signal HelpRd
      when (hr = "PWD")     then signal HelpPwd
      when (hr = "QUIT")    then signal HelpQuit
      when (hr = "QUOTE")   then signal HelpQuote
      when (hr = "HELP")    then signal HelpHelp
      otherwise
      do
        Call AdeptPrint line,"\r\nFtp Help -"
        Call AdeptPrint line,"\r\nOPEN      CLOSE     SITE      DIR       LS        GET"
        Call AdeptPrint line,"\r\nPUT       BIN       ASC       CAT       RENAME    DELETE"
        Call AdeptPrint line,"\r\nSYS       MD        CD        RD        PWD       QUIT"
        Call AdeptPrint line,"\r\nQUOTE     HELP"
        Call AdeptPrint line,"\r\nFor Detailed Help, Type:  'Help <option>'"
      end
return

HelpOpen:
   Call AdeptPrint line,"\r\n{FGOPEN {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    OPEN [host] [username] [password]"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Opens connection to remote host"
   Call AdeptPrint line,"\r\n{F9"
return

HelpClose:
   Call AdeptPrint line,"\r\n{FGCLOSE {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    CLOSE"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Closes connection to the remote host"
   Call AdeptPrint line,"\r\n{F9"
return

HelpSite:
   Call AdeptPrint line,"\r\n{FGSITE {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    SITE <command>"
   Call AdeptPrint line,"\r\n{FG  Descripiton:"
   Call AdeptPrint line,"\r\n{F8    Issues site command to the remote host"
   Call AdeptPrint line,"\r\n{F9"
return

HelpDir:
   Call AdeptPrint line,"\r\n{FGDIR {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    DIR [pattern]"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Lists files in directory or by pattern, displays in long form."
   Call AdeptPrint line,"\r\n{F9"
return

HelpLs:
   Call AdeptPrint line,"\r\n{FGLS {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    LS [pattern]"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Lists files in current directory or by pattern, displays in short form"
   Call AdeptPrint line,"\r\n{F9"
return

HelpGet:
   Call AdeptPrint line,"\r\n{FGGET {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    GET <remotefile> [localfile]"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Receives a file from the remote host"
   Call AdeptPrint line,"\r\n{F9"
return

HelpPut:
   Call AdeptPrint line,"\r\n{FGPUT {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    PUT <localfile> [remotefile]"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Sends a file to the remote host"
   Call AdeptPrint line,"\r\n{F9"
return

HelpCat:
   Call AdeptPrint line,"\r\n{FGCAT {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    CAT <remotefile>"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Display a remote text file"
   Call AdeptPrint line,"\r\n{F9"
return

HelpRename:
   Call AdeptPrint line,"\r\n{FGRENAME {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    RENAME <oldname> <newname>"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Renames a remote file"
   Call AdeptPrint line,"\r\n{F9"
return

HelpDelete:
   Call AdeptPrint line,"\r\n{FGDELETE {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    DELETE <remotefile>"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Deletes a remote file"
   Call AdeptPrint line,"\r\n{F9"
return

HelpSys:
   Call AdeptPrint line,"\r\n{FGSYS {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    SYS"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Issues sys command to remote server"
   Call AdeptPrint line,"\r\n{F9"
return

HelpMd:
   Call AdeptPrint line,"\r\n{FGMD {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    MD <directory>"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Creates a directory on remote server"
   Call AdeptPrint line,"\r\n{F9"
return

HelpCd:
   Call AdeptPrint line,"\r\n{FGCD {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    CD <directory>"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Changes directory on remote server"
   Call AdeptPrint line,"\r\n{F9"
return

HelpRd:
   Call AdeptPrint line,"\r\n{FGRD {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    RD <directory>"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Removes directory on remote server"
   Call AdeptPrint line,"\r\n{F9"
return

HelpPwd:						 
   Call AdeptPrint line,"\r\n{FGPWD {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    PWD"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Displays current directory"
   Call AdeptPrint line,"\r\n{F9"
return

HelpQuit:
   Call AdeptPrint line,"\r\n{FGQUIT {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    QUIT"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Exits FTP\r\n"
   Call AdeptPrint line,"\r\n{F9"
return

HelpBin:
   Call AdeptPrint line,"\r\n{FGBIN {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    BIN"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Switches Transfer mode to BINARY."
   Call AdeptPrint line,"\r\n{FG  Note:"
   Call AdeptPrint line,"\r\n{F8    Use To transfer Binary files and Images"
   Call AdeptPrint line,"\r\n{F9"
return

HelpAsc:
   Call AdeptPrint line,"\r\n{FGASC {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    ASC"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Switches Transfer mode to ASCII"
   Call AdeptPrint line,"\r\n{FG  Note: "
   Call AdeptPrint line,"\r\n{F8    Don't transfer Images/Zip's in this mode"
   Call AdeptPrint line,"\r\n{F9"
return

HelpQuote:
   Call AdeptPrint line,"\r\n{FGQUOTE {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    Quote <command>"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Issues Quote command with <command> to ftpd"
   Call AdeptPrint line,"\r\n{F9"
return

HelpHelp:
   Call AdeptPrint line,"\r\n{FGHELP {F9"
   Call AdeptPrint line,"\r\n{FG  Usage:"
   Call AdeptPrint line,"\r\n{F8    Help [Command]"
   Call AdeptPrint line,"\r\n{FG  Description:"
   Call AdeptPrint line,"\r\n{F8    Brings up Help for Command"
   Call AdeptPrint line,"\r\n{F9"
return

