/*
 Adept_Oracle v0.99 for AdeptXBBS (c) 1995 by Robert Stephens
 ---------------------------------------------------------------

 Q. What Does it do?

 A. Ever tried to Manually Edit Adept's Language.Text file ?.

    If you have, you'll appreciate what a pain in the arse it is, because
    every time you make a change, you must shut down adept, then restart it,
    logon locally and THEN see if you have managed to get the prompt
    right, which 9 times out of 10, you wont.

    AdeptLangOracle allows you to view prompts quite simply from the
    Command Line, no crapping around for up to 3-5 minutes at a time, this
    program makes it MUCH simpler and quicker.

    There are a fair few Neta Commands in Adept's Language file of which
    I have no idea what they do, so for the moment, they will probably
    show up errors or something, you can manually edit this file at the
    end and add them in if you like, you have the source :)

    This is a pre-release version, i'll probably have 1.00 out in a few
    days.

    This program is Postcard ware!.

    If you like it, send me a Postcard as appreciation for the few hours
    of work it took me to put this together.
    My Post Office Box is :

    Robert Stephens
    Po Box 121
    Lambton, NSW, 2299
    Australia.

 Q. What Utils am I writing Next ?

 A. I've been working on a PM Menu Editor for a few weeks now, it should
    be ready in a week or 2 for testing.

 Command Line Arguments
 ----------------------

   Adept_Oracle.Cmd <Prompt Number> <option>

   Where <Prompt Number> is the number of the prompt to view,
   and <option> is ANSI or ASCII.

   Example.

   [D:\Adept] Adept_Oracle.Cmd 668 ANSI

   ** Hint! **
   If you use Qedit or Qedit/2 to edit your Language.Text file, you can run
   this program with Command Line Arguments from Qedit's Alt-F9 Exec Menu.

    Hope you like this util!

    Robert Stephens (aka Jewfish)
    Internet: ourjs@net-unix.newcastle.edu.au
    Fidonet : 3:622/421

P.S If you Modify/Enhance this in anyway, please send me a copy of your
work, so I can use it too :)

*** Edit the Input_File Line Below! to suit your Drive:Path ***
*/

Input_File = "D:\Adept\System\Language.Text"

/******|Begin Main Code|********************************************/
'@Cls'
Call RxFuncAdd 'SysGetKey', 'RexxUtil', 'SysGetKey'
Say ""
Say "                [1;34;40m *** [1;33;40mAdeptXBBS [1;32mLanguage.Text [1;37;40mPrompt Viewer [1;34;40m***"
Say "[1;37m                         by Robert Stephens (Jewfish)[0m"
Parse Upper Arg Prompt_Number View
Say ""
Loopey:
If (Prompt_Number = "") Then Do
    Temp = CharOut(,"[s[0;36mEnter in the Prompt Number to View : ")
    Pull Prompt_Number
    If Prompt_Number = "" Then Signal Loopey
End
If (View \= "ANSI") & (View \= "ASCII") Then Do
    Say ""
    Temp = CharOut(,"[s[0;36mView, [1;37m[Enter] [0;36mAnsi or [1;37m[A] [0;36mAscii? : ")
    Key = SysGetKey('NOECHO')
    If (Key = "A") | (Key = "a") Then View = "ASCII"
    If (Key \= "a") & (Key \= "A") Then Do
       Say "[uWrong Key Selected... Assuming [1;37mA[1;32mn[1;33ms[1;35mi[0m"
       View = "ANSI"
    End
End
Say ""
Say "[K[1;37;40mPlease wait, searching ...[0m"
Do While Lines(Input_File) = 1
   Line = LineIn(Input_File)
   Call Check_Prompt(Line)
   If Prompt = Prompt_Number Then Do
      Say "[1;32;40mFound Prompt Number [1;37m"Prompt_Number"[1;32m, displaying ...[0m"
      Counter = 1
      Do Forever
         Prompt_Text.Counter = LineIn(Input_File)
         Call Check_Prompt(Prompt_Text.Counter)
         If Prompt = Prompt_Number + 1 Then Do
            Counter = Counter - 1
            Leave
         End
         Counter = Counter + 1
      End
      Call Display_Prompt
      Exit
   End
End
Say "[1;36mError! [1;32mCouldn't find prompt number [1;37m"Prompt_Number"[1;32m.[0m"
/******|End Main Code|**********************************************/

/*******************************************************************/
Check_Prompt:
Parse Arg Check_What
    Check = SubStr(Check_What,1,1)
    If Check = "#" Then Do
        Prompt = Word(Check_What,1)
        Prompt = DelStr(Prompt,Pos('#',Check_What),1)
    End
Return
/*******************************************************************/

/*******************************************************************/
Display_Prompt:
'@Cls'
CountR = 1
Do i = 1 to Counter
   Analyse = Prompt_Text.i
   If View = "ANSI" Then Check_Tag = Pos('[Asc]',Prompt_Text.i)
   If View = "ASCII" Then Check_Tag = Pos('[Ans]',Prompt_Text.i)
   If Check_Tag = 0 Then Do
      New_Prompt_Text.CountR = Prompt_Text.i
      Call Process_Text(New_Prompt_Text.CountR)
      Temp = CharOut(,New_Prompt_Text.CountR)
   End

/*
   If Check_Tag = 1 Then Do
     Say "[1;32mError! [1;33mPROMPT TYPE [1;32mnot found within this prompt,"
     Say "This may be due to the prompt being [1;37m[Ans] [1;32mor [1;37m[Asc] [1;32mbut not both.[0m"
     Exit
   End
*/

   CountR = CountR + 1
End
Dummy = CharOut(,"[s[0m[25;57H[1;37;46m Press Any Key to Exit [0m[u")
Dummy = SysGetKey('NOECHO')
Dummy = CharOut(,"[0m[24;0H")
Return
/*******************************************************************/

/*****|Function to Process The Data Lines from Language.Text|************/
Process_Text:
Parse Arg New_Prompt_Text.CountR
    Call Code_Stripper('[Ans]')
    Call Code_Stripper('[Asc]')
    Call Code_Stripper('[Str]')
    Call Code_Stripper('[Log]')
    Call Code_Stripper('[Mta]')
    Call Code_Stripper('[Loc]')
    Call Code_Stripper('[Clr]')
    Call Code_Stripper('[Pse]')
    Call Code_Stripper('[8bt]')
    Call Code_Stripper('[Cls]')
    Call Code_Stripper('[Fil]')
    Call Code_Stripper('[Rem]')
    Call Code_Stripper('[Cvt]')
    Do Forever
        Test_Pos = Pos('{',New_Prompt_Text.CountR)
        If Test_Pos = 0 Then Leave
        Meta = SubStr(New_Prompt_Text.CountR,Test_Pos,3)
        New_Prompt_Text.CountR = DelStr(New_Prompt_Text.CountR,Test_Pos,3)
        Call Conversion(New_Prompt_Text.CountR)
        New_Prompt_Text.CountR = Insert(New_Ansi,New_Prompt_Text.CountR,Test_Pos - 1)
    End
    Call Replace_Codes("\r [80D")
    Enter_Key = D2C(10)
    Esc_Key = D2C(27)
    Call Replace_Codes("\n "Enter_Key)
    Call Replace_Codes("\x1b "Esc_Key)
    Check_For_Semi_Colon_1 = Length(New_Prompt_Text.CountR)
    Check_For_Semi_Colon_2 = LastPos(';',New_Prompt_Text.CountR)
    If Check_For_Semi_Colon_2 = Check_For_Semi_Colon_1 Then New_Prompt_Text.CountR = DelStr(New_Prompt_Text.CountR,Check_For_Semi_Colon_2,1)
Return
/************************************************************************/

/******|Replace C's String Literals|*************************************/
Replace_Codes:
Parse Arg Replace_What With_What
	Do Forever
	   Search = Pos(Replace_What,New_Prompt_Text.CountR)
	   If Search = 0 Then Return
	   Length = Length(Replace_What)
	   New_Prompt_Text.CountR = DelStr(New_Prompt_Text.CountR,Search,Length)
	   New_Prompt_Text.CountR = Insert(With_What,New_Prompt_Text.CountR,Search - 1)
	End
Return
/************************************************************************/

/*****|Strip Out Adept's Language Control Codes|*************************/
Code_Stripper:
Parse Arg Code
   Check_Dumm = Pos(Code,New_Prompt_Text.CountR)
   If Check_Dumm \= 0 Then New_Prompt_Text.CountR = DelStr(New_Prompt_Text.CountR,Check_Dumm,5)
Return
/************************************************************************/

/*****|Convert Meta's Into Colours, and Meaningful Text|*****************/
/*   A CASE option be nice here :), IF's are processed Fast anyway...   */
Conversion:
   If Meta = "{F1" Then New_Ansi = "[0;40m"
   If Meta = "{F2" Then New_Ansi = "[0;34;40m"
   If Meta = "{F3" Then New_Ansi = "[0;32;40m"
   If Meta = "{F4" Then New_Ansi = "[0;36;40m"
   If Meta = "{F5" Then New_Ansi = "[0;31;40m"
   If Meta = "{F6" Then New_Ansi = "[0;35;40m"
   If Meta = "{F7" Then New_Ansi = "[0;33;40m"
   If Meta = "{F8" Then New_Ansi = "[0;37;40m"
   If Meta = "{F9" Then New_Ansi = "[1;30;40m"
   If Meta = "{FA" Then New_Ansi = "[1;34;40m"
   If Meta = "{FB" Then New_Ansi = "[1;32;40m"
   If Meta = "{FC" Then New_Ansi = "[1;36;40m"
   If Meta = "{FD" Then New_Ansi = "[1;31;40m"
   If Meta = "{FE" Then New_Ansi = "[1;35;40m"
   If Meta = "{FF" Then New_Ansi = "[1;33;40m"
   If Meta = "{FG" Then New_Ansi = "[1;37;40m"
   If Meta = "{B1" Then New_Ansi = "[40m"
   If Meta = "{B2" Then New_Ansi = "[44m"
   If Meta = "{B3" Then New_Ansi = "[42m"
   If Meta = "{B4" Then New_Ansi = "[46m"
   If Meta = "{B5" Then New_Ansi = "[41m"
   If Meta = "{B6" Then New_Ansi = "[45m"
   If Meta = "{B7" Then New_Ansi = "[43m"
   If Meta = "{B8" Then New_Ansi = "[47m"
   If Meta = "{CL" Then New_Ansi = "[K"
   If Meta = "{CS" Then New_Ansi = "[2J"
   If Meta = "{PC" Then New_Ansi = "[1;37mPress [Enter] to Continue"

   If Meta = "{QE" Then New_Ansi = ""

   If Meta = "{S0" Then New_Ansi = "25432"
   If Meta = "{S1" Then New_Ansi = "8"
   If Meta = "{S2" Then New_Ansi = "90"
   If Meta = "{S3" Then New_Ansi = "0"
   If Meta = "{S4" Then New_Ansi = "2"
   If Meta = "{S5" Then New_Ansi = "3"
   If Meta = "{S6" Then New_Ansi = "Pointbreak BBS"
   If Meta = "{S7" Then New_Ansi = "Joe Sysop"
   If Meta = "{S8" Then New_Ansi = "28800"

   If Meta = "{U0" Then New_Ansi = "John Doe"
   If Meta = "{U1" Then New_Ansi = "ShitHead"
   If Meta = "{U2" Then New_Ansi = "43 Blakely St, Nowhere"
   If Meta = "{U3" Then New_Ansi = "049-563768"
   If Meta = "{U4" Then New_Ansi = "Computers, TV, Booze, Women, Sex"
   If Meta = "{U5" Then New_Ansi = "Commodore C64 with 32MB RAM"
   If Meta = "{U6" Then New_Ansi = "C64"
   If Meta = "{U7" Then New_Ansi = "421"
   If Meta = "{U8" Then New_Ansi = "421"
   If Meta = "{U9" Then New_Ansi = "75/03/17"
   If Meta = "{UA" Then New_Ansi = "324"
   If Meta = "{UB" Then New_Ansi = "60"
   If Meta = "{UC" Then New_Ansi = "10"
   If Meta = "{UD" Then New_Ansi = "90"
   If Meta = "{UE" Then New_Ansi = "84"
   If Meta = "{UF" Then New_Ansi = "10"
   If Meta = "{UG" Then New_Ansi = "124"
   If Meta = "{UH" Then New_Ansi = "255"
   If Meta = "{UI" Then New_Ansi = "8643"
   If Meta = "{UJ" Then New_Ansi = "0"
   If Meta = "{UK" Then New_Ansi = "754"
   If Meta = "{UL" Then New_Ansi = "4096"
   If Meta = "{UM" Then New_Ansi = "2048"
   If Meta = "{UN" Then New_Ansi = "20"
   If Meta = "{UO" Then New_Ansi = "30"
   If Meta = "{UP" Then New_Ansi = "1024"
   If Meta = "{UQ" Then New_Ansi = "1024"
   If Meta = "{UR" Then New_Ansi = "1024"
   If Meta = "{US" Then New_Ansi = "1024"
   If Meta = "{UT" Then New_Ansi = "25"
   If Meta = "{UU" Then New_Ansi = "80"
   If Meta = "{UV" Then New_Ansi = "1"
   If Meta = "{UW" Then New_Ansi = "1"
   If Meta = "{UX" Then New_Ansi = "Z"
   If Meta = "{UY" Then New_Ansi = "L"
   If Meta = "{UZ" Then New_Ansi = "60"
   If Meta = "{V3" Then New_Ansi = "20"
   If Meta = "{V4" Then New_Ansi = "1"
   If Meta = "{V5" Then New_Ansi = "2"
   If Meta = "{V6" Then New_Ansi = "        3"
   If Meta = "{V7" Then New_Ansi = "        8"
   If Meta = "{V8" Then New_Ansi = "      101"
   If Meta = "{V9" Then New_Ansi = "      512"
   If Meta = "{VA" Then New_Ansi = "     1253"
   If Meta = "{VB" Then New_Ansi = "       10"
   If Meta = "{VC" Then New_Ansi = "      424"
   If Meta = "{VD" Then New_Ansi = "     4096"
   If Meta = "{VE" Then New_Ansi = "     2048"
   If Meta = "{VF" Then New_Ansi = "John Doe                            "
   If Meta = "{VG" Then New_Ansi = "My Stupid Handle                    "
   If Meta = "{VH" Then New_Ansi = "8000"
   If Meta = "{VI" Then New_Ansi = "26"
   If Meta = "{VJ" Then New_Ansi = "5"
   If Meta = "{VK" Then New_Ansi = "432"
   If Meta = "{O7" Then New_Ansi = "32"
   If Meta = "{O9" Then New_Ansi = "Newcastle"
   If Meta = "{P1" Then New_Ansi = "ShitHole Street"
   If Meta = "{P2" Then New_Ansi = "NSW"
   If Meta = "{P3" Then New_Ansi = "2299"
   If Meta = "{P4" Then New_Ansi = "049-524905"
   If Meta = "{P5" Then New_Ansi = "049-524906"
   If Meta = "{PF" Then New_Ansi = "Bluewave"
   If Meta = "{PI" Then New_Ansi = "ON"
   If Meta = "{PJ" Then New_Ansi = "OFF"
   If Meta = "{Q9" Then New_Ansi = "Zmodem"
   If Meta = "{QA" Then New_Ansi = "Pkzip v1.01"
   If Meta = "{QB" Then New_Ansi = "1048576"
   If Meta = "{O1" Then New_Ansi = "ON"
   If Meta = "{O2" Then New_Ansi = "OFF"
   If Meta = "{O3" Then New_Ansi = "OFF"
   If Meta = "{O4" Then New_Ansi = "OFF"
   If Meta = "{O5" Then New_Ansi = "OFF"
   If Meta = "{O6" Then New_Ansi = "OFF"
   If Meta = "{P6" Then New_Ansi = "OFF"
   If Meta = "{P7" Then New_Ansi = "ON"
   If Meta = "{P9" Then New_Ansi = "ON"
   If Meta = "{PE" Then New_Ansi = "ON"

   If Meta = "{M0" Then New_Ansi = "AUST_BBS"
   If Meta = "{M1" Then New_Ansi = "43"
   If Meta = "{M2" Then New_Ansi = "25"
   If Meta = "{M3" Then New_Ansi = "14"
   If Meta = "{M4" Then New_Ansi = "26"
   If Meta = "{M5" Then New_Ansi = "Australian BBS Listings"
   If Meta = "{M6" Then New_Ansi = "AUST_BBS   "
   If Meta = "{M7" Then New_Ansi = "    5"
   If Meta = "{M8" Then New_Ansi = "   25"
   If Meta = "{M9" Then New_Ansi = "   26"
   If Meta = "{MA" Then New_Ansi = "   30"
   If Meta = "{MB" Then New_Ansi = "Australian BBS Listings                        "
   If Meta = "{MC" Then New_Ansi = "56"
   If Meta = "{MD" Then New_Ansi = "Msg from (based on text #361)"
   If Meta = "{ME" Then New_Ansi = "02/20/1995"
   If Meta = "{MF" Then New_Ansi = "Msg to   (based on text #363)"
   If Meta = "{MG" Then New_Ansi = "[Private]"
   If Meta = "{MH" Then New_Ansi = "!"
   If Meta = "{MI" Then New_Ansi = "[Deleted]"
   If Meta = "{MJ" Then New_Ansi = "[Netmail]"
   If Meta = "{MK" Then New_Ansi = "[Echomail]"
   If Meta = "{ML" Then New_Ansi = "+"
   If Meta = "{MM" Then New_Ansi = "A"
   If Meta = "{MN" Then New_Ansi = "Q"
   If Meta = "{MO" Then New_Ansi = "U"
   If Meta = "{MP" Then New_Ansi = "K"
   If Meta = "{MQ" Then New_Ansi = "C"
   If Meta = "{MR" Then New_Ansi = "S"
   If Meta = "{MS" Then New_Ansi = "H"
   If Meta = "{MT" Then New_Ansi = "h"
   If Meta = "{MU" Then New_Ansi = "a"
   If Meta = "{MV" Then New_Ansi = "Threading ?? Tower??"
   If Meta = "{MW" Then New_Ansi = "More threading"
   If Meta = "{MX" Then New_Ansi = "More Threading"
   If Meta = "{MY" Then New_Ansi = "More Threading"
   If Meta = "{A2" Then New_Ansi = "Threading"
   If Meta = "{A3" Then New_Ansi = "Threading"
   If Meta = "{A4" Then New_Ansi = "Thread Back"
   If Meta = "{A5" Then New_Ansi = ".2"
   If Meta = "{A6" Then New_Ansi = "File: "
   If Meta = "{A7" Then New_Ansi = "This BBS is the Best"
   If Meta = "{A8" Then New_Ansi = "486 too slow        "
   If Meta = "{A9" Then New_Ansi = "Tom Jennings        "
   If Meta = "{AA" Then New_Ansi = "Joe Blow            "
   If Meta = "{AB" Then New_Ansi = "20   "
   If Meta = "{Q1" Then New_Ansi = "AUST_BBS"
   If Meta = "{Q2" Then New_Ansi = "15"
   If Meta = "{Q3" Then New_Ansi = "Australian BBS Listings"
   If Meta = "{Q4" Then New_Ansi = "14"
   If Meta = "{Q7" Then New_Ansi = "*"
   If Meta = "{Q8" Then New_Ansi = "+"
   If Meta = "{QC" Then New_Ansi = "15:06 10/23/1995        "
   If Meta = "{QD" Then New_Ansi = "    1"

   If Meta = "{A0" Then New_Ansi = "NEW_FILES"
   If Meta = "{A1" Then New_Ansi = "1"

   If Meta = "{L0" Then New_Ansi = "LIBRARY_BOOKS"
   If Meta = "{L1" Then New_Ansi = "5"

   If Meta = "{T0" Then New_Ansi = "23"
   If Meta = "{T1" Then New_Ansi = ""
   If Meta = "{T2" Then New_Ansi = "2800"

   If Meta = "{D0" Then New_Ansi = "Nov"
   If Meta = "{D1" Then New_Ansi = "Fri"
   If Meta = "{D2" Then New_Ansi = "1995"
   If Meta = "{D3" Then New_Ansi = "11"
   If Meta = "{D4" Then New_Ansi = "20"
   If Meta = "{D5" Then New_Ansi = "November"
   If Meta = "{D6" Then New_Ansi = "Friday"
   If Meta = "{D7" Then New_Ansi = "23:50:01"
   If Meta = "{D8" Then New_Ansi = "Friday November 20 23:50:01 1995"
   If Meta = "{I0" Then New_Ansi = "P"

   If Meta = "{K0" Then New_Ansi = "102234"
   If Meta = "{K1" Then New_Ansi = "2453453"
   If Meta = "{K2" Then New_Ansi = "5654"
   If Meta = "{K3" Then New_Ansi = "345534"
   If Meta = "{K4" Then New_Ansi = "16777216"
   If Meta = "{K5" Then New_Ansi = "4194304"
   If Meta = "{K6" Then New_Ansi = "2048"
   If Meta = "{K7" Then New_Ansi = "200"
   If Meta = "{K9" Then New_Ansi = "3233"
   If Meta = "{KA" Then New_Ansi = "50"
   If Meta = "{H0" Then New_Ansi = "16"
   If Meta = "{LN" Then New_Ansi = "3"
   If Meta = "{PA" Then New_Ansi = "Cycle Colour"
   If Meta = "{PB" Then New_Ansi = "Press any key to contiune"
   If Meta = "{PC" Then New_Ansi = "Press [Enter] to Continue Prompt"
   If Meta = "{PD" Then New_Ansi = "PAUSE"
   If Meta = "{PG" Then New_Ansi = "PAUSE 1/30"
   If Meta = "{PH" Then New_Ansi = "Sp Cursor"
   If Meta = "{Q5" Then New_Ansi = "Add1"
   If Meta = "{Q6" Then New_Ansi = "Add1"

   If Meta = "{QF" Then New_Ansi = "User Storage"
   If Meta = "{QG" Then New_Ansi = "ON"

   If Meta = "{CE" Then New_Ansi = "3"
   If Meta = "{CF" Then New_Ansi = "John Doe"
   If Meta = "{CH" Then New_Ansi = "Lambton, NSW"
   If Meta = "{CK" Then New_Ansi = "Playing Door"
   If Meta = "{CJ" Then New_Ansi = "28800"


Return
/************************************************************************/
