' VTzone v1.1
' This utility will update VConfig's timezone setting automatically when
' ran each night.

DECLARE SUB UpdateTZ (ntz$)
DECLARE SUB CmdError ()
DECLARE FUNCTION Easter$ (y%)
DECLARE FUNCTION DaysOfWeek$ (d%)
DECLARE FUNCTION DaysOfMonth% (m%, y%)
DECLARE FUNCTION LD% (dw%, m%, y%)
DECLARE FUNCTION OD% (o%, dw%, m%, y%)
DECLARE FUNCTION DOW% (d%, m%, y%)
DECLARE FUNCTION TRIM$ (text$)

DEFINT A-Z

'$INCLUDE: 'VADVCFG.BAS'

PRINT
PRINT "VTZone v1.1"
PRINT "(c) Aspect Technologies"
PRINT "-----------------------"
PRINT


' Check configuration.
OPEN "MAIN.CFG" FOR RANDOM ACCESS READ SHARED AS #1
IF LOF(1) = 0 THEN
    PRINT "MAIN.CFG is missing."
    PRINT
    CLOSE #1
    KILL "MAIN.CFG"
    END
END IF
CLOSE #1


' Command line defaults.
tz = -6
sm = 3
si$ = "20"
em = 11
ei$ = "10"
sc$ = ""
ec$ = ""


' Parse the command line.
cmd$ = TRIM$(UCASE$(COMMAND$))
IF (cmd$ = "") THEN CmdError

DIM opt$(1 TO 14)

FOR I = 1 TO 14
    p = INSTR(cmd$, " ")
    IF (p = 0) THEN
        opt$(I) = cmd$
        EXIT FOR
    END IF
    opt$(I) = TRIM$(LEFT$(cmd$, p - 1))
    cmd$ = TRIM$(MID$(cmd$, p + 1))
NEXT I

FOR I = 1 TO 14 STEP 2
    SELECT CASE opt$(I)
        CASE "-TZ"
            tz = VAL(opt$(I + 1))
        CASE "-SM"
            sm = VAL(opt$(I + 1))
        CASE "-SI"
            si$ = opt$(I + 1)
        CASE "-EM"
            em = VAL(opt$(I + 1))
        CASE "-EI"
            ei$ = opt$(I + 1)
        CASE "-SC"
            sc$ = opt$(I + 1)
        CASE "-EC"
            ec$ = opt$(I + 1)
    END SELECT
NEXT I


' Get today's date information.
month = VAL(LEFT$(DATE$, 2))
day = VAL(MID$(DATE$, 4, 2))
year = VAL(RIGHT$(DATE$, 4))


' Break down variables.
so$ = LEFT$(si$, 1)
sdw = VAL(RIGHT$(si$, 1))
eo$ = LEFT$(ei$, 1)
edw = VAL(RIGHT$(ei$, 1))


' DST Begins
IF (so$ = "L") THEN
    dstsday = LD(sdw, sm, year)
ELSE
    dstsday = OD(VAL(so$), sdw, sm, year)
END IF
IF (sm < 10) THEN
    sm$ = "0" + TRIM$(STR$(sm))
ELSE
    sm$ = STR$(sm)
END IF
IF (dstsday < 10) THEN
    dstsday$ = "0" + TRIM$(STR$(dstsday))
ELSE
    dstsday$ = STR$(dstsday)
END IF
dststart$ = sm$ + "-" + dstsday$ + "-" + TRIM$(STR$(year))


' DST Ends
IF (eo$ = "L") THEN
    dsteday = LD(edw, em, year)
ELSE
    dsteday = OD(VAL(eo$), edw, em, year)
END IF
IF (em < 10) THEN
    em$ = "0" + TRIM$(STR$(em))
ELSE
    em$ = TRIM$(STR$(em))
END IF
IF (dsteday < 10) THEN
    dsteday$ = "0" + TRIM$(STR$(dsteday))
ELSE
    dsteday$ = TRIM$(STR$(dsteday))
END IF
dstend$ = em$ + "-" + dsteday$ + "-" + TRIM$(STR$(year))


' Format the timezone.
t = tz
IF (tz < 0) THEN t = t - (t * 2)
IF (t < 100) THEN t = t * 100
IF (tz < 0) THEN
    tz = t - (t * 2)
ELSE
    tz = t
END IF


' Compare to today.
IF (dststart$ = DATE$) THEN
    t$ = TRIM$(STR$(tz + 100))
    IF (tz < 0) THEN
        IF (LEN(t$) < 5) THEN
            t$ = "-0" + RIGHT$(t$, 3)
        END IF
    ELSE
        IF (LEN(t$) < 4) THEN
            t$ = "+0" + RIGHT$(t$, 3)
        ELSE
            t$ = "+" + t$
        END IF
    END IF
    ntz$ = sc$ + " (" + t$ + ")"
    UpdateTZ (ntz$)
    PRINT "Timezone updated!"
ELSEIF (dstend$ = DATE$) THEN
    t$ = TRIM$(STR$(tz))
    IF (tz < 0) THEN
        IF (LEN(t$) < 5) THEN
            t$ = "-0" + RIGHT$(t$, 3)
        END IF
    ELSE
        IF (LEN(t$) < 4) THEN
            t$ = "+0" + RIGHT$(t$, 3)
        ELSE
            t$ = "+" + t$
        END IF
    END IF

    ntz$ = ec$ + " (" + t$ + ")"
    UpdateTZ (ntz$)
    PRINT "Timezone updated!"
ELSE
    PRINT "No update today!"
END IF

SUB CmdError
    PRINT "Command line error."
    PRINT "VTZONE.EXE -tz TIMEZONE [options]"
    PRINT
    PRINT "Options:"
    PRINT "  -tz  Specify your timezone relation to GMT (Required)"
    PRINT "  -sm  Month DST begins (01-12)"
    PRINT "  -si  Date identifier DST begins (see below)"
    PRINT "  -em  Month DST ends (01-12)"
    PRINT "  -ei  Date identifier DST ends (see below)"
    PRINT "  -sc  Custom VADV field when DST begins"
    PRINT "  -ec  Custom VADV field when DST ends"
    PRINT
    PRINT "Date Identifier:"
    PRINT "  The identifier is made of two characters in the format 'xd'."
    PRINT "  x - The relation of the date to the month (first, second, etc)"
    PRINT "  d - The day of the week"
    PRINT "Valid entries for x are:"
    PRINT "  1 - First, 2 - Second, 3 - Third, 4 - Fourth, 5 - Fifth, L - Last"
    PRINT "Valid entries for d are:"
    PRINT "  0 - Sunday, 1 - Monday, 2 - Tuesday, 3 - Wednesday, 4 - Thursday,"
    PRINT "  5 - Friday, 6 - Saturday"
    PRINT
    PRINT "Examples:"
    PRINT "Central Standard Time example..."
    PRINT "VTZONE.EXE -tz -6 -sc CDT -ec CST"
    PRINT "Central European Time example..."
    PRINT "VTZONE.EXE -tz +1 -sm 3 -si L0 -em 10 -ei L0 -sc CET -ec CEST"
    PRINT
    END
END SUB

FUNCTION DaysOfMonth% (m%, y%)
    SELECT CASE m%
        CASE 1
            DaysOfMonth = 31
        CASE 2
            l7 = y% MOD 4
            l8 = y% MOD 100
            l9 = y% MOD 400
            IF l7 <> 0 THEN
                DaysOfMonth = 28
            ELSEIF l8 <> 0 THEN
                DaysOfMonth = 29
            ELSEIF l9 = 0 THEN
                DaysOfMonth = 29
            ELSE
                DaysOfMonth = 28
            END IF
        CASE 3
            DaysOfMonth = 31
        CASE 4
            DaysOfMonth = 30
        CASE 5
            DaysOfMonth = 31
        CASE 6
            DaysOfMonth = 30
        CASE 7
            DaysOfMonth = 31
        CASE 8
            DaysOfMonth = 31
        CASE 9
            DaysOfMonth = 30
        CASE 10
            DaysOfMonth = 31
        CASE 11
            DaysOfMonth = 30
        CASE 12
            DaysOfMonth = 31
    END SELECT
END FUNCTION

FUNCTION DaysOfWeek$ (d%)
    SELECT CASE d%
        CASE 1
            DaysOfWeek = "Monday"
        CASE 2
            DaysOfWeek = "Tuesday"
        CASE 3
            DaysOfWeek = "Wednesday"
        CASE 4
            DaysOfWeek = "Thursday"
        CASE 5
            DaysOfWeek = "Friday"
        CASE 6
            DaysOfWeek = "Saturday"
        CASE ELSE
            DaysOfWeek = "Sunday"
    END SELECT
END FUNCTION

FUNCTION DOW% (d%, m%, y%)
    e0 = (14 - m%) \ 12
    e1 = y% - e0
    e2 = 12 * e0 + m% - 2
    e3 = e1 \ 4
    e4 = e1 \ 100
    e5 = e1 \ 400
    e6 = (31 * e2) \ 12
    e0 = d% + e1 + e3 - e4 + e5 + e6
    DOW = e0 MOD 7
END FUNCTION

FUNCTION Easter$ (y%)
    i0 = y% \ 100
    i1 = (y% \ 19) * -19 + y%
    i2 = (i0 - 17) \ 25
        i4 = i0 \ 4
        i5 = (i0 - i2) \ 3
        i6 = i0 - i4 - i5
    i3 = (19 * i1) + 15 + i6
    i4 = (i3 \ 30) * -30 + i3
        i6 = i4 \ 28
        i7 = i4 + 1
        i8 = 29 \ i7
        i9 = (21 - i1) \ 11
        j0 = i6 * i8 * i9
        j1 = (1 - j0) * i6
    i5 = i4 - j1
        i7 = y% \ 4
        i8 = i0 \ 4
    i6 = y! + i7 + i5 + 2 - i0 + i8
    i7 = (i6 \ 7) * -7 + i6
    i8 = i5 - i7
    j0 = (i8 + 40) \ 44 + 3
    j1 = (j0 \ 4) * -31 + 28 + i8
    Easter = STR$(j0) + STR$(j1)
END FUNCTION

FUNCTION LD% (dw%, m%, y%)
    f0 = DaysOfMonth(m%, y%)
    e0 = DOW(f0%, m%, y%)
    i1 = e0 - dw%
    IF (i1 < 0) THEN
        i1 = i1 + 7
    END IF
    i1 = i1 MOD 7
    LD = f0 - i1
END FUNCTION

FUNCTION OD% (o%, dw%, m%, y%)
    e0 = DOW(1, m%, y%)
    i1 = dw% - e0
    IF (i1 < 0) THEN
        i1 = i1 + 7
    END IF
    i1 = i1 MOD 7
    OD = 7 * o% - 6 + i1
END FUNCTION

FUNCTION TRIM$ (text$)
    TRIM$ = RTRIM$(LTRIM$(text$))
END FUNCTION

SUB UpdateTZ (ntz$)
' Update the main.cfg file with the new timezone info.
    DIM cfgMain AS cfgMain

    OPEN "MAIN.CFG" FOR RANDOM ACCESS READ WRITE SHARED AS #1 LEN = LEN(cfgMain)
    IF (LEN(ntz$) > 12) THEN
        ntz$ = LEFT$(ntz$, 12)
    END IF
    GET #1, 1, cfgMain
    cfgMain.timezone = TRIM$(ntz$)
    PUT #1, 1, cfgMain
    CLOSE #1
END SUB

