<?php
/*
 * ----------------------------------------------------------------------------
 * Who.php                                                           02/15/2006
 * Display who's online the BBS to the mobile device.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Mobile: Viewing Who\'s Online';

require_once('include_dir.php');
require_once($includeDir . 'va-functions.inc.php');
require_once($includeDir . 'va-main.inc.php');
require_once($includeDir . 'va-control.inc.php');
include_once('wml_header.php');
?>

<wml>

    <head>
        <meta http-equiv="Cache-Control" content="must-revalidate" forua="true" />
        <meta http-equiv="Cache-Control" content="no-cache" forua="true" />
    </head>

    <card title="Who's Online">
        <do type="prev" label="Back"><prev /></do>
        <p mode="wrap" align="center">

            <?php
            // Get who's online information...
            $who = GetControl();
            $maxChannel = 10;   // Display only first 10 channels.
            if ($VA_MAIN['maxchannelno'] < 10) {
                $maxChannel = $VA_MAIN['maxchannelno'];
            }
            if ($who['nodetotal'] < $maxChannel) {
                $maxChannel = $who['nodetotal'];
            }
            ?>

            <b>Who's Online</b><br />
            <?php print WMLSpecialChars($VA_MAIN['bbsname']) . "\n"; ?><br />
            <small><?php print UserDate("m/d/y g:ia"); ?></small>
        </p>
        <p mode="nowrap">
            <b>BBS:</b> (<?php print $who['activenodes']; ?>)<br />

            <?php
            // Print the results.
            $num = 0;
            for ($x = 0; $x <= $maxChannel; $x++) {
                if ($who[$x]['userno'] != '') {
                    print '[' . str_pad($x, 2, '0', STR_PAD_LEFT) . '] <b>' . WMLSpecialChars($who[$x]['handle']) . '</b> (#' . $who[$x]['userno'] . ')<br />' . "\n";
                    print '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small>' . WMLSpecialChars($who[$x]['action']) . '</small><br />' . "\n";
                    $num++;
                }
            }
            if ($num == 0) {
                print "No users online.<br />\n";
            }
            ?>

        </p>
        <p mode="nowrap">
            <b>Web-BBS:</b> (<?php print $VA_USERS[0]; ?>)<br />

            <?php
            // Get number of guests...
            $totalGuests = 0;
            for ($x = 1; $x <= $VA_USERS[0]; $x++) {
                if (($VA_USERS[$x]['userno'] == 0) ||
                    ($VA_USERS[$x]['userno'] == $CONFIG['guestacct'])) {
                    $totalGuests++;
                }
            }

            // Display guest information...
            if ($totalGuests > 0) {
                if ($totalGuests == 1) {
                    print '[--] <b>Guest</b><br />' . "\n";
                } else {
                    print '[--] <b>Guests </b>(' . $totalGuests . ')<br />' . "\n";
                }
            }

            $totalUsers = $VA_USERS[0] - $totalGuests;
            $foundUsers = 0;
            // Display up to ten users...
            for ($x = 1; (($foundUsers < $totalUsers) && ($foundUsers <= 10)); $x++) {
                if (($VA_USERS[$x]['userno'] > 0) &&
                    ($VA_USERS[$x]['userno'] != $CONFIG['guestacct'])) {
                    print '[--] <b>' . WMLSpecialChars($VA_USERS[$x]['handle']) . '</b> (#' . $VA_USERS[$x]['userno'] . ')<br />' . "\n";
                    print '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small>' . WMLSpecialChars($VA_USERS[$x]['action']) . '</small><br />' . "\n";
                    $foundUsers++;
                }
            }
            ?>

        </p>
        <p mode="nowrap">
            <anchor>Back<go href="index.php" /></anchor>
        </p>
        <?php include('mobile_footer.php'); ?>
    </card>

</wml>