<?php
/*
 * ----------------------------------------------------------------------------
 * Login.php                                                         08/20/2006
 * Displays login prompt and logs the user into Mobile VADV-PHP.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Mobile: Logging In...';

require_once('include_dir.php');
require_once($includeDir . 'va-functions.inc.php');
require_once($includeDir . 'va-main.inc.php');

include_once('wml_header.php');

if (($USER['userno'] > 0) &&
    ($USER['userno'] != $CONFIG['guestacct']) &&
    ($USER['securitylevel'] > 0)) {

    // Redirect the user using WML to erase variables.
    RedirectUser('index.php', 0, 'p', '', 'r', '');
}
?>

<wml>

    <head>
        <meta http-equiv="Cache-Control" content="must-revalidate" forua="true" />
        <meta http-equiv="Cache-Control" content="no-cache" forua="true" />
    </head>

    <card title="VADV-PHP Login">
        <do type="prev" label="Back"><prev /></do>
        <p mode="wrap" align="center">
            <b>Mobile VADV-PHP Login</b><br />
            <?php print WMLSpecialChars($VA_MAIN['bbsname']) . "\n"; ?>
        </p>
        <p mode="nowrap">
            <b>Username: </b><br /><input name="u" size="16" maxlength="40" type="text" />
            <br />
            <b>Password: </b><br /><input name="p" size="16" maxlength="32" type="password" />
            <?php
            if ($CONFIG['cookielife'] > 0) {
                print '<br />' . "\n";
                print '<select name="r">' . "\n";
                print '<option value="1">Remember Me</option>' . "\n";
                print '<option value="0">One-Time Login</option></select>' . "\n";
            }
            ?>
            <br /><br />
            <anchor>Login<go href="<?php print $rootDir; ?>login.php" method="post">
                <postfield name="referer" value="wap/index.php" />
                <postfield name="mobile" value="1" />
                <postfield name="username" value="$u" />
                <postfield name="password" value="$p" />
                <postfield name="remember" value="$r" /></go></anchor>
            &nbsp;|&nbsp;
            <anchor>Cancel<go href="index.php">
                <setvar name="u" value="" />
                <setvar name="p" value="" />
                <setvar name="r" value="" /></go></anchor>
        </p>

        <?php include('mobile_footer.php'); ?>

    </card>
    
</wml>