<?php
/*
 * ----------------------------------------------------------------------------
 * Email.php                                                         05/09/2006
 * Displays email menu, lists emails, and views emails.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Mobile: Email Functions';

require_once('include_dir.php');
require_once($includeDir . 'va-functions.inc.php');
require_once($includeDir . 'va-database.inc.php');
require_once($includeDir . 'va-main.inc.php');

if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct']) ||
    ($USER['securitylevel'] == 0)) {
    RedirectUser('index.php');
}

if (isset($_GET['view'])) {
    $view = strtolower($_GET['view']);
} else {
    $view = '';
}

if (isset($_GET['sent'])) {
    $sent = (boolean) $_GET['sent'];
} else {
    $sent = FALSE;
}

if (isset($_GET['read'])) {
    $read = (boolean) $_GET['read'];
} else {
    $read = FALSE;
}

include_once('wml_header.php');

// Setup common variables.
if (isset($_GET['referer'])) {
    $referer = $_GET['referer'];
} else {
    $referer = '';
}

if ($sent) {
    $db = SetSentEmailInfo($USER['userno']);
} else {
    $db = SetEmailInfo($USER['userno']);
}

if (!DbAccess($db)) {
    RedirectUser('email.php');
}

$msgno = $db['msgno'];

if ((($view == 'all') || ($view == 'new')) && (!$sent)) {
// ----------------------------------------------------------------------------
// Display the listing of emails.

    $userSettings['hidedeleted'] = 0;
    if ($userSettings['hidedeleted'] == 1) {
        $msgstat = GetEmailCount($USER['userno'], 0);   // Retrieve the number of user messages.
    } else {
        $msgstat = GetEmailCount($USER['userno']);
    }
    $msgcnt     = $msgstat['msgno'];
    $msgtotal   = $msgstat['msgtotal'];
    $nondeleted = $msgstat['msgtotal'] - $msgstat['deleted'];
    $unread     = $msgstat['unread'];
    $deleted    = $msgstat['deleted'];

    if ($userSettings['hidedeleted'] == 1) {
        $msgtotal = $nondeleted;
    } else {
        $msgtotal = $msgcnt;
    }

    if (isset($_GET['m'])) {                // Set the passed variables.
        $m = (integer) $_GET['m'];
    } else {
        $m = $msgcnt;
    }
    if ($m > $msgcnt) {
        $m = $msgcnt;
    }
    if ($m <= 0) {
        $m = 1;
    }

    // Set the fileString variable.
    $file = $VA_SYSPATHS['db'] . '/' . $db['filename'] . '.DAT';
    if (!is_file($file)) {
        RedirectUser('email.php');
    }
    $fileString = ReadCfgFile($file);       // Read the file.
?>

<wml>

    <head>
        <meta http-equiv="Cache-Control" content="must-revalidate" forua="true" />
        <meta http-equiv="Cache-Control" content="no-cache" forua="true" />
    </head>

    <card title="VADV-PHP Email">
        <do type="prev" label="Back"><prev /></do>
        <p mode="wrap" align="center">
            <b>Mobile VADV-PHP Email</b><br />
            <?php print WMLSpecialChars($VA_MAIN['bbsname']) . "\n"; ?>
            <br />
            <?php print '<small>[' . $unread . ' / ' . $nondeleted . '] (' . $deleted . ')</small>'; ?>
        </p>
        <p mode="nowrap">

            <?php
            if ($view == 'all') {
                print '<b>View ALL Email</b><br />';
            } else {
                print '<b>View NEW Email</b><br />';
            }

            if ($view == 'all') {
                if ($m > 15) {
                    $num = $m - 15;
                    $cnt = 15;
                    if ($num < 15) {
                        $cnt = $num;
                    }
                    print '<anchor>Previous ' . $cnt . '<go href="email.php" method="get">' . "\n";
                    print '<postfield name="view" value="' . $view . '" />' . "\n";
                    print '<postfield name="m" value="' . $num . '" /></go></anchor>' . "\n";
                }

                if (($m > 15) && ($m < $msgcnt)) {
                    print '&nbsp;|&nbsp;' . "\n";
                }

                if ($m < $msgcnt) {
                    $num = $m + 15;
                    if ($num > $msgcnt) {
                        $num = $msgcnt;
                    }
                    $cnt = 15;
                    if (($msgcnt - $m) < 15) {
                        $cnt = ($msgcnt - $m);
                    }
                    print '<anchor>Next ' . $cnt . '<go href="email.php" method="get">' . "\n";
                    print '<postfield name="view" value="' . $view . '" />' . "\n";
                    print '<postfield name="m" value="' . $num . '" /></go></anchor>' . "\n";
                }
            }
            print '<br />' . "\n";
            print '<anchor>Back<go href="email.php" /></anchor>&nbsp;|&nbsp;' . "\n";
            print '<anchor>Home<go href="index.php" /></anchor><br />' . "\n";

            // Loop to display the messages.
            $forCnt = $msgtotal;
            for ($x = $m; $forCnt >= ($msgtotal - 14); $x--) {
                if (($msgcnt == 0) || (($userSettings['hidedeleted'] == 1) && ($nondeleted == 0))) {
                    print '<br />' . "\n";
                    print 'You have no messages.<br />' . "\n";
                    break;
                }

                if (($view == 'new') && ($unread == 0)) {
                    print '<br />' . "\n";
                    print 'You have no new messages.<br />' . "\n";
                    break;
                }

                if ($x <= 0) {
                    break;
                }
                $msgInfo = GetMessageInfo($db, $msgstat[$x - 1], $fileString);  // Get the message information.
                $dateTime = ConvertDateTime($msgInfo['creation']);

                if ($msgInfo['touserno'] == $USER['userno']) {      // If to the current user...
                    if (($userSettings['hidedeleted'] == 0) || ($msgInfo['deleted'] == 0)) {
                        if (($view == 'all') || (($view == 'new') && ($msgInfo['offline'] == 0))) {
                            $forCnt--;
                            $from = $msgInfo['fromhandle'];
                            $char = substr($from, 0, 1);
                            if ($char == '<') {
                                $from = substr($from, 1);
                            }
                            if ($char == '"') {
                                $pos = strpos($from, '"', 1);
                                $from = substr($from, 1, $pos - 1);
                            }
                            $from = trim(WMLSpecialChars($from));

                            if ($msgInfo['subject'] == '') {
                                $subject = '(No Subject)';
                            } else {
                                $subject = WMLSpecialChars(StripANSICodes(StripBBSCodes($msgInfo['subject'])));
                            }
                            print '<br />' . "\n";
                            print '<b>' . WMLSpecialChars($from) . '</b><br />' . "\n";
                            print '<anchor>' . WMLSpecialChars($subject) . '<go href="email.php" method="get">' . "\n";
                            print '<postfield name="referer" value="' . $view . '" />' . "\n";
                            print '<postfield name="read" value="1" />' . "\n";
                            print '<postfield name="m" value="' . $x . '" /></go></anchor><br />' . "\n";
                            print '<small>' . $dateTime['date'] . ' ' . $dateTime['time'] . '</small><br />' . "\n";
                        }
                    }
                }
            }

            print '<br />' . "\n";

            if ($view == "all") {
                if ($m > 15) {
                    $num = $m - 15;
                    $cnt = 15;
                    if ($num < 15) {
                        $cnt = $num;
                    }
                    print '<anchor>Previous ' . $cnt . '<go href="email.php" method="get">' . "\n";
                    print '<postfield name="view" value="' . $view . '" />' . "\n";
                    print '<postfield name="m" value="' . $num . '" /></go></anchor>' . "\n";
                }

                if (($m > 15) && ($m < $msgcnt)) {
                    print '&nbsp;|&nbsp;' . "\n";
                }

                if ($m < $msgcnt) {
                    $num = $m + 15;
                    if ($num > $msgcnt) {
                        $num = $msgcnt;
                    }
                    $cnt = 15;
                    if (($msgcnt - $m) < 15) {
                        $cnt = ($msgcnt - $m);
                    }
                    print '<anchor>Next ' . $cnt . '<go href="email.php" method="get">' . "\n";
                    print '<postfield name="view" value="' . $view . '" />' . "\n";
                    print '<postfield name="m" value="' . $num . '" /></go></anchor>' . "\n";
                }
            }
            ?>

            <br />
            <anchor>Back<go href="email.php" /></anchor>&nbsp;|&nbsp;
            <anchor>Home<go href="index.php" /></anchor>
        </p>
        <?php include('mobile_footer.php'); ?>
    </card>

</wml>

<?php
}


if ((($view == 'all') || ($view == 'new')) && ($sent)) {
// ----------------------------------------------------------------------------
// Display the listing of sent emails.

    $userSettings['hidedeleted'] = 0;
    if ($userSettings['hidedeleted'] == 1) {
        $msgstat = GetSentEmailCount($USER['userno'], 0);   // Retrieve the number of user messages.
    } else {
        $msgstat = GetSentEmailCount($USER['userno']);
    }
    $msgcnt     = $msgstat['msgno'];
    $msgtotal   = $msgstat['msgtotal'];
    $nondeleted = $msgstat['msgtotal'] - $msgstat['deleted'];
    $unread     = $msgstat['unread'];
    $deleted    = $msgstat['deleted'];

    if ($userSettings['hidedeleted'] == 1) {
        $msgtotal = $nondeleted;
    } else {
        $msgtotal = $msgcnt;
    }

    if (isset($_GET['m'])) {                // Set the passed variables.
        $m = (integer) $_GET['m'];
    } else {
        $m = $msgcnt;
    }
    if ($m > $msgcnt) {
        $m = $msgcnt;
    }
    if ($m <= 0) {
        $m = 1;
    }

    // Set the fileString variable.
    $file = $VA_SYSPATHS['db'] . '/' . $db['filename'] . '.DAT';
    if (!is_file($file)) {
        RedirectUser('email.php');
    }
    $fileString = ReadCfgFile($file);       // Read the file.
?>

<wml>

    <head>
        <meta http-equiv="Cache-Control" content="must-revalidate" forua="true" />
        <meta http-equiv="Cache-Control" content="no-cache" forua="true" />
    </head>

    <card title="VADV-PHP Email">
        <do type="prev" label="Back"><prev /></do>
        <p mode="wrap" align="center">
            <b>Mobile VADV-PHP Email</b><br />
            <?php print WMLSpecialChars($VA_MAIN['bbsname']) . "\n"; ?>
            <br />
            <?php print '<small>[' . $unread . ' / ' . $nondeleted . '] (' . $deleted . ')</small>'; ?>
        </p>
        <p mode="nowrap">

            <?php
            print '<b>View Sent Email</b><br />';

            if ($m > 15) {
                $num = $m - 15;
                $cnt = 15;
                if ($num < 15) {
                    $cnt = $num;
                }
                print '<anchor>Previous ' . $cnt . '<go href="email.php" method="get">' . "\n";
                print '<postfield name="view" value="' . $view . '" />' . "\n";
                print '<postfield name="sent" value="1" />' . "\n";
                print '<postfield name="m" value="' . $num . '" /></go></anchor>' . "\n";
            }

            if (($m > 15) && ($m < $msgcnt)) {
                print '&nbsp;|&nbsp;' . "\n";
            }

            if ($m < $msgcnt) {
                $num = $m + 15;
                if ($num > $msgcnt) {
                    $num = $msgcnt;
                }
                $cnt = 15;
                if (($msgcnt - $m) < 15) {
                    $cnt = ($msgcnt - $m);
                }
                print '<anchor>Next ' . $cnt . '<go href="email.php" method="get">' . "\n";
                print '<postfield name="view" value="' . $view . '" />' . "\n";
                print '<postfield name="sent" value="1" />' . "\n";
                print '<postfield name="m" value="' . $num . '" /></go></anchor>' . "\n";
            }
            print '<br />' . "\n";
            print '<anchor>Back<go href="email.php" /></anchor>&nbsp;|&nbsp;' . "\n";
            print '<anchor>Home<go href="index.php" /></anchor><br />' . "\n";

            // Loop to display the messages.
            $forCnt = $msgtotal;
            for ($x = $m; $forCnt >= ($msgtotal - 14); $x--) {
                if (($msgcnt == 0) || (($userSettings['hidedeleted'] == 1) && ($nondeleted == 0))) {
                    print '<br />' . "\n";
                    print 'You have no messages.<br />' . "\n";
                    break;
                }

                if (($view == 'new') && ($unread == 0)) {
                    print '<br />' . "\n";
                    print 'You have no new messages.<br />' . "\n";
                    break;
                }

                if ($x <= 0) {
                    break;
                }
                $msgInfo = GetMessageInfo($db, $msgstat[$x - 1], $fileString);  // Get the message information.
                $dateTime = ConvertDateTime($msgInfo['creation']);

                if ($msgInfo['fromuserno'] == $USER['userno']) {      // If from the current user...
                    if (($userSettings['hidedeleted'] == 0) || ($msgInfo['deleted'] == 0)) {
                        $forCnt--;
                        
                        $to = $msgInfo['tohandle'];
                        $char = substr($to, 0, 1);
                        if ($char == '<') {
                            $to = substr($to, 1);
                        }
                        if ($char == '"') {
                            $pos = strpos($to, '"', 1);
                            $to = substr($to, 1, $pos - 1);
                        }
                        $to = trim(WMLSpecialChars($to));

                        if ($msgInfo['subject'] == '') {
                            $subject = '(No Subject)';
                        } else {
                            $subject = WMLSpecialChars(StripANSICodes(StripBBSCodes($msgInfo['subject'])));
                        }
                        print '<br />' . "\n";
                        print '<b>' . WMLSpecialChars($to) . '</b><br />' . "\n";
                        print '<anchor>' . WMLSpecialChars($subject) . '<go href="email.php" method="get">' . "\n";
                        print '<postfield name="referer" value="' . $view . '" />' . "\n";
                        print '<postfield name="read" value="1" />' . "\n";
                        print '<postfield name="sent" value="1" />' . "\n";
                        print '<postfield name="m" value="' . $x . '" /></go></anchor><br />' . "\n";
                        print '<small>' . $dateTime['date'] . ' ' . $dateTime['time'] . '</small><br />' . "\n";
                    }
                }
            }

            print '<br />' . "\n";

            if ($m > 15) {
                $num = $m - 15;
                $cnt = 15;
                if ($num < 15) {
                    $cnt = $num;
                }
                print '<anchor>Previous ' . $cnt . '<go href="email.php" method="get">' . "\n";
                print '<postfield name="view" value="' . $view . '" />' . "\n";
                print '<postfield name="sent" value="1" />' . "\n";
                print '<postfield name="m" value="' . $num . '" /></go></anchor>' . "\n";
            }

            if (($m > 15) && ($m < $msgcnt)) {
                print '&nbsp;|&nbsp;' . "\n";
            }

            if ($m < $msgcnt) {
                $num = $m + 15;
                if ($num > $msgcnt) {
                    $num = $msgcnt;
                }
                $cnt = 15;
                if (($msgcnt - $m) < 15) {
                    $cnt = ($msgcnt - $m);
                }
                print '<anchor>Next ' . $cnt . '<go href="email.php" method="get">' . "\n";
                print '<postfield name="view" value="' . $view . '" />' . "\n";
                print '<postfield name="sent" value="1" />' . "\n";
                print '<postfield name="m" value="' . $num . '" /></go></anchor>' . "\n";
            }
            ?>

            <br />
            <anchor>Back<go href="email.php" /></anchor>&nbsp;|&nbsp;
            <anchor>Home<go href="index.php" /></anchor>
        </p>
        <?php include('mobile_footer.php'); ?>
    </card>

</wml>

<?php
}

if ($read) {
// ----------------------------------------------------------------------------
// Display the selected email.
    if ($msgno == 0) {
        RedirectUser('email.php');
    }

    if ($sent) {
        $msgstat = GetSentEmailCount($USER['userno']);
    } else {
        $msgstat = GetEmailCount($USER['userno']);
    }
    $msgcnt  = $msgstat['msgno'];

    if ($msgcnt == 0) {
        RedirectUser('email.php');
    }

    if (isset($_GET['m'])) {
        $m = (integer) $_GET['m'];
    } else {
        $m = $msgcnt;
    }
    if ($m > $msgcnt) {
        $m = $msgcnt;
    }
    if ($m <= 0) {
        $m = 1;
    }

    $msgInfo = GetMessageInfo($db, $msgstat[$m - 1]);     // Get the message information.
    if ($sent) {
        if ($msgInfo['fromuserno'] != $USER['userno']) {
            RedirectUser('email.php');
        }
    } else {
        if ($msgInfo['touserno'] != $USER['userno']) {
            RedirectUser('email.php');
        }
    }

    // Check for delete message flag.
    if (isset($_GET['delete'])) {
        if ($_GET['delete'] == 1) {
            // If an attached file, then delete it. Non-reversible!
            if ($msgInfo['attfilename'] != '') {
                if ($CONFIG['hostname'] != '') {
                    $file = ConvertDir($CONFIG['hostname'], $db['filepath']) . '/' . $msgInfo['attfilename'];
                } else {
                    $file = $db['filepath'] . '/' . $msgInfo['attfilename'];
                }

                if ($msgInfo['attfilepath'] == '') {
                    if (is_file($file)) {
                        unlink($file);
                    }
                } else {
                    if ($CONFIG['hostname'] != '') {
                        $userDir = ConvertUnc($VA_SYSPATHS['sysop'] . '/' . $USER['userno'] . '/' . $msgInfo['attfilename']);
                    } else {
                        $userDir = $VA_SYSPATHS['sysop'] . '/' . $USER['userno'] . '/' . $msgInfo['attfilename'];
                    }
                    if ($msgInfo['attfilepath'] == $userDir) {
                        if ($CONFIG['hostname'] != '') {
                            $file = ConvertDir($CONFIG['hostname'], $msgInfo['attfilepath']);
                        } else {
                            $file = $msgInfo['attfilepath'];
                        }
                    }
                    if (is_file($file)) {
                        unlink($file);
                    }
                }
                $msgInfo['attfilesize'] = 0;
                $msgInfo['attfilename'] = '';
                $msgInfo['attfilepath'] = '';
            }
            $msgInfo['deleted'] = 1;
            WriteMessageInfo($db, $msgstat[$m - 1], $msgInfo);
            RedirectUser('email.php?view=' . $referer . '&sent=' . intval($sent));
        } else if ($_GET['delete'] == 0) {
            $msgInfo['deleted'] = 0;
            WriteMessageInfo($db, $msgstat[$m - 1], $msgInfo);
        }
    }

    $dateTime = ConvertDateTime($msgInfo['creation']);

    $from = $msgInfo['fromhandle'];
    $char = substr($from, 0, 1);
    if ($char == '<') {
        $from = substr($from, 1);
    }
    if ($char == '"') {
        $pos = strpos($from, '"', 1);
        $from = substr($from, 1, $pos - 1);
    }
    $from = trim(WMLSpecialChars($from));

    if ($msgInfo['subject'] == '') {
        $subject = '(No Subject)';
    } else {
        $subject = WMLSpecialChars(StripANSICodes(StripBBSCodes($msgInfo['subject'])));
    }

    $to = $msgInfo['tohandle'];
    $char = substr($to, 0, 1);
    if ($char == '<') {
        $to = substr($to, 1);
    }
    if ($char == '"') {
        $pos = strpos($to, '"', 1);
        $to = substr($to, 1, $pos - 1);
    }
    $to = trim(WMLSpecialChars($to));

    $message = GetMessage($db, $msgstat[$m - 1], 2, '', $msgInfo);      // Get the message to display.
    $message = WMLSpecialChars($message);                               // Convert special chars.
    $message = StripANSICodes(StripBBSCodes(StripRouting($message)));   // Remove any coding.
    $message = str_replace("\r\n", "\n", $message);                     // Change all line breaks/ carriage returns to breaks.
    $message = str_replace("\r", "\n", $message);
    $message = str_replace("\n", "<br />\n", $message);
?>

<wml>

    <head>
        <meta http-equiv="Cache-Control" content="must-revalidate" forua="true" />
        <meta http-equiv="Cache-Control" content="no-cache" forua="true" />
    </head>

    <card title="VADV-PHP Email">
        <do type="prev" label="Back"><prev /></do>
        <p mode="wrap" align="center">
            <b>Mobile VADV-PHP Email</b><br />
            <?php print WMLSpecialChars($VA_MAIN['bbsname']) . "\n"; ?>
        </p>
        <p mode="nowrap">

            <?php
            if ($m > 1) {
                $num = $m - 1;
                print '<anchor>Previous Email<go href="email.php" method="get">' . "\n";
                print '<postfield name="referer" value="' . $referer . '" />' . "\n";
                print '<postfield name="read" value="1" />' . "\n";
                print '<postfield name="sent" value="' . intval($sent) . '" />' . "\n";
                print '<postfield name="m" value="' . $num . '" /></go></anchor>' . "\n";
            }

            if (($m > 1) && ($m < $msgcnt)) {
                print '&nbsp;|&nbsp;' . "\n";
            }

            if ($m < $msgcnt) {
                $num = $m + 1;
                print '<anchor>Next Email<go href="email.php" method="get">' . "\n";
                print '<postfield name="referer" value="' . $referer . '" />' . "\n";
                print '<postfield name="read" value="1" />' . "\n";
                print '<postfield name="sent" value="' . intval($sent) . '" />' . "\n";
                print '<postfield name="m" value="' . $num . '" /></go></anchor>' . "\n";
            }
            ?>

            <br />
            <anchor>Back<go href="email.php" method="get">
                <postfield name="view" value="<?php print $referer; ?>" />
                <postfield name="sent" value="<?php print intval($sent); ?>" /></go></anchor>&nbsp;|&nbsp;
            <anchor>Home<go href="index.php" /></anchor>
            <br />

            <?php
            if (($USER['userno'] > 0) &&
                ($USER['userno'] != $CONFIG['guestacct']) &&
                ($USER['securitylevel'] >= $db['minwritesl']) &&
                (!$sent)) {
                print '<anchor>Reply<go href="post-email.php" method="get">' . "\n";
                print '<postfield name="referer" value="' . $referer . '" />' . "\n";
                print '<postfield name="m" value="' . $m . '" />' . "\n";
                print '<postfield name="reply" value="' . $msgstat[$m - 1] . '" /></go></anchor>&nbsp;|&nbsp;' . "\n";
            }

            if ($msgInfo['deleted'] == 1) {
                print '<anchor>UnDelete<go href="email.php" method="get">' . "\n";
                print '<postfield name="m" value="' . $m . '" />' . "\n";
                print '<postfield name="delete" value="0" />' . "\n";
                print '<postfield name="referer" value="' . $referer . '" />' . "\n";
                print '<postfield name="sent" value="' . intval($sent) . '" />' . "\n";
                print '<postfield name="read" value="1" /></go></anchor>' . "\n";
            } else {
                print '<anchor>Delete<go href="email.php" method="get">' . "\n";
                print '<postfield name="m" value="' . $m . '" />' . "\n";
                print '<postfield name="delete" value="1" />' . "\n";
                print '<postfield name="referer" value="' . $referer . '" />' . "\n";
                print '<postfield name="sent" value="' . intval($sent) . '" />' . "\n";
                print '<postfield name="read" value="1" /></go></anchor>' . "\n";
            }
            ?>

            <br />
        </p>
        <p mode="wrap">
            <?php
            if ($sent) {
                print '<b>To: </b>' . WMLSpecialChars($to) . '<br />' . "\n";
            } else {
                print '<b>From: </b>' . WMLSpecialChars($from) . '<br />' . "\n";
            }
            ?>
            <b>Subject: </b><?php print WMLSpecialChars($subject); ?><br />
            <b>Date: </b><?php print $dateTime['date'] . ' ' . $dateTime['time']; ?><br />
            <br />
            <?php print $message . "\n"; ?>
        </p>
        <p mode="nowrap">
            <br />

            <?php
            if ($m > 1) {
                $num = $m - 1;
                print '<anchor>Previous Email<go href="email.php" method="get">' . "\n";
                print '<postfield name="referer" value="' . $referer . '" />' . "\n";
                print '<postfield name="read" value="1" />' . "\n";
                print '<postfield name="sent" value="' . intval($sent) . '" />' . "\n";
                print '<postfield name="m" value="' . $num . '" /></go></anchor>' . "\n";
            }
            
            if (($m > 1) && ($m < $msgcnt)) {
                print '&nbsp;|&nbsp;' . "\n";
            }

            if ($m < $msgcnt) {
                $num = $m + 1;
                print '<anchor>Next Email<go href="email.php" method="get">' . "\n";
                print '<postfield name="referer" value="' . $referer . '" />' . "\n";
                print '<postfield name="read" value="1" />' . "\n";
                print '<postfield name="sent" value="' . intval($sent) . '" />' . "\n";
                print '<postfield name="m" value="' . $num . '" /></go></anchor>' . "\n";
            }
            ?>

            <br />
            <anchor>Back<go href="email.php" method="get">
                <postfield name="view" value="<?php print $referer; ?>" />
                <postfield name="sent" value="<?php print intval($sent); ?>" /></go></anchor>&nbsp;|&nbsp;
            <anchor>Home<go href="index.php" /></anchor>
            <br />
            
            <?php
            if (($USER['userno'] > 0) &&
                ($USER['userno'] != $CONFIG['guestacct']) &&
                ($USER['securitylevel'] >= $db['minwritesl']) &&
                (!$sent)) {
                print '<anchor>Reply<go href="post-email.php" method="get">' . "\n";
                print '<postfield name="referer" value="' . $referer . '" />' . "\n";
                print '<postfield name="m" value="' . $m . '" />' . "\n";
                print '<postfield name="reply" value="' . $msgstat[$m - 1] . '" /></go></anchor>&nbsp;|&nbsp;' . "\n";
            }

            if ($msgInfo['deleted'] == 1) {
                print '<anchor>UnDelete<go href="email.php" method="get">' . "\n";
                print '<postfield name="m" value="' . $m . '" />' . "\n";
                print '<postfield name="delete" value="0" />' . "\n";
                print '<postfield name="referer" value="' . $referer . '" />' . "\n";
                print '<postfield name="sent" value="' . intval($sent) . '" />' . "\n";
                print '<postfield name="read" value="1" /></go></anchor>' . "\n";
            } else {
                print '<anchor>Delete<go href="email.php" method="get">' . "\n";
                print '<postfield name="m" value="' . $m . '" />' . "\n";
                print '<postfield name="delete" value="1" />' . "\n";
                print '<postfield name="referer" value="' . $referer . '" />' . "\n";
                print '<postfield name="sent" value="' . intval($sent) . '" />' . "\n";
                print '<postfield name="read" value="1" /></go></anchor>' . "\n";
            }
            ?>

        </p>
        <?php include('mobile_footer.php'); ?>
    </card>

</wml>

<?php
    // Update the message as read if not already marked and send oneliner.
    if ($msgInfo['offline'] == 0) {
        $msgInfo['offline'] = 1;
        WriteMessageInfo($db, $msgstat[$m - 1], $msgInfo);

        if (($msgInfo['fromnetid'] == 1) && (!$sent)) {
            $msg = $USER['handle'] . ' #' . $USER['userno'] . ' Read Email: ' . $subject;
            WriteOneliner($msgInfo['fromuserno'], $msg);
        }
    }
}

// ----------------------------------------------------------------------------
// Display the menu.
?>

<wml>

    <head>
        <meta http-equiv="Cache-Control" content="must-revalidate" forua="true" />
        <meta http-equiv="Cache-Control" content="no-cache" forua="true" />
    </head>

    <card title="VADV-PHP Email">
        <do type="prev" label="Back"><prev /></do>
        <p mode="wrap" align="center">
            <b>Mobile VADV-PHP Email</b><br />
            <?php print WMLSpecialChars($VA_MAIN['bbsname']) . "\n"; ?>
        </p>
        <p mode="wrap">

            <?php
            if (($USER['userno'] > 0) &&
                ($USER['userno'] != $CONFIG['guestacct'])) {
                print 'Logged in as:<br /><b>' . WMLSpecialChars($USER['handle']) . '</b> (#' . $USER['userno'] . ')<br />' . "\n";
                $msgcnt = GetEmailCount($USER['userno']);
            }
            ?>

        </p>
        <p mode="nowrap">
            Choose:
            <br />

            <?php
            if ($msgcnt['unread'] > 0) {
            ?>

            <anchor>View New Email<go href="email.php" method="get">
                <postfield name="view" value="new" />
                <postfield name="sent" value="0" /></go></anchor>
            <br />

            <?php
            }
            ?>

            <anchor>View All Email<go href="email.php" method="get">
                <postfield name="view" value="all" />
                <postfield name="sent" value="0" /></go></anchor>
            <br />
            <anchor>View Sent Email<go href="email.php" method="get">
                <postfield name="view" value="all" />
                <postfield name="sent" value="1" /></go></anchor>
            <br />

            <?php
            if (($USER['userno'] > 0) &&
                ($USER['userno'] != $CONFIG['guestacct']) &&
                ($USER['securitylevel'] >= $VA_MAIN['emlothers'])) {
            ?>

            <anchor>Send Email<go href="post-email.php" /></anchor>
            <br />

            <?php
            }
            ?>

            <anchor>Back<go href="index.php" /></anchor>
        </p>
        <?php include('mobile_footer.php'); ?>
    </card>

</wml>