<?php
/*
 * ----------------------------------------------------------------------------
 * VConfig_VADV-PHP_Process.php                                      10/02/2006
 * This script processes the info from the vconfig_vadv-php.php script.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'SysOp Function';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.

if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct']) ||
    ($USER['securitylevel'] == 0)) {
    RedirectUser($rootDir . 'index.php');
}
if ($USER['securitylevel'] < 255) {
    $log = 'VConfig Error!  "' . $USER['handle'] . '" - Attempted Unauthorized VConfig Entry';
    WriteLog('VADV-PHP.LOG', $log);
    RedirectUser($rootDir . 'index.php');
}

// Check for system password.
if ($CONFIG['syspass']) {
    if (isset($_SESSION['systempw'])) {
        if ($_SESSION['systempw'] !== $VA_MAIN['systempw']) {
            RedirectUser($rootDir . 'index.php');
        }
    } else {
        RedirectUser($rootDir . 'index.php');
    }
}

if ((!isset($_SERVER['HTTP_REFERER'])) ||
    (strpos($_SERVER['HTTP_REFERER'], $_SERVER['HTTP_HOST']) === FALSE)) {
    die('<br /><h4>You are not allowed to access this script from an outside source.<br />Press the BACK button on your browser.</h4>');
}

if ((!isset($_POST['process'])) || ($_POST['process'] != 1)) {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}
if (!isset($_POST['submit'])) {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}

if ($_POST['submit'] == 'Reset') {
    RedirectUser($_POST['referer']);
}
if ($_POST['submit'] == 'Cancel') {
    RedirectUser('vconfig.php');
}

$newConfig = $CONFIG;

if ((isset($_POST['telnet']))        && ($_POST['telnet']        != $CONFIG['telnet']))        $newConfig['telnet']        = $_POST['telnet'];
if ((isset($_POST['hostname']))      && ($_POST['hostname']      != $CONFIG['hostname']))      $newConfig['hostname']      = $_POST['hostname'];
if ((isset($_POST['filehost']))      && ($_POST['filehost']      != $CONFIG['filehost']))      $newConfig['filehost']      = $_POST['filehost'];
if ((isset($_POST['bbsdir']))        && ($_POST['bbsdir']        != $CONFIG['bbsdir']))        $newConfig['bbsdir']        = $_POST['bbsdir'];
if ((isset($_POST['syspass']))       && ($_POST['syspass']       != $CONFIG['syspass'])        && ($_POST['syspass']       != ''))  { $newConfig['syspass']    = $_POST['syspass'];    } else if (!isset($_POST['syspass']))    $newConfig['syspass']    = 0;
if ((isset($_POST['webmaster']))     && ($_POST['webmaster']     != $CONFIG['webmaster']))     $newConfig['webmaster']     = $_POST['webmaster'];
if ((isset($_POST['guestacct']))     && ($_POST['guestacct']     != $CONFIG['guestacct']))     $newConfig['guestacct']     = (integer) $_POST['guestacct'];
if ((isset($_POST['usersl']))        && ($_POST['usersl']        != $CONFIG['usersl']))        $newConfig['usersl']        = (integer) $_POST['usersl'];
if ((isset($_POST['useraccflags']))  && ($_POST['useraccflags']  != $CONFIG['useraccflags']))  $newConfig['useraccflags']  = $_POST['useraccflags'];
if ((isset($_POST['userage']))       && ($_POST['userage']       != $CONFIG['userage']))       $newConfig['userage']       = (integer) $_POST['userage'];
if ((isset($_POST['purgetime']))     && ($_POST['purgetime']     != $CONFIG['purgetime']))     $newConfig['purgetime']     = (integer) $_POST['purgetime'];
if ((isset($_POST['purgeminlevel'])) && ($_POST['purgeminlevel'] != $CONFIG['purgeminlevel'])) $newConfig['purgeminlevel'] = (integer) $_POST['purgeminlevel'];
if ((isset($_POST['purgemaxlevel'])) && ($_POST['purgemaxlevel'] != $CONFIG['purgemaxlevel'])) $newConfig['purgemaxlevel'] = (integer) $_POST['purgemaxlevel'];
if ((isset($_POST['newuserreq']))    && ($_POST['newuserreq']    != $CONFIG['newuserreq']))    $newConfig['newuserreq']    = (integer) $_POST['newuserreq'];
if ((isset($_POST['banned']))        && ($_POST['banned']        != $CONFIG['banned']))        $newConfig['banned']        = $_POST['banned'];
if ((isset($_POST['refresh']))       && ($_POST['refresh']       != $CONFIG['refresh']))       $newConfig['refresh']       = (integer) $_POST['refresh'];
if ((isset($_POST['cookielife']))    && ($_POST['cookielife']    != $CONFIG['cookielife']))    $newConfig['cookielife']    = (integer) $_POST['cookielife'];
if ((isset($_POST['fileupload']))    && ($_POST['fileupload']    != $CONFIG['fileupload'])     && ($_POST['fileupload']    != ''))  { $newConfig['fileupload'] = $_POST['fileupload']; } else if (!isset($_POST['fileupload'])) $newConfig['fileupload'] = 0;
if ((isset($_POST['fileuploadsl']))  && ($_POST['fileuploadsl']  != $CONFIG['fileuploadsl']))  $newConfig['fileuploadsl']  = (integer) $_POST['fileuploadsl'];
if ((isset($_POST['sslredirect']))   && ($_POST['sslredirect']   != $CONFIG['sslredirect']))   $newConfig['sslredirect']   = $_POST['sslredirect'];
if ((isset($_POST['newslist']))      && ($_POST['newslist']      != $CONFIG['newslist'])       && ($_POST['newslist']      != ''))  { $newConfig['newslist']   = $_POST['newslist'];   } else if (!isset($_POST['newslist']))   $newConfig['newslist']   = 0;
if ((isset($_POST['postitnt']))      && ($_POST['postitnt']      != $CONFIG['postitnt'])       && ($_POST['postitnt']      != ''))  { $newConfig['postitnt']   = $_POST['postitnt'];   } else if (!isset($_POST['postitnt']))   $newConfig['postitnt']   = 0;
if ((isset($_POST['sysnews']))       && ($_POST['sysnews']       != $CONFIG['sysnews'])        && ($_POST['sysnews']       != ''))  { $newConfig['sysnews']    = $_POST['sysnews'];    } else if (!isset($_POST['sysnews']))    $newConfig['sysnews']    = 0;

if (isset($newConfig)) {
    WriteConfig($newConfig);
}

RedirectUser($_POST['referer']);

?>