<?php
/*
 * ----------------------------------------------------------------------------
 * VConfig_VADV-PHP.php                                              10/14/2006
 * VADV-PHP Configuration
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'SysOp Function';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.

if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct']) ||
    ($USER['securitylevel'] == 0)) {
    die(VA_LoginError());
}
if ($USER['securitylevel'] < 255) {
    $log = 'VConfig Error!  "' . $USER['handle'] . '" - Attempted Unauthorized VConfig Entry';
    WriteLog('VADV-PHP.LOG', $log);
    RedirectUser($rootDir . 'index.php');
}

// Check for system password.
if ($CONFIG['syspass']) {
    if (isset($_SESSION['systempw'])) {
        if ($_SESSION['systempw'] !== $VA_MAIN['systempw']) {
            RedirectUser($rootDir . 'index.php');
        }
    } else {
        RedirectUser('systemlogin.php?url=' . urlencode(GetCurrentURL()));
    }
}

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>VADV-PHP VConfig (VADV-PHP Configuration)</title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<link rel="stylesheet" type="text/css" href="VCONFIG.css">
<script language="JavaScript" type="text/javascript">
<!--
    function HelpWindow(bmark) {
        var url = "<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#" + bmark;
        var newwindow = window.open(url, "helpwindow", "toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=no, width=350, height=450");
        newwindow.focus();
    }
//-->
</script>
</head>

<body bgcolor="#000000">

<div align="center">
    <center>
    <table border="1" cellpadding="5" cellspacing="0" width="750" bgcolor="#000080" bordercolor="#FFFFFF">
        <tr>
            <td>
                <table border="0" cellspacing="0" style="border-collapse: collapse" cellpadding="5" bgcolor="#000080" width="100%">
                    <tr>
                        <td align="center">
                            <table border="0" style="border-collapse: collapse" cellpadding="5" cellspacing="0">
                                <tr>
                                    <td class="heading" align="center" height="40" colspan="2">
                                        VADV-PHP Configuration
                                    </td>
                                </tr>
                                <tr>
                                    <td class="footer" align="center" height="40" colspan="2">
                                        <a class="footer" href="vconfig.php">Exit to VADV-PHP VConfig</a><br />
                                        <a class="footer" href="<?php print $rootDir; ?>index.php">Exit to BBS&#39;s VADV-PHP Page</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2" height="25"></td>
                                </tr>
                                <form name="vadvphp" method="post" action="vconfig_vadv-php_process.php">
                                    <input type="hidden" name="process" value="1">
                                    <input type="hidden" name="referer" value="<?php print GetCurrentURL(); ?>">
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Required VADV-PHP Settings
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'telnet\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#telnet" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            BBS Telnet Address:</td>
                                        <td align="left"><input type="text" name="telnet" size="40" value="<?php print $CONFIG['telnet']; ?>" tabindex="1"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'hostname\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#hostname" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Hostname (If Required):</td>
                                        <td align="left"><input type="text" name="hostname" size="40" value="<?php print $CONFIG['hostname']; ?>" tabindex="2"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'filehost\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#filehost" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            File Hostname (If Required):</td>
                                        <td align="left"><input type="text" name="filehost" size="40" value="<?php print $CONFIG['filehost']; ?>" tabindex="3"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'bbsdir\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#bbsdir" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            BBS Directory:</td>
                                        <td align="left"><input type="text" name="bbsdir" size="40" value="<?php print $CONFIG['bbsdir']; ?>" tabindex="4"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'syspass\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#syspass" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            System Password Required:</td>
                                        <td align="left"><input type="checkbox" name="syspass" value="1" <?php if ($CONFIG['syspass'] == 1) print 'checked'; ?> tabindex="5"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'webmaster\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#webmaster" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Webmaster Email:</td>
                                        <td align="left"><input type="text" name="webmaster" size="40" value="<?php print $CONFIG['webmaster']; ?>" tabindex="6"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Default User Settings
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'guestacct\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#guestacct" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Guest Account Number (Optional):</td>
                                        <td align="left"><input type="text" name="guestacct" size="3" maxlength="3" value="<?php print $CONFIG['guestacct']; ?>" tabindex="7"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'usersl\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#usersl" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Web User Security Level:</td>
                                        <td align="left"><input type="text" name="usersl" size="3" maxlength="3" value="<?php print $CONFIG['usersl']; ?>" tabindex="8"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'useraccflags\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#useraccflags" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Web User Access Flags:</td>
                                        <td align="left"><input type="text" name="useraccflags" size="26" maxlength="26" value="<?php print $CONFIG['useraccflags']; ?>" tabindex="9"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'userage\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#userage" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Web User Age:</td>
                                        <td align="left"><input type="text" name="userage" size="2" maxlength="2" value="<?php print $CONFIG['userage']; ?>" tabindex="10"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Other VADV-PHP Settings
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'purgetime\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#purgetime" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            User Account Purge Time (Days):</td>
                                        <td align="left"><input type="text" name="purgetime" size="5" maxlength="5" value="<?php print $CONFIG['purgetime']; ?>" tabindex="11"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'purgeminlevel\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#purgeminlevel" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Purge Minimum Security Level:</td>
                                        <td align="left"><input type="text" name="purgeminlevel" size="3" maxlength="3" value="<?php print $CONFIG['purgeminlevel']; ?>" tabindex="12"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'purgemaxlevel\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#purgemaxlevel" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Purge Maximum Security Level:</td>
                                        <td align="left"><input type="text" name="purgemaxlevel" size="3" maxlength="3" value="<?php print $CONFIG['purgemaxlevel']; ?>" tabindex="13"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'newuserreq\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#newuserreq" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Required New User Information:</td>
                                        <td align="left"><input type="text" name="newuserreq" size="5" maxlength="5" value="<?php print $CONFIG['newuserreq']; ?>" tabindex="14"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'banned\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#banned" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Banned Account Numbers:</td>
                                        <td align="left"><input type="text" name="banned" size="40" value="<?php if ($CONFIG['guestacct'] > 0) {print substr($CONFIG['banned'], (strlen($CONFIG['guestacct']) + 1));} else {print $CONFIG['banned'];} ?>" tabindex="15"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'refresh\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#refresh" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Page Refresh (Seconds):</td>
                                        <td align="left"><input type="text" name="refresh" size="3" maxlength="3" value="<?php print $CONFIG['refresh']; ?>" tabindex="16"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'cookielife\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#cookielife" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Cookie Life (Days):</td>
                                        <td align="left"><input type="text" name="cookielife" size="3" maxlength="3" value="<?php print $CONFIG['cookielife']; ?>" tabindex="17"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'fileupload\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#fileupload" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            File Uploads:</td>
                                        <td align="left"><input type="checkbox" name="fileupload" value="1" <?php if ($CONFIG['fileupload'] == 1) print 'checked'; ?> tabindex="18"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'fileuploadsl\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#fileuploadsl" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            File Uploads Security Level:</td>
                                        <td align="left"><input type="text" name="fileuploadsl" size="3" maxlength="3" value="<?php print $CONFIG['fileuploadsl']; ?>" tabindex="19"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'sslredirect\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#sslredirect" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            SSL Enabled Site:</td>
                                        <td align="left"><input type="text" name="sslredirect" size="40" value="<?php print $CONFIG['sslredirect']; ?>" tabindex="20"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            AT2k Script Options
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'newslist\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#newslist" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            NewsList Support:</td>
                                        <td align="left"><input type="checkbox" name="newslist" value="1" <?php if ($CONFIG['newslist'] == 1) print 'checked'; ?> tabindex="21"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'postitnt\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#postitnt" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Post-It! Network Support:</td>
                                        <td align="left"><input type="checkbox" name="postitnt" value="1" <?php if ($CONFIG['postitnt'] == 1) print 'checked'; ?> tabindex="22"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'sysnews\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_vadv-php_help.php#sysnews" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            System News Support:</td>
                                        <td align="left"><input type="checkbox" name="sysnews" value="1" <?php if ($CONFIG['sysnews'] == 1) print 'checked'; ?> tabindex="23"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="center" colspan="2">
                                            <input type="submit" value="Apply" name="submit" tabindex="23">
                                            <input type="reset" value="Reset" name="submit" tabindex="24">
                                            <input type="submit" value="Cancel" name="submit" tabindex="25">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="footer" align="center" height="40" colspan="2">
                                            <a class="footer" href="vconfig.php">Exit to VADV-PHP VConfig</a><br />
                                            <a class="footer" href="<?php print $rootDir; ?>index.php">Exit to BBS&#39;s VADV-PHP Page</a>
                                        </td>
                                    </tr>
                                </form>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    </center>
</div>

</body>

</html>