<?php
/*
 * ----------------------------------------------------------------------------
 * VConfig_Main.php                                                  10/14/2006
 * VConfig's main configuration.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'SysOp Function';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Get current main configuration.

if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct']) ||
    ($USER['securitylevel'] == 0)) {
    die(VA_LoginError());
}
if ($USER['securitylevel'] < 255) {
    $log = 'VConfig Error!  "' . $USER['handle'] . '" - Attempted Unauthorized VConfig Entry';
    WriteLog('VADV-PHP.LOG', $log);
    RedirectUser($rootDir . 'index.php');
}

// Check for system password.
if ($CONFIG['syspass']) {
    if (isset($_SESSION['systempw'])) {
        if ($_SESSION['systempw'] !== $VA_MAIN['systempw']) {
            RedirectUser($rootDir . 'index.php');
        }
    } else {
        RedirectUser('systemlogin.php?url=' . urlencode(GetCurrentURL()));
    }
}

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>VADV-PHP VConfig (Main Configuration)</title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<link rel="stylesheet" type="text/css" href="VCONFIG.css">
<script language="JavaScript" type="text/javascript">
<!--
    function HelpWindow(bmark) {
        var url = "<?php print $rootDir; ?>help/vconfig_main_help.php#" + bmark;
        var newwindow = window.open(url, "helpwindow", "toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=no, width=350, height=450");
        newwindow.focus();
    }
//-->
</script>
</head>

<body link="#FFFFFF" vlink="#FFFFFF" bgcolor="#000000">

<div align="center">
    <center>
    <table border="1" cellpadding="5" cellspacing="0" width="750" bgcolor="#000080" bordercolor="#FFFFFF">
        <tr>
            <td>
                <table border="0" cellspacing="0" style="border-collapse: collapse" cellpadding="5" bgcolor="#000080" width="100%">
                    <tr>
                        <td align="center">
                            <table border="0" style="border-collapse: collapse" cellpadding="5" cellspacing="0">
                                <tr>
                                    <td class="heading" align="center" height="40" colspan="2">
                                        Main Configuration
                                    </td>
                                </tr>
                                <tr>
                                    <td class="footer" align="center" height="40" colspan="2">
                                        <a class="footer" href="vconfig.php">Exit to VADV-PHP VConfig</a><br />
                                        <a class="footer" href="<?php print $rootDir; ?>index.php">Exit to BBS&#39;s VADV-PHP Page</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2" height="25"></td>
                                </tr>
                                <form name="maincfg" method="post" action="vconfig_main_process.php">
                                    <input type="hidden" name="process" value="1">
                                    <input type="hidden" name="referer" value="<?php print GetCurrentURL(); ?>">
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            General Settings
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'bbsname\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#bbsname" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            BBS Name:</td>
                                        <td align="left"><input type="text" name="bbsname" size="40" maxlength="40" value="<?php print $VA_MAIN['bbsname']; ?>" tabindex="1"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'sysopname\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#sysopname" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Sysop Name:</td>
                                        <td align="left"><input type="text" name="sysopname" size="40" maxlength="40" value="<?php print $VA_MAIN['sysopname']; ?>" tabindex="2"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'timezone\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#timezone" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Local Time Zone:</td>
                                        <td align="left"><input type="text" name="timezone" size="12" maxlength="12" value="<?php print $VA_MAIN['timezone']; ?>" tabindex="3"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'wfcdrives\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#wfcdrives" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            WFC Drive List:</td>
                                        <td align="left"><input type="text" name="wfcdrives" size="5" maxlength="5" value="<?php print $VA_MAIN['wfcdrives']; ?>" tabindex="4"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'phoneformat\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#phoneformat" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Phone Number Format:</td>
                                        <td align="left"><input type="text" name="phoneformat" size="24" maxlength="24" value="<?php print $VA_MAIN['phoneformat']; ?>" tabindex="5"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'netlowtime\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#netlowtime" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Net Low Time:</td>
                                        <td align="left"><input type="text" name="netlowtime" size="5" maxlength="5" value="<?php print $VA_MAIN['netlowtime']; ?>" tabindex="6"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'nethightime\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#nethightime" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Net High Time:</td>
                                        <td align="left"><input type="text" name="nethightime" size="5" maxlength="5" value="<?php print $VA_MAIN['nethightime']; ?>" tabindex="7"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'qwkfilename\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#qwkfilename" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            QWK Packet Filename:</td>
                                        <td align="left"><input type="text" name="qwkfilename" size="8" maxlength="8" value="<?php print $VA_MAIN['qwkfilename']; ?>" tabindex="8"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Feature Settings
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'tossopt\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#tossopt" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Tossing Options:</td>
                                        <td align="left">
                                            <select size="1" name="tossopt" tabindex="9">
                                                <option value="0" <?php if ($VA_MAIN['tossopt'] == 0) print "selected"; ?>>Standard</option>
                                                <option value="1" <?php if ($VA_MAIN['tossopt'] == 1) print "selected"; ?>>Direct</option>
                                                <option value="2" <?php if ($VA_MAIN['tossopt'] == 2) print "selected"; ?>>Background</option>
                                                <option value="3" <?php if ($VA_MAIN['tossopt'] == 3) print "selected"; ?>>Direct Background</option>
                                                <option value="4" <?php if ($VA_MAIN['tossopt'] == 4) print "selected"; ?>>LoadSense</option>
                                                <option value="5" <?php if ($VA_MAIN['tossopt'] == 5) print "selected"; ?>>Direct LoadSense</option>
                                                <option value="6" <?php if ($VA_MAIN['tossopt'] == 6) print "selected"; ?>>Background LoadSense</option>
                                                <option value="7" <?php if ($VA_MAIN['tossopt'] == 7) print "selected"; ?>>Direct Background LoadSense</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'uploadscan\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#uploadscan" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            New Upload Scanner:</td>
                                        <td align="left">
                                            <select size="1" name="uploadscan" tabindex="10">
                                                <option value="0" <?php if ($VA_MAIN['uploadscan'] == 0) print "selected"; ?>>Disabled</option>
                                                <option value="1" <?php if ($VA_MAIN['uploadscan'] == 1) print "selected"; ?>>Scan & Warn</option>
                                                <option value="2" <?php if ($VA_MAIN['uploadscan'] == 2) print "selected"; ?>>Scan & Delete</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'logdetail\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#logdetail" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Log Level:</td>
                                        <td align="left">
                                            <select size="1" name="logdetail" tabindex="11">
                                                <option value="0" <?php if ($VA_MAIN['logdetail'] == 0) print "selected"; ?>>Normal</option>
                                                <option value="1" <?php if ($VA_MAIN['logdetail'] == 1) print "selected"; ?>>Extended</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'logoffbat\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#logoffbat" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Logoff BAT/CMD:</td>
                                        <td align="left">
                                            <select size="1" name="logoffbat" tabindex="12">
                                                <option value="0" <?php if ($VA_MAIN['logoffbat'] == 0) print "selected"; ?>>Disabled</option>
                                                <option value="1" <?php if ($VA_MAIN['logoffbat'] == 1) print "selected"; ?>>Channel 1 Only</option>
                                                <option value="2" <?php if ($VA_MAIN['logoffbat'] == 2) print "selected"; ?>>All Channels</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'multitasker\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#multitasker" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Multitasker:</td>
                                        <td align="left">
                                            <select size="1" name="multitasker" tabindex="13">
                                                <option value="0" <?php if ($VA_MAIN['multitasker'] == 0) print "selected"; ?>>Disabled</option>
                                                <option value="1" <?php if ($VA_MAIN['multitasker'] == 1) print "selected"; ?>>Desqview</option>
                                                <option value="2" <?php if ($VA_MAIN['multitasker'] == 2) print "selected"; ?>>Windows or OS/2</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'allowhandle\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#allowhandle" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Allow Handles</td>
                                        <td align="left"><input type="checkbox" name="allowhandle" value="1" <?php if ($VA_MAIN['allowhandle'] == 1) print "checked"; ?> tabindex="14"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'needwfcpw\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#needwfcpw" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            System PW at WFC</td>
                                        <td align="left"><input type="checkbox" name="needwfcpw" value="1" <?php if ($VA_MAIN['needwfcpw'] == 1) print "checked"; ?> tabindex="15"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'ignoreext\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#ignoreext" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Ignore Extensions</td>
                                        <td align="left"><input type="checkbox" name="ignoreext" value="1" <?php if ($VA_MAIN['ignoreext'] == 1) print "checked"; ?> tabindex="16"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'forcefilename\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#forcefilename" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Require Filename Entry</td>
                                        <td align="left"><input type="checkbox" name="forcefilename" value="1" <?php if ($VA_MAIN['forcefilename'] == 1) print "checked"; ?> tabindex="17"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'inversebar\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#inversebar" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Inverse Bar</td>
                                        <td align="left"><input type="checkbox" name="inversebar" value="1" <?php if ($VA_MAIN['inversebar'] == 1) print "checked"; ?> tabindex="18"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'displaynet\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#displaynet" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Display Networks</td>
                                        <td align="left"><input type="checkbox" name="displaynet" value="1" <?php if ($VA_MAIN['displaynet'] == 1) print "checked"; ?> tabindex="19"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'forcefeedback\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#forcefeedback" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Force Feedback</td>
                                        <td align="left"><input type="checkbox" name="forcefeedback" value="1" <?php if ($VA_MAIN['forcefeedback'] == 1) print "checked"; ?> tabindex="20"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'checkpolls\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#checkpolls" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Auto-Check Polls</td>
                                        <td align="left"><input type="checkbox" name="checkpolls" value="1" <?php if ($VA_MAIN['checkpolls'] == 1) print "checked"; ?> tabindex="21"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'directmail\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#directmail" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Allow DIRECTmail</td>
                                        <td align="left"><input type="checkbox" name="directmail" value="1" <?php if ($VA_MAIN['directmail'] == 1) print "checked"; ?> tabindex="22"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'secuploads\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#secuploads" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Secure Uploads</td>
                                        <td align="left"><input type="checkbox" name="secuploads" value="1" <?php if ($VA_MAIN['secuploads'] == 1) print "checked"; ?> tabindex="23"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'sysfkey\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#sysfkey" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            SysOp F-Key Lockout</td>
                                        <td align="left"><input type="checkbox" name="sysfkey" value="1" <?php if ($VA_MAIN['sysfkey'] == 1) print "checked"; ?> tabindex="24"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'detectfido\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#detectfido" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Detect FIDOnet</td>
                                        <td align="left"><input type="checkbox" name="detectfido" value="1" <?php if ($VA_MAIN['detectfido'] == 1) print "checked"; ?> tabindex="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'allowremote\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#allowremote" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Allow Remote SysOp</td>
                                        <td align="left"><input type="checkbox" name="allowremote" value="1" <?php if ($VA_MAIN['allowremote'] == 1) print "checked"; ?> tabindex="26"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Security Levels
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'autopostsl\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#autopostsl" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Autopost:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Autopost Security Level" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" i-maximum-length="3" s-validation-constraint="Less than or equal to" s-validation-value="255" -->
                                            <input type="text" name="autopostsl" size="3" maxlength="3" value="<?php print $VA_MAIN['autopostsl']; ?>" tabindex="27">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'emlothers\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#emlothers" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Email Others:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Email Others Security Level" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" i-maximum-length="3" s-validation-constraint="Less than or equal to" s-validation-value="255" -->
                                            <input type="text" name="emlothers" size="3" maxlength="3" value="<?php print $VA_MAIN['emlothers']; ?>" tabindex="28">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'emlsysfile\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#emlsysfile" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Email SysOp Att File:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Email SysOp Security Level" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" i-maximum-length="3" s-validation-constraint="Less than or equal to" s-validation-value="255" -->
                                            <input type="text" name="emlsysfile" size="3" maxlength="3" value="<?php print $VA_MAIN['emlsysfile']; ?>" tabindex="29">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'emlotherfile\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#emlotherfile" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Email Others Att File:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Email Others Att File Security Level" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" i-maximum-length="3" s-validation-constraint="Less than or equal to" s-validation-value="255" -->
                                            <input type="text" name="emlotherfile" size="3" maxlength="3" value="<?php print $VA_MAIN['emlotherfile']; ?>" tabindex="30">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'multimail\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#multimail" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            MultiMail:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="MultiMail Security Level" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" i-maximum-length="3" s-validation-constraint="Less than or equal to" s-validation-value="255" -->
                                            <input type="text" name="multimail" size="3" maxlength="3" value="<?php print $VA_MAIN['multimail']; ?>" tabindex="31">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'carboncopy\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#carboncopy" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Email Carbon Copy:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Email Carbon Copy Security Level" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" i-maximum-length="3" s-validation-constraint="Less than or equal to" s-validation-value="255" -->
                                            <input type="text" name="carboncopy" size="3" maxlength="3" value="<?php print $VA_MAIN['carboncopy']; ?>" tabindex="32">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            New User Defaults
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'newusersl\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#newusersl" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Security Level:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="New User Security Level" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" i-maximum-length="3" s-validation-constraint="Less than or equal to" s-validation-value="255" -->
                                            <input type="text" name="newusersl" size="3" maxlength="3" value="<?php print $VA_MAIN['newusersl']; ?>" tabindex="33">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'newusertime\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#newusertime" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Time Limit:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="New User Time Limit" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" i-maximum-length="4" s-validation-constraint="Less than or equal to" s-validation-value="1440" -->
                                            <input type="text" name="newusertime" size="5" maxlength="4" value="<?php print $VA_MAIN['newusertime']; ?>" tabindex="34">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'nucredits\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#nucredits" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Credits:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="New User Credits" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" -->
                                            <input type="text" name="nucredits" size="5" maxlength="4" value="<?php print $VA_MAIN['nucredits']; ?>" tabindex="35">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Credit Accounting
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'creditcost\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#creditcost" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Cost per Minute:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Credit Cost per Minute" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" -->
                                            <input type="text" name="creditcost" size="5" maxlength="3" value="<?php print $VA_MAIN['creditcost']; ?>" tabindex="36">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'credperdlk\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#credperdlk" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Cost per Download KB:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Credit Cost per Download KB" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" -->
                                            <input type="text" name="credperdlk" size="5" maxlength="4" value="<?php print $VA_MAIN['credperdlk']; ?>" tabindex="37">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'credperpost\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#credperpost" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Given per Post:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Credits Given per Upload KB" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" -->
                                            <input type="text" name="credperpost" size="5" maxlength="4" value="<?php print $VA_MAIN['credperpost']; ?>" tabindex="38">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'credperuplk\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#credperuplk" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Given per Upload KB:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Credits Given per Minute" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" -->
                                            <input type="text" name="credperuplk" size="5" maxlength="4" value="<?php print $VA_MAIN['credperuplk']; ?>" tabindex="39">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Call Back Verifier
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'cbvsl\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#cbvsl" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Security Level:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="CBV Security Level" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" i-maximum-length="3" s-validation-constraint="Less than or equal to" s-validation-value="255" -->
                                            <input type="text" name="cbvsl" size="3" maxlength="3" value="<?php print $VA_MAIN['cbvsl']; ?>" tabindex="40">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'cbvtime\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#cbvtime" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Time Limit:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="CBV Time Limit" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" i-maximum-length="4" s-validation-constraint="Less than or equal to" s-validation-value="1440" -->
                                            <input type="text" name="cbvtime" size="5" maxlength="4" value="<?php print $VA_MAIN['cbvtime']; ?>" tabindex="41">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Auto-SysOp Validation
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'autosysopsl\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#autosysopsl" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Security Level:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Auto-SysOp Security Level" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" i-maximum-length="3" s-validation-constraint="Less than or equal to" s-validation-value="255" -->
                                            <input type="text" name="autosysopsl" size="3" maxlength="3" value="<?php print $VA_MAIN['autosysopsl']; ?>" tabindex="42">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'autosysoptime\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#autosysoptime" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Time Limit:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Auto-SysOp Time Limit" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" i-maximum-length="4" s-validation-constraint="Less than or equal to" s-validation-value="1440" -->
                                            <input type="text" name="autosysoptime" size="5" maxlength="4" value="<?php print $VA_MAIN['autosysoptime']; ?>" tabindex="43">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Miscellaneous
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'timeout\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#timeout" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Inactivity TimeOut:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Inactivity TimeOut" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" -->
                                            <input type="text" name="timeout" size="8" maxlength="8" value="<?php print $VA_MAIN['timeout']; ?>" tabindex="44">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'sblank\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#sblank" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Blank WFC Screen:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Blank WFC Screen" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" -->
                                            <input type="text" name="sblank" size="5" maxlength="4" value="<?php print $VA_MAIN['sblank']; ?>" tabindex="45">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'reservekb\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#reservekb" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Reserve Space (KB):</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Reserve Space (KB)" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" -->
                                            <input type="text" name="reservekb" size="5" maxlength="5" value="<?php print $VA_MAIN['reservekb']; ?>" tabindex="46">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'maxchannelno\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#maxchannelno" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            # of Active Channels:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="# of Active Channels" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" i-maximum-length="100" -->
                                            <input type="text" name="maxchannelno" size="5" maxlength="3" value="<?php print $VA_MAIN['maxchannelno']; ?>" tabindex="47">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'polldelay\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#polldelay" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Network Poll Delay:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Network Poll Delay" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" -->
                                            <input type="text" name="polldelay" size="5" maxlength="4" value="<?php print $VA_MAIN['polldelay']; ?>" tabindex="48">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'qwklimit\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#qwklimit" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            QWK Message Limit:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="QWK Message Limit" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" -->
                                            <input type="text" name="qwklimit" size="5" maxlength="4" value="<?php print $VA_MAIN['qwklimit']; ?>" tabindex="49">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'mailholdtime\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#mailholdtime" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Mail Hold Time:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Mail Hold Time" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" -->
                                            <input type="text" name="mailholdtime" size="5" maxlength="5" value="<?php print $VA_MAIN['mailholdtime']; ?>" tabindex="50">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'maxtimebank\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#maxtimebank" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Max Time Bank:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Max Time Bank" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" -->
                                            <input type="text" name="maxtimebank" size="5" maxlength="4" value="<?php print $VA_MAIN['maxtimebank']; ?>" tabindex="51">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'redials\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#redials" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Redial Attempts:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Redial Attempts" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" -->
                                            <input type="text" name="redials" size="5" maxlength="4" value="<?php print $VA_MAIN['redials']; ?>" tabindex="52">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'ringtoanswer\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/vconfig_main_help.php#ringtoanswer" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Rings to Answer On:</td>
                                        <td align="left">
                                            <!--webbot bot="Validation" s-display-name="Rings to Answer On" s-data-type="Integer" s-number-separators="x" b-value-required="TRUE" i-minimum-length="1" -->
                                            <input type="text" name="ringtoanswer" size="5" maxlength="2" value="<?php print $VA_MAIN['ringtoanswer']; ?>" tabindex="53">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="center" colspan="2">
                                            <input type="submit" value="Apply" name="submit" tabindex="54">
                                            <input type="reset" value="Reset" name="submit" tabindex="55">
                                            <input type="submit" value="Cancel" name="submit" tabindex="56">
                                        </td>
                                    </tr>
                                </form>
                                <tr>
                                    <td colspan="2" height="25"></td>
                                </tr>
                                <tr>
                                    <td class="footer" align="center" height="40" colspan="2">
                                        <a class="footer" href="vconfig.php">Exit to VADV-PHP VConfig</a><br />
                                        <a class="footer" href="<?php print $rootDir; ?>index.php">Exit to BBS&#39;s VADV-PHP Page</a>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    </center>
</div>

</body>

</html>