<?php
/*
 * ----------------------------------------------------------------------------
 * SystemLogin.php                                                   10/14/2006
 * This script will allow a user logged in as the SysOp to login with the
 * system password for added protection when using the VConfig scripts.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'SysOp Function';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.

if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct']) ||
    ($USER['securitylevel'] == 0)) {
    RedirectUser($rootDir . 'index.php');
}
if ($USER['securitylevel'] < 255) {
    $log = 'VConfig Error!  "' . $USER['handle'] . '" - Attempted Unauthorized VConfig Entry';
    WriteLog('VADV-PHP.LOG', $log);
    RedirectUser($rootDir . 'index.php');
}

// Process the form if already submitted...
if (((isset($_POST['password'])) && (trim($_POST['password']) != '')) ||
    ((isset($_POST['md5'])) && (trim($_POST['md5']) != ''))) {
    if (!isset($_POST['referer'])) {
        die('<br /><h4>An error occurred. Please press the BACK button on your browser.</h4>');
    }

    if ((isset($_POST['md5'])) && (trim($_POST['md5']) != '')) {    // MD5 authentication.
        $md5 = substr(trim($_POST['md5']), 5);      // Remove identifier.
        $loginId = '';
        for ($x = 1; $x <= $VA_USERS[0]; $x++) {    // Get user id.
            if ($VA_USERS[$x]['session'] == session_id()) {
                $loginId = $VA_USERS[$x]['id'];
                break;
            }
        }
        UpdateWhosOnline('Logging In...', 900, 1);  // Reset the id.
        if (hmac_md5($loginId, $VA_MAIN['systempw']) === $md5) {
            $password = $VA_MAIN['systempw'];       // Set password as correct.
        } else {
            $password = '';
        }
    } else {
        $password = strtoupper(trim(htmlspecialchars($_POST['password'])));
        if (strlen($password) > 16) {
            $password = substr($password, 0, 16);
        }
        $password = md5($password);
    }

    if ($password === $VA_MAIN['systempw']) {
        $_SESSION['systempw'] = $password;
        if (isset($_POST['url'])) {
            RedirectUser($_POST['url']);
        } else {
            RedirectUser($rootDir . 'index.php');
        }
    } else {
        setcookie('vadvphp', '', time() - 86400, '/', '', 0);
        $_SESSION = array('');
        session_destroy();
        RedirectUser($rootDir . 'index.php');
    }
}

// Get login id for this session...
$loginId = '';
for ($x = 1; $x <= $VA_USERS[0]; $x++) {
    if ($VA_USERS[$x]['session'] == session_id()) {
        $loginId = $VA_USERS[$x]['id'];
        break;
    }
}

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[VADV-PHP System Login] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<style type="text/css">
<!--
a.infoBarBody:link    { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.infoBarBody:visited { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.navBar:link         { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.navBar:visited      { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.return:link         { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
a.return:visited      { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
.infoBarBody          { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; }
.navbar               { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
.return               { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
.yellowTitle          { font-family: Verdana, Arial, Helvetica; font-size: 14pt; color: #FFFF00; font-weight:bold; font-style:italic }
-->
</style>

<script language="JavaScript" type="text/javascript" src="<?php print $rootDir; ?>md5.js"></script>
<script language="JavaScript" type="text/javascript">
<!--
    var submitted = 0;
    function validate(form) {
        if (submitted == 0) {
            form.md5.value = form.password.value.toUpperCase();
            form.md5.value = hex_md5(form.md5.value);
            form.md5.value = "|md5|" + hex_hmac_md5(form.id.value, form.md5.value);
            form.password.value = "";
            form.id.value = "";
            submitted = 1;
            return true;
        } else {
            return false;
        }
    }
//-->
</script>
</head>

<body bgcolor="#000000" onload="document.login.password.focus();">

<div align="center">
    <center>
    <table border="1" width="640" cellspacing="0" cellpadding="5" bgcolor="#000080" bordercolor="#FFFFFF">
        <tr>
            <td align="center" valign="top">
                <p class="yellowTitle"><?php print HtmlSpace($VA_MAIN['bbsname']); ?>'s VADV-PHP System Login</p>
                <table cellspacing="1" width="100%">
                    <tr>
                        <td valign="top">
                            <p align="center">
                                <a class="return" href="<?php print $rootDir; ?>index.php">Return to main BBS page.</a>
                            </p>
                            <?php print '<p class="infoBarBody" align="center">You are attempting to enter VConfig. You must provide the system password.</p>' . "\n"; ?>
                            <div align="center">
                            <center>
                                <table width="240" cellspacing="0" border="0" cellpadding="2">
                                    <form name="login" method="POST" action="systemlogin.php" onsubmit="return validate(login)">
                                        <input type="hidden" name="referer" value="<?php print GetCurrentURL(0); ?>">
                                        <script language="JavaScript" type="text/javascript">
                                        <!--
                                            document.write('<input type="hidden" name="id" value="<?php print $loginId; ?>">');
                                            document.write('<input type="hidden" name="md5" value="">');
                                        -->
                                        </script>
                                        <?php
                                        if (isset($_GET['url'])) {
                                            print '<input type="hidden" name="url" value="' . $_GET['url'] . '">' . "\n";
                                        }
                                        ?>
                                        <noscript>
                                            <tr>
                                                <td class="loginboxmsg" align="center" colspan="2">
                                                    Enable JavaScript for a more secure login!
                                                </td>
                                            </tr>
                                        </noscript>
                                        <tr>
                                            <td class="infoBarBody" align="left" width="50%">
                                                System Password:
                                            </td>
                                            <td align="left" width="50%">
                                                <input type="password" name="password" size="12" maxlength="16" tabindex="1">
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="infoBarBody" align="center" colspan="2" width="100%">
                                                <p><input type="image" name="submit" src="<?php print $rootDir; ?>images/login.gif" border="0" alt="Login!" width="54" height="25" tabindex="2"></p>
                                            </td>
                                        </tr>
                                    </form>
                                </table>
                            </center>
                            </div>
                        </td>
                    </tr>
                </table>
                <p><span class="navBar">This page is powered
                by <a class="navBar" href="http://www.vadvphp.com">VADV-PHP</a></span></p>
                <p class="infoBarBody">If you experience any problems
                with this website or need help, contact the
                <a class="infoBarBody" href="mailto:<?php print $CONFIG['webmaster']; ?>">webmaster</a>.<br />
                VADV-PHP Copyright  2002-<?php print date('Y'); ?> Aspect
                Technologies. All Rights Reserved.</p>
            </td>
        </tr>
    </table>
    </center>
</div>

</body>

</html>