<?php
/*
 * ----------------------------------------------------------------------------
 * Register.inc.php                                                  10/02/2006
 * This script creates a new user account.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'New User Registration';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Database functions.
require_once($includeDir . 'va-main.inc.php');      // Main configuration.
require_once($includeDir . 'va-userfile.inc.php');  // User information.
require_once($includeDir . 'va-networks.inc.php');  // Network information.

if (!isset($_POST['submit'])) {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}

if ((!isset($_SERVER['HTTP_REFERER'])) ||
    (strpos($_SERVER['HTTP_REFERER'], $_SERVER['HTTP_HOST']) === FALSE)) {
    die('<br /><h4>You are not allowed to access this script from an outside source.<br />Press the BACK button on your browser.</h4>');
}

if ($_POST['submit'] == 'Cancel') {
    RedirectUser('vconfig.php');
}

if ($VA_MAIN['newuserpw'] != md5(strtoupper(''))) {
    die('<br /><h4>This BBS requires a new user password. Please connect to the BBS to create a new account. Press the BACK button on your browser.</h4>');
}

if ((!isset($_POST['username'])) ||
    (!isset($_POST['realname'])) ||
    (!isset($_POST['address'])) ||
    (!isset($_POST['city'])) ||
    (!isset($_POST['state'])) ||
    (!isset($_POST['zipcode'])) ||
    (!isset($_POST['voice'])) ||
    (!isset($_POST['data'])) ||
    (!isset($_POST['password'])) ||
    (!isset($_POST['verify'])) ||
    (!isset($_POST['bdaymonth'])) ||
    (!isset($_POST['bdayday'])) ||
    (!isset($_POST['bdayyear']))) {
    die('<br /><h4>Parameters are missing. Please press the BACK button on your browser.</h4>');
}

// Format the information.
$handle    = trim($_POST['username']);
$realname  = ucwords(trim(strtolower($_POST['realname'])));
$address   = ucwords(trim(strtolower($_POST['address'])));
$city      = ucwords(trim(strtolower($_POST['city'])));
$state     = trim(strtoupper($_POST['state']));
$zipcode   = trim($_POST['zipcode']);
$voice     = trim($_POST['voice']);
$data      = trim($_POST['data']);
$password  = trim(strtoupper($_POST['password']));
$verify    = trim(strtoupper($_POST['verify']));
$bdaymonth = (integer) $_POST['bdaymonth'];
$bdayday   = (integer) $_POST['bdayday'];
$bdayyear  = (integer) $_POST['bdayyear'];

// Fix the referer URL. Make sure there is no query string.
$url = parse_url($_POST['referer']);
$referer = $url['scheme'] . '://' . $url['host'] . $url['path'];
    
// Check the password.
if (($password == '') || ($password != $verify)) {
    RedirectUser($referer . '?error=password');
}

// Check the username.
if (($handle == '') ||
    (is_numeric($handle)) ||                // If it is a number.
    (FindHandle($handle) > 0) ||            // Check if it already exists.
    (strtolower($handle) == 'new') ||       // Handles not allowed.
    (strtolower($handle) == '!-*<deleted>*-!') ||
    (strtolower($handle) == 'guest') ||
    (strtolower($handle) == 'sysop') ||
    (strtolower($handle) == 'postmaster') ||
    (strtolower($handle) == 'webmaster') ||
    (strtolower($handle) == 'all') ||
    (strtolower($handle) == 'allusers') ||
    (strtolower($handle) == 'all users') ||
    (strtolower($handle) == 'info') ||
    (strtolower($handle) == 'help') ||
    (strtolower($handle) == 'support') ||
    (strtolower($handle) == 'bbs')) {
    RedirectUser($referer . '?error=username');
}
$file = $VA_SYSPATHS['text'] . '/TRASHCAN.TXT';
if (is_file($file)) {                       // Search for invalid words.
    $file = file($file);                    // Read the file.
    for ($x = 0; $x < count($file); $x++) {
        if (strpos(strtoupper($handle), trim(strtoupper($file[$x]))) !== FALSE) {
            RedirectUser($referer . '?error=username');
        }
    }
}

// Check for required information.
$required = ' ' . GetAccFlags($CONFIG['newuserreq']);   // Convert into a string.
if ((strpos($required, 'A') !== FALSE) && ($realname == '')) {
    RedirectUser($referer . '?error=realname');
}
if ((strpos($required, 'B') !== FALSE) && ($address == '')) {
    RedirectUser($referer . '?error=address');
}
if ((strpos($required, 'C') !== FALSE) && ($city == '')) {
    RedirectUser($referer . '?error=city');
}
if ((strpos($required, 'D') !== FALSE) && ($state == '')) {
    RedirectUser($referer . '?error=state');
}
if ((strpos($required, 'E') !== FALSE) && ($zipcode == '')) {
    RedirectUser($referer . '?error=zipcode');
}
if ((strpos($required, 'F') !== FALSE) && ($voice == '')) {
    RedirectUser($referer . '?error=voice');
}
if ((strpos($required, 'G') !== FALSE) && ($data == '')) {
    RedirectUser($referer . '?error=data');
}
if ((strpos($required, 'H') !== FALSE) &&
    (($bdaymonth == 0) || ($bdayday == 0) || ($bdayyear == 0))) {
    RedirectUser($referer . '?error=bday');
}

// Check the birthday date.
if ($bdaymonth == 0) {
    $bdaymonth = date("n");                 // If nothing is supplied,
}
if ($bdayday   == 0) {
    $bdayday   = date("j");                 // the user will be just born :)
}
if ($bdayyear  == 0) {
    $bdayyear  = date("Y");                 // So access maybe limited.
}
if (strlen($bdayyear) == 2) {
    $bdayyear = $bdayyear + 1900;
}
if ((($bdaymonth < 1)    || ($bdaymonth > 12)) ||
    (($bdayday   < 1)    || ($bdayday   > 31)) ||
    (($bdayyear  < 1900) || ($bdayyear > date("Y")))) {
    RedirectUser($referer . '?error=bdaydate');
}

// Setup user defaults.
$newUser['userno']        = FindNewAcct();
if ($VA_MAIN['allowhandle'] == 1) {         // Check allow handle setting.
    $newUser['handle']    = $handle;
} else {
    $newUser['handle']    = $realname;
}
$newUser['realname']      = $realname;
$newUser['address']       = $address;
$newUser['city']          = $city;
$newUser['state']         = $state;
$newUser['zipcode']       = $zipcode;
$newUser['phone1']        = $voice;
$newUser['phone2']        = $data;
$newUser['password']      = $password;
$newUser['mailfwdflag']   = 0;
$newUser['mailfwdhandle'] = '';
$newUser['mailfwduserno'] = 0;
$newUser['mailfwdnode']   = 0;
$newUser['mailfwdnetno']  = 0;
$newUser['lngdistcost']   = 0;
$newUser['lngdistacc']    = 0;
$newUser['sortfilelst']   = 0;
$newUser['pagebreak']     = 24;
$newUser['bdaymonth']     = $bdaymonth;
$newUser['bdayday']       = $bdayday;
$newUser['bdayyear']      = $bdayyear;
$newUser['accflags']      = '';
$newUser['flags']         = 'F';
$newUser['securitylevel'] = $VA_MAIN['newusersl'];
$newUser['laston']        = date("ymd");
$newUser['maxtime']       = $VA_MAIN['newusertime'];
$newUser['timecounter']   = 0;
$newUser['totalcalls']    = 0;
$newUser['totaltime']     = 0;
$newUser['videomode']     = 1;
$newUser['ratioexempt']   = 1;
$newUser['verifybday']    = 0;
$newUser['textcolor']     = 7;
$newUser['basecolor']     = 0;
$newUser['promptcolor']   = 2;
$newUser['inputcolor']    = 5;
$newUser['boxcolor']      = 5;
$newUser['mnuselcolor']   = 1;
$newUser['headercolor']   = 2;
$newUser['extra1']        = '';
$newUser['extra2']        = '';
$newUser['extra3']        = '';
$newUser['extra4']        = '';
$newUser['extra5']        = '';
$newUser['extra6']        = '';
$newUser['extra7']        = '';
$newUser['extra8']        = '';
$newUser['macro1']        = '';
$newUser['macro2']        = '';
$newUser['uplfiles']      = 0;
$newUser['uplkb']         = 0;
$newUser['dlfiles']       = 0;
$newUser['dlkb']          = 0;
$newUser['totalposts']    = 0;
$newUser['totalemail']    = 0;
$newUser['postsread']     = 0;
$newUser['timebank']      = 0;
$newUser['credits']       = $VA_MAIN['nucredits'];
$newUser['comment']       = 'VADV-PHP';
$newUser['protocol']      = 'Z';
$newUser['testid1']       = '';
$newUser['testid2']       = '';
$newUser['offsym']        = '';
$newUser['expdate']       = '';
$newUser['reserved']      = '';
$newUser['lastcalltime']  = time();
$newUser['liststyle']     = 2;
$newUser['extra']         = '';

// Delete any mail addressed to this account.
$db     = SetEmailInfo($newUser['userno']);
$msgcnt = $db['msgcnt']['msgno'];
$file   = $VA_SYSPATHS['db'] . '/' . $db['filename'] . '.DAT';
$fileString = ReadCfgFile($file);
$pos = 0;
for ($x = 1; (($x <= $db['msgno']) && ($msgcnt > 0)); $x++) {
    $db      = SetEmailInfo($newUser['userno']);
    $msgInfo = GetMessageInfo($db, $x, $fileString);
    if ($msgInfo['touserno'] == $newUser['userno']) {
        DeleteMessage($db, $x - $pos);
        $pos++;
    }
}

// Delete any sent email from this account.
$db     = SetSentEmailInfo($newUser['userno']);
$msgcnt = $db['msgcnt']['msgno'];
$file   = $VA_SYSPATHS['db'] . '/' . $db['filename'] . '.DAT';
$fileString = ReadCfgFile($file);
$pos = 0;
for ($x = 1; (($x <= $db['msgno']) && ($msgcnt > 0)); $x++) {
    $db      = SetSentEmailInfo($newUser['userno']);
    $msgInfo = GetMessageInfo($db, $x, $fileString);
    if ($msgInfo['fromuserno'] == $newUser['userno']) {
        DeleteMessage($db, $x - $pos);
        $pos++;
    }
}

// Delete any oneliners addressed to this account.
$db     = SetOnelinerInfo($newUser['userno']);
$msgcnt = $db['msgcnt']['msgno'];
$file   = $VA_SYSPATHS['db'] . '/' . $db['filename'] . '.DAT';
$fileString = ReadCfgFile($file);
$pos = 0;
for ($x = 1; (($x <= $db['msgno']) && ($msgcnt > 0)); $x++) {
    $db      = SetOnelinerInfo($newUser['userno']);
    $msgInfo = GetMessageInfo($db, $x, $fileString);
    if ($msgInfo['touserno'] == $newUser['userno']) {
        DeleteMessage($db, $x - $pos);
        $pos++;
    }
}

// Log the new user.
$log = 'New User Entry  "' . $newUser['handle'] . '" #' . $newUser['userno'];
WriteLog('VADV-PHP.LOG', $log);

// Write to userfile.dat.
$fileString = ReadUserfile();
$fileString = PutUser($fileString, $newUser['userno'], $newUser);
WriteUserfile($fileString);

// Write to userfile.idx.
$fileString = ReadUserfile_IDX();
$fileString = PutUser_IDX($fileString, $newUser['userno'], $newUser);
WriteUserfile_IDX($fileString);

// Write to handles.uip.
$netinfo = GetVnetInfo();
$handleuip['handle']  = str_replace(' ', '.', $newUser['handle']);
$handleuip['userno']  = $newUser['userno'];
$handleuip['netnode'] = $netinfo['systemid'];
$handleuip['netno']   = 1;
AddUserEmailInfo($newUser['userno'], $handleuip);

// Send the new user email if it exists.
$file = $VA_SYSPATHS['text'] . '/NEWUMAIL.TXT';
if (is_file($file)) {
    $from    = 1;
    $to      = $newUser['userno'] . '@' . $netinfo['systemid'] . '*1';
    $subject = 'Welcome New User!';
    $body    = ReadCfgFile($file);
    WriteEmail($from, $to, $subject, $body, 0, '', 0);
}

// Send an email to the sysop informing of a new user.
$from    = $newUser['userno'];
$to      = '1@' . $netinfo['systemid'] . '*1';
$subject = 'New User Alert!';
$body    = 'New BBS user: ' . $newUser['handle'] . ' (#' . $newUser['userno'] . ")\r\n"
         . 'IP Address:   ' . $_SERVER['REMOTE_ADDR'] . "\r\n"
         . 'Time & Date:  ' . date("F j, Y, g:i a") . "\r\n\r\n"
         . 'Real Name:    ' . $newUser['realname'] . "\r\n"
         . 'City, State:  ' . $newUser['city'] . ', ' . $newUser['state'] . "\r\n"
         . 'Birthday:     ' . $newUser['bdaymonth'] . '/' . $newUser['bdayday'] . '/' . $newUser['bdayyear'] . "\r\n";
WriteEmail($from, $to, $subject, $body, 0, '', 0);

// If you want a oneliner sent to the sysop as well or in the place of the email,
// uncomment the next line.
// WriteOneliner(1, 'New User Alert: ' . $newUser['handle'] . ' (#' . $newUser['userno'] . ')');

// Update all new message pointers.
UpdateMessagePointers($newUser['userno'], 0);

// Now display a welcome screen and log the user in.
require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[New User Welcome] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8559-1" />
<meta name="copyright" content="Copyright  2003, Steve Winn" />
<style type="text/css">
<!--
a.infoBarBody:link    { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.infoBarBody:visited { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.navBar:link         { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.navBar:visited      { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.return:link         { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
a.return:visited      { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
.infoBarBody          { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; }
.navbar               { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
.return               { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
.yellowTitle          { font-family: Verdana, Arial, Helvetica; font-size: 14pt; color: #FFFF00; font-weight:bold; font-style:italic }
-->
</style>
<script language="JavaScript" type="text/javascript">
<!--
    var submitted = 0;
    function validate(form) {
        if (submitted == 0) {
            submitted = 1;
            return true;
        } else {
            return false;
        }
    }
-->
</script>
</head>

<body bgcolor="#000000">

<form name="redirect" method="post" action="login.php" onsubmit="return validate(redirect)">
    <input type="hidden" name="referer" value="index.php">
    <input type="hidden" name="username" value="<?php print $newUser['handle']; ?>">
    <input type="hidden" name="password" value="<?php print $newUser['password']; ?>">
    <div align="center">
        <center>
        <table border="1" width="640" cellspacing="0" cellpadding="5" bgcolor="#000080" bordercolor="#FFFFFF">
            <tr>
                <td valign="top">
                    <p class="yellowTitle" align="center">Welcome New User!</p>
                    <table cellspacing="1" width="100%">
                        <tr>
                            <td valign="top">
                                <p class="navBar" align="center">You are now a registered user of this BBS!</p>
                                <p align="center" class="navBar">
                                    User #: <span class="return"><?php print $newUser['userno']; ?></span><br />
                                    Username: <span class="return"><?php print $newUser['handle']; ?></span><br />
                                    Password: <span class="return"><?php print $newUser['password']; ?></span>
                                </p>
                                <p class="infoBarBody" align="center"><input type="image" name="submit" src="images/login.gif" border="0" alt="Login!" width="54" height="25"></p>
                            </td>
                        </tr>
                    </table>
                    <p align="center"><span class="navBar">This page is powered
                    by <a class="navBar" href="http://www.vadvphp.com">VADV-PHP</a></span></p>
                    <p align="center" class="infoBarBody">If you experience any problems
                    with this website or need help, contact the
                    <a class="infoBarBody" href="mailto:<?php print $CONFIG['webmaster']; ?>">webmaster</a>.<br />
                    VADV-PHP Copyright  2002-<?php print date('Y'); ?> Aspect
                    Technologies. All Rights Reserved.</p>
                </td>
            </tr>
        </table>
        </center>
    </div>
</form>

</body>

</html>