<?php
/*
 * ----------------------------------------------------------------------------
 * WebUserList.php                                                   10/14/2006
 * This script displays to the sysop the current web-users.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'SysOp Function';

require_once('include_dir.php');
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.

if (($USER['userno'] == 0) || ($USER['userno'] == $CONFIG['guestacct'])) {
    RedirectUser($rootDir . 'bbslogin.php?url=' . urlencode(GetCurrentURL()));
}
if ($USER['securitylevel'] < 255) {
    $log = 'ERROR! "' . $USER['handle'] . '" - Attempted Unauthorized WebUserList Entry';
    WriteLog('VADV-PHP.LOG', $log);
    RedirectUser($rootDir . 'index.php');
}

if (isset($_GET['h'])) {
    $h = (integer) $_GET['h'];
} else {
    $h = 0;
}

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[Current VADV-PHP Users] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<style type="text/css">
<!--
    a:active           { color: #FF0000 }
    a:link             { color: #0000D0 }
    a:visited          { color: #0000D0 }
    a:hover            { color: #FF0000 }
    a.msgBack:link     { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.msgBack:visited  { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .body              { font-family: Courier New;               font-size: 10pt; color: #FFFFFF }
    .header            { font-family: Courier New;               font-size: 12pt; color: #FFFFFF; font-weight: bold }
    .msgBack           { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .title             { font-family: Verdana, Arial, Helvetica; font-size: 14pt; color: #FFFF00; font-weight:bold; font-style:italic }
-->
</style>
<script language="JavaScript" type="text/javascript" src="<?php print $rootDir; ?>tooltip.js"></script>
</head>

<body bgcolor="#000000">

<p class="title" align="right">Current VADV-PHP Users
<hr color="#525552">
<div align="center">
    <table cellspacing="0" cellpadding="0" width="100%">
        <tr>
            <td class="msgBack" align="left" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">&lt;- Back</a>
                <?php
                if ($h == 0) {
                    print '| <a class="msgBack" href="webuserlist.php?h=1">Get IP Hostnames</a>';
                }
                ?>
            </td>
            <td class="msgBack" align="right" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a>
            </td>
        </tr>
    </table>
</div>
<hr color="#525552">
<div align="center">
    <center>
    <table border="0" cellpadding="2" cellspacing="0" style="border-collapse: collapse" width="100%">
        <tr>
            <td align="left" class="header">
                No.
            </td>
            <td align="left" class="header">
                Handle
            </td>
            <td align="left" class="header">
                IP Address
            </td>
            <td align="left" class="header">
                Session ID
            </td>
            <td align="left" class="header">
                Last
            </td>
            <td align="left" class="header">
                Left
            </td>
            <td align="center" class="header">
                SSL
            </td>
        </tr>
<?php
$guestno = 0 ;                              // Set number of guests.

for ($x = 1; $x <= $VA_USERS[0]; $x++) {
    // Count the guests.
    if ($VA_USERS[$x]['userno'] == 0) $guestno++;

    // Get user's hostname.
    if ($h == 1) {
        $hostname = gethostbyaddr($VA_USERS[$x]['ip']);
    } else {
        $hostname = '';
    }

    // Get user's time.
    $lastTime = date("H:i:s", $VA_USERS[$x]['time']);
    $leftTime = 900 - (time() - $VA_USERS[$x]['time']);
    $leftTime = date("H:i:s", mktime(0, 0, $leftTime));
?>
        <tr>
            <td align="left" class="body">
                <?php
                if ($VA_USERS[$x]['userno'] > 0) {
                    print '<a href="usereditor.php?u=' . $VA_USERS[$x]['userno'] . '">';
                }
                ?>
                <span style="color: #FFFF52"><?php print $VA_USERS[$x]['userno']; ?></span>
                <?php
                if ($VA_USERS[$x]['userno'] > 0) {
                    print '</a>';
                }
                ?>
            </td>
            <td align="left" class="body">
                <?php
                if ($VA_USERS[$x]['userno'] > 0) {
                    print '<a href="userinfo.php?u=' . $VA_USERS[$x]['userno'] . '">';
                }
                ?>
                <span style="color: #52FF52"><?php print HtmlSpace($VA_USERS[$x]['handle']); ?></span>
                <?php
                if ($VA_USERS[$x]['userno'] > 0) {
                    print '</a>';
                }
                ?>
            </td>
            <td align="left" class="body">
                <a style="color: #FF55FF" href="http://ws.arin.net/cgi-bin/whois.pl?queryinput=<?php print $VA_USERS[$x]['ip']; ?>" target="iplookup">
                <span tooltip_v1="<?php print $hostname; ?>"><?php print $VA_USERS[$x]['ip']; ?></span></a>
            </td>
            <td align="left" class="body">
                <span style="color: #FF5552"><?php print $VA_USERS[$x]['session']; ?></span>
            </td>
            <td align="left" class="body">
                <span style="color: #5255FF"><?php print $lastTime; ?></span>
            </td>
            <td align="left" class="body">
                <span style="color: #5255FF"><?php print $leftTime; ?></span>
            </td>
            <td align="center" class="body">
                <?php
                if ($VA_USERS[$x]['ssl'] > 0) {
                    print '*';
                }
                ?>
            </td>
        </tr>
<?php
}
?>
    </table>
    </center>
</div>
<hr color="#525552">
<table border="0" cellpadding="2" cellspacing="0" style="border-collapse: collapse" width="100%">
    <tr>
        <td align="center" class="body">
            <span style="color: #FFFF00">Guests: </span><?php print $guestno; ?>&nbsp;&nbsp;<span style="color: #FFFF00">Users: </span><?php print $VA_USERS[0] - $guestno; ?>
        </td>
    </tr>
</table>

<?php
GlobalFooter(1);
?>

</body>

</html>