<?php
/*
 * ----------------------------------------------------------------------------
 * Vote.inc.php                                                      10/14/2006
 * This script allows users to vote on questions setup by the SysOp. This uses
 * the internal voting booth from VADV. Questions and possible answers are
 * configured using VConfig.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Voting Booth';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.
require_once($includeDir . 'va-vote.inc.php');      // Include voting functions.

$vote    = FALSE;
$results = FALSE;
$show    = FALSE;

if (isset($_GET['vote'])) {
    $vote     = TRUE;
    $results  = FALSE;
    $question = (integer) $_GET['vote'];
}

if (isset($_GET['results'])) {
    $vote     = FALSE;
    $results  = TRUE;
    $question = (integer) $_GET['results'];
}

if (isset($_GET['show'])) {
    $show = TRUE;
}

if (isset($_POST['submit'])) {
    if ($_POST['submit'] == 'Cancel') {
        unset($_POST);
    }
}

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[Voting Booth] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,follow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<style type="text/css">
<!--
    a:active           { color: #FF0000 }
    a:link             { color: #0000D0 }
    a:visited          { color: #0000D0 }
    a:hover            { color: #FF0000 }
    a.body:link        { font-family: Courier New;               font-size: 10pt; color: #FFFFFF }
    a.body:visited     { font-family: Courier New;               font-size: 10pt; color: #FFFFFF }
    a.boldBody:link    { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    a.boldBody:visited { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    a.msgBack:link     { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.msgBack:visited  { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.show:link        { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000 }
    a.show:visited     { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000 }
    .body              { font-family: Courier New;               font-size: 10pt; color: #FFFFFF }
    .boldBody          { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    .msgBack           { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .result            { font-family: Verdana, Arial, Helvetica; font-size: 12pt; color: #FFFF00; font-weight: bold; font-style: italic }
    .show              { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: normal }
    .stats             { font-family: Courier New;               font-size: 8pt;  color: #FFFF00 }
    .title             { font-family: Verdana, Arial, Helvetica; font-size: 14pt; color: #FFFF00; font-weight: bold; font-style: italic }
-->
</style>
</head>

<body bgcolor="#000000">

<?php
// Process votes.
if (($vote) && (isset($_POST['answer'])) &&
    ($USER['userno'] > 0) && ($USER['userno'] != $CONFIG['guestacct'])) {
    $answer = (integer) $_POST['answer'];
    $userVote = GetUserVote($USER['userno'], $question);
    if ($userVote == 0) {
        $log = 'Voting Booth    "' . $USER['handle'] . '" - "' . $VA_VOTE[$question]['question'] . '" --> ' . $VA_VOTE[$question]['resp' . $answer];
        WriteLog('VADV-PHP.LOG', $log);     // Log the vote.
        PutUserVote($USER['userno'], $question, $answer);
        RedirectUser('vote.php?results=' . $question);
    } else {
        RedirectUser('vote.php');
    }
}
?>

<p class="title" align="right">Virtual Advanced Voting Booth
<hr color="#525552">

<?php
// Let the user vote on the passed question.
if (($vote) &&
    (($USER['userno'] > 0) && ($USER['userno'] != $CONFIG['guestacct']))) {
    if (GetUserVote($USER['userno'], $question) > 0) {
        RedirectUser('vote.php');
    }
?>

<div align="center">
    <table cellspacing="0" cellpadding="0" width="100%">
        <tr>
            <td class="msgBack" align="left" valign="top">
                <a class="msgBack" href="vote.php">&lt;- Back</a>
            </td>
            <td class="msgBack" align="right" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a>
            </td>
        </tr>
    </table>
</div>
<hr color="#525552">
<div align="center">
    <table cellpadding="0" cellspacing="0">
        <tr>
            <td class="boldBody" width="750" align="left" height="30">
                <?php print $VA_VOTE[$question]['question']; ?></td>
        </tr>
        <tr>
            <form name="vote" method="post" action="vote.php?vote=<?php print $question; ?>">
            <td class="body" width="750" align="left">
                <?php
                for ($x = 1; $x <= $VA_VOTE[$question]['respno']; $x++) {
                    print '&nbsp;&nbsp;';
                    if ($x == 1) {
                        print '<input type="radio" name="answer" value="' . $x . '" checked>&nbsp;' . $x . '. ' . $VA_VOTE[$question]['resp' . $x] . "<br />\n";
                    } else {
                        print '<input type="radio" name="answer" value="' . $x . '">&nbsp;' . $x . '. ' . $VA_VOTE[$question]['resp' . $x] . "<br />\n";
                    }
                }
                ?>
                <br />
                <center>
                <input type="submit" value="Submit" name="submit">
                <input type="submit" value="Cancel" name="submit">
                </center>
            </td>
            </form>
        </tr>
    </table>
</div>

<?php
}


// Let the user view the results of the passed question.
if (($results) &&
    (($USER['userno'] > 0) && ($USER['userno'] != $CONFIG['guestacct']))) {
?>

<div align="center">
    <table cellspacing="0" cellpadding="0" width="100%">
        <tr>
            <td class="msgBack" align="left" valign="top">
                <a class="msgBack" href="vote.php">&lt;- Back</a>
            </td>
            <td class="msgBack" align="right" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a>
            </td>
        </tr>
    </table>
</div>
<hr color="#525552">
<div align="center">
    <table border="0" cellpadding="0" cellspacing="0">
        <tr>
            <td class="boldBody" width="750" height="30" align="left">
                <?php print $VA_VOTE[$question]['question']; ?>
            </td>
        </tr>
    </table>
</div>
<div align="center">
    <table border="0" cellspacing="0" cellpadding="0">
        <?php
        for ($x = 1; $x <= $VA_VOTE[$question]['respno']; $x++) {
            // Determine the stats...
            $stats = GetVoteStats($question);
            if ($stats[0] > 0) {
                $pct = round($stats[$x] / $stats[0] * 100);
            } else {
                $pct = 0;
            }
            $rightbar = 100 - $pct;
        ?>
        <tr>
            <td class="body" width="530" align="left" height="30">
                <?php print $x . '. ' . $VA_VOTE[$question]['resp' . $x]; ?>
            </td>
            <td width="130" align="left" height="30">
                <table cellpadding="0" cellspacing="0" width="100%" height="20">
                    <tr>
                        <td width="<?php print $pct; ?>%" bgcolor="#FF0000">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%" bgcolor="#000000">&nbsp;</td>
                    </tr>
                </table>
            </td>
            <td class="stats" width="25" align="right" height="30">
                (<?php print $stats[$x]; ?>)
            </td>
            <td class="result" width="55" align="right" height="30">
                <?php print $pct; ?>%
            </td>
        </tr>
        <?php
        }
        ?>
    </table>
</div>
<div align="center">
    <table border="0" cellspacing="0" cellpadding="0">
        <tr>
            <hr color="#525552">
            <td class="boldBody" width="750" align="left">
                Total Number of Responses:&nbsp;&nbsp;<span style="color: #FFFF00"><?php print $stats[0]; ?></span>
                <?php
                if ($USER['securitylevel'] >= 255) {
                    if ($show) {
                        include_once($includeDir . 'va-userfile.inc.php');  // Include user information.
                        print '&nbsp;&nbsp;<a class="show" href="vote.php?results=' . $question . '">Hide Responses</a>';
                        print "<pre>\n";
                        for ($x = 1; (($x <= GetUserCount()) || ($x <= $stats[0])); $x++) {
                            $userVote = GetUserVote($x, $question);
                            if ($userVote > 0) {
                                $user = GetUser($x);
                                print '<span style="font-size: 10pt; color: #FFFF52">#' . str_pad($x, 4, ' ', STR_PAD_RIGHT) . '</span>' .
                                      '<span style="font-size: 10pt; color: #52FF52">' . HtmlSpace($user['handle']) . '</span>' .
                                      '<span style="font-size: 10pt; color: #FFFFFF"> - </span>' .
                                      '<span style="font-size: 10pt; color: #FFFF52">' . $userVote . "</span>\n";
                            }
                        }
                        print "</pre>\n";
                    } else {
                        print '&nbsp;&nbsp;<a class="show" href="vote.php?results=' . $question . '&show">Show Responses</a>';
                    }
                }
                ?>
            </td>
        </tr>
    </table>
</div>

<?php
}


// Default to viewing the questions:
if (!$vote && !$results) {
?>
<div align="center">
    <table cellspacing="0" cellpadding="0" width="100%">
        <tr>
            <td class="msgBack" align="left" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">&lt;- Back</a>
            </td>
            <td class="msgBack" align="right" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a>
            </td>
        </tr>
    </table>
</div>
<hr color="#525552">
<div align="center">
    <table cellpadding="0" cellspacing="0">
    <?php
    if ($VA_VOTE[0] == 0) {
        print '<tr><td><span class="body">There are no polls at this time.</span></td></tr>' . "\n";
    } else {
        for ($x = 1; $x <= $VA_VOTE[0]; $x++) {
            if ($VA_VOTE[$x]['respno'] > 0) {
                $userVote = GetUserVote($USER['userno'], $x);
    ?>
        <tr>
            <td class="body" width="30" align="center" height="30">
                <?php
                if ($userVote == 0) {
                    print '<img border="0" src="' . $rootDir . 'images/votebox.gif" width="15" height="15" alt="New Poll!">' . "\n";
                } else {
                    print '<img border="0" src="' . $rootDir . 'images/votebox-filled.gif" width="15" height="15" alt="Completed Poll">' . "\n";
                }
                ?>
            </td>
            <td class="boldBody" width="570" height="30" align="left">
                <?php print $VA_VOTE[$x]['question']; ?>
            </td>
            <td width="150" height="30" align="right">
                <?php
                if (($USER['userno'] == 0) ||
                    ($USER['userno'] == $CONFIG['guestacct'])) {
                    print '<a class="body" href="' . $rootDir . 'bbslogin.php?url=' . urlencode(GetCurrentURL()) . '">Login to Vote!</a>' . "\n";
                } else {
                    if ($userVote == 0) {
                        print '<a href="vote.php?vote=' . $x . '"><img border=0" src="' . $rootDir . 'images/vote.gif" width="45" height="25" alt="Vote on this Poll"></a>';
                    }
                    print '<a href="vote.php?results=' . $x . '"><img border=0" src="' . $rootDir . 'images/results.gif" width="105" height="25" alt="View This Poll\'s Results"></a>' . "\n";
                }
                ?>
            </td>
        </tr>
    <?php
            }
        }
    }
    ?>
    </table>
</div>

<?php
}

GlobalFooter(1);
?>

</body>

</html>