<?php
/*
 * ----------------------------------------------------------------------------
 * UserList.php                                                      10/14/2006
 * This script will print out a listing of all users.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Viewing User List';

require_once('include_dir.php');
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.
require_once($includeDir . 'va-userfile.inc.php');  // Include user information.

if (isset($_GET['compress'])) {
    $_GET['compress'] = (boolean) $_GET['compress'];
    if (($_GET['compress']) && ($USER['securitylevel'] >= 255)) {
        CompressUserfile();
    }
}

if ((isset($_GET['sort'])) &&
    (((trim(strtolower($_GET['sort'])) == 'userno') ||
      (trim(strtolower($_GET['sort'])) == 'handle') ||
      (trim(strtolower($_GET['sort'])) == 'realname') ||
      (trim(strtolower($_GET['sort'])) == 'city') ||
      (trim(strtolower($_GET['sort'])) == 'state') ||
      (trim(strtolower($_GET['sort'])) == 'laston')) ||
      (($USER['securitylevel'] >= 255) &&
       (trim(strtolower($_GET['sort'] == 'securitylevel')))))) {
    $sort = trim(strtolower($_GET['sort']));
} else {
    $sort = 'userno';
}
if (isset($_GET['order'])) {
    $order = (boolean) $_GET['order'];
} else {
    $order = FALSE; // Default = ascending
}

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[User List] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,follow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<style type="text/css">
<!--
    a:active           { color: #FF0000 }
    a:link             { color: #0000D0 }
    a:visited          { color: #0000D0 }
    a:hover            { color: #FF0000 }
    a.header:link      { font-family: Courier New;               font-size: 12pt; color: #FFFFFF; font-weight: bold }
    a.header:visited   { font-family: Courier New;               font-size: 12pt; color: #FFFFFF; font-weight: bold }
    a.msgBack:link     { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.msgBack:visited  { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .body              { font-family: Courier New;               font-size: 10pt; color: #FFFFFF }
    .header            { font-family: Courier New;               font-size: 12pt; color: #FFFFFF; font-weight: bold }
    .msgBack           { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .title             { font-family: Verdana, Arial, Helvetica; font-size: 14pt; color: #FFFF00; font-weight:bold; font-style:italic }
-->
</style>
</head>

<body bgcolor="#000000">

<p class="title" align="right">Virtual Advanced User Listing
<hr color="#525552">

<div align="center">
    <table cellspacing="0" cellpadding="0" width="100%">
        <tr>
            <td class="msgBack" align="left" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">&lt;- Back</a>
                <?php
                if ($USER['securitylevel'] >= 255) {
                    print '| <a class="msgBack" href="userlist.php?compress=1">Compress Userfile</a>';
                }
                ?>
            </td>
            <td class="msgBack" align="right" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a>
            </td>
        </tr>
    </table>
</div>
<hr color="#525552">
<div align="center">
    <center>
    <table border="0" cellpadding="2" cellspacing="0" style="border-collapse: collapse" bordercolor="#FFFFFF" width="100%">
        <tr>
            <td align="left" class="header" style="border-bottom: 1px solid #525552">
                <a class="header" href="userlist.php?sort=userno<?php
                                                                if (($sort == 'userno') && (!$order)) {
                                                                    print '&order=1';
                                                                }
                                                                ?>">No.</a>
            </td>
            <td align="left" class="header" style="border-bottom: 1px solid #525552">
                <a class="header" href="userlist.php?sort=handle<?php
                                                                if (($sort == 'handle') && (!$order)) {
                                                                    print '&order=1';
                                                                }
                                                                ?>">Handle</a>
            </td>
            <td align="left" class="header" style="border-bottom: 1px solid #525552">
                <a class="header" href="userlist.php?sort=realname<?php
                                                                  if (($sort == 'realname') && (!$order)) {
                                                                      print '&order=1';
                                                                  }
                                                                  ?>">Real Name</a>
            </td>
            <td align="left" class="header" style="border-bottom: 1px solid #525552">
                <a class="header" href="userlist.php?sort=city<?php
                                                              if (($sort == 'city') && (!$order)) {
                                                                  print '&order=1';
                                                              }
                                                              ?>">City</a>
            </td>
            <td align="left" class="header" style="border-bottom: 1px solid #525552">
                <a class="header" href="userlist.php?sort=state<?php
                                                               if (($sort == 'state') && (!$order)) {
                                                                   print '&order=1';
                                                               }
                                                               ?>">State</a>
            </td>
            <td align="left" class="header" style="border-bottom: 1px solid #525552">
                <a class="header" href="userlist.php?sort=laston<?php
                                                                if (($sort != 'laston') ||
                                                                    ($sort == 'laston') && (!$order)) {
                                                                    print '&order=1';
                                                                }
                                                                ?>">LastOn</a>
            </td>
            <?php
            if ($USER['securitylevel'] >= 255) {
                print '<td align="left" class="header" style="border-bottom: 1px solid #525552">' . "\n";
                print '<a class="header" href="userlist.php?sort=securitylevel';
                if (($sort != 'securitylevel') ||
                    ($sort == 'securitylevel') && (!$order)) {
                    print '&order=1';
                }
                print '">SL</a></td>' . "\n";
            }
            ?>
        </tr>

<?php
$fileString = ReadUserfile();           // Read the userfile.
$length     = strlen($fileString);      // Determine the length of the file string.

$offset     = 1048;                     // Set the file offset.
$position   = 0;                        // Set the starting position.
$array      = array();                  // Create array used for sorting.
$arraycnt   = 0;                        // Create array counter.

for ($x = 1; $position < $length; $x++) {
    $handle   = GetString($fileString, 1 + $position, 40);
    $name     = GetString($fileString, 41 + $position, 40);
    $city     = GetString($fileString, 121 + $position, 32);
    $state    = GetString($fileString, 153 + $position, 3);
    $laston   = GetString($fileString, 376 + $position, 6);
    $lastcall = GetLongInt($fileString, 915 + $position);

    if (intval($laston) == 0) {
        $laston = '000000';
    }

    $seclevel = GetInteger($fileString, 374 + $position);

    if (($USER['securitylevel'] >= 255) || ($seclevel > 0)) {
        $array[$arraycnt]['userno']        = $x;
        $array[$arraycnt]['handle']        = $handle;
        $array[$arraycnt]['realname']      = $name;
        $array[$arraycnt]['city']          = $city;
        $array[$arraycnt]['state']         = $state;
        $array[$arraycnt]['laston']        = $laston;
        $array[$arraycnt]['securitylevel'] = $seclevel;
        $array[$arraycnt]['sort']          = strtolower($array[$arraycnt][$sort]);
        $arraycnt++;
    }
    $position = $position + $offset;
}

// Sort the array.
$sortarr = array();
foreach ($array as $row) {
    $sortarr[] = $row['sort'];
}
if ($order) {
    array_multisort($sortarr, SORT_DESC, $array);
} else {
    array_multisort($sortarr, SORT_ASC, $array);
}
unset($sortarr);

for ($x = 0; $x < count($array); $x++) {
    $laston = substr($array[$x]['laston'], 2, 2) . '-' . substr($array[$x]['laston'], 4, 2) . '-' . substr($array[$x]['laston'], 0, 2);
?>

        <tr>
            <td align="left" class="body">
                <?php if ($USER['securitylevel'] >= 255) print '<a href="usereditor.php?u=' . $array[$x]['userno'] . '">'; ?><span style="color: #FFFF52"><?php print $array[$x]['userno']; ?></span><?php if ($USER['securitylevel'] >= 255) print '</a>'; ?></td>
            <td align="left" class="body">
                <a href="userinfo.php?u=<?php print $array[$x]['userno']; ?>"><span style="color: #52FF52"><?php print HtmlSpace($array[$x]['handle']); ?></span></a></td>
            <td align="left" class="body">
                <a href="userinfo.php?u=<?php print $array[$x]['userno']; ?>"><span style="color: #00AA00"><?php print HtmlSpace($array[$x]['realname']); ?></span></a></td>
            <td align="left" class="body">
                <span style="color: #5255FF"><?php print HtmlSpace($array[$x]['city']); ?></span></td>
            <td align="left" class="body">
                <span style="color: #5255FF"><?php print $array[$x]['state']; ?></span></td>
            <td align="left" class="body">
                <span style="color: #FF55FF"><?php print $laston; ?></span></td>
            <?php
                if ($USER['securitylevel'] >= 255) {
                    print '<td align="left" class="body"><p><span style="color: #FF5552">' . $array[$x]['securitylevel'] . "</span></p></td>\n";
                }
            ?>
        </tr>

<?php
}
?>

    </table>
    </center>
</div>

<?php
GlobalFooter(1);
?>

</body>

</html>