<?php
/*
 * ----------------------------------------------------------------------------
 * EditUser_Process.php                                              10/02/2006
 * This script will process the usereditor form.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'SysOp Function';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-userfile.inc.php');  // Include user information.
require_once($includeDir . 'vadv-php_dat.inc.php'); // Include user settings.

if (($USER['securitylevel'] < 255) ||
    (($USER['userno'] == 0) ||
     ($USER['userno'] == $CONFIG['guestacct']))) {
    RedirectUser($rootDir . 'index.php');
}

if ((!isset($_SERVER['HTTP_REFERER'])) ||
    (strpos($_SERVER['HTTP_REFERER'], $_SERVER['HTTP_HOST']) === FALSE)) {
    die('<br /><h4>You are not allowed to access this script from an outside source.<br />Press the BACK button on your browser.</h4>');
}

if ((!isset($_POST['process'])) || ($_POST['process'] != 1)) {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}
if (!isset($_POST['submit'])) {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}

if (!isset($_POST['userno'])) {
    die('<br /><h4>Invalid information. Please press the BACK button on your browser.</h4>');
} else {
    $user = GetUser($_POST['userno']);
    $edituser = $user;
}

// Format variables.
$_POST['handle']        = trim($_POST['handle']);
$_POST['realname']      = ucwords(trim(strtolower($_POST['realname'])));
$_POST['address']       = ucwords(trim(strtolower($_POST['address'])));
$_POST['city']          = ucwords(trim(strtolower($_POST['city'])));
$_POST['state']         = trim(strtoupper($_POST['state']));
$_POST['zipcode']       = trim($_POST['zipcode']);
$_POST['phone1']        = trim($_POST['phone1']);
$_POST['phone2']        = trim($_POST['phone2']);
$_POST['bdaymonth']     = (integer) $_POST['bdaymonth'];
$_POST['bdayday']       = (integer) $_POST['bdayday'];
$_POST['bdayyear']      = (integer) $_POST['bdayyear'];
$_POST['bbspassword']   = trim(strtoupper($_POST['bbspassword']));
$_POST['bbsverify']     = trim(strtoupper($_POST['bbsverify']));
$_POST['webpassword']   = trim(strtoupper($_POST['webpassword']));
$_POST['webverify']     = trim(strtoupper($_POST['webverify']));
$_POST['securitylevel'] = (integer) $_POST['securitylevel'];
$_POST['maxtime']       = (integer) $_POST['maxtime'];
$_POST['timebank']      = (integer) $_POST['timebank'];
$_POST['credits']       = (integer) $_POST['credits'];
$_POST['flags']         = trim($_POST['flags']);
$_POST['accflags']      = trim($_POST['accflags']);
$_POST['pagebreak']     = (integer) $_POST['pagebreak'];
$_POST['videomode']     = (integer) $_POST['videomode'];
$_POST['protocol']      = trim(strtoupper($_POST['protocol']));
$_POST['liststyle']     = (integer) $_POST['liststyle'];
if (isset($_POST['sortfilelst'])) {
    $_POST['sortfilelst'] = 1;
} else {
    $_POST['sortfilelst'] = 0;
}
if (isset($_POST['ratioexempt'])) {
    $_POST['ratioexempt'] = 0;
} else {
    $_POST['ratioexempt'] = 1;
}
if (isset($_POST['verifybday'])) {
    $_POST['verifybday']  = 1;
} else {
    $_POST['verifybday']  = 0;
}
$_POST['mailfwd']      = trim($_POST['mailfwd']);
$_POST['mailfwdnetno'] = (integer) $_POST['mailfwdnetno'];
$_POST['extra1']       = trim($_POST['extra1']);
$_POST['extra2']       = trim($_POST['extra2']);
$_POST['extra3']       = trim($_POST['extra3']);
$_POST['extra4']       = trim($_POST['extra4']);
$_POST['extra5']       = trim($_POST['extra5']);
$_POST['extra6']       = trim($_POST['extra6']);
$_POST['extra7']       = trim($_POST['extra7']);
$_POST['extra8']       = trim($_POST['extra8']);
$_POST['comment']      = trim($_POST['comment']);
$_POST['totalcalls']   = (integer) $_POST['totalcalls'];
$_POST['totaltime']    = (integer) $_POST['totaltime'];
$_POST['uplfiles']     = (integer) $_POST['uplfiles'];
$_POST['uplkb']        = (integer) $_POST['uplkb'];
$_POST['dlfiles']      = (integer) $_POST['dlfiles'];
$_POST['dlkb']         = (integer) $_POST['dlkb'];
$_POST['totalposts']   = (integer) $_POST['totalposts'];
$_POST['totalemail']   = (integer) $_POST['totalemail'];

// Check the birthday field.
if (strlen($_POST['bdayyear']) == 2) {
    $_POST['bdayyear'] == '19' . $_POST['bdayyear'];
}

// Fix the referer URL. Make sure there is no query string.
$url = parse_url($_POST['referer']);
$referer = $url['scheme'] . '://' . $url['host'] . $url['path'];

if ((isset($_POST['handle']))        && ($_POST['handle']        != $user['handle']))   {
                                                                                             $edituser['handle']        = $_POST['handle'];
                                                                                             $useridx['handle']         = $_POST['handle'];
                                                                                        }
if ((isset($_POST['realname']))      && ($_POST['realname']      != $user['realname'])) {
                                                                                             $edituser['realname']      = $_POST['realname'];
                                                                                             $useridx['realname']       = $_POST['realname'];
                                                                                        }
if ((isset($_POST['address']))       && ($_POST['address']       != $user['address']))       $edituser['address']       = $_POST['address'];
if ((isset($_POST['city']))          && ($_POST['city']          != $user['city']))          $edituser['city']          = $_POST['city'];
if ((isset($_POST['state']))         && ($_POST['state']         != $user['state']))         $edituser['state']         = $_POST['state'];
if ((isset($_POST['zipcode']))       && ($_POST['zipcode']       != $user['zipcode']))       $edituser['zipcode']       = $_POST['zipcode'];
if ((isset($_POST['phone1']))        && ($_POST['phone1']        != $user['phone1']))        $edituser['phone1']        = $_POST['phone1'];
if ((isset($_POST['phone2']))        && ($_POST['phone2']        != $user['phone2']))        $edituser['phone2']        = $_POST['phone2'];
if ((isset($_POST['bdaymonth']))     && ($_POST['bdaymonth']     != $user['bdaymonth']))     $edituser['bdaymonth']     = $_POST['bdaymonth'];
if ((isset($_POST['bdayday']))       && ($_POST['bdayday']       != $user['bdayday']))       $edituser['bdayday']       = $_POST['bdayday'];
if ((isset($_POST['bdayyear']))      && ($_POST['bdayyear']      != $user['bdayyear']))      $edituser['bdayyear']      = $_POST['bdayyear'];
if ((isset($_POST['securitylevel'])) && ($_POST['securitylevel'] != $user['securitylevel'])) $edituser['securitylevel'] = $_POST['securitylevel'];
if ((isset($_POST['maxtime']))       && ($_POST['maxtime']       != $user['maxtime']))       $edituser['maxtime']       = $_POST['maxtime'];
if ((isset($_POST['timebank']))      && ($_POST['timebank']      != $user['timebank']))      $edituser['timebank']      = $_POST['timebank'];
if ((isset($_POST['credits']))       && ($_POST['credits']       != $user['credits']))       $edituser['credits']       = $_POST['credits'];
if ((isset($_POST['flags']))         && ($_POST['flags']         != $user['flags']))         $edituser['flags']         = $_POST['flags'];
if ((isset($_POST['accflags']))      && ($_POST['accflags']      != $user['accflags']))      $edituser['accflags']      = $_POST['accflags'];
if ((isset($_POST['pagebreak']))     && ($_POST['pagebreak']     != $user['pagebreak']))     $edituser['pagebreak']     = $_POST['pagebreak'];
if ((isset($_POST['videomode']))     && ($_POST['videomode']     != $user['videomode']))     $edituser['videomode']     = $_POST['videomode'];
if ((isset($_POST['protocol']))      && ($_POST['protocol']      != $user['protocol']))      $edituser['protocol']      = $_POST['protocol'];
if ((isset($_POST['liststyle']))     && ($_POST['liststyle']     != $user['liststyle']))     $edituser['liststyle']     = $_POST['liststyle'];
if ((isset($_POST['sortfilelst']))   && ($_POST['sortfilelst']   != $user['sortfilelst']))   $edituser['sortfilelst']   = $_POST['sortfilelst'];
if ((isset($_POST['ratioexempt']))   && ($_POST['ratioexempt']   != $user['ratioexempt']))   $edituser['ratioexempt']   = $_POST['ratioexempt'];
if ((isset($_POST['verifybday']))    && ($_POST['verifybday']    != $user['verifybday']))    $edituser['verifybday']    = $_POST['verifybday'];
if ((isset($_POST['extra1']))        && ($_POST['extra1']        != $user['extra1']))        $edituser['extra1']        = $_POST['extra1'];
if ((isset($_POST['extra2']))        && ($_POST['extra2']        != $user['extra2']))        $edituser['extra2']        = $_POST['extra2'];
if ((isset($_POST['extra3']))        && ($_POST['extra3']        != $user['extra3']))        $edituser['extra3']        = $_POST['extra3'];
if ((isset($_POST['extra4']))        && ($_POST['extra4']        != $user['extra4']))        $edituser['extra4']        = $_POST['extra4'];
if ((isset($_POST['extra5']))        && ($_POST['extra5']        != $user['extra5']))        $edituser['extra5']        = $_POST['extra5'];
if ((isset($_POST['extra6']))        && ($_POST['extra6']        != $user['extra6']))        $edituser['extra6']        = $_POST['extra6'];
if ((isset($_POST['extra7']))        && ($_POST['extra7']        != $user['extra7']))        $edituser['extra7']        = $_POST['extra7'];
if ((isset($_POST['extra8']))        && ($_POST['extra8']        != $user['extra8']))        $edituser['extra8']        = $_POST['extra8'];
if ((isset($_POST['comment']))       && ($_POST['comment']       != $user['comment']))       $edituser['comment']       = $_POST['comment'];
if ((isset($_POST['totalcalls']))    && ($_POST['totalcalls']    != $user['totalcalls']))    $edituser['totalcalls']    = $_POST['totalcalls'];
if ((isset($_POST['totaltime']))     && ($_POST['totaltime']     != $user['totaltime']))     $edituser['totaltime']     = $_POST['totaltime'];
if ((isset($_POST['uplfiles']))      && ($_POST['uplfiles']      != $user['uplfiles']))      $edituser['uplfiles']      = $_POST['uplfiles'];
if ((isset($_POST['uplkb']))         && ($_POST['uplkb']         != $user['uplkb']))         $edituser['uplkb']         = $_POST['uplkb'];
if ((isset($_POST['dlfiles']))       && ($_POST['dlfiles']       != $user['dlfiles']))       $edituser['dlfiles']       = $_POST['dlfiles'];
if ((isset($_POST['dlkb']))          && ($_POST['dlkb']          != $user['dlkb']))          $edituser['dlkb']          = $_POST['dlkb'];
if ((isset($_POST['totalposts']))    && ($_POST['totalposts']    != $user['totalposts']))    $edituser['totalposts']    = $_POST['totalposts'];
if ((isset($_POST['totalemail']))    && ($_POST['totalemail']    != $user['totalemail']))    $edituser['totalemail']    = $_POST['totalemail'];

if ((isset($_POST['timeleft'])) &&
    ($_POST['timeleft'] != $user['maxtime'] - $user['timecounter'])) {
    $edituser['timecounter'] = $edituser['maxtime'] - $_POST['timeleft'];
}

// If password change...
if ((isset($_POST['bbspassword'])) && ($_POST['bbspassword'] != '') &&
    (isset($_POST['bbsverify'])) && ($_POST['bbsverify'] != '')) {
    $password = $_POST['bbspassword'];
    $verify   = $_POST['bbsverify'];
    if ($password === $verify) {
        $edituser['password'] = $password;
        if ($_POST['userno'] == $USER['userno']) {
            $USER['password'] = md5($password);
            $_SESSION['password'] = base64_encode(md5($password));  // Change session password.
        }
    }
}

// Mail forwarding...
if ((isset($_POST['mailfwd'])) && (trim($_POST['mailfwd']) != '')) {
    $pos = strpos($_POST['mailfwd'], '@');
    if ($pos !== FALSE) {
        $to = substr($_POST['mailfwd'], 0, $pos);
        $node = substr($_POST['mailfwd'], $pos + 1);
        if (intval($to) > 0) {
            $edituser['mailfwdhandle'] = '';
            $edituser['mailfwduserno'] = $to;
        } else {
            $edituser['mailfwdhandle'] = $to;
            $edituser['mailfwduserno'] = 0;
        }
        $edituser['mailfwdflag']  = 1;
        $edituser['mailfwdnode']  = $node;
        $edituser['mailfwdnetno'] = $_POST['mailfwdnetno'];
    }
} else {
    $edituser['mailfwdflag']   = 0;
    $edituser['mailfwdhandle'] = '';
    $edituser['mailfwduserno'] = 0;
    $edituser['mailfwdnode']   = '';
    $edituser['mailfwdnetno']  = 0;
}

// Write new DAT file.
if (isset($edituser)) {
    $fileString = ReadUserfile();                                   // Get the file string.
    $fileString = PutUser($fileString, $user['userno'], $edituser); // Put the new information into the file string.
    WriteUserfile($fileString);                                     // Write the new file.
}

// Write new IDX file.
if (isset($useridx)) {
    $fileString = ReadUserfile_IDX();
    $fileString = PutUser_IDX($fileString, $user['userno'], $useridx);
    WriteUserfile_IDX($fileString);
}

// If vadv-php password change...
if ((isset($_POST['resetwebpassword'])) && (intval($_POST['resetwebpassword']) == 1)) {
    $newsettings['password'] = '';
    if ($_POST['userno'] == $USER['userno']) {
        $_SESSION['password'] = base64_encode($USER['password']);
    }
} else {
    if ((isset($_POST['webpassword'])) && ($_POST['webpassword'] != '') &&
        (isset($_POST['webverify'])) && ($_POST['webverify'] != '')) {
        $password = $_POST['webpassword'];
        $verify   = $_POST['webverify'];

        if ($password === $verify) {
            $newsettings['password'] = md5($password);
            if ($_POST['userno'] == $USER['userno']) {
                $_SESSION['password'] = base64_encode(md5($password));  // Change session password.
            }
        }
    }
}

if (isset($newsettings)) {
    $fileString = ReadUserSettings();
    $fileString = PutUserSettings($fileString, $_POST['userno'], $newsettings);
    WriteUserSettings($fileString);
}

RedirectUser($_POST['referer']);

?>