<?php
/*
 * ----------------------------------------------------------------------------
 * UserEditor.php                                                    10/14/2006
 * This script will allow the sysop to edit all of the specified user's
 * information, preferences and statistics.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'SysOp Function';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.
require_once($includeDir . 'va-userfile.inc.php');  // Include user information.
require_once($includeDir . 'va-networks.inc.php');  // Include network information.

if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct']) ||
    ($USER['securitylevel'] == 0)) {
    die(VA_LoginError());
}
if ($USER['securitylevel'] < 255) {
    die('<br /><h4>You do not have access to this page. Press the BACK button on your browser.</h4>');
}

if (isset($_GET['u'])) {
    $userno = (integer) $_GET['u'];
} else {
    $userno = 1;
}

if ((isset($_GET['delete'])) && ($_GET['delete'] == 1)) {
    DeleteUser($userno);
    RedirectUser(GetCurrentURL(0) . '?u=' . $userno);
}

$user = GetUser($userno);
$VA_NETWORKS = GetNetworkInfo();

require_once($includeDir. 'html_header.php');
?>
<html>

<head>
<title>[VADV-PHP SysOp Editor] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<style type="text/css">
<!--
a:active              { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000 }
a:link                { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF }
a:visited             { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF }
a:hover               { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000 }
a.footer:link         { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.footer:visited      { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.pre:link            { font-family: Courier New;               font-size: 10pt; color: #FFFFFF; }
a.pre:visted          { font-family: Courier New;               font-size: 10pt; color: #FFFFFF; }
a.pre2:link           { font-family: Courier New;               font-size: 12pt; color: #FFFFFF; }
a.pre2:visited        { font-family: Courier New;               font-size: 12pt; color: #FFFFFF; }
a.return:link         { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
a.return:visited      { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
a.subHeading:link     { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; }
a.subHeading:visited  { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; }
.body                 { font-family: Courier New;               font-size: 10pt; color: #C0C0C0; }
.footer               { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; }
.pre                  { font-family: Courier New;               font-size: 10pt; color: #FFFFFF; }
.pre2                 { font-family: Courier New;               font-size: 12pt; color: #FFFFFF; }
.pre3                 { font-family: Courier New;               font-size: 12pt; color: #E2E2E2; }
.heading              { font-family: Verdana, Arial, Helvetica; font-size: 14pt; color: #FFFF00; font-weight:bold; font-style:italic }
.return               { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
.subHeading           { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; }
-->
</style>
<script language="JavaScript" type="text/javascript">
<!--
    function validate(form) {
        if (form.bdayyear.value.length < 4) {
            alert("The birthday year must be in a four-digit format.");
            form.bdayyear.focus();
            return false;
        }
    }

    function HelpWindow(bmark) {
        var url = "<?php print $rootDir; ?>help/usereditor_help.php#" + bmark;
        var newwindow = window.open(url, "helpwindow", "toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=no, width=350, height=450");
        newwindow.focus();
    }
//-->
</script>
</head>

<body link="#FFFFFF" vlink="#FFFFFF" bgcolor="#000000">

<div align="center">
    <center>
    <table border="1" cellpadding="5" cellspacing="0" width="750" bgcolor="#000080" bordercolor="#FFFFFF">
        <tr>
            <td>
                <table border="0" cellspacing="0" style="border-collapse: collapse" cellpadding="5" bgcolor="#000080" width="100%">
                    <tr>
                        <td align="center">
                            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td class="heading" align="center" height="40" colspan="2">
                                        SysOp User Editor: <?php print HtmlSpace($user['handle']); ?>
                                    </td>
                                </tr>
                            </table>
                            <table border="0" style="border-collapse: collapse" cellpadding="5" cellspacing="0">
                                <tr>
                                    <td class="footer" align="center" height="40" colspan="2">
                                        <a class="footer" href="<?php print $rootDir; ?>index.php">Return to main BBS page.</a><br />
                                        <a class="footer" href="userlist.php">Return to BBS user listing.</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="left" colspan="2" height="25">
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tr>
                                                <td align="left"><?php
                                                                 if ($user['userno'] > 1) {
                                                                     print '<a class="subHeading" href="usereditor.php?u=' . ($user['userno'] - 1) . '">Previous User</a>';
                                                                 }
                                                                 ?></td>
                                                <td align="right"><?php
                                                                  if ($user['userno'] < GetUserCount()) {
                                                                      print '<a class="subHeading" href="usereditor.php?u=' . ($user['userno'] + 1) . '">Next User</a>';
                                                                  }
                                                                  ?></td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                                <form name="usereditor" method="post" action="usereditor_process.php" onsubmit="return validate(usereditor)">
                                    <input type="hidden" name="process" value="1">
                                    <input type="hidden" name="referer" value="<?php print GetCurrentURL(); ?>">
                                    <input type="hidden" name="userno" value="<?php print $user['userno']; ?>">
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Personal Information
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'userno\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#userno" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            User Number:</td>
                                        <td class="pre" align="left"><?php print $user['userno']; ?></td>
                                    </tr>
                                    <?php
                                    if ($userno > 1) {
                                    ?>
                                    <tr>
                                        <td class="return" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'delete\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#delete" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            <a class="return" href="<?php print GetCurrentUrl(0) . '?u=' . $userno . '&delete=1'; ?>">Delete this User</a></td>
                                    </tr>
                                    <?php
                                    }
                                    ?>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'handle\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#handle" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Handle:</td>
                                        <td align="left"><input type="text" name="handle" size="40" maxlength="40" value="<?php print $user['handle']; ?>" tabindex="1"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'realname\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#realname" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Real Name:</td>
                                        <td align="left"><input type="text" name="realname" size="40" maxlength="40" value="<?php print $user['realname']; ?>" tabindex="2"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'address\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#address" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Address:</td>
                                        <td align="left"><input type="text" name="address" size="40" maxlength="40" value="<?php print $user['address']; ?>" tabindex="3"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'city\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#city" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            City:</td>
                                        <td align="left"><input type="text" name="city" size="32" maxlength="32" value="<?php print $user['city']; ?>" tabindex="4"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'state\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#state" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            State:</td>
                                        <td align="left"><input type="text" name="state" size="3" maxlength="3" value="<?php print $user['state']; ?>" tabindex="5"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'zipcode\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#zipcode" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Zip Code:</td>
                                        <td align="left"><input type="text" name="zipcode" size="10" maxlength="10" value="<?php print $user['zipcode']; ?>" tabindex="6"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'phone1\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#phone1" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Phone Number:</td>
                                        <td align="left"><input type="text" name="phone1" size="12" maxlength="12" value="<?php print $user['phone1']; ?>" tabindex="7"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'phone2\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#phone2" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Data/Fax Number:</td>
                                        <td align="left"><input type="text" name="phone2" size="12" maxlength="12" value="<?php print $user['phone2']; ?>" tabindex="8"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'bday\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#bday" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Birthday: (MM/DD/YYYY)</td>
                                        <td align="left"><input type="text" name="bdaymonth" size="2" maxlength="2" value="<?php print $user['bdaymonth']; ?>" tabindex="9">/<input type="text" name="bdayday" size="2" maxlength="2" value="<?php print $user['bdayday']; ?>" tabindex="10">/<input type="text" name="bdayyear" size="4" maxlength="4" value="<?php print $user['bdayyear']; ?>" tabindex="11"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Change BBS Password
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'bbspassword\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#bbspassword" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            New BBS Password:</td>
                                        <td align="left"><input type="password" name="bbspassword" size="8" maxlength="8" tabindex="12"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'bbspassword\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#bbspassword" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Verify Password:</td>
                                        <td align="left"><input type="password" name="bbsverify" size="8" maxlength="8" tabindex="13"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Change VADV-PHP Password
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'webpassword\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#webpassword" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            New VADV-PHP Password:</td>
                                        <td align="left"><input type="password" name="webpassword" size="32" maxlength="32" tabindex="14"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'webpassword\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#webpassword" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Verify Password:</td>
                                        <td align="left"><input type="password" name="webverify" size="32" maxlength="32" tabindex="15"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'resetwebpassword\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#resetwebpassword" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Reset VADV-PHP Password:</td>
                                        <td align="left"><input type="checkbox" name="resetwebpassword" value="1" tabindex="16"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            Other Settings
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'laston\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#laston" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Last Online:</td>
                                        <td class="pre" align="left"><?php
                                                                     $last = strtotime($user['laston']);
                                                                     $laston = date("m/d/Y", $last);
                                                                     $days = CalcDayNumber(date("m"), date("d"), date("Y")) - CalcDayNumber(date("m", $last), date("d", $last), date("Y", $last));
                                                                     print $laston . ' (' . $days . ' days ago)';
                                                                     ?></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'securitylevel\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#securitylevel" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Security Level:</td>
                                        <td align="left"><input type="text" name="securitylevel" size="3" maxlength="3" value="<?php print $user['securitylevel']; ?>" tabindex="17"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'maxtime\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#maxtime" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Time per Day:</td>
                                        <td align="left"><input type="text" name="maxtime" size="4" maxlength="4" value="<?php print $user['maxtime']; ?>" tabindex="18"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'timeleft\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#timeleft" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Time Left Today:</td>
                                        <td align="left"><input type="text" name="timeleft" size="4" maxlength="4" value="<?php if ($user['laston'] != date("ymd")) { print $user['maxtime']; } else { print $user['maxtime'] - $user['timecounter']; } ?>" tabindex="19"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'timebank\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#timebank" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Time Bank:</td>
                                        <td align="left"><input type="text" name="timebank" size="5" maxlength="5" value="<?php print $user['timebank']; ?>" tabindex="20"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'credits\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#credits" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Credits:</td>
                                        <td align="left"><input type="text" name="credits" size="8" maxlength="8" value="<?php print $user['credits']; ?>" tabindex="21"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'flags\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#flags" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            User Flags:</td>
                                        <td align="left"><input type="text" name="flags" size="40" maxlength="26" value="<?php print $user['flags']; ?>" tabindex="22"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'accflags\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#accflags" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Access Flags:</td>
                                        <td align="left"><input type="text" name="accflags" size="40" maxlength="26" value="<?php print $user['accflags']; ?>" tabindex="23"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'pagebreak\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#pagebreak" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Page Break Length:</td>
                                        <td align="left"><input type="text" name="pagebreak" size="3" maxlength="3" value="<?php print $user['pagebreak']; ?>" tabindex="24"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'videomode\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#videomode" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Video Mode:</td>
                                        <td align="left"><input type="text" name="videomode" size="1" maxlength="1" value="<?php print $user['videomode']; ?>" tabindex="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'protocol\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#protocol" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Default Xfer Protocol:</td>
                                        <td align="left"><input type="text" name="protocol" size="1" maxlength="1" value="<?php print $user['protocol']; ?>" tabindex="26"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'liststyle\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#liststyle" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            File List Type</td>
                                        <td align="left">
                                            <select size="1" name="liststyle" tabindex="27">
                                                <option value="1" <?php if ($user['liststyle'] == 1) print "selected"; ?>>Single Line</option>
                                                <option value="0" <?php if ($user['liststyle'] == 0) print "selected"; ?>>Double Line</option>
                                                <option value="2" <?php if ($user['liststyle'] == 2) print "selected"; ?>>Double Line w/ Ext</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'sortfilelst\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#sortfilelst" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Sorted File Listing</td>
                                        <td align="left"><input type="checkbox" name="sortfilelst" value="1" <?php
                                                                                                             if ($user['sortfilelst'] == 1) {
                                                                                                                 print "checked";
                                                                                                             }
                                                                                                             ?> tabindex="28"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'ratioexempt\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#ratioexempt" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Ratio Exempt</td>
                                        <td align="left"><input type="checkbox" name="ratioexempt" value="1" <?php
                                                                                                             if ($user['ratioexempt'] == 0) {
                                                                                                                 print "checked";
                                                                                                             }
                                                                                                             ?> tabindex="29"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'verifybday\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#verifybday" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Verify Birthday</td>
                                        <td align="left"><input type="checkbox" name="verifybday" value="1" <?php
                                                                                                            if ($user['verifybday'] == 1) {
                                                                                                                print "checked";
                                                                                                            }
                                                                                                            ?> tabindex="30"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'mailfwd\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#mailfwd" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Forward Email Address:</td>
                                        <td align="left">
                                            <input type="text" name="mailfwd" size="12" value="<?php if (($user['mailfwdflag'] == 1) && ($user['mailfwduserno'] != '')) {print $user['mailfwduserno'] . '@' . $user['mailfwdnode'];} else if (($user['mailfwdflag'] == 1) && ($user['mailfwdhandle'] != '')) {print $user['mailfwdhandle'] . '@' . $user['mailfwdnode'];} ?>" tabindex="31">
                                            <select name="mailfwdnetno" size="1" tabindex="32">
                                                <option <?php
                                                        if (($user['mailfwdflag'] == 1) &&
                                                            ($user['mailfwdnetno'] == 1) &&
                                                            ($user['mailfwdnetnode'] == $VA_NEWORKS[1]['settings']['systemid'])) {
                                                            print 'selected ';
                                                        }
                                                        ?> value="0">Local</option>
                                                <?php
                                                $cnt = 0;
                                                $net = array();
                                                foreach($VA_NETWORKS as $netInfo) {
                                                    if ((isset($netInfo['nettype'])) &&
                                                        ($netInfo['nettype'] != 2) &&   // If not a VLive network
                                                        ($netInfo['nettype'] != 5)) {   // If not a QWK network
                                                        if ((isset($netInfo['settings']['systemid'])) &&
                                                            ($netInfo['settings']['systemid'] != '0')) {
                                                            if (($USER['securitylevel'] >= 255) ||
                                                                ($netInfo['accflag'] == '') ||                                  // If a access flag is set..
                                                                (strpos($USER['flags'], $netInfo['accflag']) !== FALSE)) {      // If the user has the flag
                                                                switch ($netInfo['nettype']) {
                                                                    case 1:
                                                                       $type = 'VirtualNET';
                                                                        break;
                                                                    case 3:
                                                                        $type = 'Internet';
                                                                        break;
                                                                    case 4:
                                                                        $type = 'FIDOnet';
                                                                        break;
                                                                    case 9:
                                                                        $type = 'WWIVnet';
                                                                        break;
                                                                    default:
                                                                        $type = 'Unknown';
                                                                        break;
                                                                }
                                                                $net[$cnt]['netno']    = $netInfo['netno'];
                                                                $net[$cnt]['desc']     = $netInfo['desc'];
                                                                $net[$cnt]['sortdesc'] = strtolower($netInfo['desc']);
                                                                $net[$cnt]['type']     = $type;
                                                                $cnt++;
                                                            }
                                                        }
                                                    }
                                                }
                                                // Organize the array alphabetically by description.
                                                $sortarr = array();
                                                foreach ($net as $row) {
                                                    $sortarr[] = $row['sortdesc'];
                                                }
                                                array_multisort($sortarr, $net);

                                                // Display the listing.
                                                for ($x = 0; $x < count($net); $x++) {
                                                    if (($user['mailfwdflag'] == 1) && ($user['mailfwdnetno'] == $net[$x]['netno'])) {
                                                        print '<option selected value="' . $net[$x]['netno'] . '">' . $net[$x]['desc'] . ' (' . $net[$x]['type'] . ")</option>\n";
                                                    } else {
                                                        print '<option value="' . $net[$x]['netno'] . '">' . $net[$x]['desc'] . ' (' . $net[$x]['type'] . ")</option>\n";
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'extra\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#extra" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Extra Value #1:</td>
                                        <td align="left"><input type="text" name="extra1" size="12" maxlength="12" value="<?php print $user['extra1']; ?>" tabindex="33"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'extra\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#extra" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Extra Value #2:</td>
                                        <td align="left"><input type="text" name="extra2" size="12" maxlength="12" value="<?php print $user['extra2']; ?>" tabindex="34"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'extra\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#extra" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Extra Value #3:</td>
                                        <td align="left"><input type="text" name="extra3" size="12" maxlength="12" value="<?php print $user['extra3']; ?>" tabindex="35"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'extra\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#extra" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Extra Value #4:</td>
                                        <td align="left"><input type="text" name="extra4" size="12" maxlength="12" value="<?php print $user['extra4']; ?>" tabindex="36"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'extra\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#extra" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Extra Value #5:</td>
                                        <td align="left"><input type="text" name="extra5" size="12" maxlength="12" value="<?php print $user['extra5']; ?>" tabindex="37"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'extra\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#extra" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Extra Value #6:</td>
                                        <td align="left"><input type="text" name="extra6" size="12" maxlength="12" value="<?php print $user['extra6']; ?>" tabindex="38"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'extra\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#extra" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Extra Value #7:</td>
                                        <td align="left"><input type="text" name="extra7" size="12" maxlength="12" value="<?php print $user['extra7']; ?>" tabindex="39"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'extra\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#extra" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Extra Value #8:</td>
                                        <td align="left"><input type="text" name="extra8" size="12" maxlength="12" value="<?php print $user['extra8']; ?>" tabindex="40"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'comment\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#comment" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Optional User Comment:</td>
                                        <td align="left"><input type="text" name="comment" size="16" maxlength="16" value="<?php print $user['comment']; ?>" tabindex="41"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td class="subHeading" align="center" colspan="2" style="border-top:1px solid #C0C0C0; border-bottom:1px solid #C0C0C0;">
                                            User Statistics
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'totalcalls\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#totalcalls" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Total Number of Calls:</td>
                                        <td align="left"><input type="text" name="totalcalls" size="8" maxlength="8" value="<?php print $user['totalcalls']; ?>" tabindex="42"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'totaltime\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#totaltime" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Total Time Online:</td>
                                        <td align="left"><input type="text" name="totaltime" size="8" maxlength="8" value="<?php print $user['totaltime']; ?>" tabindex="43"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'uplfiles\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#uplfiles" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Uploaded Files:</td>
                                        <td align="left"><input type="text" name="uplfiles" size="8" maxlength="8" value="<?php print $user['uplfiles']; ?>" tabindex="44"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'uplkb\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#uplkb" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Uploaded KB:</td>
                                        <td align="left"><input type="text" name="uplkb" size="8" maxlength="8" value="<?php print $user['uplkb']; ?>" tabindex="45"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'dlfiles\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#dlfiles" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Downloaded Files:</td>
                                        <td align="left"><input type="text" name="dlfiles" size="8" maxlength="8" value="<?php print $user['dlfiles']; ?>" tabindex="46"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'dlkb\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#dlkb" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Downloaded KB:</td>
                                        <td align="left"><input type="text" name="dlkb" size="8" maxlength="8" value="<?php print $user['dlkb']; ?>" tabindex="47"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'totalposts\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#totalposts" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Number of Posts:</td>
                                        <td align="left"><input type="text" name="totalposts" size="8" maxlength="8" value="<?php print $user['totalposts']; ?>" tabindex="48"></td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="left">
                                            <script language="JavaScript" type="text/javascript">
                                            <!--
                                                document.write('<a href="Javascript:HelpWindow(\'totalemail\')"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>');
                                            -->
                                            </script>
                                            <noscript>
                                                <a href="<?php print $rootDir; ?>help/usereditor_help.php#totalemail" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Help" width="15" height="15" align="middle"></a>
                                            </noscript>
                                            Number of Emails:</td>
                                        <td align="left"><input type="text" name="totalemail" size="8" maxlength="8" value="<?php print $user['totalemail']; ?>" tabindex="49"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" height="25"></td>
                                    </tr>
                                    <tr>
                                        <td align="left" colspan="2" height="25" style="border-top:1px solid #C0C0C0;">
                                            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                                <tr>
                                                    <td align="left"><?php
                                                                     if ($user['userno'] > 1) {
                                                                         print '<a class="subHeading" href="usereditor.php?u=' . ($user['userno'] - 1) . '">Previous User</a>';
                                                                     }
                                                                     ?></td>
                                                    <td align="right"><?php
                                                                      if ($user['userno'] < GetUserCount()) {
                                                                          print '<a class="subHeading" href="usereditor.php?u=' . ($user['userno'] + 1) . '">Next User</a>';
                                                                      }
                                                                      ?></td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pre" align="center" colspan="2">
                                            <input type="submit" value="Apply" name="submit" tabindex="50">
                                            <input type="reset" value="Reset" name="submit" tabindex="51">
                                        </td>
                                    </tr>
                                </form>
                                <tr>
                                    <td colspan="2" height="25"></td>
                                </tr>
                                <tr>
                                    <td class="footer" align="center" height="40" colspan="2">
                                        <a class="footer" href="<?php print $rootDir; ?>index.php">Return to main BBS page.</a><br />
                                        <a class="footer" href="userlist.php">Return to BBS user listing.</a>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    </center>
</div>

</body>

</html>