<?php
/*
 * ----------------------------------------------------------------------------
 * Post-It_Network.php                                               10/14/2006
 * This script will display the last five posts on the Post-It Network.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Post-It! Network';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once($includeDir . 'at2k.inc.php');         // Include AT2k functions.

if (!$CONFIG['postitnt']) {
    die('<br /><h4>This script has been disabled. Press the BACK button on your browser.</h4>');
}

$postitCfg = GetPostItConfig();             // Get the configuration.

if (!$postitCfg) {
    die('<br /><h4>The Post-It! Network script is not installed. Press the BACK button on your browser.</h4>');
}

$db = GetDbInfo($postitCfg['topicno'], $postitCfg['db']);   // Get the Post-It database information.

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[Post-It! Network] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="index,follow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<style type="text/css">
<!--
    a:active           { color: #FF0000 }
    a:link             { color: #0000D0 }
    a:visited          { color: #0000D0 }
    a:hover            { color: #FF0000 }
    a.boldBody:link    { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    a.boldBody:visited { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    a.msgBack:link     { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.msgBack:visited  { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .boldBody          { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    .footer            { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF }
    .message           { font-family: Courier New;               font-size: 10pt; color: #00AAAD; font-weight: bold }
    .msgBack           { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .title             { font-family: Verdana, Arial, Helvetica; font-size: 14pt; color: #FFFF00; font-weight: bold; font-style:italic }
-->
</style>
</head>

<body bgcolor="#000000">

<p class="title" align="right">Aspect Technologies Post-It! Network<span style="font-size: 8pt"> v<?php print $postitCfg['ver']; ?></span>
<hr color="#525552">

<div align="center">
    <table cellspacing="0" cellpadding="0" width="100%">
        <tr>
            <td class="msgBack" align="left" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">&lt;- Back</a>
            </td>
            <td class="msgBack" align="right" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a>
            </td>
        </tr>
    </table>
</div>

<span style="font-family: Courier New; font-size: 12pt">
<div align="left">

<?php
// Read the Post-It! database file for faster searches.
$file    = $VA_SYSPATHS['db'] . '/' . $db['filename'] . '.DAT';
if (!is_file($file)) {
    die('<br /><h4>Requested database is missing. Please press the BACK button on your browser.</h4>');
}
$fileString = ReadCfgFile($file);           // Read the file.

// Get the messages to display and apply any filters.
$num   = 0;
$msgNo = $db['msgno'];
$msg   = array();
while (($num < 5) && ($msgNo > 0)) {
    $msgInfo = GetMessageInfo($db, $msgNo, $fileString);
    if (!$msgInfo['deleted']) {
        if (strpos($msgInfo['subject'], 'Post-It! Network v') !== FALSE) {
            if ($postitCfg['filter']) {
                if (strpos($msgInfo['subject'], '*p') === FALSE) {
                    $msg[$num] = $msgNo;
                    $num++;
                }
            } else {
                $msg[$num] = $msgNo;
                $num++;
            }
        }
    }
    $msgNo--;
}
$msg = array_reverse($msg);                 // Turn the array around to display in correct order.

// Print out the array (messages).
for ($num = 0; ($num < 5) && (isset($msg[$num])); $num++) {
    $header  = GetMessageInfo($db, $msg[$num], $fileString);
    $message = FixHeartColors(StripRouting(GetMessage($db, $msg[$num], 0, '', $header)));

    if (($header['fromnetid'] == 1) && ($header['fromnetnode'] == $postitCfg['vnetnode'])) {
        $header['fromnetnode'] = $postitCfg['networknode'];
        $fromBbs = trim($VA_MAIN['bbsname']);
    } else {
        $fromBbs = '';
        $netFile = $VA_SYSPATHS['data'] . '/NETLIST.' . $header['fromnetid'];
        if (is_file($netFile)) {
            $fileArray = file($netFile);
            for ($x = 0; $x < count($fileArray); $x++) {
                $node = trim(substr($fileArray[$x], 2, 9));
                if ($node == $header['fromnetnode']) {
                    $fromBbs = trim(substr($fileArray[$x], 19, 30));
                    break;
                }
            }
        } else {
            $fromBbs = "Unknown";
        }
    }
?>

<hr color="#525552">
<span style="color: #FFFF52">By: </span><span style="color: #FF5552"><?php print HtmlSpace($header['fromhandle']); ?></span><span style="color: #FFFFFF"> - </span><span style="color: FFFF52"><?php print $fromBbs; ?></span><span style="color: #FFFFFF"> (</span><span style="color: #ADAAAD"><?php print $header['fromuserno']; ?></span><span style="color: #FFFFFF">@</span><span style="color: #ADAAAD"><?php print $header['fromnetnode']; ?></span><span style="color: #FFFFFF">*</span><span style="color: #ADAAAD"><?php print $header['fromnetid']; ?></span><span style="color: #FFFFFF">)</span><br />

<?php
    print $message . "\n";
}
?>

</div>
</span>

<?php
// Update message pointer if needed.
if (GetMessagePointer($db, $USER['userno']) < $db['msgno']) {
    WriteMessagePointer($db, $USER['userno'], $db['msgno']);
}

GlobalFooter(1);
?>

</body>

</html>