<?php
/*
 * ----------------------------------------------------------------------------
 * EditUser_Process.php                                              10/02/2006
 * This script will process the edituser form.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Editing User Profile';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-userfile.inc.php');  // Include user information.
require_once($includeDir . 'vadv-php_dat.inc.php'); // Incluse user settings.

if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct'])) {
    RedirectUser($rootDir . 'index.php');
}

if ((!isset($_SERVER['HTTP_REFERER'])) ||
    (strpos($_SERVER['HTTP_REFERER'], $_SERVER['HTTP_HOST']) === FALSE)) {
    die('<br /><h4>You are not allowed to access this script from an outside source.<br />Press the BACK button on your browser.</h4>');
}

if ((!isset($_POST['process'])) || ($_POST['process'] != 1)) {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}
if (!isset($_POST['submit'])) {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}

if ((isset($_POST['userno'])) && ($_POST['userno'] != $USER['userno'])) {
    die('<br /><h4>Invalid information. Please press the BACK button on your browser.</h4>');
}

// Format variables.
$_POST['realname']         = ucwords(trim(strtolower($_POST['realname'])));
$_POST['address']          = ucwords(trim(strtolower($_POST['address'])));
$_POST['city']             = ucwords(trim(strtolower($_POST['city'])));
$_POST['state']            = trim(strtoupper($_POST['state']));
$_POST['zipcode']          = trim($_POST['zipcode']);
$_POST['phone1']           = trim($_POST['phone1']);
$_POST['phone2']           = trim($_POST['phone2']);
$_POST['bbspassword']      = trim(strtoupper($_POST['bbspassword']));
$_POST['bbsverify']        = trim(strtoupper($_POST['bbsverify']));
$_POST['webpassword']      = trim(strtoupper($_POST['webpassword']));
$_POST['webverify']        = trim(strtoupper($_POST['webverify']));
$_POST['mailfwd']          = trim($_POST['mailfwd']);
$_POST['mailfwdnetno']     = (integer) $_POST['mailfwdnetno'];
$_POST['timezone']         = (integer) $_POST['timezone'];
$_POST['htmlencode']       = (integer) $_POST['htmlencode'];
$_POST['tagline']          = (integer) $_POST['tagline'];

// Fix the referer URL. Make sure there is no query string.
$url = parse_url($_POST['referer']);
$referer = $url['scheme'] . '://' . $url['host'] . $url['path'];

// Check for required information.
$required = ' ' . GetAccFlags($CONFIG['newuserreq']);   // Convert into a string.
if (is_int((strpos($required, 'A'))) && ($_POST['realname'] == '')) RedirectUser($referer . '?error=realname');
if (is_int((strpos($required, 'B'))) && ($_POST['address'] == ''))  RedirectUser($referer . '?error=address');
if (is_int((strpos($required, 'C'))) && ($_POST['city'] == ''))     RedirectUser($referer . '?error=city');
if (is_int((strpos($required, 'D'))) && ($_POST['state'] == ''))    RedirectUser($referer . '?error=state');
if (is_int((strpos($required, 'E'))) && ($_POST['zipcode'] == ''))  RedirectUser($referer . '?error=zipcode');
if (is_int((strpos($required, 'F'))) && ($_POST['phone1'] == ''))   RedirectUser($referer . '?error=voice');
if (is_int((strpos($required, 'G'))) && ($_POST['phone2'] == ''))   RedirectUser($referer . '?error=data');

if ((isset($_POST['realname'])) && ($_POST['realname'] != $USER['realname'])) {
                                                                              $edituser['realname'] = $_POST['realname'];
                                                                              $useridx['realname']  = $_POST['realname'];
                                                                              }
if ((isset($_POST['address']))  && ($_POST['address']  != $USER['address']))  $edituser['address']  = $_POST['address'];
if ((isset($_POST['city']))     && ($_POST['city']     != $USER['city']))     $edituser['city']     = $_POST['city'];
if ((isset($_POST['state']))    && ($_POST['state']    != $USER['state']))    $edituser['state']    = $_POST['state'];
if ((isset($_POST['zipcode']))  && ($_POST['zipcode']  != $USER['zipcode']))  $edituser['zipcode']  = $_POST['zipcode'];
if ((isset($_POST['phone1']))   && ($_POST['phone1']   != $USER['phone1']))   $edituser['phone1']   = $_POST['phone1'];
if ((isset($_POST['phone2']))   && ($_POST['phone2']   != $USER['phone2']))   $edituser['phone2']   = $_POST['phone2'];

// If password change...
if ((isset($_POST['bbspassword'])) && ($_POST['bbspassword'] != '') &&
    (isset($_POST['bbsverify'])) && ($_POST['bbsverify'] != '')) {
    $password = $_POST['bbspassword'];
    $verify   = $_POST['bbsverify'];
    if ($password === $verify) {
        $edituser['password'] = $password;
        $USER['password'] = md5($password);
        $_SESSION['password'] = base64_encode(md5($password));  // Change session password.
    }
}

// Mail forwarding...
if ((isset($_POST['mailfwd'])) && (trim($_POST['mailfwd']) != '')) {
    $pos = strpos($_POST['mailfwd'], '@');
    if ($pos !== FALSE) {
        $to = substr($_POST['mailfwd'], 0, $pos);
        $node = substr($_POST['mailfwd'], $pos + 1);
        if (intval($to) > 0) {
            $edituser['mailfwdhandle'] = '';
            $edituser['mailfwduserno'] = $to;
        } else {
            $edituser['mailfwdhandle'] = $to;
            $edituser['mailfwduserno'] = 0;
        }
        $edituser['mailfwdflag']  = 1;
        $edituser['mailfwdnode']  = $node;
        $edituser['mailfwdnetno'] = $_POST['mailfwdnetno'];
    }
} else {
    $edituser['mailfwdflag']   = 0;
    $edituser['mailfwdhandle'] = '';
    $edituser['mailfwduserno'] = 0;
    $edituser['mailfwdnode']   = '';
    $edituser['mailfwdnetno']  = 0;
}

$log = 'User Editor     "' . $USER['handle'] . '"';
WriteLog('VADV-PHP.LOG', $log);

// Write new DAT file.
if (isset($edituser)) {
    $fileString = ReadUserfile();                                   // Get the file string.
    $fileString = PutUser($fileString, $USER['userno'], $edituser); // Put the new information into the file string.
    WriteUserfile($fileString);                                     // Write the new file.
}

// Write new IDX file.
if (isset($useridx)) {
    $fileString = ReadUserfile_IDX();
    $fileString = PutUser_IDX($fileString, $USER['userno'], $useridx);
    WriteUserfile_IDX($fileString);
}

if ((isset($_POST['timezone'])   && ($_POST['timezone']   != $USER_SETTINGS['timezone'])))   $newsettings['timezone']   = $_POST['timezone'];
if ((isset($_POST['htmlencode']) && ($_POST['htmlencode'] != $USER_SETTINGS['htmlencode']))) $newsettings['htmlencode'] = $_POST['htmlencode'];
if ((isset($_POST['tagline'])    && ($_POST['tagline']    != $USER_SETTINGS['tagline'])))    $newsettings['tagline']    = $_POST['tagline'];

// If password change...
if ((isset($_POST['resetwebpassword'])) && (intval($_POST['resetwebpassword']) == 1)) {
    $newsettings['password'] = '';
    $_SESSION['password'] = base64_encode($USER['password']);
} else {
    if ((isset($_POST['webpassword'])) && ($_POST['webpassword'] != '') &&
        (isset($_POST['webverify'])) && ($_POST['webverify'] != '')) {
        $password = $_POST['webpassword'];
        $verify   = $_POST['webverify'];
        if ($password === $verify) {
            $newsettings['password'] = md5($password);
            $_SESSION['password'] = base64_encode(md5($password));  // Change session password.
        }
    }
}

if (isset($newsettings)) {
    $fileString = ReadUserSettings();
    $fileString = PutUserSettings($fileString, $USER['userno'], $newsettings);
    WriteUserSettings($fileString);
}

RedirectUser($_POST['referer']);

?>