<?php
/*
 * ----------------------------------------------------------------------------
 * DispNet.php                                                       10/14/2006
 * This script will display the network listings.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Viewing Network Listing';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include the main BBS configuration.
require_once($includeDir . 'va-networks.inc.php');  // Include networks data.

if (isset($_GET['net'])) {                  // Set the passed variables.
    $netNo = $_GET['net'];
} else {
    $netNo = 0;
}

if (isset($_GET['l'])) {
    $startLine = $_GET['l'];
} else {
    $startLine = 0;
}

$netinfo = GetNetworkinfo();

require_once($includeDir. 'html_header.php');

if (!isset($netinfo[$netNo])) {
    die('<br /><h4>Invalid network number! Please press the back button on your browser.</h4>');
}

if ($netNo == 0) {
    // If no net number set, then display a list of available networks.
?>

<html>

<head>
<title>[Network Listing] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="index,follow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<style type="text/css">
<!--
    a:active           { color: #FF0000 }
    a:link             { color: #0000D0 }
    a:visited          { color: #0000D0 }
    a:hover            { color: #FF0000 }
    a.msgBack:link     { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.msgBack:visited  { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .msgBack           { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
-->
</style>
</head>

<body text="#C0C0C0" bgcolor="#000000">
<span style="font-family: Courier New; font-size: 12pt; color: #FFFFFF">
<p align="center"><b><?php print HtmlSpace($VA_MAIN['bbsname']); ?> - Network Listing</b></span>
<hr color="#525552">

<div align="center">
    <table cellspacing="0" cellpadding="0" width="100%">
        <tr>
            <td class="msgBack" align="left" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">&lt;- Back</a>
            </td>
            <td class="msgBack" align="right" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a>
            </td>
        </tr>
    </table>
</div>
<hr color="#525552">

<div align="center">
    <center>
    <table border="0" cellspacing="0" cellpadding="0">
        <tr>
            <td align="left">
<?php
    if ($netinfo[0] == 0) {
        print '<pre><span style="font-size: 10pt; color: #FFFF52">' . "\n";
        print 'No Configured Networks!</pre>' . "\n";
    } else {
        print '<pre><span style="font-size: 10pt">' . "\n";
        $cnt = 0;
        for ($x = 1; $cnt < $netinfo[0]; $x++) {
            if (isset($netinfo[$x])) {
                $filename = $VA_SYSPATHS['data'] . '\NETLIST.' . $netinfo[$x]['netno']; // Set the filename.
                if ((is_file($filename)) && (filesize($filename) > 0)) {
                    print '<a href="dispnet.php?net=' . $netinfo[$x]['netno'] . '"><span style="color: #52FF52">' . $netinfo[$x]['desc'] . '</span></a> <span style="color: #FFFFFF">(</span><span style="color: #52FFFF">' . $netinfo[$x]['netno'] . '</span><span style="color: #FFFFFF">)</span>' . "\n";
                }
                $cnt++;
            }
        }
        print '</span></pre>' . "\n";
    }
?>
            </td>
        </tr>
    </table>
    </center>
</div>

<?php
    GlobalFooter(1);
?>

</body>
</html>

<?php
    ob_end_flush();
    die();
}

?>

<html>

<head>
<title>[Node List] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="index, follow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<style type="text/css">
<!--
    a:active           { color: #FF0000 }
    a:link             { color: #0000D0 }
    a:visited          { color: #0000D0 }
    a:hover            { color: #FF0000 }
    a.msgBack:link     { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.msgBack:visited  { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .msgBack           { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
-->
</style>
</head>

<body text="#C0C0C0" bgcolor="#000000">
<span style="font-family: Courier New; font-size: 12pt; color: #FFFFFF">
<p align="center"><b><?php print HtmlSpace($VA_MAIN['bbsname']) . ' - ' . $netinfo[$netNo]['desc']; ?> Node List</b></span>
<hr color="#525552">

<div align="center">
    <table cellspacing="0" cellpadding="0" width="100%">
        <tr>
            <td class="msgBack" align="left" valign="top">
                <a class="msgBack" href="dispnet.php">&lt;- Back</a>
            </td>
            <td class="msgBack" align="right" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a>
            </td>
        </tr>
    </table>
</div>
<hr color="#525552">

<div align="center">
    <center>
    <table border="0" cellspacing="0" cellpadding="0">
        <tr>
            <td align="left">
<?php
$filename = $VA_SYSPATHS['data'] . '\NETLIST.' . $netNo;    // Set the filename.
$x = 0;

if ((!is_file($filename)) || (filesize($filename) == 0)) {
    print '<pre><span style="font-size: 10pt; color: #FFFF52">' . "\n";
    print 'No Listed Nodes!</pre>' . "\n";
} else {
    $file = file($filename);                // Read and close the file.

    // Print each line and convert heart codes to html.
    print '<pre><span style="font-size: 10pt">' . "\n";
    $line = $startLine;
    for ($x = 0; (isset($file[$line]) && ($x < 200)); $x++) {
        print FixHeartColors(htmlspecialchars($file[$line])) . '<br />';
        $line++;
    }
    print "</span></pre>\n";
}
?>
            </td>
        </tr>
    </table>
    </center>
    <p align="center">
<?php
if ($startLine >= 200) {
    $y = $startLine - 200;
    if ($y < 0) {
        $y = 0;
    }
    print '<span style="font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFFFF"> - <a href="dispnet.php?net=' . $netNo . '&l=' . $y . '"><span style="color: #FFFFFF">Previous Page</span></a> - </span>' . "\n";
}
if (($x >= 200) && (isset($file[$line + 1]))) {
    print '<span style="font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFFFF"> - <a href="dispnet.php?net=' . $netNo . '&l=' . $line . '"><span style="color: #FFFFFF">Next Page</span></a> - </span>' . "\n";
}
?>
    </p>
</div>

<?php
GlobalFooter(1);
?>

</body>

</html>